/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.relocated.org.picocontainer.defaults;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.jetbrains.kotlin.relocated.org.picocontainer.ComponentMonitor;
import org.jetbrains.kotlin.relocated.org.picocontainer.Parameter;
import org.jetbrains.kotlin.relocated.org.picocontainer.PicoContainer;
import org.jetbrains.kotlin.relocated.org.picocontainer.PicoIntrospectionException;
import org.jetbrains.kotlin.relocated.org.picocontainer.defaults.AbstractComponentAdapter;
import org.jetbrains.kotlin.relocated.org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.jetbrains.kotlin.relocated.org.picocontainer.defaults.AssignabilityRegistrationException;
import org.jetbrains.kotlin.relocated.org.picocontainer.defaults.ComponentParameter;
import org.jetbrains.kotlin.relocated.org.picocontainer.defaults.DefaultLifecycleStrategy;
import org.jetbrains.kotlin.relocated.org.picocontainer.defaults.DelegatingComponentMonitor;
import org.jetbrains.kotlin.relocated.org.picocontainer.defaults.LifecycleStrategy;
import org.jetbrains.kotlin.relocated.org.picocontainer.defaults.NotConcreteRegistrationException;
import org.jetbrains.kotlin.relocated.org.picocontainer.defaults.UnsatisfiableDependenciesException;

public abstract class InstantiatingComponentAdapter
extends AbstractComponentAdapter
implements LifecycleStrategy {
    protected transient Parameter[] parameters;
    protected boolean allowNonPublicClasses;
    protected LifecycleStrategy lifecycleStrategy;

    protected InstantiatingComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters2, boolean allowNonPublicClasses, ComponentMonitor monitor2, LifecycleStrategy lifecycleStrategy) {
        super(componentKey, componentImplementation, monitor2);
        this.checkConcrete();
        if (parameters2 != null) {
            for (int i = 0; i < parameters2.length; ++i) {
                if (parameters2[i] != null) continue;
                throw new NullPointerException(new StringBuffer().append("Parameter ").append(i).append(" is null").toString());
            }
        }
        this.parameters = parameters2;
        this.allowNonPublicClasses = allowNonPublicClasses;
        this.lifecycleStrategy = lifecycleStrategy;
    }

    protected InstantiatingComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters2, boolean allowNonPublicClasses, ComponentMonitor monitor2) {
        this(componentKey, componentImplementation, parameters2, allowNonPublicClasses, monitor2, new DefaultLifecycleStrategy(monitor2));
    }

    protected InstantiatingComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters2, boolean allowNonPublicClasses) {
        this(componentKey, componentImplementation, parameters2, allowNonPublicClasses, new DelegatingComponentMonitor());
    }

    private void checkConcrete() throws NotConcreteRegistrationException {
        boolean isAbstract;
        boolean bl = isAbstract = (this.getComponentImplementation().getModifiers() & 0x400) == 1024;
        if (this.getComponentImplementation().isInterface() || isAbstract) {
            throw new NotConcreteRegistrationException(this.getComponentImplementation());
        }
    }

    protected Parameter[] createDefaultParameters(Class[] parameters2) {
        Parameter[] componentParameters = new Parameter[parameters2.length];
        for (int i = 0; i < parameters2.length; ++i) {
            componentParameters[i] = ComponentParameter.DEFAULT;
        }
        return componentParameters;
    }

    protected Object newInstance(Constructor constructor2, Object[] parameters2) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this.allowNonPublicClasses) {
            constructor2.setAccessible(true);
        }
        return constructor2.newInstance(parameters2);
    }

    protected abstract Constructor getGreediestSatisfiableConstructor(PicoContainer var1) throws PicoIntrospectionException, UnsatisfiableDependenciesException, AmbiguousComponentResolutionException, AssignabilityRegistrationException, NotConcreteRegistrationException;
}

