/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.relocated.jline;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.kotlin.relocated.jline.Terminal;
import org.jetbrains.kotlin.relocated.jline.TerminalFactory;
import org.jetbrains.kotlin.relocated.jline.internal.Log;
import org.jetbrains.kotlin.relocated.jline.internal.ShutdownHooks;

public abstract class TerminalSupport
implements Terminal {
    private ShutdownHooks.Task shutdownTask;
    private boolean supported;
    private boolean echoEnabled;
    private boolean ansiSupported;

    protected TerminalSupport(boolean supported) {
        this.supported = supported;
    }

    @Override
    public void init() throws Exception {
        this.shutdownTask = ShutdownHooks.add(new ShutdownHooks.Task(){

            @Override
            public void run() throws Exception {
                TerminalSupport.this.restore();
            }
        });
    }

    public void restore() throws Exception {
        TerminalFactory.resetIf(this);
        ShutdownHooks.remove(this.shutdownTask);
    }

    @Override
    public final boolean isSupported() {
        return this.supported;
    }

    @Override
    public synchronized boolean isAnsiSupported() {
        return this.ansiSupported;
    }

    protected synchronized void setAnsiSupported(boolean supported) {
        this.ansiSupported = supported;
        Log.debug("Ansi supported: ", supported);
    }

    @Override
    public OutputStream wrapOutIfNeeded(OutputStream out) {
        return out;
    }

    @Override
    public boolean hasWeirdWrap() {
        return true;
    }

    @Override
    public int getWidth() {
        return 80;
    }

    @Override
    public int getHeight() {
        return 24;
    }

    @Override
    public synchronized boolean isEchoEnabled() {
        return this.echoEnabled;
    }

    public synchronized void setEchoEnabled(boolean enabled) {
        this.echoEnabled = enabled;
        Log.debug("Echo enabled: ", enabled);
    }

    @Override
    public InputStream wrapInIfNeeded(InputStream in) throws IOException {
        return in;
    }
}

