/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.relocated.gnu.trove;

import org.jetbrains.kotlin.relocated.gnu.trove.HashFunctions;
import org.jetbrains.kotlin.relocated.gnu.trove.TIntHashingStrategy;
import org.jetbrains.kotlin.relocated.gnu.trove.TIntProcedure;
import org.jetbrains.kotlin.relocated.gnu.trove.TPrimitiveHash;

public abstract class TIntHash
extends TPrimitiveHash
implements TIntHashingStrategy {
    protected transient int[] _set;
    protected TIntHashingStrategy _hashingStrategy = this;

    public TIntHash() {
    }

    public TIntHash(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public Object clone() {
        TIntHash h = (TIntHash)super.clone();
        h._set = (int[])this._set.clone();
        return h;
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._set = new int[capacity];
        return capacity;
    }

    public boolean contains(int val) {
        return this.index(val) >= 0;
    }

    public boolean forEach(TIntProcedure procedure) {
        byte[] states = this._states;
        int[] set = this._set;
        int i = set.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(set[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void removeAt(int index2) {
        this._set[index2] = 0;
        super.removeAt(index2);
    }

    protected int index(int val) {
        byte[] states = this._states;
        int[] set = this._set;
        int length = states.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index2 = hash % length;
        if (states[index2] != 0 && (states[index2] == 2 || set[index2] != val)) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index2 -= probe) >= 0) continue;
                index2 += length;
            } while (states[index2] != 0 && (states[index2] == 2 || set[index2] != val));
        }
        return states[index2] == 0 ? -1 : index2;
    }

    protected int insertionIndex(int val) {
        byte[] states = this._states;
        int[] set = this._set;
        int length = states.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index2 = hash % length;
        if (states[index2] == 0) {
            return index2;
        }
        if (states[index2] == 1 && set[index2] == val) {
            return -index2 - 1;
        }
        int probe = 1 + hash % (length - 2);
        do {
            if ((index2 -= probe) >= 0) continue;
            index2 += length;
        } while (states[index2] == 1 && set[index2] != val);
        if (states[index2] == 2) {
            int firstRemoved = index2;
            while (states[index2] != 0 && (states[index2] == 2 || set[index2] != val)) {
                if ((index2 -= probe) >= 0) continue;
                index2 += length;
            }
            return states[index2] == 1 ? -index2 - 1 : firstRemoved;
        }
        return states[index2] == 1 ? -index2 - 1 : index2;
    }

    @Override
    public final int computeHashCode(int val) {
        return HashFunctions.hash(val);
    }
}

