/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.relocated.com.google.common.base;

import java.io.Serializable;
import java.util.Map;
import org.jetbrains.kotlin.relocated.com.google.common.base.Function;
import org.jetbrains.kotlin.relocated.com.google.common.base.Preconditions;

public final class Functions {
    public static <K, V> Function<K, V> forMap(Map<K, V> map) {
        return new FunctionForMapNoDefault<K, V>(map);
    }

    private static class FunctionForMapNoDefault<K, V>
    implements Function<K, V>,
    Serializable {
        final Map<K, V> map;

        FunctionForMapNoDefault(Map<K, V> map) {
            this.map = Preconditions.checkNotNull(map);
        }

        @Override
        public V apply(K key) {
            V result2 = this.map.get(key);
            Preconditions.checkArgument(result2 != null || this.map.containsKey(key), "Key '%s' not present in map", key);
            return result2;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof FunctionForMapNoDefault) {
                FunctionForMapNoDefault that = (FunctionForMapNoDefault)o;
                return this.map.equals(that.map);
            }
            return false;
        }

        public int hashCode() {
            return this.map.hashCode();
        }

        public String toString() {
            return "forMap(" + this.map + ")";
        }
    }
}

