/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.IfNotParsed;
import org.jetbrains.kotlin.psi.JetElementImplStub;
import org.jetbrains.kotlin.psi.JetExpressionImplStub;
import org.jetbrains.kotlin.psi.JetNameReferenceExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetTypeArgumentList;
import org.jetbrains.kotlin.psi.JetTypeElement;
import org.jetbrains.kotlin.psi.JetTypeProjection;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinUserTypeStub;
import org.jetbrains.kotlin.psi.stubs.elements.JetStubElementTypes;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Lists;

public class JetUserType
extends JetElementImplStub<KotlinUserTypeStub>
implements JetTypeElement {
    public JetUserType(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/JetUserType", "<init>"));
        }
        super(node);
    }

    public JetUserType(@NotNull KotlinUserTypeStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/JetUserType", "<init>"));
        }
        super(stub, JetStubElementTypes.USER_TYPE);
    }

    public boolean isAbsoluteInRootPackage() {
        KotlinUserTypeStub stub = (KotlinUserTypeStub)this.getStub();
        if (stub != null) {
            return stub.isAbsoluteInRootPackage();
        }
        return this.findChildByType(JetTokens.PACKAGE_KEYWORD) != null;
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor2, D data2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/JetUserType", "accept"));
        }
        return visitor2.visitUserType(this, data2);
    }

    public JetTypeArgumentList getTypeArgumentList() {
        return (JetTypeArgumentList)this.getStubOrPsiChild(JetStubElementTypes.TYPE_ARGUMENT_LIST);
    }

    @NotNull
    public List<JetTypeProjection> getTypeArguments() {
        JetTypeArgumentList typeArgumentList = this.getTypeArgumentList();
        List<Object> list = typeArgumentList == null ? Collections.emptyList() : typeArgumentList.getArguments();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetUserType", "getTypeArguments"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<JetTypeReference> getTypeArgumentsAsTypes() {
        ArrayList<JetTypeReference> result2 = Lists.newArrayList();
        for (JetTypeProjection projection : this.getTypeArguments()) {
            result2.add(projection.getTypeReference());
        }
        ArrayList<JetTypeReference> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetUserType", "getTypeArgumentsAsTypes"));
        }
        return arrayList;
    }

    @IfNotParsed
    @Nullable
    public JetSimpleNameExpression getReferenceExpression() {
        JetNameReferenceExpression nameRefExpr = this.getStubOrPsiChild(JetStubElementTypes.REFERENCE_EXPRESSION);
        return nameRefExpr != null ? nameRefExpr : (JetExpressionImplStub)this.getStubOrPsiChild(JetStubElementTypes.ENUM_ENTRY_SUPERCLASS_REFERENCE_EXPRESSION);
    }

    @Nullable
    public JetUserType getQualifier() {
        return this.getStubOrPsiChild(JetStubElementTypes.USER_TYPE);
    }

    public void deleteQualifier() {
        JetUserType qualifier = this.getQualifier();
        assert (qualifier != null);
        Object dot = this.findChildByType(JetTokens.DOT);
        assert (dot != null);
        qualifier.delete();
        dot.delete();
    }

    @Nullable
    public String getReferencedName() {
        JetSimpleNameExpression referenceExpression = this.getReferenceExpression();
        return referenceExpression == null ? null : referenceExpression.getReferencedName();
    }
}

