/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.operation;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.operation.BinaryOperationTranslator;
import org.jetbrains.kotlin.js.translate.operation.OperatorTable;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.ErrorReportingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.lexer.JetToken;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

public final class CompareToTranslator
extends AbstractTranslator {
    @NotNull
    private final JetBinaryExpression expression;

    public static boolean isCompareToCall(@NotNull JetToken operationToken, @Nullable CallableDescriptor operationDescriptor) {
        if (operationToken == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationToken", "org/jetbrains/kotlin/js/translate/operation/CompareToTranslator", "isCompareToCall"));
        }
        if (!OperatorConventions.COMPARISON_OPERATIONS.contains(operationToken) || operationDescriptor == null) {
            return false;
        }
        return JsDescriptorUtils.isCompareTo(operationDescriptor);
    }

    @NotNull
    public static JsExpression translate(@NotNull JetBinaryExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/operation/CompareToTranslator", "translate"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/operation/CompareToTranslator", "translate"));
        }
        JsExpression jsExpression = new CompareToTranslator(expression, context2).translate();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/CompareToTranslator", "translate"));
        }
        return jsExpression;
    }

    private CompareToTranslator(@NotNull JetBinaryExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/operation/CompareToTranslator", "<init>"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/operation/CompareToTranslator", "<init>"));
        }
        super(context2);
        this.expression = expression;
        CallableDescriptor descriptor2 = BindingUtils.getCallableDescriptorForOperationExpression(context2.bindingContext(), expression);
        assert (descriptor2 != null) : "CompareTo should always have a descriptor";
        assert (OperatorConventions.COMPARISON_OPERATIONS.contains(PsiUtils.getOperationToken(expression))) : ErrorReportingUtils.message(expression, "CompareToTranslator supported only expressions with operation token from COMPARISON_OPERATIONS, expression: " + expression.getText());
    }

    @NotNull
    private JsExpression translate() {
        JsBinaryOperator correspondingOperator = OperatorTable.getBinaryOperator(PsiUtils.getOperationToken(this.expression));
        JsExpression methodCall = BinaryOperationTranslator.translateAsOverloadedCall(this.expression, this.context());
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(correspondingOperator, methodCall, this.context().program().getNumberLiteral(0));
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/CompareToTranslator", "translate"));
        }
        return jsBinaryOperation;
    }
}

