/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetWhenCondition;
import org.jetbrains.kotlin.psi.JetWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.JetWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.JetWhenEntry;
import org.jetbrains.kotlin.psi.JetWhenExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsBlock;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsEmpty;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsIf;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsLiteral;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsPrefixOperation;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsStatement;

public final class WhenTranslator
extends AbstractTranslator {
    @NotNull
    private final JetWhenExpression whenExpression;
    @Nullable
    private final JsExpression expressionToMatch;

    @Nullable
    public static JsNode translate(@NotNull JetWhenExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translate"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translate"));
        }
        return new WhenTranslator(expression, context2).translate();
    }

    private WhenTranslator(@NotNull JetWhenExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "<init>"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "<init>"));
        }
        super(context2);
        this.whenExpression = expression;
        JetExpression subject = expression.getSubjectExpression();
        if (subject != null) {
            JsExpression subjectExpression = Translation.translateAsExpression(subject, context2);
            if (TranslationUtils.isCacheNeeded(subjectExpression)) {
                TemporaryVariable subjectVar = context2.declareTemporary(null);
                context2.addStatementToCurrentBlock(JsAstUtils.assignment(subjectVar.reference(), subjectExpression).makeStmt());
                subjectExpression = subjectVar.reference();
            }
            this.expressionToMatch = subjectExpression;
        } else {
            this.expressionToMatch = null;
        }
    }

    private JsStatement translate() {
        if (this.expressionToMatch != null && JsAstUtils.isEmptyExpression(this.expressionToMatch)) {
            return JsEmpty.INSTANCE$;
        }
        JsIf currentIf = null;
        JsIf resultIf = null;
        for (JetWhenEntry entry : this.whenExpression.getEntries()) {
            JsBlock statementBlock = new JsBlock();
            JsStatement statement = WhenTranslator.translateEntryExpression(entry, this.context(), statementBlock);
            if (resultIf == null && entry.isElse()) {
                this.context().addStatementsToCurrentBlockFrom(statementBlock);
                return statement;
            }
            statement = JsAstUtils.mergeStatementInBlockIfNeeded(statement, statementBlock);
            if (resultIf == null) {
                resultIf = currentIf = JsAstUtils.newJsIf(this.translateConditions(entry, this.context()), statement);
                continue;
            }
            if (entry.isElse()) {
                currentIf.setElseStatement(statement);
                return resultIf;
            }
            JsBlock conditionsBlock = new JsBlock();
            JsIf nextIf = JsAstUtils.newJsIf(this.translateConditions(entry, this.context().innerBlock(conditionsBlock)), statement);
            JsStatement statementToAdd = JsAstUtils.mergeStatementInBlockIfNeeded(nextIf, conditionsBlock);
            currentIf.setElseStatement(statementToAdd);
            currentIf = nextIf;
        }
        return resultIf;
    }

    @NotNull
    private static JsStatement translateEntryExpression(@NotNull JetWhenEntry entry, @NotNull TranslationContext context2, @NotNull JsBlock block) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateEntryExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateEntryExpression"));
        }
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateEntryExpression"));
        }
        JetExpression expressionToExecute = entry.getExpression();
        assert (expressionToExecute != null) : "WhenEntry should have whenExpression to execute.";
        JsStatement jsStatement = Translation.translateAsStatement(expressionToExecute, context2, block);
        if (jsStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateEntryExpression"));
        }
        return jsStatement;
    }

    @NotNull
    private JsExpression translateConditions(@NotNull JetWhenEntry entry, @NotNull TranslationContext context2) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateConditions"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateConditions"));
        }
        JetWhenCondition[] conditions = entry.getConditions();
        assert (conditions.length > 0) : "When entry (not else) should have at least one condition";
        if (conditions.length == 1) {
            JsExpression jsExpression = this.translateCondition(conditions[0], context2);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateConditions"));
            }
            return jsExpression;
        }
        JsExpression result2 = this.translateCondition(conditions[0], context2);
        for (int i = 1; i < conditions.length; ++i) {
            result2 = this.translateOrCondition(result2, conditions[i], context2);
        }
        JsExpression jsExpression = result2;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateConditions"));
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression translateOrCondition(@NotNull JsExpression leftExpression, @NotNull JetWhenCondition condition, @NotNull TranslationContext context2) {
        if (leftExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftExpression", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateOrCondition"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateOrCondition"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateOrCondition"));
        }
        TranslationContext rightContext = context2.innerBlock();
        JsExpression rightExpression = this.translateCondition(condition, rightContext);
        context2.moveVarsFrom(rightContext);
        if (rightContext.currentBlockIsEmpty()) {
            JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.OR, leftExpression, rightExpression);
            if (jsBinaryOperation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateOrCondition"));
            }
            return jsBinaryOperation;
        }
        assert (rightExpression instanceof JsNameRef) : "expected JsNameRef, but: " + rightExpression;
        JsNameRef result2 = (JsNameRef)rightExpression;
        JsIf ifStatement = JsAstUtils.newJsIf(leftExpression, JsAstUtils.assignment(result2, JsLiteral.TRUE).makeStmt(), rightContext.getCurrentBlock());
        context2.addStatementToCurrentBlock(ifStatement);
        JsNameRef jsNameRef = result2;
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateOrCondition"));
        }
        return jsNameRef;
    }

    @NotNull
    private JsExpression translateCondition(@NotNull JetWhenCondition condition, @NotNull TranslationContext context2) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateCondition"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateCondition"));
        }
        if (condition instanceof JetWhenConditionIsPattern || condition instanceof JetWhenConditionWithExpression) {
            JsExpression jsExpression = this.translatePatternCondition(condition, context2);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateCondition"));
            }
            return jsExpression;
        }
        throw new AssertionError((Object)("Unsupported when condition " + condition.getClass()));
    }

    @NotNull
    private JsExpression translatePatternCondition(@NotNull JetWhenCondition condition, @NotNull TranslationContext context2) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translatePatternCondition"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translatePatternCondition"));
        }
        JsExpression patternMatchExpression = this.translateWhenConditionToBooleanExpression(condition, context2);
        if (WhenTranslator.isNegated(condition)) {
            JsPrefixOperation jsPrefixOperation = JsAstUtils.negated(patternMatchExpression);
            if (jsPrefixOperation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translatePatternCondition"));
            }
            return jsPrefixOperation;
        }
        JsExpression jsExpression = patternMatchExpression;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translatePatternCondition"));
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression translateWhenConditionToBooleanExpression(@NotNull JetWhenCondition condition, @NotNull TranslationContext context2) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateWhenConditionToBooleanExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateWhenConditionToBooleanExpression"));
        }
        if (condition instanceof JetWhenConditionIsPattern) {
            JsExpression jsExpression = this.translateIsCondition((JetWhenConditionIsPattern)condition, context2);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateWhenConditionToBooleanExpression"));
            }
            return jsExpression;
        }
        if (condition instanceof JetWhenConditionWithExpression) {
            JsExpression jsExpression = this.translateExpressionCondition((JetWhenConditionWithExpression)condition, context2);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateWhenConditionToBooleanExpression"));
            }
            return jsExpression;
        }
        throw new AssertionError((Object)"Wrong type of JetWhenCondition");
    }

    @NotNull
    private JsExpression translateIsCondition(@NotNull JetWhenConditionIsPattern conditionIsPattern, @NotNull TranslationContext context2) {
        if (conditionIsPattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conditionIsPattern", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateIsCondition"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateIsCondition"));
        }
        JsExpression expressionToMatch = this.getExpressionToMatch();
        assert (expressionToMatch != null) : "An is-check is not allowed in when() without subject.";
        JetTypeReference typeReference = conditionIsPattern.getTypeReference();
        assert (typeReference != null) : "An is-check must have a type reference.";
        JsExpression jsExpression = Translation.patternTranslator(context2).translateIsCheck(expressionToMatch, typeReference);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateIsCondition"));
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression translateExpressionCondition(@NotNull JetWhenConditionWithExpression condition, @NotNull TranslationContext context2) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateExpressionCondition"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateExpressionCondition"));
        }
        JetExpression patternExpression = condition.getExpression();
        assert (patternExpression != null) : "Expression pattern should have an expression.";
        JsExpression expressionToMatch = this.getExpressionToMatch();
        if (expressionToMatch == null) {
            JsExpression jsExpression = Translation.patternTranslator(context2).translateExpressionForExpressionPattern(patternExpression);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateExpressionCondition"));
            }
            return jsExpression;
        }
        JsExpression jsExpression = Translation.patternTranslator(context2).translateExpressionPattern(expressionToMatch, patternExpression);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateExpressionCondition"));
        }
        return jsExpression;
    }

    @Nullable
    private JsExpression getExpressionToMatch() {
        return this.expressionToMatch;
    }

    private static boolean isNegated(@NotNull JetWhenCondition condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "isNegated"));
        }
        if (condition instanceof JetWhenConditionIsPattern) {
            return ((JetWhenConditionIsPattern)condition).isNegated();
        }
        return false;
    }
}

