/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.arguments;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.ValueDescription;
import org.jetbrains.kotlin.relocated.com.sampullara.cli.Argument;

public class K2JVMCompilerArguments
extends CommonCompilerArguments {
    @Argument(value="d", description="Destination for generated class files")
    @ValueDescription(value="<directory|jar>")
    public String destination;
    @Argument(value="classpath", alias="cp", description="Paths where to find user class files")
    @ValueDescription(value="<path>")
    public String classpath;
    @Argument(value="annotations", description="Paths to external annotations")
    @ValueDescription(value="<path>")
    public String annotations;
    @Argument(value="include-runtime", description="Include Kotlin runtime in to resulting .jar")
    public boolean includeRuntime;
    @Argument(value="no-jdk", description="Don't include Java runtime into classpath")
    public boolean noJdk;
    @Argument(value="no-stdlib", description="Don't include Kotlin runtime into classpath")
    public boolean noStdlib;
    @Argument(value="no-jdk-annotations", description="Don't include JDK external annotations into classpath")
    public boolean noJdkAnnotations;
    @Argument(value="module", description="Path to the module file to compile")
    @ValueDescription(value="<path>")
    public String module;
    @Argument(value="script", description="Evaluate the script file")
    public boolean script;
    @Argument(value="kotlin-home", description="Path to Kotlin compiler home directory, used for annotations and runtime libraries discovery")
    @ValueDescription(value="<path>")
    public String kotlinHome;
    @Argument(value="Xno-call-assertions", description="Don't generate not-null assertion after each invocation of method returning not-null")
    public boolean noCallAssertions;
    @Argument(value="Xno-param-assertions", description="Don't generate not-null assertions on parameters of methods accessible from Java")
    public boolean noParamAssertions;
    @Argument(value="Xno-optimize", description="Disable optimizations")
    public boolean noOptimize;

    @Override
    @NotNull
    public String executableScriptFileName() {
        if ("kotlinc-jvm" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments", "executableScriptFileName"));
        }
        return "kotlinc-jvm";
    }
}

