/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Lists;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.OverrideResolver;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilPackage;

public abstract class DataClassMethodGenerator {
    private final JetClassOrObject declaration;
    private final BindingContext bindingContext;
    private final ClassDescriptor classDescriptor;

    public DataClassMethodGenerator(JetClassOrObject declaration, BindingContext bindingContext) {
        this.declaration = declaration;
        this.bindingContext = bindingContext;
        this.classDescriptor = BindingContextUtils.getNotNull(bindingContext, BindingContext.CLASS, declaration);
    }

    public void generate() {
        this.generateComponentFunctionsForDataClasses();
        this.generateCopyFunctionForDataClasses(this.getPrimaryConstructorParameters());
        List<PropertyDescriptor> properties2 = this.getDataProperties();
        if (!properties2.isEmpty()) {
            this.generateDataClassToStringIfNeeded(properties2);
            this.generateDataClassHashCodeIfNeeded(properties2);
            this.generateDataClassEqualsIfNeeded(properties2);
        }
    }

    protected abstract void generateComponentFunction(@NotNull FunctionDescriptor var1, @NotNull ValueParameterDescriptor var2);

    protected abstract void generateCopyFunction(@NotNull FunctionDescriptor var1, @NotNull List<JetParameter> var2);

    protected abstract void generateToStringMethod(@NotNull List<PropertyDescriptor> var1);

    protected abstract void generateHashCodeMethod(@NotNull List<PropertyDescriptor> var1);

    protected abstract void generateEqualsMethod(@NotNull List<PropertyDescriptor> var1);

    protected ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    private void generateComponentFunctionsForDataClasses() {
        ConstructorDescriptor constructor2 = this.classDescriptor.getUnsubstitutedPrimaryConstructor();
        if (constructor2 == null) {
            return;
        }
        for (ValueParameterDescriptor parameter : constructor2.getValueParameters()) {
            FunctionDescriptor function = this.bindingContext.get(BindingContext.DATA_CLASS_COMPONENT_FUNCTION, parameter);
            if (function == null) continue;
            this.generateComponentFunction(function, parameter);
        }
    }

    private void generateCopyFunctionForDataClasses(List<JetParameter> constructorParameters) {
        FunctionDescriptor copyFunction = this.bindingContext.get(BindingContext.DATA_CLASS_COPY_FUNCTION, this.classDescriptor);
        if (copyFunction != null) {
            this.generateCopyFunction(copyFunction, constructorParameters);
        }
    }

    private void generateDataClassToStringIfNeeded(@NotNull List<PropertyDescriptor> properties2) {
        if (properties2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/kotlin/backend/common/DataClassMethodGenerator", "generateDataClassToStringIfNeeded"));
        }
        ClassDescriptor stringClass = DescriptorUtilPackage.getBuiltIns(this.classDescriptor).getString();
        if (!this.hasDeclaredNonTrivialMember("toString", stringClass, new ClassDescriptor[0])) {
            this.generateToStringMethod(properties2);
        }
    }

    private void generateDataClassHashCodeIfNeeded(@NotNull List<PropertyDescriptor> properties2) {
        if (properties2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/kotlin/backend/common/DataClassMethodGenerator", "generateDataClassHashCodeIfNeeded"));
        }
        ClassDescriptor intClass = DescriptorUtilPackage.getBuiltIns(this.classDescriptor).getInt();
        if (!this.hasDeclaredNonTrivialMember("hashCode", intClass, new ClassDescriptor[0])) {
            this.generateHashCodeMethod(properties2);
        }
    }

    private void generateDataClassEqualsIfNeeded(@NotNull List<PropertyDescriptor> properties2) {
        if (properties2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/kotlin/backend/common/DataClassMethodGenerator", "generateDataClassEqualsIfNeeded"));
        }
        ClassDescriptor booleanClass = DescriptorUtilPackage.getBuiltIns(this.classDescriptor).getBoolean();
        ClassDescriptor anyClass = DescriptorUtilPackage.getBuiltIns(this.classDescriptor).getAny();
        if (!this.hasDeclaredNonTrivialMember("equals", booleanClass, anyClass)) {
            this.generateEqualsMethod(properties2);
        }
    }

    private List<PropertyDescriptor> getDataProperties() {
        ArrayList<PropertyDescriptor> result2 = Lists.newArrayList();
        for (JetParameter parameter : this.getPrimaryConstructorParameters()) {
            if (!parameter.hasValOrVarNode()) continue;
            result2.add(this.bindingContext.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter));
        }
        return result2;
    }

    @NotNull
    private List<JetParameter> getPrimaryConstructorParameters() {
        if (this.declaration instanceof JetClass) {
            List<JetParameter> list = ((JetClass)this.declaration).getPrimaryConstructorParameters();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/backend/common/DataClassMethodGenerator", "getPrimaryConstructorParameters"));
            }
            return list;
        }
        List<JetParameter> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/backend/common/DataClassMethodGenerator", "getPrimaryConstructorParameters"));
        }
        return list;
    }

    private boolean hasDeclaredNonTrivialMember(@NotNull String name, @NotNull ClassDescriptor returnedClassifier, ClassDescriptor ... valueParameterClassifiers) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/backend/common/DataClassMethodGenerator", "hasDeclaredNonTrivialMember"));
        }
        if (returnedClassifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnedClassifier", "org/jetbrains/kotlin/backend/common/DataClassMethodGenerator", "hasDeclaredNonTrivialMember"));
        }
        if (valueParameterClassifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameterClassifiers", "org/jetbrains/kotlin/backend/common/DataClassMethodGenerator", "hasDeclaredNonTrivialMember"));
        }
        FunctionDescriptor function = CodegenUtil.getDeclaredFunctionByRawSignature(this.classDescriptor, Name.identifier(name), returnedClassifier, valueParameterClassifiers);
        if (function == null) {
            return false;
        }
        if (function.getKind() == CallableMemberDescriptor.Kind.DECLARATION) {
            return true;
        }
        for (CallableMemberDescriptor overridden : OverrideResolver.getOverriddenDeclarations(function)) {
            if (!(overridden instanceof CallableMemberDescriptor) || overridden.getKind() != CallableMemberDescriptor.Kind.DECLARATION || overridden.getContainingDeclaration().equals(DescriptorUtilPackage.getBuiltIns(this.classDescriptor).getAny())) continue;
            return true;
        }
        return false;
    }
}

