/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin;

import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import java.lang.reflect.Constructor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.JetLanguage;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetElementImpl;

public class JetNodeType
extends IElementType {
    private Constructor<? extends JetElement> myPsiFactory;

    public JetNodeType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/kotlin/JetNodeType", "<init>"));
        }
        this(debugName, (Class<? extends JetElement>)null);
    }

    public JetNodeType(@NotNull @NonNls String debugName, Class<? extends JetElement> psiClass) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/kotlin/JetNodeType", "<init>"));
        }
        super(debugName, JetLanguage.INSTANCE);
        try {
            this.myPsiFactory = psiClass != null ? psiClass.getConstructor(ASTNode.class) : null;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Must have a constructor with ASTNode");
        }
    }

    public JetElement createPsi(ASTNode node) {
        assert (node.getElementType() == this);
        try {
            if (this.myPsiFactory == null) {
                return new JetElementImpl(node);
            }
            return this.myPsiFactory.newInstance(node);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating psi element for node", e);
        }
    }
}

