/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.relocated.gnu.trove.THashSet;

public class JavaSdkUtil {
    @NotNull
    public static List<File> getJdkClassesRoots(@NotNull File home, boolean isJre) {
        File classesDir;
        String[] additionalJars;
        File libDir;
        File[] jarDirs;
        if (home == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "home", "org/jetbrains/jps/model/java/impl/JavaSdkUtil", "getJdkClassesRoots"));
        }
        if (SystemInfo.isMac && !home.getName().startsWith("mockJDK")) {
            File libEndorsedDir;
            File libExtDir;
            File classesDir2;
            File libDir2;
            File openJdkRtJar = new File(home, "jre/lib/rt.jar");
            if (openJdkRtJar.exists() && !openJdkRtJar.isDirectory()) {
                libDir2 = new File(home, "lib");
                classesDir2 = openJdkRtJar.getParentFile();
                libExtDir = new File(openJdkRtJar.getParentFile(), "ext");
                libEndorsedDir = new File(libDir2, "endorsed");
                jarDirs = new File[]{libEndorsedDir, libDir2, classesDir2, libExtDir};
            } else {
                libDir2 = new File(home, "lib");
                classesDir2 = new File(home, "../Classes");
                libExtDir = new File(libDir2, "ext");
                libEndorsedDir = new File(libDir2, "endorsed");
                jarDirs = new File[]{libEndorsedDir, libDir2, classesDir2, libExtDir};
            }
        } else if (new File(home, "lib/modules").isDirectory()) {
            libDir = new File(home, "lib");
            jarDirs = new File[]{libDir};
        } else {
            libDir = isJre ? new File(home, "lib") : new File(home, "jre/lib");
            File libExtDir = new File(libDir, "ext");
            File libEndorsedDir = new File(libDir, "endorsed");
            jarDirs = new File[]{libEndorsedDir, libDir, libExtDir};
        }
        FileFilter jarFileFilter = new FileFilter(){

            @Override
            public boolean accept(@NotNull File f) {
                if (f == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/jps/model/java/impl/JavaSdkUtil$1", "accept"));
                }
                return !f.isDirectory() && f.getName().endsWith(".jar");
            }
        };
        THashSet<String> pathFilter = ContainerUtil.newTroveSet(FileUtil.PATH_HASHING_STRATEGY);
        ArrayList<File> rootFiles = ContainerUtil.newArrayList();
        for (File jarDir : jarDirs) {
            File[] jarFiles;
            if (jarDir == null || !jarDir.isDirectory()) continue;
            for (File jarFile : jarFiles = jarDir.listFiles(jarFileFilter)) {
                String canonicalPath;
                String jarFileName = jarFile.getName();
                if (jarFileName.equals("alt-rt.jar") || jarFileName.equals("alt-string.jar") || (canonicalPath = JavaSdkUtil.getCanonicalPath(jarFile)) == null || !pathFilter.add(canonicalPath)) continue;
                rootFiles.add(jarFile);
            }
        }
        for (String relativePath : additionalJars = new String[]{"jre/bin/default/jclSC170/vm.jar", "jre/lib/i386/default/jclSC170/vm.jar", "jre/lib/amd64/default/jclSC170/vm.jar", "jre/bin/default/jclSC160/vm.jar", "jre/lib/i386/default/jclSC160/vm.jar", "jre/lib/amd64/default/jclSC160/vm.jar", "lib/classes.zip"}) {
            File jar = new File(home, relativePath);
            if (!jar.isFile()) continue;
            rootFiles.add(jar);
        }
        if (rootFiles.isEmpty() && (classesDir = new File(home, "classes")).isDirectory()) {
            rootFiles.add(classesDir);
        }
        ArrayList<File> arrayList = rootFiles;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/impl/JavaSdkUtil", "getJdkClassesRoots"));
        }
        return arrayList;
    }

    @Nullable
    private static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
    }
}

