/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Getter;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.relocated.gnu.trove.TObjectHashingStrategy;

public class ConcurrentWeakKeySoftValueHashMap<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentMap<KeyReference<K, V>, ValueReference<K, V>> myMap;
    final ReferenceQueue<K> myKeyQueue;
    final ReferenceQueue<V> myValueQueue;
    @NotNull
    final TObjectHashingStrategy<K> myHashingStrategy;
    private static final ThreadLocal<HardKey> HARD_KEY = new ThreadLocal<HardKey>(){

        @Override
        protected HardKey initialValue() {
            return new HardKey();
        }
    };

    public ConcurrentWeakKeySoftValueHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<K> hashingStrategy) {
        if (hashingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap", "<init>"));
        }
        this.myKeyQueue = new ReferenceQueue();
        this.myValueQueue = new ReferenceQueue();
        this.myHashingStrategy = hashingStrategy;
        this.myMap = ContainerUtil.newConcurrentMap(initialCapacity, loadFactor, concurrencyLevel, ContainerUtil.canonicalStrategy());
    }

    @NotNull
    protected KeyReference<K, V> createKeyReference(@NotNull K k, @NotNull V v) {
        if (k == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k", "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap", "createKeyReference"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap", "createKeyReference"));
        }
        ValueReference<K, V> valueReference = this.createValueReference(v, this.myValueQueue);
        WeakKey<K, V> keyReference = new WeakKey<K, V>(k, valueReference, this.myHashingStrategy, this.myKeyQueue);
        if (valueReference instanceof SoftValue) {
            ((SoftValue)valueReference).myKeyReference = keyReference;
        }
        WeakKey<K, V> weakKey = keyReference;
        if (weakKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap", "createKeyReference"));
        }
        return weakKey;
    }

    @NotNull
    protected ValueReference<K, V> createValueReference(@NotNull V value, @NotNull ReferenceQueue<V> queue) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap", "createValueReference"));
        }
        if (queue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queue", "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap", "createValueReference"));
        }
        SoftValue softValue = new SoftValue(value, queue);
        if (softValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap", "createValueReference"));
        }
        return softValue;
    }

    @Override
    public int size() {
        return this.myMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    public void clear() {
        this.processQueues();
        this.myMap.clear();
    }

    @NotNull
    private HardKey<K, V> createHardKey(Object o) {
        Object key = o;
        HardKey hardKey = HARD_KEY.get();
        hardKey.set(key, this.myHashingStrategy.computeHashCode(key));
        HardKey hardKey2 = hardKey;
        if (hardKey2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap", "createHardKey"));
        }
        return hardKey2;
    }

    @Override
    public V get(@NotNull Object key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap", "get"));
        }
        HardKey<K, V> hardKey = this.createHardKey(key);
        ValueReference valueReference = (ValueReference)this.myMap.get(hardKey);
        Object v = SoftReference.deref(valueReference);
        ((HardKey)hardKey).clear();
        return (V)v;
    }

    @Override
    public boolean containsKey(Object key) {
        HardKey<K, V> hardKey = this.createHardKey(key);
        boolean result2 = this.myMap.containsKey(hardKey);
        ((HardKey)hardKey).clear();
        return result2;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        this.processQueues();
        HardKey<K, V> hardKey = this.createHardKey(key);
        ValueReference valueReference = (ValueReference)this.myMap.remove(hardKey);
        Object v = SoftReference.deref(valueReference);
        ((HardKey)hardKey).clear();
        return (V)v;
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        if (m == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "m", "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap", "putAll"));
        }
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V put(K key, V value) {
        this.processQueues();
        KeyReference<K, V> keyReference = this.createKeyReference(key, value);
        ValueReference<K, V> valueReference = keyReference.getValueReference();
        ValueReference<K, V> prevValReference = this.myMap.put(keyReference, valueReference);
        return (V)SoftReference.deref(prevValReference);
    }

    boolean processQueues() {
        ValueReference valueReference;
        KeyReference keyReference;
        boolean removed = false;
        while ((keyReference = (KeyReference)((Object)this.myKeyQueue.poll())) != null) {
            valueReference = keyReference.getValueReference();
            removed |= this.myMap.remove(keyReference, valueReference);
        }
        while ((valueReference = (ValueReference)((Object)this.myValueQueue.poll())) != null) {
            keyReference = valueReference.getKeyReference();
            removed |= this.myMap.remove(keyReference, valueReference);
        }
        return removed;
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(@NotNull Object key, @NotNull Object value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap", "remove"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap", "remove"));
        }
        this.processQueues();
        HardKey<K, V> hardKey = this.createHardKey(key);
        ValueReference valueReference = (ValueReference)this.myMap.get(hardKey);
        Object v = SoftReference.deref(valueReference);
        boolean result2 = value.equals(v) && this.myMap.remove(hardKey, valueReference);
        ((HardKey)hardKey).clear();
        return result2;
    }

    @Override
    public V putIfAbsent(@NotNull K key, @NotNull V value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap", "putIfAbsent"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap", "putIfAbsent"));
        }
        this.processQueues();
        KeyReference<K, V> keyReference = this.createKeyReference(key, value);
        ValueReference<K, V> valueReference = keyReference.getValueReference();
        ValueReference<K, V> result2 = this.myMap.putIfAbsent(keyReference, valueReference);
        return (V)SoftReference.deref(result2);
    }

    @Override
    public boolean replace(@NotNull K key, @NotNull V oldValue, @NotNull V newValue) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap", "replace"));
        }
        if (oldValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldValue", "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap", "replace"));
        }
        if (newValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newValue", "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap", "replace"));
        }
        this.processQueues();
        KeyReference<K, V> oldKeyReference = this.createKeyReference(key, oldValue);
        ValueReference<K, V> oldValueReference = oldKeyReference.getValueReference();
        KeyReference<K, V> newKeyReference = this.createKeyReference(key, newValue);
        ValueReference<K, V> newValueReference = newKeyReference.getValueReference();
        return this.myMap.replace(oldKeyReference, oldValueReference, newValueReference);
    }

    @Override
    public V replace(@NotNull K key, @NotNull V value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap", "replace"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap", "replace"));
        }
        this.processQueues();
        KeyReference<K, V> keyReference = this.createKeyReference(key, value);
        ValueReference<K, V> valueReference = keyReference.getValueReference();
        ValueReference<K, V> result2 = this.myMap.replace(keyReference, valueReference);
        return (V)SoftReference.deref(result2);
    }

    private static class HardKey<K, V>
    implements KeyReference<K, V> {
        private K myKey;
        private int myHash;

        private HardKey() {
        }

        private void set(@NotNull K key, int hash) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap$HardKey", "set"));
            }
            this.myKey = key;
            this.myHash = hash;
        }

        private void clear() {
            this.myKey = null;
        }

        @Override
        public K get() {
            return this.myKey;
        }

        public boolean equals(Object o) {
            return o.equals(this);
        }

        public int hashCode() {
            return this.myHash;
        }

        @Override
        @NotNull
        public ValueReference<K, V> getValueReference() {
            throw new UnsupportedOperationException();
        }
    }

    private static class SoftValue<K, V>
    extends java.lang.ref.SoftReference<V>
    implements ValueReference<K, V> {
        @NotNull
        private volatile KeyReference<K, V> myKeyReference;
        private final int myHash;

        private SoftValue(@NotNull V value, @NotNull ReferenceQueue<V> queue) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap$SoftValue", "<init>"));
            }
            if (queue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queue", "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap$SoftValue", "<init>"));
            }
            super(value, queue);
            this.myHash = value.hashCode();
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            ValueReference that = (ValueReference)o;
            return this.myHash == that.hashCode() && Comparing.equal(this.get(), that.get());
        }

        public final int hashCode() {
            return this.myHash;
        }

        @Override
        @NotNull
        public KeyReference<K, V> getKeyReference() {
            KeyReference<K, V> keyReference = this.myKeyReference;
            if (keyReference == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap$SoftValue", "getKeyReference"));
            }
            return keyReference;
        }
    }

    static class WeakKey<K, V>
    extends WeakReference<K>
    implements KeyReference<K, V> {
        private final int myHash;
        private final TObjectHashingStrategy<K> myStrategy;
        @NotNull
        private final ValueReference<K, V> myValueReference;

        WeakKey(@NotNull K k, @NotNull ValueReference<K, V> valueReference, @NotNull TObjectHashingStrategy<K> strategy, @NotNull ReferenceQueue<K> queue) {
            if (k == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k", "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap$WeakKey", "<init>"));
            }
            if (valueReference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueReference", "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap$WeakKey", "<init>"));
            }
            if (strategy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap$WeakKey", "<init>"));
            }
            if (queue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queue", "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap$WeakKey", "<init>"));
            }
            super(k, queue);
            this.myValueReference = valueReference;
            this.myHash = strategy.computeHashCode(k);
            this.myStrategy = strategy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof KeyReference)) {
                return false;
            }
            Object t = this.get();
            Object other = ((KeyReference)o).get();
            if (t == null || other == null) {
                return false;
            }
            if (t == other) {
                return true;
            }
            return this.myHash == o.hashCode() && this.myStrategy.equals(t, other);
        }

        public int hashCode() {
            return this.myHash;
        }

        @Override
        @NotNull
        public ValueReference<K, V> getValueReference() {
            ValueReference<K, V> valueReference = this.myValueReference;
            if (valueReference == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap$WeakKey", "getValueReference"));
            }
            return valueReference;
        }
    }

    public static interface ValueReference<K, V>
    extends Getter<V> {
        @NotNull
        public KeyReference<K, V> getKeyReference();

        @Override
        public V get();
    }

    public static interface KeyReference<K, V>
    extends Getter<K> {
        @Override
        public K get();

        @NotNull
        public ValueReference<K, V> getValueReference();
    }
}

