/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ConcurrentRefHashMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.relocated.gnu.trove.TObjectHashingStrategy;

final class ConcurrentSoftHashMap<K, V>
extends ConcurrentRefHashMap<K, V> {
    @Override
    protected ConcurrentRefHashMap.KeyReference<K, V> createKeyReference(@NotNull K key, @NotNull V value, @NotNull TObjectHashingStrategy<K> hashingStrategy) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentSoftHashMap", "createKeyReference"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentSoftHashMap", "createKeyReference"));
        }
        if (hashingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/util/containers/ConcurrentSoftHashMap", "createKeyReference"));
        }
        return new SoftKey(key, hashingStrategy.computeHashCode(key), hashingStrategy, value, this.myReferenceQueue);
    }

    private static class SoftKey<K, V>
    extends SoftReference<K>
    implements ConcurrentRefHashMap.KeyReference<K, V> {
        private final int myHash;
        private final TObjectHashingStrategy<K> myStrategy;
        private final V value;

        private SoftKey(@NotNull K k, int hash, @NotNull TObjectHashingStrategy<K> strategy, V v, @NotNull ReferenceQueue<K> q) {
            if (k == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k", "com/intellij/util/containers/ConcurrentSoftHashMap$SoftKey", "<init>"));
            }
            if (strategy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "com/intellij/util/containers/ConcurrentSoftHashMap$SoftKey", "<init>"));
            }
            if (q == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "q", "com/intellij/util/containers/ConcurrentSoftHashMap$SoftKey", "<init>"));
            }
            super(k, q);
            this.myStrategy = strategy;
            this.value = v;
            this.myHash = hash;
        }

        @Override
        @NotNull
        public V getValue() {
            V v = this.value;
            if (v == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentSoftHashMap$SoftKey", "getValue"));
            }
            return v;
        }

        public boolean equals(Object o) {
            Object u;
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConcurrentRefHashMap.KeyReference)) {
                return false;
            }
            Object t = this.get();
            if (t == (u = ((ConcurrentRefHashMap.KeyReference)o).get())) {
                return true;
            }
            if (t == null || u == null) {
                return false;
            }
            return this.myStrategy.equals(t, u);
        }

        public int hashCode() {
            return this.myHash;
        }
    }
}

