/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.source.ClassInnerStuffCache;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.ElementClassFilter;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.FilterScopeProcessor;
import com.intellij.psi.scope.processor.MethodResolverProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.ui.IconDeferrer;
import com.intellij.ui.RowIcon;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.relocated.gnu.trove.THashMap;
import org.jetbrains.kotlin.relocated.gnu.trove.THashSet;

public class PsiClassImplUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.PsiClassImplUtil");
    private static final Key<ParameterizedCachedValue<Map<GlobalSearchScope, MembersMap>, PsiClass>> MAP_IN_CLASS_KEY = Key.create("MAP_KEY");
    private static final Function<ClassIconRequest, Icon> FULL_ICON_EVALUATOR = new NullableFunction<ClassIconRequest, Icon>(){

        @Override
        public Icon fun(ClassIconRequest r) {
            if (!r.psiClass.isValid() || r.psiClass.getProject().isDisposed()) {
                return null;
            }
            boolean isLocked = (r.flags & 2) != 0 && !r.psiClass.isWritable();
            Icon symbolIcon = r.symbolIcon != null ? r.symbolIcon : ElementPresentationUtil.getClassIconOfKind(r.psiClass, ElementPresentationUtil.getClassKind(r.psiClass));
            RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon(symbolIcon, r.psiClass, isLocked);
            return ElementPresentationUtil.addVisibilityIcon(r.psiClass, r.flags, baseIcon);
        }
    };

    private PsiClassImplUtil() {
    }

    @NotNull
    public static PsiField[] getAllFields(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "getAllFields"));
        }
        List<PsiField> map = PsiClassImplUtil.getAllByMap(aClass, MemberType.FIELD);
        PsiField[] psiFieldArray = map.toArray(new PsiField[map.size()]);
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getAllFields"));
        }
        return psiFieldArray;
    }

    @NotNull
    public static PsiMethod[] getAllMethods(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "getAllMethods"));
        }
        List<PsiMethod> methods = PsiClassImplUtil.getAllByMap(aClass, MemberType.METHOD);
        PsiMethod[] psiMethodArray = methods.toArray(new PsiMethod[methods.size()]);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getAllMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    public static PsiClass[] getAllInnerClasses(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "getAllInnerClasses"));
        }
        List<PsiClass> classes2 = PsiClassImplUtil.getAllByMap(aClass, MemberType.CLASS);
        PsiClass[] psiClassArray = classes2.toArray(new PsiClass[classes2.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getAllInnerClasses"));
        }
        return psiClassArray;
    }

    @Nullable
    public static PsiField findFieldByName(@NotNull PsiClass aClass, String name, boolean checkBases) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "findFieldByName"));
        }
        List<PsiMember> byMap = PsiClassImplUtil.findByMap(aClass, name, checkBases, MemberType.FIELD);
        return byMap.isEmpty() ? null : (PsiField)byMap.get(0);
    }

    @NotNull
    public static PsiMethod[] findMethodsByName(@NotNull PsiClass aClass, String name, boolean checkBases) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "findMethodsByName"));
        }
        List<PsiMember> methods = PsiClassImplUtil.findByMap(aClass, name, checkBases, MemberType.METHOD);
        PsiMethod[] psiMethodArray = methods.toArray(new PsiMethod[methods.size()]);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "findMethodsByName"));
        }
        return psiMethodArray;
    }

    @Nullable
    public static PsiMethod findMethodBySignature(@NotNull PsiClass aClass, @NotNull PsiMethod patternMethod, boolean checkBases) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "findMethodBySignature"));
        }
        if (patternMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternMethod", "com/intellij/psi/impl/PsiClassImplUtil", "findMethodBySignature"));
        }
        List<PsiMethod> result2 = PsiClassImplUtil.findMethodsBySignature(aClass, patternMethod, checkBases, true);
        return result2.isEmpty() ? null : result2.get(0);
    }

    @NotNull
    public static PsiMethod[] findMethodsBySignature(@NotNull PsiClass aClass, @NotNull PsiMethod patternMethod, boolean checkBases) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "findMethodsBySignature"));
        }
        if (patternMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternMethod", "com/intellij/psi/impl/PsiClassImplUtil", "findMethodsBySignature"));
        }
        List<PsiMethod> methods = PsiClassImplUtil.findMethodsBySignature(aClass, patternMethod, checkBases, false);
        PsiMethod[] psiMethodArray = methods.toArray(new PsiMethod[methods.size()]);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "findMethodsBySignature"));
        }
        return psiMethodArray;
    }

    @NotNull
    private static List<PsiMethod> findMethodsBySignature(@NotNull PsiClass aClass, @NotNull PsiMethod patternMethod, boolean checkBases, boolean stopOnFirst) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "findMethodsBySignature"));
        }
        if (patternMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternMethod", "com/intellij/psi/impl/PsiClassImplUtil", "findMethodsBySignature"));
        }
        PsiMethod[] methodsByName = aClass.findMethodsByName(patternMethod.getName(), checkBases);
        if (methodsByName.length == 0) {
            List<PsiMethod> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "findMethodsBySignature"));
            }
            return list;
        }
        SmartList<PsiMethod> methods = new SmartList<PsiMethod>();
        MethodSignature patternSignature = patternMethod.getSignature(PsiSubstitutor.EMPTY);
        for (PsiMethod method : methodsByName) {
            PsiClass superClass = method.getContainingClass();
            PsiSubstitutor substitutor = checkBases && !aClass.equals(superClass) && superClass != null ? TypeConversionUtil.getSuperClassSubstitutor(superClass, aClass, PsiSubstitutor.EMPTY) : PsiSubstitutor.EMPTY;
            MethodSignature signature = method.getSignature(substitutor);
            if (!signature.equals(patternSignature)) continue;
            methods.add(method);
            if (stopOnFirst) break;
        }
        SmartList<PsiMethod> smartList = methods;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "findMethodsBySignature"));
        }
        return smartList;
    }

    @Nullable
    public static PsiClass findInnerByName(@NotNull PsiClass aClass, String name, boolean checkBases) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "findInnerByName"));
        }
        List<PsiMember> byMap = PsiClassImplUtil.findByMap(aClass, name, checkBases, MemberType.CLASS);
        return byMap.isEmpty() ? null : (PsiClass)byMap.get(0);
    }

    @NotNull
    private static List<PsiMember> findByMap(@NotNull PsiClass aClass, String name, boolean checkBases, @NotNull MemberType type2) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "findByMap"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/PsiClassImplUtil", "findByMap"));
        }
        if (name == null) {
            List<PsiMember> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "findByMap"));
            }
            return list;
        }
        if (checkBases) {
            Map<String, List<Pair<PsiMember, PsiSubstitutor>>> allMethodsMap = PsiClassImplUtil.getMap(aClass, type2);
            List<Pair<PsiMember, PsiSubstitutor>> list = allMethodsMap.get(name);
            if (list == null) {
                List<PsiMember> list2 = Collections.emptyList();
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "findByMap"));
                }
                return list2;
            }
            ArrayList<PsiMember> ret = new ArrayList<PsiMember>(list.size());
            for (Pair<PsiMember, PsiSubstitutor> info : list) {
                ret.add(info.getFirst());
            }
            ArrayList<PsiMember> arrayList = ret;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "findByMap"));
            }
            return arrayList;
        }
        PsiMember[] members = null;
        switch (type2) {
            case METHOD: {
                members = aClass.getMethods();
                break;
            }
            case CLASS: {
                members = aClass.getInnerClasses();
                break;
            }
            case FIELD: {
                members = aClass.getFields();
            }
        }
        ArrayList<PsiMember> list = new ArrayList<PsiMember>();
        for (PsiMember member : members) {
            if (!name.equals(member.getName())) continue;
            list.add(member);
        }
        ArrayList<PsiMember> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "findByMap"));
        }
        return arrayList;
    }

    @NotNull
    public static <T extends PsiMember> List<Pair<T, PsiSubstitutor>> getAllWithSubstitutorsByMap(@NotNull PsiClass aClass, @NotNull MemberType type2) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "getAllWithSubstitutorsByMap"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/PsiClassImplUtil", "getAllWithSubstitutorsByMap"));
        }
        Map<String, List<Pair<PsiMember, PsiSubstitutor>>> allMap = PsiClassImplUtil.getMap(aClass, type2);
        List<Pair<T, PsiSubstitutor>> list = allMap.get("Intellij-IDEA-ALL");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getAllWithSubstitutorsByMap"));
        }
        return list;
    }

    @NotNull
    private static <T extends PsiMember> List<T> getAllByMap(@NotNull PsiClass aClass, @NotNull MemberType type2) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "getAllByMap"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/PsiClassImplUtil", "getAllByMap"));
        }
        List<Pair<T, PsiSubstitutor>> pairs = PsiClassImplUtil.getAllWithSubstitutorsByMap(aClass, type2);
        ArrayList<PsiMember> ret = new ArrayList<PsiMember>(pairs.size());
        for (int i = 0; i < pairs.size(); ++i) {
            Pair<T, PsiSubstitutor> pair = pairs.get(i);
            PsiMember t = (PsiMember)pair.getFirst();
            LOG.assertTrue(t != null, aClass);
            ret.add(t);
        }
        ArrayList<PsiMember> arrayList = ret;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getAllByMap"));
        }
        return arrayList;
    }

    private static Map<String, List<Pair<PsiMember, PsiSubstitutor>>> getMap(@NotNull PsiClass aClass, @NotNull MemberType type2) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "getMap"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/PsiClassImplUtil", "getMap"));
        }
        ParameterizedCachedValue<Map<GlobalSearchScope, MembersMap>, PsiClass> value = PsiClassImplUtil.getValues(aClass);
        return (Map)value.getValue(aClass).get(aClass.getResolveScope()).get((Object)type2);
    }

    @NotNull
    private static ParameterizedCachedValue<Map<GlobalSearchScope, MembersMap>, PsiClass> getValues(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "getValues"));
        }
        ParameterizedCachedValue<Map<GlobalSearchScope, MembersMap>, PsiClass> value = aClass.getUserData(MAP_IN_CLASS_KEY);
        if (value == null) {
            value = CachedValuesManager.getManager(aClass.getProject()).createParameterizedCachedValue(ByNameCachedValueProvider.INSTANCE, false);
            if (aClass.isPhysical()) {
                value = ((UserDataHolderEx)((Object)aClass)).putUserDataIfAbsent(MAP_IN_CLASS_KEY, value);
            }
        }
        ParameterizedCachedValue<Map<GlobalSearchScope, MembersMap>, PsiClass> parameterizedCachedValue = value;
        if (parameterizedCachedValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getValues"));
        }
        return parameterizedCachedValue;
    }

    public static Icon getClassIcon(int flags, @NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "getClassIcon"));
        }
        return PsiClassImplUtil.getClassIcon(flags, aClass, null);
    }

    public static Icon getClassIcon(int flags, @NotNull PsiClass aClass, @Nullable Icon symbolIcon) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "getClassIcon"));
        }
        Icon base = Iconable.LastComputedIcon.get(aClass, flags);
        if (base == null) {
            if (symbolIcon == null) {
                symbolIcon = ElementPresentationUtil.getClassIconOfKind(aClass, ElementPresentationUtil.getBasicClassKind(aClass));
            }
            RowIcon baseIcon = ElementBase.createLayeredIcon(aClass, symbolIcon, 0);
            base = ElementPresentationUtil.addVisibilityIcon(aClass, flags, baseIcon);
        }
        return IconDeferrer.getInstance().defer(base, new ClassIconRequest(aClass, flags, symbolIcon), FULL_ICON_EVALUATOR);
    }

    @NotNull
    public static SearchScope getClassUseScope(@NotNull PsiClass aClass) {
        PsiDirectory dir;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "getClassUseScope"));
        }
        if (aClass instanceof PsiAnonymousClass) {
            LocalSearchScope localSearchScope = new LocalSearchScope(aClass);
            if (localSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getClassUseScope"));
            }
            return localSearchScope;
        }
        GlobalSearchScope maximalUseScope = ResolveScopeManager.getElementUseScope(aClass);
        PsiFile file = aClass.getContainingFile();
        if (PsiImplUtil.isInServerPage(file)) {
            GlobalSearchScope globalSearchScope = maximalUseScope;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getClassUseScope"));
            }
            return globalSearchScope;
        }
        PsiClass containingClass = aClass.getContainingClass();
        if (aClass.hasModifierProperty("public") || aClass.hasModifierProperty("protected")) {
            SearchScope searchScope = containingClass == null ? maximalUseScope : containingClass.getUseScope();
            if (searchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getClassUseScope"));
            }
            return searchScope;
        }
        if (aClass.hasModifierProperty("private") || aClass instanceof PsiTypeParameter) {
            PsiClass topClass = PsiUtil.getTopLevelClass(aClass);
            LocalSearchScope localSearchScope = new LocalSearchScope(topClass == null ? aClass.getContainingFile() : topClass);
            if (localSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getClassUseScope"));
            }
            return localSearchScope;
        }
        PsiPackage aPackage = null;
        if (file instanceof PsiJavaFile) {
            aPackage = JavaPsiFacade.getInstance(aClass.getProject()).findPackage(((PsiJavaFile)file).getPackageName());
        }
        if (aPackage == null && (dir = file.getContainingDirectory()) != null) {
            aPackage = JavaDirectoryService.getInstance().getPackage(dir);
        }
        if (aPackage != null) {
            SearchScope scope2 = PackageScope.packageScope(aPackage, false);
            SearchScope searchScope = scope2 = ((SearchScope)scope2).intersectWith(maximalUseScope);
            if (searchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getClassUseScope"));
            }
            return searchScope;
        }
        LocalSearchScope localSearchScope = new LocalSearchScope(file);
        if (localSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getClassUseScope"));
        }
        return localSearchScope;
    }

    public static boolean isMainOrPremainMethod(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/PsiClassImplUtil", "isMainOrPremainMethod"));
        }
        if (!PsiType.VOID.equals(method.getReturnType())) {
            return false;
        }
        String name = method.getName();
        if (!"main".equals(name) && !"premain".equals(name) && "agentmain".equals(name)) {
            return false;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance(method.getProject()).getElementFactory();
        MethodSignature signature = method.getSignature(PsiSubstitutor.EMPTY);
        try {
            MethodSignature main2 = PsiClassImplUtil.createSignatureFromText(factory, "void main(String[] args);");
            if (MethodSignatureUtil.areSignaturesEqual(signature, main2)) {
                return true;
            }
            MethodSignature premain = PsiClassImplUtil.createSignatureFromText(factory, "void premain(String args, java.lang.instrument.Instrumentation i);");
            if (MethodSignatureUtil.areSignaturesEqual(signature, premain)) {
                return true;
            }
            MethodSignature agentmain = PsiClassImplUtil.createSignatureFromText(factory, "void agentmain(String args, java.lang.instrument.Instrumentation i);");
            if (MethodSignatureUtil.areSignaturesEqual(signature, agentmain)) {
                return true;
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
        }
        return false;
    }

    @NotNull
    private static MethodSignature createSignatureFromText(@NotNull PsiElementFactory factory, @NotNull String text) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/psi/impl/PsiClassImplUtil", "createSignatureFromText"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/PsiClassImplUtil", "createSignatureFromText"));
        }
        MethodSignature methodSignature = factory.createMethodFromText(text, null).getSignature(PsiSubstitutor.EMPTY);
        if (methodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "createSignatureFromText"));
        }
        return methodSignature;
    }

    public static boolean processDeclarationsInEnum(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull ClassInnerStuffCache innerStuffCache) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInEnum"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInEnum"));
        }
        if (innerStuffCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerStuffCache", "com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInEnum"));
        }
        ElementClassHint classHint = processor.getHint(ElementClassHint.KEY);
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.METHOD)) {
            PsiMethod method;
            NameHint nameHint = processor.getHint(NameHint.KEY);
            if ((nameHint == null || "values".equals(nameHint.getName(state))) && (method = innerStuffCache.getValuesMethod()) != null && !processor.execute(method, ResolveState.initial())) {
                return false;
            }
            if ((nameHint == null || "valueOf".equals(nameHint.getName(state))) && (method = innerStuffCache.getValueOfMethod()) != null && !processor.execute(method, ResolveState.initial())) {
                return false;
            }
        }
        return true;
    }

    public static boolean processDeclarationsInClass(@NotNull PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable Set<PsiClass> visited, PsiElement last, @NotNull PsiElement place, @NotNull LanguageLevel languageLevel, boolean isRaw) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClass"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClass"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClass"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClass"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClass"));
        }
        return PsiClassImplUtil.processDeclarationsInClass(aClass, processor, state, visited, last, place, languageLevel, isRaw, place.getResolveScope());
    }

    private static boolean processDeclarationsInClass(@NotNull PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable Set<PsiClass> visited, PsiElement last, @NotNull PsiElement place, @NotNull LanguageLevel languageLevel, boolean isRaw, @NotNull GlobalSearchScope resolveScope) {
        NameHint nameHint;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClass"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClass"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClass"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClass"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClass"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClass"));
        }
        if (last instanceof PsiTypeParameterList || last instanceof PsiModifierList) {
            return true;
        }
        if (visited != null && visited.contains(aClass)) {
            return true;
        }
        PsiSubstitutor substitutor = state.get(PsiSubstitutor.KEY);
        isRaw = isRaw || PsiUtil.isRawSubstitutor(aClass, substitutor);
        ParameterizedCachedValue<Map<GlobalSearchScope, MembersMap>, PsiClass> cache2 = PsiClassImplUtil.getValues(aClass);
        boolean upToDate = cache2.hasUpToDateValue();
        if (upToDate && (nameHint = processor.getHint(NameHint.KEY)) != null) {
            String name = nameHint.getName(state);
            return PsiClassImplUtil.processCachedMembersByName(aClass, processor, state, visited, last, place, isRaw, substitutor, cache2.getValue(aClass).get(resolveScope), name, languageLevel);
        }
        return PsiClassImplUtil.processDeclarationsInClassNotCached(aClass, processor, state, visited, last, place, isRaw, languageLevel, resolveScope);
    }

    private static boolean processCachedMembersByName(@NotNull PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable Set<PsiClass> visited, PsiElement last, @NotNull PsiElement place, boolean isRaw, @NotNull PsiSubstitutor substitutor, @NotNull MembersMap value, String name, @NotNull LanguageLevel languageLevel) {
        PsiSubstitutor finalSubstitutor;
        PsiClass containingClass;
        boolean resolved;
        List list;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "processCachedMembersByName"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/PsiClassImplUtil", "processCachedMembersByName"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/PsiClassImplUtil", "processCachedMembersByName"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/PsiClassImplUtil", "processCachedMembersByName"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/impl/PsiClassImplUtil", "processCachedMembersByName"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/impl/PsiClassImplUtil", "processCachedMembersByName"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/impl/PsiClassImplUtil", "processCachedMembersByName"));
        }
        ElementClassHint classHint = processor.getHint(ElementClassHint.KEY);
        PsiElementFactory factory = JavaPsiFacade.getInstance(aClass.getProject()).getElementFactory();
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.FIELD)) {
            PsiField fieldByName = aClass.findFieldByName(name, false);
            if (fieldByName != null) {
                processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, aClass);
                if (!processor.execute(fieldByName, state)) {
                    return false;
                }
            } else {
                Map allFieldsMap = (Map)value.get((Object)MemberType.FIELD);
                list = (List)allFieldsMap.get(name);
                if (list != null) {
                    resolved = false;
                    for (Pair candidate : list) {
                        PsiMember candidateField = (PsiMember)candidate.getFirst();
                        containingClass = candidateField.getContainingClass();
                        if (containingClass == null) {
                            LOG.error("No class for field " + candidateField.getName() + " of " + candidateField.getClass());
                            continue;
                        }
                        finalSubstitutor = PsiClassImplUtil.obtainFinalSubstitutor(containingClass, (PsiSubstitutor)candidate.getSecond(), aClass, substitutor, factory, languageLevel);
                        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, containingClass);
                        if (processor.execute(candidateField, state.put(PsiSubstitutor.KEY, finalSubstitutor))) continue;
                        resolved = true;
                    }
                    if (resolved) {
                        return false;
                    }
                }
            }
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            if (last != null && last.getContext() == aClass) {
                if (last instanceof PsiClass && !processor.execute(last, state)) {
                    return false;
                }
                PsiTypeParameterList list2 = aClass.getTypeParameterList();
                if (list2 != null && !list2.processDeclarations(processor, state, last, place)) {
                    return false;
                }
            }
            if (!(last instanceof PsiReferenceList)) {
                PsiClass classByName = aClass.findInnerClassByName(name, false);
                if (classByName != null) {
                    processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, aClass);
                    if (!processor.execute(classByName, state)) {
                        return false;
                    }
                } else {
                    Map allClassesMap = (Map)value.get((Object)MemberType.CLASS);
                    list = (List)allClassesMap.get(name);
                    if (list != null) {
                        resolved = false;
                        for (Pair candidate : list) {
                            PsiMember inner = (PsiMember)candidate.getFirst();
                            containingClass = inner.getContainingClass();
                            if (containingClass == null) continue;
                            finalSubstitutor = PsiClassImplUtil.obtainFinalSubstitutor(containingClass, (PsiSubstitutor)candidate.getSecond(), aClass, substitutor, factory, languageLevel);
                            processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, containingClass);
                            if (processor.execute(inner, state.put(PsiSubstitutor.KEY, finalSubstitutor))) continue;
                            resolved = true;
                        }
                        if (resolved) {
                            return false;
                        }
                    }
                }
            }
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.METHOD)) {
            MethodResolverProcessor methodResolverProcessor;
            if (processor instanceof MethodResolverProcessor && (methodResolverProcessor = (MethodResolverProcessor)processor).isConstructor()) {
                PsiMethod[] constructors2 = aClass.getConstructors();
                methodResolverProcessor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, aClass);
                for (PsiMethod constructor2 : constructors2) {
                    if (methodResolverProcessor.execute(constructor2, state)) continue;
                    return false;
                }
                return true;
            }
            Map allMethodsMap = (Map)value.get((Object)MemberType.METHOD);
            List list3 = (List)allMethodsMap.get(name);
            if (list3 != null) {
                boolean resolved2 = false;
                for (Pair candidate : list3) {
                    PsiClass containingClass2;
                    ProgressIndicatorProvider.checkCanceled();
                    PsiMethod candidateMethod = (PsiMethod)candidate.getFirst();
                    if (processor instanceof MethodResolverProcessor && candidateMethod.isConstructor() != ((MethodResolverProcessor)processor).isConstructor() || (containingClass2 = candidateMethod.getContainingClass()) == null || visited != null && visited.contains(containingClass2)) continue;
                    PsiSubstitutor finalSubstitutor2 = PsiClassImplUtil.obtainFinalSubstitutor(containingClass2, (PsiSubstitutor)candidate.getSecond(), aClass, substitutor, factory, languageLevel);
                    finalSubstitutor2 = PsiClassImplUtil.checkRaw(isRaw, factory, candidateMethod, finalSubstitutor2);
                    processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, containingClass2);
                    if (processor.execute(candidateMethod, state.put(PsiSubstitutor.KEY, finalSubstitutor2))) continue;
                    resolved2 = true;
                }
                if (resolved2) {
                    return false;
                }
                if (visited != null) {
                    for (Pair aList : list3) {
                        visited.add(((PsiMember)aList.getFirst()).getContainingClass());
                    }
                }
            }
        }
        return true;
    }

    private static PsiSubstitutor checkRaw(boolean isRaw, @NotNull PsiElementFactory factory, @NotNull PsiMethod candidateMethod, @NotNull PsiSubstitutor substitutor) {
        PsiClass containingClass;
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/psi/impl/PsiClassImplUtil", "checkRaw"));
        }
        if (candidateMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateMethod", "com/intellij/psi/impl/PsiClassImplUtil", "checkRaw"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/impl/PsiClassImplUtil", "checkRaw"));
        }
        if (isRaw && !candidateMethod.hasModifierProperty("static") && (containingClass = candidateMethod.getContainingClass()) != null && containingClass.hasTypeParameters()) {
            PsiTypeParameter[] methodTypeParameters = candidateMethod.getTypeParameters();
            substitutor = factory.createRawSubstitutor(substitutor, methodTypeParameters);
        }
        return substitutor;
    }

    public static PsiSubstitutor obtainFinalSubstitutor(@NotNull PsiClass candidateClass, @NotNull PsiSubstitutor candidateSubstitutor, @NotNull PsiClass aClass, @NotNull PsiSubstitutor substitutor, @NotNull PsiElementFactory elementFactory, @NotNull LanguageLevel languageLevel) {
        if (candidateClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateClass", "com/intellij/psi/impl/PsiClassImplUtil", "obtainFinalSubstitutor"));
        }
        if (candidateSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateSubstitutor", "com/intellij/psi/impl/PsiClassImplUtil", "obtainFinalSubstitutor"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "obtainFinalSubstitutor"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/impl/PsiClassImplUtil", "obtainFinalSubstitutor"));
        }
        if (elementFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementFactory", "com/intellij/psi/impl/PsiClassImplUtil", "obtainFinalSubstitutor"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/impl/PsiClassImplUtil", "obtainFinalSubstitutor"));
        }
        if (PsiUtil.isRawSubstitutor(aClass, substitutor)) {
            return elementFactory.createRawSubstitutor(candidateClass).putAll(substitutor);
        }
        PsiClassType containingType = elementFactory.createType(candidateClass, candidateSubstitutor, languageLevel);
        PsiType type2 = substitutor.substitute(containingType);
        if (!(type2 instanceof PsiClassType)) {
            return candidateSubstitutor;
        }
        return ((PsiClassType)type2).resolveGenerics().getSubstitutor();
    }

    private static boolean processDeclarationsInClassNotCached(@NotNull PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable Set<PsiClass> visited, PsiElement last, @NotNull PsiElement place, boolean isRaw, @NotNull LanguageLevel languageLevel, @NotNull GlobalSearchScope resolveScope) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClassNotCached"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClassNotCached"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClassNotCached"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClassNotCached"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClassNotCached"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClassNotCached"));
        }
        if (visited == null) {
            visited = new THashSet<PsiClass>();
        }
        if (!visited.add(aClass)) {
            return true;
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, aClass);
        ElementClassHint classHint = processor.getHint(ElementClassHint.KEY);
        NameHint nameHint = processor.getHint(NameHint.KEY);
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.FIELD)) {
            if (nameHint != null) {
                PsiField fieldByName = aClass.findFieldByName(nameHint.getName(state), false);
                if (fieldByName != null && !processor.execute(fieldByName, state)) {
                    return false;
                }
            } else {
                PsiField[] fields2;
                for (PsiField field2 : fields2 = aClass.getFields()) {
                    if (processor.execute(field2, state)) continue;
                    return false;
                }
            }
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance(aClass.getProject()).getElementFactory();
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.METHOD)) {
            PsiMethod[] methods;
            PsiSubstitutor baseSubstitutor = state.get(PsiSubstitutor.KEY);
            for (PsiMethod method : methods = nameHint != null ? aClass.findMethodsByName(nameHint.getName(state), false) : aClass.getMethods()) {
                ResolveState methodState;
                PsiSubstitutor finalSubstitutor = PsiClassImplUtil.checkRaw(isRaw, factory, method, baseSubstitutor);
                ResolveState resolveState = methodState = finalSubstitutor == baseSubstitutor ? state : state.put(PsiSubstitutor.KEY, finalSubstitutor);
                if (processor.execute(method, methodState)) continue;
                return false;
            }
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            PsiTypeParameterList list;
            if (last != null && last.getContext() == aClass && (list = aClass.getTypeParameterList()) != null && !list.processDeclarations(processor, ResolveState.initial(), last, place)) {
                return false;
            }
            if (!(last instanceof PsiReferenceList) && !(last instanceof PsiModifierList)) {
                if (nameHint != null) {
                    PsiClass inner = aClass.findInnerClassByName(nameHint.getName(state), false);
                    if (inner != null && !processor.execute(inner, state)) {
                        return false;
                    }
                } else {
                    PsiClass[] inners;
                    for (PsiClass inner : inners = aClass.getInnerClasses()) {
                        if (processor.execute(inner, state)) continue;
                        return false;
                    }
                }
            }
        }
        return last instanceof PsiReferenceList || PsiClassImplUtil.processSuperTypes(aClass, processor, visited, last, place, state, isRaw, factory, languageLevel, resolveScope);
    }

    @Nullable
    public static PsiClassType correctType(PsiClassType originalType, final GlobalSearchScope resolveScope) {
        if (!Registry.is("java.correct.class.type.by.place.resolve.scope")) {
            return originalType;
        }
        PsiClassType.ClassResolveResult originalResolveResult = originalType.resolveGenerics();
        PsiClass superClass = originalResolveResult.getElement();
        if (superClass == null) {
            return originalType;
        }
        String qualifiedName = superClass.getQualifiedName();
        if (qualifiedName != null && !PsiSearchScopeUtil.isInScope(resolveScope, (PsiElement)superClass)) {
            PsiTypeParameter[] originalTypeParameters;
            PsiFile file = superClass.getContainingFile();
            if (file == null || !file.getViewProvider().isPhysical()) {
                return originalType;
            }
            PsiClass originalSuperClass = superClass;
            PsiSubstitutor originalSubstitutor = originalResolveResult.getSubstitutor();
            if ((superClass = JavaPsiFacade.getInstance(superClass.getProject()).findClass(qualifiedName, resolveScope)) == null) {
                return null;
            }
            PsiTypeParameter[] typeParameters = superClass.getTypeParameters();
            if (typeParameters.length != (originalTypeParameters = originalSuperClass.getTypeParameters()).length) {
                return null;
            }
            PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
            for (int i = 0; i < originalTypeParameters.length; ++i) {
                PsiType originalSubstitute = originalSubstitutor.substitute(originalTypeParameters[i]);
                if (originalSubstitute == null) continue;
                PsiType substitute = originalSubstitute.accept(new PsiTypeVisitor<PsiType>(){

                    @Override
                    @Nullable
                    public PsiType visitClassType(PsiClassType classType) {
                        return PsiClassImplUtil.correctType(classType, resolveScope);
                    }
                });
                if (substitute == null) {
                    return null;
                }
                substitutor = substitutor.put(typeParameters[i], substitute);
            }
            return JavaPsiFacade.getElementFactory(superClass.getProject()).createType(superClass, substitutor);
        }
        return originalType;
    }

    private static boolean processSuperTypes(@NotNull PsiClass aClass, @NotNull PsiScopeProcessor processor, @Nullable Set<PsiClass> visited, PsiElement last, @NotNull PsiElement place, @NotNull ResolveState state, boolean isRaw, @NotNull PsiElementFactory factory, @NotNull LanguageLevel languageLevel, GlobalSearchScope resolveScope) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "processSuperTypes"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/PsiClassImplUtil", "processSuperTypes"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/PsiClassImplUtil", "processSuperTypes"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/PsiClassImplUtil", "processSuperTypes"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/psi/impl/PsiClassImplUtil", "processSuperTypes"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/impl/PsiClassImplUtil", "processSuperTypes"));
        }
        boolean resolved = false;
        for (PsiClassType superType : aClass.getSuperTypes()) {
            PsiSubstitutor finalSubstitutor;
            PsiClassType.ClassResolveResult superTypeResolveResult;
            PsiClass superClass;
            if ((superType = PsiClassImplUtil.correctType(superType, resolveScope)) == null || (superClass = (superTypeResolveResult = superType.resolveGenerics()).getElement()) == null || PsiClassImplUtil.processDeclarationsInClass(superClass, processor, state.put(PsiSubstitutor.KEY, finalSubstitutor = PsiClassImplUtil.obtainFinalSubstitutor(superClass, superTypeResolveResult.getSubstitutor(), aClass, state.get(PsiSubstitutor.KEY), factory, languageLevel)), visited, last, place, languageLevel, isRaw, resolveScope)) continue;
            resolved = true;
        }
        return !resolved;
    }

    @Nullable
    public static PsiClass getSuperClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/PsiClassImplUtil", "getSuperClass"));
        }
        PsiManager manager = psiClass.getManager();
        GlobalSearchScope resolveScope = psiClass.getResolveScope();
        JavaPsiFacade facade = JavaPsiFacade.getInstance(manager.getProject());
        if (psiClass.isInterface()) {
            return facade.findClass("java.lang.Object", resolveScope);
        }
        if (psiClass.isEnum()) {
            return facade.findClass("java.lang.Enum", resolveScope);
        }
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClassType baseClassReference = ((PsiAnonymousClass)psiClass).getBaseClassType();
            PsiClass baseClass = baseClassReference.resolve();
            if (baseClass == null || baseClass.isInterface()) {
                return facade.findClass("java.lang.Object", resolveScope);
            }
            return baseClass;
        }
        if ("java.lang.Object".equals(psiClass.getQualifiedName())) {
            return null;
        }
        PsiClassType[] referenceElements = psiClass.getExtendsListTypes();
        if (referenceElements.length == 0) {
            return facade.findClass("java.lang.Object", resolveScope);
        }
        PsiClass psiResoved = referenceElements[0].resolve();
        return psiResoved == null ? facade.findClass("java.lang.Object", resolveScope) : psiResoved;
    }

    @NotNull
    public static PsiClass[] getSupers(@NotNull PsiClass psiClass) {
        PsiClass[] supers;
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/PsiClassImplUtil", "getSupers"));
        }
        for (PsiClass aSuper : supers = PsiClassImplUtil.getSupersInner(psiClass)) {
            LOG.assertTrue(aSuper != null);
        }
        if (supers == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getSupers"));
        }
        return supers;
    }

    @NotNull
    private static PsiClass[] getSupersInner(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/PsiClassImplUtil", "getSupersInner"));
        }
        PsiClassType[] extendsListTypes = psiClass.getExtendsListTypes();
        if (psiClass.isInterface()) {
            PsiClass[] psiClassArray = PsiClassImplUtil.resolveClassReferenceList(extendsListTypes, psiClass.getManager(), psiClass.getResolveScope(), true);
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getSupersInner"));
            }
            return psiClassArray;
        }
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClass[] psiClassArray;
            PsiAnonymousClass psiAnonymousClass = (PsiAnonymousClass)psiClass;
            PsiClassType baseClassReference = psiAnonymousClass.getBaseClassType();
            PsiClass baseClass = baseClassReference.resolve();
            if (baseClass != null) {
                if (baseClass.isInterface()) {
                    PsiClass[] psiClassArray2;
                    PsiClass objectClass = JavaPsiFacade.getInstance(psiClass.getProject()).findClass("java.lang.Object", psiClass.getResolveScope());
                    if (objectClass != null) {
                        PsiClass[] psiClassArray3 = new PsiClass[2];
                        psiClassArray3[0] = objectClass;
                        psiClassArray2 = psiClassArray3;
                        psiClassArray3[1] = baseClass;
                    } else {
                        PsiClass[] psiClassArray4 = new PsiClass[1];
                        psiClassArray2 = psiClassArray4;
                        psiClassArray4[0] = baseClass;
                    }
                    if (psiClassArray2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getSupersInner"));
                    }
                    return psiClassArray2;
                }
                PsiClass[] psiClassArray5 = new PsiClass[]{baseClass};
                if (psiClassArray5 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getSupersInner"));
                }
                return psiClassArray5;
            }
            PsiClass objectClass = JavaPsiFacade.getInstance(psiClass.getProject()).findClass("java.lang.Object", psiClass.getResolveScope());
            if (objectClass != null) {
                PsiClass[] psiClassArray6 = new PsiClass[1];
                psiClassArray = psiClassArray6;
                psiClassArray6[0] = objectClass;
            } else {
                psiClassArray = PsiClass.EMPTY_ARRAY;
            }
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getSupersInner"));
            }
            return psiClassArray;
        }
        if (psiClass instanceof PsiTypeParameter) {
            if (extendsListTypes.length == 0) {
                PsiClass[] psiClassArray;
                PsiClass objectClass = JavaPsiFacade.getInstance(psiClass.getProject()).findClass("java.lang.Object", psiClass.getResolveScope());
                if (objectClass != null) {
                    PsiClass[] psiClassArray7 = new PsiClass[1];
                    psiClassArray = psiClassArray7;
                    psiClassArray7[0] = objectClass;
                } else {
                    psiClassArray = PsiClass.EMPTY_ARRAY;
                }
                if (psiClassArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getSupersInner"));
                }
                return psiClassArray;
            }
            PsiClass[] psiClassArray = PsiClassImplUtil.resolveClassReferenceList(extendsListTypes, psiClass.getManager(), psiClass.getResolveScope(), false);
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getSupersInner"));
            }
            return psiClassArray;
        }
        PsiClassType[] implementsListTypes = psiClass.getImplementsListTypes();
        PsiClass[] interfaces = PsiClassImplUtil.resolveClassReferenceList(implementsListTypes, psiClass.getManager(), psiClass.getResolveScope(), false);
        PsiClass superClass = PsiClassImplUtil.getSuperClass(psiClass);
        if (superClass == null) {
            if (interfaces == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getSupersInner"));
            }
            return interfaces;
        }
        PsiClass[] types = new PsiClass[interfaces.length + 1];
        types[0] = superClass;
        System.arraycopy(interfaces, 0, types, 1, interfaces.length);
        if (types == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getSupersInner"));
        }
        return types;
    }

    @NotNull
    public static PsiClassType[] getSuperTypes(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/PsiClassImplUtil", "getSuperTypes"));
        }
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClassType baseClassType = ((PsiAnonymousClass)psiClass).getBaseClassType();
            PsiClass baseClass = baseClassType.resolve();
            if (baseClass == null || !baseClass.isInterface()) {
                PsiClassType[] psiClassTypeArray = new PsiClassType[]{baseClassType};
                if (psiClassTypeArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getSuperTypes"));
                }
                return psiClassTypeArray;
            }
            PsiClassType objectType = PsiType.getJavaLangObject(psiClass.getManager(), psiClass.getResolveScope());
            PsiClassType[] psiClassTypeArray = new PsiClassType[]{objectType, baseClassType};
            if (psiClassTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getSuperTypes"));
            }
            return psiClassTypeArray;
        }
        PsiClassType[] extendsTypes = psiClass.getExtendsListTypes();
        PsiClassType[] implementsTypes = psiClass.getImplementsListTypes();
        boolean hasExtends = extendsTypes.length != 0;
        int extendsListLength = extendsTypes.length + (hasExtends ? 0 : 1);
        PsiClassType[] result2 = new PsiClassType[extendsListLength + implementsTypes.length];
        System.arraycopy(extendsTypes, 0, result2, 0, extendsTypes.length);
        if (!hasExtends) {
            PsiClassType objectType;
            if ("java.lang.Object".equals(psiClass.getQualifiedName())) {
                if (PsiClassType.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getSuperTypes"));
                }
                return PsiClassType.EMPTY_ARRAY;
            }
            PsiManager manager = psiClass.getManager();
            result2[0] = objectType = PsiType.getJavaLangObject(manager, psiClass.getResolveScope());
        }
        System.arraycopy(implementsTypes, 0, result2, extendsListLength, implementsTypes.length);
        for (int i = 0; i < result2.length; ++i) {
            PsiClassType type2 = result2[i];
            result2[i] = (PsiClassType)PsiUtil.captureToplevelWildcards(type2, psiClass);
        }
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getSuperTypes"));
        }
        return result2;
    }

    @NotNull
    private static PsiClassType getAnnotationSuperType(@NotNull PsiClass psiClass, @NotNull PsiElementFactory factory) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/PsiClassImplUtil", "getAnnotationSuperType"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/psi/impl/PsiClassImplUtil", "getAnnotationSuperType"));
        }
        PsiClassType psiClassType = factory.createTypeByFQClassName("java.lang.annotation.Annotation", psiClass.getResolveScope());
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getAnnotationSuperType"));
        }
        return psiClassType;
    }

    private static PsiClassType getEnumSuperType(@NotNull PsiClass psiClass, @NotNull PsiElementFactory factory) {
        PsiClassType superType;
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/PsiClassImplUtil", "getEnumSuperType"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/psi/impl/PsiClassImplUtil", "getEnumSuperType"));
        }
        PsiManager manager = psiClass.getManager();
        PsiClass enumClass = JavaPsiFacade.getInstance(manager.getProject()).findClass("java.lang.Enum", psiClass.getResolveScope());
        if (enumClass == null) {
            try {
                superType = (PsiClassType)factory.createTypeFromText("java.lang.Enum", null);
            }
            catch (IncorrectOperationException e) {
                superType = null;
            }
        } else {
            PsiTypeParameter[] typeParameters = enumClass.getTypeParameters();
            PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
            if (typeParameters.length == 1) {
                substitutor = substitutor.put(typeParameters[0], factory.createType(psiClass));
            }
            superType = new PsiImmediateClassType(enumClass, substitutor);
        }
        return superType;
    }

    @NotNull
    public static PsiClass[] getInterfaces(@NotNull PsiTypeParameter typeParameter) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "com/intellij/psi/impl/PsiClassImplUtil", "getInterfaces"));
        }
        PsiClassType[] referencedTypes = typeParameter.getExtendsListTypes();
        if (referencedTypes.length == 0) {
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getInterfaces"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        ArrayList<PsiClass> result2 = new ArrayList<PsiClass>(referencedTypes.length);
        for (PsiClassType referencedType : referencedTypes) {
            PsiClass psiClass = referencedType.resolve();
            if (psiClass == null || !psiClass.isInterface()) continue;
            result2.add(psiClass);
        }
        PsiClass[] psiClassArray = result2.toArray(new PsiClass[result2.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getInterfaces"));
        }
        return psiClassArray;
    }

    @NotNull
    public static PsiClass[] getInterfaces(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/PsiClassImplUtil", "getInterfaces"));
        }
        if (psiClass.isInterface()) {
            PsiClassType[] extendsListTypes = psiClass.getExtendsListTypes();
            PsiClass[] psiClassArray = PsiClassImplUtil.resolveClassReferenceList(extendsListTypes, psiClass.getManager(), psiClass.getResolveScope(), false);
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getInterfaces"));
            }
            return psiClassArray;
        }
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClass[] psiClassArray;
            PsiClassType baseClassReference = ((PsiAnonymousClass)psiClass).getBaseClassType();
            PsiClass baseClass = baseClassReference.resolve();
            if (baseClass != null && baseClass.isInterface()) {
                PsiClass[] psiClassArray2 = new PsiClass[1];
                psiClassArray = psiClassArray2;
                psiClassArray2[0] = baseClass;
            } else {
                psiClassArray = PsiClass.EMPTY_ARRAY;
            }
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getInterfaces"));
            }
            return psiClassArray;
        }
        PsiClassType[] implementsListTypes = psiClass.getImplementsListTypes();
        PsiClass[] psiClassArray = PsiClassImplUtil.resolveClassReferenceList(implementsListTypes, psiClass.getManager(), psiClass.getResolveScope(), false);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getInterfaces"));
        }
        return psiClassArray;
    }

    @NotNull
    private static PsiClass[] resolveClassReferenceList(@NotNull PsiClassType[] listOfTypes, @NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope, boolean includeObject) {
        if (listOfTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOfTypes", "com/intellij/psi/impl/PsiClassImplUtil", "resolveClassReferenceList"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/PsiClassImplUtil", "resolveClassReferenceList"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "com/intellij/psi/impl/PsiClassImplUtil", "resolveClassReferenceList"));
        }
        PsiClass objectClass = null;
        if (includeObject && (objectClass = JavaPsiFacade.getInstance(manager.getProject()).findClass("java.lang.Object", resolveScope)) == null) {
            includeObject = false;
        }
        if (listOfTypes.length == 0) {
            if (includeObject) {
                PsiClass[] psiClassArray = new PsiClass[]{objectClass};
                if (psiClassArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "resolveClassReferenceList"));
                }
                return psiClassArray;
            }
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "resolveClassReferenceList"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        int referenceCount = listOfTypes.length;
        if (includeObject) {
            ++referenceCount;
        }
        PsiClass[] resolved = new PsiClass[referenceCount];
        int resolvedCount = 0;
        if (includeObject) {
            resolved[resolvedCount++] = objectClass;
        }
        for (PsiClassType reference : listOfTypes) {
            PsiClass refResolved = reference.resolve();
            if (refResolved == null) continue;
            resolved[resolvedCount++] = refResolved;
        }
        if (resolvedCount < referenceCount) {
            PsiClass[] shorter = new PsiClass[resolvedCount];
            System.arraycopy(resolved, 0, shorter, 0, resolvedCount);
            resolved = shorter;
        }
        if (resolved == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "resolveClassReferenceList"));
        }
        return resolved;
    }

    @NotNull
    public static List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(@NotNull PsiClass psiClass, String name, boolean checkBases) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/PsiClassImplUtil", "findMethodsAndTheirSubstitutorsByName"));
        }
        if (!checkBases) {
            PsiMethod[] methodsByName = psiClass.findMethodsByName(name, false);
            ArrayList<Pair<PsiMethod, PsiSubstitutor>> ret = new ArrayList<Pair<PsiMethod, PsiSubstitutor>>(methodsByName.length);
            for (PsiMethod method : methodsByName) {
                ret.add(Pair.create(method, PsiSubstitutor.EMPTY));
            }
            ArrayList<Pair<PsiMethod, PsiSubstitutor>> arrayList = ret;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "findMethodsAndTheirSubstitutorsByName"));
            }
            return arrayList;
        }
        Map<String, List<Pair<PsiMember, PsiSubstitutor>>> map = PsiClassImplUtil.getMap(psiClass, MemberType.METHOD);
        List<Pair<PsiMember, PsiSubstitutor>> list = map.get(name);
        List<Object> list2 = list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "findMethodsAndTheirSubstitutorsByName"));
        }
        return list2;
    }

    @NotNull
    public static PsiClassType[] getExtendsListTypes(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/PsiClassImplUtil", "getExtendsListTypes"));
        }
        if (psiClass.isEnum()) {
            PsiClassType[] psiClassTypeArray;
            PsiClassType enumSuperType = PsiClassImplUtil.getEnumSuperType(psiClass, JavaPsiFacade.getInstance(psiClass.getProject()).getElementFactory());
            if (enumSuperType == null) {
                psiClassTypeArray = PsiClassType.EMPTY_ARRAY;
            } else {
                PsiClassType[] psiClassTypeArray2 = new PsiClassType[1];
                psiClassTypeArray = psiClassTypeArray2;
                psiClassTypeArray2[0] = enumSuperType;
            }
            if (psiClassTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getExtendsListTypes"));
            }
            return psiClassTypeArray;
        }
        if (psiClass.isAnnotationType()) {
            PsiClassType[] psiClassTypeArray = new PsiClassType[]{PsiClassImplUtil.getAnnotationSuperType(psiClass, JavaPsiFacade.getInstance(psiClass.getProject()).getElementFactory())};
            if (psiClassTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getExtendsListTypes"));
            }
            return psiClassTypeArray;
        }
        PsiReferenceList extendsList = psiClass.getExtendsList();
        if (extendsList != null) {
            PsiClassType[] psiClassTypeArray = extendsList.getReferencedTypes();
            if (psiClassTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getExtendsListTypes"));
            }
            return psiClassTypeArray;
        }
        if (PsiClassType.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getExtendsListTypes"));
        }
        return PsiClassType.EMPTY_ARRAY;
    }

    @NotNull
    public static PsiClassType[] getImplementsListTypes(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/PsiClassImplUtil", "getImplementsListTypes"));
        }
        PsiReferenceList extendsList = psiClass.getImplementsList();
        if (extendsList != null) {
            PsiClassType[] psiClassTypeArray = extendsList.getReferencedTypes();
            if (psiClassTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getImplementsListTypes"));
            }
            return psiClassTypeArray;
        }
        if (PsiClassType.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getImplementsListTypes"));
        }
        return PsiClassType.EMPTY_ARRAY;
    }

    public static boolean isClassEquivalentTo(@NotNull PsiClass aClass, PsiElement another) {
        PsiFile original2;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "isClassEquivalentTo"));
        }
        if (aClass == another) {
            return true;
        }
        if (!(another instanceof PsiClass)) {
            return false;
        }
        String name1 = aClass.getName();
        if (name1 == null) {
            return false;
        }
        if (!another.isValid()) {
            return false;
        }
        String name2 = ((PsiClass)another).getName();
        if (name2 == null) {
            return false;
        }
        if (name1.hashCode() != name2.hashCode()) {
            return false;
        }
        if (!name1.equals(name2)) {
            return false;
        }
        String qName1 = aClass.getQualifiedName();
        String qName2 = ((PsiClass)another).getQualifiedName();
        if (qName1 == null || qName2 == null) {
            if (qName1 != qName2) {
                return false;
            }
            if (aClass instanceof PsiTypeParameter && another instanceof PsiTypeParameter) {
                PsiTypeParameter p1 = (PsiTypeParameter)aClass;
                PsiTypeParameter p2 = (PsiTypeParameter)another;
                return p1.getIndex() == p2.getIndex() && (aClass.getManager().areElementsEquivalent(p1.getOwner(), p2.getOwner()) || InferenceSession.areSameFreshVariables(p1, p2));
            }
            return false;
        }
        if (qName1.hashCode() != qName2.hashCode() || !qName1.equals(qName2)) {
            return false;
        }
        if (aClass.getOriginalElement().equals(another.getOriginalElement())) {
            return true;
        }
        PsiFile file1 = aClass.getContainingFile().getOriginalFile();
        PsiFile file2 = another.getContainingFile().getOriginalFile();
        PsiFile original1 = file1.getUserData(PsiFileFactory.ORIGINAL_FILE);
        if (original1 == (original2 = file2.getUserData(PsiFileFactory.ORIGINAL_FILE)) && original1 != null || original1 == file2 || original2 == file1 || file1 == file2) {
            return PsiClassImplUtil.compareClassSeqNumber(aClass, (PsiClass)another);
        }
        FileIndexFacade fileIndex = ServiceManager.getService(file1.getProject(), FileIndexFacade.class);
        VirtualFile vfile1 = file1.getViewProvider().getVirtualFile();
        VirtualFile vfile2 = file2.getViewProvider().getVirtualFile();
        boolean lib1 = fileIndex.isInLibraryClasses(vfile1);
        boolean lib2 = fileIndex.isInLibraryClasses(vfile2);
        return !(!fileIndex.isInSource(vfile1) && !lib1 || !fileIndex.isInSource(vfile2) && !lib2);
    }

    private static boolean compareClassSeqNumber(@NotNull PsiClass aClass, @NotNull PsiClass another) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "compareClassSeqNumber"));
        }
        if (another == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "another", "com/intellij/psi/impl/PsiClassImplUtil", "compareClassSeqNumber"));
        }
        int index1 = PsiClassImplUtil.getSeqNumber(aClass);
        if (index1 == -1) {
            return true;
        }
        int index2 = PsiClassImplUtil.getSeqNumber(another);
        return index1 == index2;
    }

    private static int getSeqNumber(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "getSeqNumber"));
        }
        PsiElement parent = aClass.getParent();
        if (parent == null) {
            return -1;
        }
        int seqNo = 0;
        for (PsiElement child : parent.getChildren()) {
            if (child == aClass) {
                return seqNo;
            }
            if (!(child instanceof PsiClass) || !Comparing.strEqual(aClass.getName(), ((PsiClass)child).getName())) continue;
            ++seqNo;
        }
        return -1;
    }

    public static boolean isFieldEquivalentTo(@NotNull PsiField field2, PsiElement another) {
        if (field2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/psi/impl/PsiClassImplUtil", "isFieldEquivalentTo"));
        }
        if (!(another instanceof PsiField)) {
            return false;
        }
        String name1 = field2.getName();
        if (name1 == null) {
            return false;
        }
        if (!another.isValid()) {
            return false;
        }
        String name2 = ((PsiField)another).getName();
        if (!name1.equals(name2)) {
            return false;
        }
        PsiClass aClass1 = field2.getContainingClass();
        PsiClass aClass2 = ((PsiField)another).getContainingClass();
        return aClass1 != null && aClass2 != null && field2.getManager().areElementsEquivalent(aClass1, aClass2);
    }

    public static boolean isMethodEquivalentTo(@NotNull PsiMethod method1, PsiElement another) {
        PsiParameter[] parameters2;
        if (method1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method1", "com/intellij/psi/impl/PsiClassImplUtil", "isMethodEquivalentTo"));
        }
        if (method1 == another) {
            return true;
        }
        if (!(another instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method2 = (PsiMethod)another;
        if (!another.isValid()) {
            return false;
        }
        if (!method1.getName().equals(method2.getName())) {
            return false;
        }
        PsiClass aClass1 = method1.getContainingClass();
        PsiClass aClass2 = method2.getContainingClass();
        PsiManager manager = method1.getManager();
        if (aClass1 == null || aClass2 == null || !manager.areElementsEquivalent(aClass1, aClass2)) {
            return false;
        }
        PsiParameter[] parameters1 = method1.getParameterList().getParameters();
        if (parameters1.length != (parameters2 = method2.getParameterList().getParameters()).length) {
            return false;
        }
        for (int i = 0; i < parameters1.length; ++i) {
            PsiType type2;
            PsiParameter parameter1 = parameters1[i];
            PsiParameter parameter2 = parameters2[i];
            PsiType type1 = parameter1.getType();
            if (PsiClassImplUtil.compareParamTypes(manager, type1, type2 = parameter2.getType(), new HashSet<String>())) continue;
            return false;
        }
        return true;
    }

    private static boolean compareParamTypes(@NotNull PsiManager manager, @NotNull PsiType type1, @NotNull PsiType type2, Set<String> visited) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/PsiClassImplUtil", "compareParamTypes"));
        }
        if (type1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type1", "com/intellij/psi/impl/PsiClassImplUtil", "compareParamTypes"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type2", "com/intellij/psi/impl/PsiClassImplUtil", "compareParamTypes"));
        }
        if (type1 instanceof PsiArrayType) {
            PsiType componentType2;
            PsiType componentType1;
            return type2 instanceof PsiArrayType && PsiClassImplUtil.compareParamTypes(manager, componentType1 = ((PsiArrayType)type1).getComponentType(), componentType2 = ((PsiArrayType)type2).getComponentType(), visited);
        }
        if (!(type1 instanceof PsiClassType) || !(type2 instanceof PsiClassType)) {
            return type1.equals(type2);
        }
        PsiClass class1 = ((PsiClassType)type1).resolve();
        PsiClass class2 = ((PsiClassType)type2).resolve();
        visited.add(type1.getCanonicalText());
        visited.add(type2.getCanonicalText());
        if (class1 instanceof PsiTypeParameter && class2 instanceof PsiTypeParameter) {
            PsiClassType[] eTypes2;
            if (!Comparing.equal(class1.getName(), class2.getName()) || ((PsiTypeParameter)class1).getIndex() != ((PsiTypeParameter)class2).getIndex()) {
                return false;
            }
            PsiClassType[] eTypes1 = class1.getExtendsListTypes();
            if (eTypes1.length != (eTypes2 = class2.getExtendsListTypes()).length) {
                return false;
            }
            for (int i = 0; i < eTypes1.length; ++i) {
                PsiClassType eType1 = eTypes1[i];
                PsiClassType eType2 = eTypes2[i];
                if (visited.contains(eType1.getCanonicalText()) || visited.contains(eType2.getCanonicalText())) {
                    return false;
                }
                if (PsiClassImplUtil.compareParamTypes(manager, eType1, eType2, visited)) continue;
                return false;
            }
            return true;
        }
        return manager.areElementsEquivalent(class1, class2);
    }

    private static class ByNameCachedValueProvider
    implements ParameterizedCachedValueProvider<Map<GlobalSearchScope, MembersMap>, PsiClass> {
        private static final ByNameCachedValueProvider INSTANCE = new ByNameCachedValueProvider();

        private ByNameCachedValueProvider() {
        }

        @Override
        public CachedValueProvider.Result<Map<GlobalSearchScope, MembersMap>> compute(final @NotNull PsiClass myClass) {
            if (myClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myClass", "com/intellij/psi/impl/PsiClassImplUtil$ByNameCachedValueProvider", "compute"));
            }
            ConcurrentFactoryMap<GlobalSearchScope, MembersMap> map = new ConcurrentFactoryMap<GlobalSearchScope, MembersMap>(){

                @Override
                @Nullable
                protected MembersMap create(GlobalSearchScope resolveScope) {
                    return new MembersMap(myClass, resolveScope);
                }
            };
            return CachedValueProvider.Result.create(map, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
        }
    }

    private static class MembersMap
    extends ConcurrentFactoryMap<MemberType, Map<String, List<Pair<PsiMember, PsiSubstitutor>>>> {
        private final PsiClass myPsiClass;
        private final GlobalSearchScope myResolveScope;

        public MembersMap(PsiClass psiClass, GlobalSearchScope scope2) {
            this.myPsiClass = psiClass;
            this.myResolveScope = scope2;
        }

        @Override
        @Nullable
        protected Map<String, List<Pair<PsiMember, PsiSubstitutor>>> create(final MemberType key) {
            final THashMap<String, List<Pair<PsiMember, PsiSubstitutor>>> map = new THashMap<String, List<Pair<PsiMember, PsiSubstitutor>>>();
            final ArrayList allMembers = new ArrayList();
            map.put("Intellij-IDEA-ALL", allMembers);
            ElementClassFilter filter = key == MemberType.CLASS ? ElementClassFilter.CLASS : (key == MemberType.METHOD ? ElementClassFilter.METHOD : ElementClassFilter.FIELD);
            FilterScopeProcessor<MethodCandidateInfo> processor = new FilterScopeProcessor<MethodCandidateInfo>((ElementFilter)filter){

                @Override
                protected void add(@NotNull PsiElement element, @NotNull PsiSubstitutor substitutor) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/PsiClassImplUtil$MembersMap$1", "add"));
                    }
                    if (substitutor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/impl/PsiClassImplUtil$MembersMap$1", "add"));
                    }
                    if (key == MemberType.CLASS && element instanceof PsiClass || key == MemberType.METHOD && element instanceof PsiMethod || key == MemberType.FIELD && element instanceof PsiField) {
                        Pair<PsiMember, PsiSubstitutor> info = Pair.create((PsiMember)element, substitutor);
                        allMembers.add(info);
                        String currentName = ((PsiMember)element).getName();
                        ArrayList<Pair<PsiMember, PsiSubstitutor>> listByName = (ArrayList<Pair<PsiMember, PsiSubstitutor>>)map.get(currentName);
                        if (listByName == null) {
                            listByName = new ArrayList<Pair<PsiMember, PsiSubstitutor>>(1);
                            map.put(currentName, listByName);
                        }
                        listByName.add(info);
                    }
                }
            };
            PsiClassImplUtil.processDeclarationsInClassNotCached(this.myPsiClass, processor, ResolveState.initial(), null, null, this.myPsiClass, false, PsiUtil.getLanguageLevel(this.myPsiClass), this.myResolveScope);
            return map;
        }
    }

    private static class ClassIconRequest {
        @NotNull
        private final PsiClass psiClass;
        private final int flags;
        private final Icon symbolIcon;

        private ClassIconRequest(@NotNull PsiClass psiClass, int flags, Icon symbolIcon) {
            if (psiClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/PsiClassImplUtil$ClassIconRequest", "<init>"));
            }
            this.psiClass = psiClass;
            this.flags = flags;
            this.symbolIcon = symbolIcon;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClassIconRequest)) {
                return false;
            }
            ClassIconRequest that = (ClassIconRequest)o;
            return this.flags == that.flags && this.psiClass.equals(that.psiClass);
        }

        public int hashCode() {
            int result2 = this.psiClass.hashCode();
            result2 = 31 * result2 + this.flags;
            return result2;
        }
    }

    public static enum MemberType {
        CLASS,
        FIELD,
        METHOD;

    }
}

