/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters;

import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ElementFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OrFilter
implements ElementFilter {
    private final List<ElementFilter> myFilters = new ArrayList<ElementFilter>();

    public OrFilter() {
    }

    public OrFilter(ElementFilter ... filters) {
        for (ElementFilter filter : filters) {
            this.addFilter(filter);
        }
    }

    public void addFilter(ElementFilter filter) {
        this.myFilters.add(filter);
    }

    protected List getFilters() {
        return this.myFilters;
    }

    @Override
    public boolean isAcceptable(Object element, PsiElement context2) {
        if (this.myFilters.isEmpty()) {
            return true;
        }
        for (ElementFilter elementFilter : this.myFilters) {
            if (!elementFilter.isAcceptable(element, context2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isClassAcceptable(Class elementClass) {
        if (this.myFilters.isEmpty()) {
            return true;
        }
        for (ElementFilter elementFilter : this.myFilters) {
            if (!elementFilter.isClassAcceptable(elementClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        String ret = "(";
        Iterator<ElementFilter> iter = this.myFilters.iterator();
        while (iter.hasNext()) {
            ret = ret + iter.next();
            if (!iter.hasNext()) continue;
            ret = ret + " | ";
        }
        ret = ret + ")";
        return ret;
    }
}

