/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.ZipFileCache;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.relocated.gnu.trove.THashMap;

public class ZipHandler
extends ArchiveHandler {
    public ZipHandler(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/ZipHandler", "<init>"));
        }
        super(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected Map<String, ArchiveHandler.EntryInfo> createEntriesMap() throws IOException {
        THashMap<String, ArchiveHandler.EntryInfo> map = new THashMap<String, ArchiveHandler.EntryInfo>();
        map.put("", this.createRootEntry());
        ZipFile zip2 = this.getZipFile();
        try {
            Enumeration<? extends ZipEntry> entries = zip2.entries();
            while (entries.hasMoreElements()) {
                this.getOrCreate(entries.nextElement(), map, zip2);
            }
        }
        finally {
            ZipFileCache.release(zip2);
        }
        THashMap<String, ArchiveHandler.EntryInfo> tHashMap = map;
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "createEntriesMap"));
        }
        return tHashMap;
    }

    @NotNull
    protected File getFileToUse() {
        File file = this.getFile();
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "getFileToUse"));
        }
        return file;
    }

    @NotNull
    private ZipFile getZipFile() throws IOException {
        ZipFile zipFile = ZipFileCache.acquire(this.getFileToUse().getPath());
        if (zipFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "getZipFile"));
        }
        return zipFile;
    }

    @NotNull
    private ArchiveHandler.EntryInfo getOrCreate(ZipEntry entry, Map<String, ArchiveHandler.EntryInfo> map, ZipFile zip2) {
        ArchiveHandler.EntryInfo info;
        boolean isDirectory = entry.isDirectory();
        String entryName = entry.getName();
        if (StringUtil.endsWithChar(entryName, '/')) {
            entryName = entryName.substring(0, entryName.length() - 1);
            isDirectory = true;
        }
        if ((info = map.get(entryName)) != null) {
            ArchiveHandler.EntryInfo entryInfo = info;
            if (entryInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
            }
            return entryInfo;
        }
        Pair<String, String> path = this.splitPath(entryName);
        ArchiveHandler.EntryInfo parentInfo = this.getOrCreate((String)path.first, map, zip2);
        if (".".equals(path.second)) {
            ArchiveHandler.EntryInfo entryInfo = parentInfo;
            if (entryInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
            }
            return entryInfo;
        }
        info = new ArchiveHandler.EntryInfo(parentInfo, (String)path.second, isDirectory, entry.getSize(), entry.getTime());
        map.put(entryName, info);
        ArchiveHandler.EntryInfo entryInfo = info;
        if (entryInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
        }
        return entryInfo;
    }

    @NotNull
    private ArchiveHandler.EntryInfo getOrCreate(String entryName, Map<String, ArchiveHandler.EntryInfo> map, ZipFile zip2) {
        ArchiveHandler.EntryInfo info = map.get(entryName);
        if (info == null) {
            ZipEntry entry = zip2.getEntry(entryName + "/");
            if (entry != null) {
                ArchiveHandler.EntryInfo entryInfo = this.getOrCreate(entry, map, zip2);
                if (entryInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
                }
                return entryInfo;
            }
            Pair<String, String> path = this.splitPath(entryName);
            ArchiveHandler.EntryInfo parentInfo = this.getOrCreate((String)path.first, map, zip2);
            info = new ArchiveHandler.EntryInfo(parentInfo, (String)path.second, true, 0L, -1L);
            map.put(entryName, info);
        }
        if (!info.isDirectory) {
            Logger.getInstance(this.getClass()).info(zip2.getName() + ": " + entryName + " should be a directory");
            info = new ArchiveHandler.EntryInfo(info.parent, info.shortName, true, info.length, info.timestamp);
            map.put(entryName, info);
        }
        ArchiveHandler.EntryInfo entryInfo = info;
        if (entryInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
        }
        return entryInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    public byte[] contentsToByteArray(@NotNull String relativePath) throws IOException {
        block8: {
            byte[] byArray;
            InputStream stream2;
            ZipFile zip2;
            block9: {
                if (relativePath == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/openapi/vfs/impl/ZipHandler", "contentsToByteArray"));
                }
                zip2 = this.getZipFile();
                ZipEntry entry = zip2.getEntry(relativePath);
                if (entry == null || (stream2 = zip2.getInputStream(entry)) == null) break block8;
                byArray = FileUtil.loadBytes(stream2, (int)entry.getSize());
                stream2.close();
                if (byArray != null) break block9;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "contentsToByteArray"));
            }
            return byArray;
            {
                catch (Throwable throwable) {
                    stream2.close();
                    throw throwable;
                }
            }
            finally {
                ZipFileCache.release(zip2);
            }
        }
        if (ArrayUtil.EMPTY_BYTE_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "contentsToByteArray"));
        }
        return ArrayUtil.EMPTY_BYTE_ARRAY;
    }
}

