/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.ClassUtilCore;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.StartupProgress;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginClassCache;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.AreaListener;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.LogProvider;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.io.ZipFileCache;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.xmlb.XmlSerializationException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.relocated.gnu.trove.THashMap;
import org.jetbrains.kotlin.relocated.gnu.trove.THashSet;
import org.jetbrains.kotlin.relocated.gnu.trove.TIntProcedure;
import org.jetbrains.kotlin.relocated.gnu.trove.TObjectIntHashMap;
import org.jetbrains.kotlin.relocated.org.jdom.Document;

public class PluginManagerCore {
    private static final TObjectIntHashMap<PluginId> ourId2Index = new TObjectIntHashMap();
    private static final Map<String, IdeaPluginDescriptorImpl> ourModulesToContainingPlugins = new THashMap<String, IdeaPluginDescriptorImpl>();
    private static final PluginClassCache ourPluginClasses = new PluginClassCache();
    private static List<String> ourDisabledPlugins;
    private static MultiMap<String, String> ourBrokenPluginVersions;
    private static IdeaPluginDescriptor[] ourPlugins;
    static String myPluginError;
    static List<String> myPlugins2Disable;
    static LinkedHashSet<String> myPlugins2Enable;
    public static String BUILD_NUMBER;
    private static BuildNumber ourBuildNumber;

    @NotNull
    public static synchronized IdeaPluginDescriptor[] getPlugins() {
        if (ourPlugins == null) {
            PluginManagerCore.initPlugins(null);
        }
        if (ourPlugins == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/PluginManagerCore", "getPlugins"));
        }
        return ourPlugins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadDisabledPlugins(@NotNull String configPath, @NotNull Collection<String> disabledPlugins) {
        if (configPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configPath", "com/intellij/ide/plugins/PluginManagerCore", "loadDisabledPlugins"));
        }
        if (disabledPlugins == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disabledPlugins", "com/intellij/ide/plugins/PluginManagerCore", "loadDisabledPlugins"));
        }
        File file = new File(configPath, "disabled_plugins.txt");
        if (file.isFile()) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(file));
                try {
                    String id;
                    while ((id = reader.readLine()) != null) {
                        disabledPlugins.add(id.trim());
                    }
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @NotNull
    public static List<String> getDisabledPlugins() {
        if (ourDisabledPlugins == null) {
            ourDisabledPlugins = new ArrayList<String>();
            if (System.getProperty("idea.ignore.disabled.plugins") == null && !PluginManagerCore.isUnitTestMode()) {
                PluginManagerCore.loadDisabledPlugins(PathManager.getConfigPath(), ourDisabledPlugins);
            }
        }
        List<String> list = ourDisabledPlugins;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/PluginManagerCore", "getDisabledPlugins"));
        }
        return list;
    }

    public static boolean isBrokenPlugin(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/plugins/PluginManagerCore", "isBrokenPlugin"));
        }
        return PluginManagerCore.getBrokenPluginVersions().get(descriptor2.getPluginId().getIdString()).contains(descriptor2.getVersion());
    }

    @NotNull
    private static MultiMap<String, String> getBrokenPluginVersions() {
        if (ourBrokenPluginVersions == null) {
            ourBrokenPluginVersions = MultiMap.createSet();
            if (System.getProperty("idea.ignore.disabled.plugins") == null && !PluginManagerCore.isUnitTestMode()) {
                BufferedReader br = new BufferedReader(new InputStreamReader(PluginManagerCore.class.getResourceAsStream("/brokenPlugins.txt")));
                try {
                    String s;
                    while ((s = br.readLine()) != null) {
                        List<String> tokens;
                        if ((s = s.trim()).startsWith("//") || (tokens = ParametersListUtil.parse(s)).isEmpty()) continue;
                        if (tokens.size() == 1) {
                            throw new RuntimeException("brokenPlugins.txt is broken. The line contains plugin name, but does not contains version: " + s);
                        }
                        String pluginId = tokens.get(0);
                        List<String> versions = tokens.subList(1, tokens.size());
                        ourBrokenPluginVersions.putValues(pluginId, versions);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read /brokenPlugins.txt", e);
                }
                finally {
                    StreamUtil.closeStream(br);
                }
            }
        }
        MultiMap<String, String> multiMap = ourBrokenPluginVersions;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/PluginManagerCore", "getBrokenPluginVersions"));
        }
        return multiMap;
    }

    private static boolean isUnitTestMode() {
        Application app = ApplicationManager.getApplication();
        return app != null && app.isUnitTestMode();
    }

    public static Logger getLogger() {
        return LoggerHolder.ourLogger;
    }

    public static boolean isModuleDependency(@NotNull PluginId dependentPluginId) {
        if (dependentPluginId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependentPluginId", "com/intellij/ide/plugins/PluginManagerCore", "isModuleDependency"));
        }
        return dependentPluginId.getIdString().startsWith("com.intellij.module");
    }

    public static void checkDependants(@NotNull IdeaPluginDescriptor pluginDescriptor, @NotNull Function<PluginId, IdeaPluginDescriptor> pluginId2Descriptor, @NotNull Condition<PluginId> check2) {
        if (pluginDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/ide/plugins/PluginManagerCore", "checkDependants"));
        }
        if (pluginId2Descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginId2Descriptor", "com/intellij/ide/plugins/PluginManagerCore", "checkDependants"));
        }
        if (check2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "check", "com/intellij/ide/plugins/PluginManagerCore", "checkDependants"));
        }
        PluginManagerCore.checkDependants(pluginDescriptor, pluginId2Descriptor, check2, new THashSet<PluginId>());
    }

    private static boolean checkDependants(@NotNull IdeaPluginDescriptor pluginDescriptor, @NotNull Function<PluginId, IdeaPluginDescriptor> pluginId2Descriptor, @NotNull Condition<PluginId> check2, @NotNull Set<PluginId> processed) {
        if (pluginDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/ide/plugins/PluginManagerCore", "checkDependants"));
        }
        if (pluginId2Descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginId2Descriptor", "com/intellij/ide/plugins/PluginManagerCore", "checkDependants"));
        }
        if (check2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "check", "com/intellij/ide/plugins/PluginManagerCore", "checkDependants"));
        }
        if (processed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processed", "com/intellij/ide/plugins/PluginManagerCore", "checkDependants"));
        }
        processed.add(pluginDescriptor.getPluginId());
        PluginId[] dependentPluginIds = pluginDescriptor.getDependentPluginIds();
        THashSet<PluginId> optionalDependencies = new THashSet<PluginId>(Arrays.asList(pluginDescriptor.getOptionalDependentPluginIds()));
        for (PluginId dependentPluginId : dependentPluginIds) {
            if (processed.contains(dependentPluginId) || PluginManagerCore.isModuleDependency(dependentPluginId) && (ourModulesToContainingPlugins.isEmpty() || ourModulesToContainingPlugins.containsKey(dependentPluginId.getIdString())) || optionalDependencies.contains(dependentPluginId)) continue;
            if (!check2.value(dependentPluginId)) {
                return false;
            }
            IdeaPluginDescriptor dependantPluginDescriptor = pluginId2Descriptor.fun(dependentPluginId);
            if (dependantPluginDescriptor == null || PluginManagerCore.checkDependants(dependantPluginDescriptor, pluginId2Descriptor, check2, processed)) continue;
            return false;
        }
        return true;
    }

    public static void addPluginClass(@NotNull String className, PluginId pluginId, boolean loaded) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/ide/plugins/PluginManagerCore", "addPluginClass"));
        }
        ourPluginClasses.addPluginClass(className, pluginId, loaded);
    }

    @Nullable
    public static PluginId getPluginByClassName(@NotNull String className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/ide/plugins/PluginManagerCore", "getPluginByClassName"));
        }
        return ourPluginClasses.getPluginByClassName(className);
    }

    private static boolean isDependent(@NotNull IdeaPluginDescriptor descriptor2, @NotNull PluginId on, @NotNull Map<PluginId, IdeaPluginDescriptor> map, boolean checkModuleDependencies) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/plugins/PluginManagerCore", "isDependent"));
        }
        if (on == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "on", "com/intellij/ide/plugins/PluginManagerCore", "isDependent"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/ide/plugins/PluginManagerCore", "isDependent"));
        }
        for (PluginId id : descriptor2.getDependentPluginIds()) {
            if (ArrayUtil.contains(id, descriptor2.getOptionalDependentPluginIds()) || !checkModuleDependencies && PluginManagerCore.isModuleDependency(id)) continue;
            if (id.equals(on)) {
                return true;
            }
            IdeaPluginDescriptor depDescriptor = map.get(id);
            if (depDescriptor == null || !PluginManagerCore.isDependent(depDescriptor, on, map, checkModuleDependencies)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasModuleDependencies(@NotNull IdeaPluginDescriptor descriptor2) {
        PluginId[] dependentPluginIds;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/plugins/PluginManagerCore", "hasModuleDependencies"));
        }
        for (PluginId dependentPluginId : dependentPluginIds = descriptor2.getDependentPluginIds()) {
            if (!PluginManagerCore.isModuleDependency(dependentPluginId)) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldLoadPlugins() {
        try {
            Class.forName("com.intellij.openapi.extensions.Extensions");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        String loadPlugins = System.getProperty("idea.load.plugins");
        return loadPlugins == null || Boolean.TRUE.toString().equals(loadPlugins);
    }

    private static void configureExtensions() {
        Extensions.setLogProvider(new IdeaLogProvider());
        Extensions.registerAreaClass("IDEA_PROJECT", null);
        Extensions.registerAreaClass("IDEA_MODULE", "IDEA_PROJECT");
    }

    private static Method getAddUrlMethod(@NotNull ClassLoader loader) {
        if (loader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loader", "com/intellij/ide/plugins/PluginManagerCore", "getAddUrlMethod"));
        }
        return ReflectionUtil.getDeclaredMethod(loader instanceof URLClassLoader ? URLClassLoader.class : loader.getClass(), "addURL", URL.class);
    }

    @Nullable
    private static ClassLoader createPluginClassLoader(@NotNull File[] classPath, @NotNull ClassLoader[] parentLoaders, @NotNull IdeaPluginDescriptor pluginDescriptor) {
        if (classPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classPath", "com/intellij/ide/plugins/PluginManagerCore", "createPluginClassLoader"));
        }
        if (parentLoaders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentLoaders", "com/intellij/ide/plugins/PluginManagerCore", "createPluginClassLoader"));
        }
        if (pluginDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/ide/plugins/PluginManagerCore", "createPluginClassLoader"));
        }
        if (pluginDescriptor.getUseIdeaClassLoader()) {
            try {
                ClassLoader loader = PluginManagerCore.class.getClassLoader();
                Method addUrlMethod = PluginManagerCore.getAddUrlMethod(loader);
                for (File aClassPath : classPath) {
                    File file = aClassPath.getCanonicalFile();
                    addUrlMethod.invoke((Object)loader, file.toURI().toURL());
                }
                return loader;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        PluginId pluginId = pluginDescriptor.getPluginId();
        File pluginRoot = pluginDescriptor.getPath();
        if (PluginManagerCore.isUnitTestMode()) {
            return null;
        }
        try {
            ArrayList<URL> urls = new ArrayList<URL>(classPath.length);
            for (File aClassPath : classPath) {
                File file = aClassPath.getCanonicalFile();
                urls.add(file.toURI().toURL());
            }
            return new PluginClassLoader(urls, parentLoaders, pluginId, pluginDescriptor.getVersion(), pluginRoot);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static void logPlugins() {
        ArrayList<String> loadedBundled = new ArrayList<String>();
        ArrayList<String> disabled = new ArrayList<String>();
        ArrayList<String> loadedCustom = new ArrayList<String>();
        for (IdeaPluginDescriptor descriptor2 : ourPlugins) {
            String version = descriptor2.getVersion();
            String s = descriptor2.getName() + (version != null ? " (" + version + ")" : "");
            if (descriptor2.isEnabled()) {
                if (descriptor2.isBundled() || "IDEA CORE".equals(descriptor2.getName())) {
                    loadedBundled.add(s);
                    continue;
                }
                loadedCustom.add(s);
                continue;
            }
            disabled.add(s);
        }
        Collections.sort(loadedBundled);
        Collections.sort(loadedCustom);
        Collections.sort(disabled);
        PluginManagerCore.getLogger().info("Loaded bundled plugins: " + StringUtil.join(loadedBundled, ", "));
        if (!loadedCustom.isEmpty()) {
            PluginManagerCore.getLogger().info("Loaded custom plugins: " + StringUtil.join(loadedCustom, ", "));
        }
        if (!disabled.isEmpty()) {
            PluginManagerCore.getLogger().info("Disabled plugins: " + StringUtil.join(disabled, ", "));
        }
    }

    @NotNull
    private static ClassLoader[] getParentLoaders(@NotNull Map<PluginId, ? extends IdeaPluginDescriptor> idToDescriptorMap, @NotNull PluginId[] pluginIds) {
        if (idToDescriptorMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idToDescriptorMap", "com/intellij/ide/plugins/PluginManagerCore", "getParentLoaders"));
        }
        if (pluginIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginIds", "com/intellij/ide/plugins/PluginManagerCore", "getParentLoaders"));
        }
        if (PluginManagerCore.isUnitTestMode()) {
            ClassLoader[] classLoaderArray = new ClassLoader[]{};
            if (classLoaderArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/PluginManagerCore", "getParentLoaders"));
            }
            return classLoaderArray;
        }
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        for (PluginId id : pluginIds) {
            IdeaPluginDescriptor pluginDescriptor = idToDescriptorMap.get(id);
            if (pluginDescriptor == null) continue;
            ClassLoader loader = pluginDescriptor.getPluginClassLoader();
            if (loader == null) {
                PluginManagerCore.getLogger().error("Plugin class loader should be initialized for plugin " + id);
            }
            classLoaders.add(loader);
        }
        ClassLoader[] classLoaderArray = classLoaders.toArray(new ClassLoader[classLoaders.size()]);
        if (classLoaderArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/PluginManagerCore", "getParentLoaders"));
        }
        return classLoaderArray;
    }

    private static int countPlugins(@NotNull String pluginsPath) {
        String[] list;
        if (pluginsPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginsPath", "com/intellij/ide/plugins/PluginManagerCore", "countPlugins"));
        }
        File configuredPluginsDir = new File(pluginsPath);
        if (configuredPluginsDir.exists() && (list = configuredPluginsDir.list()) != null) {
            return list.length;
        }
        return 0;
    }

    @NotNull
    private static Collection<URL> getClassLoaderUrls() {
        List list;
        ClassLoader classLoader = PluginManagerCore.class.getClassLoader();
        Class<?> aClass = classLoader.getClass();
        try {
            List urls;
            list = urls = (List)aClass.getMethod("getUrls", new Class[0]).invoke((Object)classLoader, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/PluginManagerCore", "getClassLoaderUrls"));
        }
        return list;
        if (classLoader instanceof URLClassLoader) {
            List<URL> list2 = Arrays.asList(((URLClassLoader)classLoader).getURLs());
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/PluginManagerCore", "getClassLoaderUrls"));
            }
            return list2;
        }
        List<URL> list3 = Collections.emptyList();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/PluginManagerCore", "getClassLoaderUrls"));
        }
        return list3;
    }

    private static void prepareLoadingPluginsErrorMessage(@NotNull String errorMessage) {
        if (errorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/ide/plugins/PluginManagerCore", "prepareLoadingPluginsErrorMessage"));
        }
        if (!StringUtil.isEmptyOrSpaces(errorMessage)) {
            if (ApplicationManager.getApplication() != null && !ApplicationManager.getApplication().isHeadlessEnvironment() && !ApplicationManager.getApplication().isUnitTestMode()) {
                myPluginError = myPluginError == null ? errorMessage : myPluginError + "\n" + errorMessage;
            } else {
                PluginManagerCore.getLogger().error(errorMessage);
            }
        }
    }

    private static void addModulesAsDependents(@NotNull Map<PluginId, ? super IdeaPluginDescriptorImpl> map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/ide/plugins/PluginManagerCore", "addModulesAsDependents"));
        }
        for (Map.Entry<String, IdeaPluginDescriptorImpl> entry : ourModulesToContainingPlugins.entrySet()) {
            map.put(PluginId.getId(entry.getKey()), entry.getValue());
        }
    }

    @NotNull
    private static Comparator<IdeaPluginDescriptor> getPluginDescriptorComparator(final @NotNull Map<PluginId, ? extends IdeaPluginDescriptor> idToDescriptorMap) {
        if (idToDescriptorMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idToDescriptorMap", "com/intellij/ide/plugins/PluginManagerCore", "getPluginDescriptorComparator"));
        }
        Graph<PluginId> graph = PluginManagerCore.createPluginIdGraph(idToDescriptorMap);
        final DFSTBuilder<PluginId> builder = new DFSTBuilder<PluginId>(graph);
        if (!builder.isAcyclic()) {
            builder.getSCCs().forEach(new TIntProcedure(){
                private int myTNumber = 0;

                @Override
                public boolean execute(int size) {
                    if (size > 1) {
                        for (int j = 0; j < size; ++j) {
                            ((IdeaPluginDescriptor)idToDescriptorMap.get(builder.getNodeByTNumber(this.myTNumber + j))).setEnabled(false);
                        }
                    }
                    this.myTNumber += size;
                    return true;
                }
            });
        }
        final Comparator<PluginId> idComparator = builder.comparator();
        Comparator<IdeaPluginDescriptor> comparator2 = new Comparator<IdeaPluginDescriptor>(){

            @Override
            public int compare(@NotNull IdeaPluginDescriptor o1, @NotNull IdeaPluginDescriptor o2) {
                if (o1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/ide/plugins/PluginManagerCore$2", "compare"));
                }
                if (o2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/ide/plugins/PluginManagerCore$2", "compare"));
                }
                PluginId pluginId1 = o1.getPluginId();
                PluginId pluginId2 = o2.getPluginId();
                if (pluginId1.getIdString().equals("com.intellij")) {
                    return -1;
                }
                if (pluginId2.getIdString().equals("com.intellij")) {
                    return 1;
                }
                return idComparator.compare(pluginId1, pluginId2);
            }
        };
        if (comparator2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/PluginManagerCore", "getPluginDescriptorComparator"));
        }
        return comparator2;
    }

    @NotNull
    private static Graph<PluginId> createPluginIdGraph(final @NotNull Map<PluginId, ? extends IdeaPluginDescriptor> idToDescriptorMap) {
        if (idToDescriptorMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idToDescriptorMap", "com/intellij/ide/plugins/PluginManagerCore", "createPluginIdGraph"));
        }
        final ArrayList<PluginId> ids = new ArrayList<PluginId>(idToDescriptorMap.keySet());
        Collections.sort(ids, new Comparator<PluginId>(){

            @Override
            public int compare(@NotNull PluginId o1, @NotNull PluginId o2) {
                if (o1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/ide/plugins/PluginManagerCore$3", "compare"));
                }
                if (o2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/ide/plugins/PluginManagerCore$3", "compare"));
                }
                return o2.getIdString().compareTo(o1.getIdString());
            }
        });
        GraphGenerator<PluginId> graphGenerator = GraphGenerator.create(CachingSemiGraph.create(new GraphGenerator.SemiGraph<PluginId>(){

            @Override
            public Collection<PluginId> getNodes() {
                return ids;
            }

            @Override
            public Iterator<PluginId> getIn(PluginId pluginId) {
                IdeaPluginDescriptor descriptor2 = (IdeaPluginDescriptor)idToDescriptorMap.get(pluginId);
                ArrayList<PluginId> plugins = new ArrayList<PluginId>();
                for (PluginId dependentPluginId : descriptor2.getDependentPluginIds()) {
                    IdeaPluginDescriptor dep = (IdeaPluginDescriptor)idToDescriptorMap.get(dependentPluginId);
                    if (dep == null) continue;
                    plugins.add(dep.getPluginId());
                }
                return plugins.iterator();
            }
        }));
        if (graphGenerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/PluginManagerCore", "createPluginIdGraph"));
        }
        return graphGenerator;
    }

    @Nullable
    static IdeaPluginDescriptorImpl loadDescriptorFromDir(@NotNull File file, @NotNull String fileName) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/plugins/PluginManagerCore", "loadDescriptorFromDir"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/ide/plugins/PluginManagerCore", "loadDescriptorFromDir"));
        }
        File descriptorFile = new File(file, "META-INF" + File.separator + fileName);
        if (descriptorFile.exists()) {
            try {
                IdeaPluginDescriptorImpl descriptor2 = new IdeaPluginDescriptorImpl(file);
                descriptor2.readExternal(descriptorFile.toURI().toURL());
                return descriptor2;
            }
            catch (XmlSerializationException e) {
                PluginManagerCore.getLogger().info("Cannot load " + file, e);
                PluginManagerCore.prepareLoadingPluginsErrorMessage("File '" + file.getName() + "' contains invalid plugin descriptor.");
            }
            catch (Throwable e) {
                PluginManagerCore.getLogger().info("Cannot load " + file, e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptorFromJar(@NotNull File file, @NotNull String fileName) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/plugins/PluginManagerCore", "loadDescriptorFromJar"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/ide/plugins/PluginManagerCore", "loadDescriptorFromJar"));
        }
        try {
            String fileURL = StringUtil.replace(file.toURI().toASCIIString(), "!", "%21");
            URL jarURL = new URL("jar:" + fileURL + "!/META-INF/" + fileName);
            ZipFile zipFile = ZipFileCache.acquire(file.getPath());
            try {
                ZipEntry entry = zipFile.getEntry("META-INF/" + fileName);
                if (entry == null) return null;
                Document document = JDOMUtil.loadDocument(zipFile.getInputStream(entry));
                IdeaPluginDescriptorImpl descriptor2 = new IdeaPluginDescriptorImpl(file);
                descriptor2.readExternal(document, jarURL);
                IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = descriptor2;
                return ideaPluginDescriptorImpl;
            }
            finally {
                ZipFileCache.release(zipFile);
            }
        }
        catch (XmlSerializationException e) {
            PluginManagerCore.getLogger().info("Cannot load " + file, e);
            PluginManagerCore.prepareLoadingPluginsErrorMessage("File '" + file.getName() + "' contains invalid plugin descriptor.");
            return null;
        }
        catch (Throwable e) {
            PluginManagerCore.getLogger().info("Cannot load " + file, e);
        }
        return null;
    }

    @Nullable
    public static IdeaPluginDescriptorImpl loadDescriptor(final @NotNull File file, @NotNull String fileName) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/plugins/PluginManagerCore", "loadDescriptor"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/ide/plugins/PluginManagerCore", "loadDescriptor"));
        }
        IdeaPluginDescriptorImpl descriptor2 = null;
        if (file.isDirectory()) {
            descriptor2 = PluginManagerCore.loadDescriptorFromDir(file, fileName);
            if (descriptor2 == null) {
                File libDir = new File(file, "lib");
                if (!libDir.isDirectory()) {
                    return null;
                }
                File[] files = libDir.listFiles();
                if (files == null || files.length == 0) {
                    return null;
                }
                Arrays.sort(files, new Comparator<File>(){

                    @Override
                    public int compare(@NotNull File o1, @NotNull File o2) {
                        if (o1 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/ide/plugins/PluginManagerCore$5", "compare"));
                        }
                        if (o2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/ide/plugins/PluginManagerCore$5", "compare"));
                        }
                        if (o2.getName().startsWith(file.getName())) {
                            return Integer.MAX_VALUE;
                        }
                        if (o1.getName().startsWith(file.getName())) {
                            return -2147483647;
                        }
                        if (o2.getName().startsWith("resources")) {
                            return -2147483647;
                        }
                        if (o1.getName().startsWith("resources")) {
                            return Integer.MAX_VALUE;
                        }
                        return 0;
                    }
                });
                for (File f : files) {
                    IdeaPluginDescriptorImpl descriptor1;
                    if (FileUtil.isJarOrZip(f)) {
                        descriptor2 = PluginManagerCore.loadDescriptorFromJar(f, fileName);
                        if (descriptor2 == null) continue;
                        descriptor2.setPath(file);
                        break;
                    }
                    if (!f.isDirectory() || (descriptor1 = PluginManagerCore.loadDescriptorFromDir(f, fileName)) == null) continue;
                    if (descriptor2 != null) {
                        PluginManagerCore.getLogger().info("Cannot load " + file + " because two or more plugin.xml's detected");
                        return null;
                    }
                    descriptor2 = descriptor1;
                    descriptor2.setPath(file);
                }
            }
        } else if (StringUtil.endsWithIgnoreCase(file.getName(), ".jar") && file.exists()) {
            descriptor2 = PluginManagerCore.loadDescriptorFromJar(file, fileName);
        }
        if (descriptor2 != null && descriptor2.getOptionalConfigs() != null && !descriptor2.getOptionalConfigs().isEmpty()) {
            THashMap<PluginId, IdeaPluginDescriptorImpl> descriptors = new THashMap<PluginId, IdeaPluginDescriptorImpl>(descriptor2.getOptionalConfigs().size());
            for (Map.Entry<PluginId, String> entry : descriptor2.getOptionalConfigs().entrySet()) {
                String optionalDescriptorName = entry.getValue();
                assert (!Comparing.equal(fileName, optionalDescriptorName)) : "recursive dependency: " + fileName;
                IdeaPluginDescriptorImpl optionalDescriptor = PluginManagerCore.loadDescriptor(file, optionalDescriptorName);
                if (optionalDescriptor == null && !FileUtil.isJarOrZip(file)) {
                    for (URL url : PluginManagerCore.getClassLoaderUrls()) {
                        if ("file".equals(url.getProtocol()) && (optionalDescriptor = PluginManagerCore.loadDescriptor(new File(PluginManagerCore.decodeUrl(url.getFile())), optionalDescriptorName)) != null) break;
                    }
                }
                if (optionalDescriptor != null) {
                    descriptors.put(entry.getKey(), optionalDescriptor);
                    continue;
                }
                PluginManagerCore.getLogger().info("Cannot find optional descriptor " + optionalDescriptorName);
            }
            descriptor2.setOptionalDescriptors(descriptors);
        }
        return descriptor2;
    }

    private static void loadDescriptors(@NotNull String pluginsPath, @NotNull List<IdeaPluginDescriptorImpl> result2, @Nullable StartupProgress progress, int pluginsCount) {
        if (pluginsPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginsPath", "com/intellij/ide/plugins/PluginManagerCore", "loadDescriptors"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/ide/plugins/PluginManagerCore", "loadDescriptors"));
        }
        PluginManagerCore.loadDescriptors(new File(pluginsPath), result2, progress, pluginsCount);
    }

    public static void loadDescriptors(@NotNull File pluginsHome, @NotNull List<IdeaPluginDescriptorImpl> result2, @Nullable StartupProgress progress, int pluginsCount) {
        if (pluginsHome == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginsHome", "com/intellij/ide/plugins/PluginManagerCore", "loadDescriptors"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/ide/plugins/PluginManagerCore", "loadDescriptors"));
        }
        File[] files = pluginsHome.listFiles();
        if (files != null) {
            int i = result2.size();
            for (File file : files) {
                int oldIndex;
                IdeaPluginDescriptorImpl descriptor2 = PluginManagerCore.loadDescriptor(file, "plugin.xml");
                if (descriptor2 == null) continue;
                if (progress != null) {
                    progress.showProgress(descriptor2.getName(), 0.3f * ((float)(++i) / (float)pluginsCount));
                }
                if ((oldIndex = result2.indexOf(descriptor2)) >= 0) {
                    IdeaPluginDescriptorImpl oldDescriptor = result2.get(oldIndex);
                    if (StringUtil.compareVersionNumbers(oldDescriptor.getVersion(), descriptor2.getVersion()) >= 0) continue;
                    result2.set(oldIndex, descriptor2);
                    continue;
                }
                result2.add(descriptor2);
            }
        }
    }

    @NotNull
    private static String filterBadPlugins(@NotNull List<? extends IdeaPluginDescriptor> result2, final @NotNull Map<String, String> disabledPluginNames) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/ide/plugins/PluginManagerCore", "filterBadPlugins"));
        }
        if (disabledPluginNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disabledPluginNames", "com/intellij/ide/plugins/PluginManagerCore", "filterBadPlugins"));
        }
        final THashMap<PluginId, IdeaPluginDescriptor> idToDescriptorMap = new THashMap<PluginId, IdeaPluginDescriptor>();
        final StringBuilder message = new StringBuilder();
        boolean pluginsWithoutIdFound = false;
        Iterator<? extends IdeaPluginDescriptor> it2 = result2.iterator();
        while (it2.hasNext()) {
            IdeaPluginDescriptor descriptor2 = it2.next();
            PluginId id = descriptor2.getPluginId();
            if (id == null) {
                pluginsWithoutIdFound = true;
                continue;
            }
            if (idToDescriptorMap.containsKey(id)) {
                message.append("<br>");
                message.append(IdeBundle.message("message.duplicate.plugin.id", new Object[0]));
                message.append(id);
                it2.remove();
                continue;
            }
            if (!descriptor2.isEnabled()) continue;
            idToDescriptorMap.put(id, descriptor2);
        }
        PluginManagerCore.addModulesAsDependents(idToDescriptorMap);
        final SmartList<String> disabledPluginIds = new SmartList<String>();
        final LinkedHashSet faultyDescriptors = new LinkedHashSet();
        final Iterator<? extends IdeaPluginDescriptor> it3 = result2.iterator();
        while (it3.hasNext()) {
            final IdeaPluginDescriptor pluginDescriptor = it3.next();
            PluginManagerCore.checkDependants(pluginDescriptor, new Function<PluginId, IdeaPluginDescriptor>(){

                @Override
                public IdeaPluginDescriptor fun(PluginId pluginId) {
                    return (IdeaPluginDescriptor)idToDescriptorMap.get(pluginId);
                }
            }, new Condition<PluginId>(){

                @Override
                public boolean value(PluginId pluginId) {
                    if (!idToDescriptorMap.containsKey(pluginId)) {
                        pluginDescriptor.setEnabled(false);
                        if (!pluginId.getIdString().startsWith("com.intellij.module")) {
                            String pluginName;
                            faultyDescriptors.add(pluginId.getIdString());
                            disabledPluginIds.add(pluginDescriptor.getPluginId().getIdString());
                            message.append("<br>");
                            String name = pluginDescriptor.getName();
                            IdeaPluginDescriptor descriptor2 = (IdeaPluginDescriptor)idToDescriptorMap.get(pluginId);
                            if (descriptor2 == null) {
                                pluginName = pluginId.getIdString();
                                if (disabledPluginNames.containsKey(pluginName)) {
                                    pluginName = (String)disabledPluginNames.get(pluginName);
                                }
                            } else {
                                pluginName = descriptor2.getName();
                            }
                            message.append(PluginManagerCore.getDisabledPlugins().contains(pluginId.getIdString()) ? IdeBundle.message("error.required.plugin.disabled", name, pluginName) : IdeBundle.message("error.required.plugin.not.installed", name, pluginName));
                        }
                        it3.remove();
                        return false;
                    }
                    return true;
                }
            });
        }
        if (!disabledPluginIds.isEmpty()) {
            myPlugins2Disable = disabledPluginIds;
            myPlugins2Enable = faultyDescriptors;
            message.append("<br>");
            message.append("<br>").append("<a href=\"disable\">Disable ");
            if (disabledPluginIds.size() == 1) {
                PluginId pluginId2Disable = PluginId.getId((String)disabledPluginIds.iterator().next());
                message.append(idToDescriptorMap.containsKey(pluginId2Disable) ? ((IdeaPluginDescriptor)idToDescriptorMap.get(pluginId2Disable)).getName() : pluginId2Disable.getIdString());
            } else {
                message.append("not loaded plugins");
            }
            message.append("</a>");
            boolean possibleToEnable = true;
            for (String descriptor3 : faultyDescriptors) {
                if (disabledPluginNames.get(descriptor3) != null) continue;
                possibleToEnable = false;
                break;
            }
            if (possibleToEnable) {
                message.append("<br>").append("<a href=\"enable\">Enable ").append(faultyDescriptors.size() == 1 ? disabledPluginNames.get(faultyDescriptors.iterator().next()) : " all necessary plugins").append("</a>");
            }
            message.append("<br>").append("<a href=\"edit\">Open plugin manager</a>");
        }
        if (pluginsWithoutIdFound) {
            message.append("<br>");
            message.append(IdeBundle.message("error.plugins.without.id.found", new Object[0]));
        }
        if (message.length() > 0) {
            message.insert(0, IdeBundle.message("error.problems.found.loading.plugins", new Object[0]));
            String string = message.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/PluginManagerCore", "filterBadPlugins"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/PluginManagerCore", "filterBadPlugins"));
        }
        return "";
    }

    private static void loadDescriptorsFromClassPath(@NotNull List<IdeaPluginDescriptorImpl> result2, @Nullable StartupProgress progress) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/ide/plugins/PluginManagerCore", "loadDescriptorsFromClassPath"));
        }
        Collection<URL> urls = PluginManagerCore.getClassLoaderUrls();
        String platformPrefix = System.getProperty("idea.platform.prefix");
        int i = 0;
        for (URL url : urls) {
            ++i;
            if (!"file".equals(url.getProtocol())) continue;
            File file = new File(PluginManagerCore.decodeUrl(url.getFile()));
            IdeaPluginDescriptorImpl platformPluginDescriptor = null;
            if (platformPrefix != null && (platformPluginDescriptor = PluginManagerCore.loadDescriptor(file, platformPrefix + "Plugin.xml")) != null && !result2.contains(platformPluginDescriptor)) {
                platformPluginDescriptor.setUseCoreClassLoader(true);
                result2.add(platformPluginDescriptor);
            }
            IdeaPluginDescriptorImpl pluginDescriptor = PluginManagerCore.loadDescriptor(file, "plugin.xml");
            if (platformPrefix != null && pluginDescriptor != null && pluginDescriptor.getName().equals("IDEA CORE") || pluginDescriptor == null || result2.contains(pluginDescriptor)) continue;
            if (platformPluginDescriptor != null) {
                pluginDescriptor.setUseCoreClassLoader(true);
            }
            result2.add(pluginDescriptor);
            if (progress == null) continue;
            progress.showProgress("Plugin loaded: " + pluginDescriptor.getName(), 0.3f * ((float)i / (float)urls.size()));
        }
    }

    @NotNull
    private static String decodeUrl(@NotNull String file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/plugins/PluginManagerCore", "decodeUrl"));
        }
        String quotePluses = StringUtil.replace(file, "+", "%2B");
        String string = URLDecoder.decode(quotePluses);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/PluginManagerCore", "decodeUrl"));
        }
        return string;
    }

    private static void loadDescriptorsFromProperty(@NotNull List<IdeaPluginDescriptorImpl> result2) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/ide/plugins/PluginManagerCore", "loadDescriptorsFromProperty"));
        }
        String pathProperty = System.getProperty("plugin.path");
        if (pathProperty == null) {
            return;
        }
        StringTokenizer t = new StringTokenizer(pathProperty, File.pathSeparator + ",");
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            IdeaPluginDescriptorImpl ideaPluginDescriptor = PluginManagerCore.loadDescriptor(new File(s), "plugin.xml");
            if (ideaPluginDescriptor == null) continue;
            result2.add(ideaPluginDescriptor);
        }
    }

    @NotNull
    public static IdeaPluginDescriptorImpl[] loadDescriptors(@Nullable StartupProgress progress) {
        if (ClassUtilCore.isLoadingOfExternalPluginsDisabled()) {
            if (IdeaPluginDescriptorImpl.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/PluginManagerCore", "loadDescriptors"));
            }
            return IdeaPluginDescriptorImpl.EMPTY_ARRAY;
        }
        ArrayList<IdeaPluginDescriptorImpl> result2 = new ArrayList<IdeaPluginDescriptorImpl>();
        int pluginsCount = PluginManagerCore.countPlugins(PathManager.getPluginsPath()) + PluginManagerCore.countPlugins(PathManager.getPreInstalledPluginsPath());
        PluginManagerCore.loadDescriptors(PathManager.getPluginsPath(), result2, progress, pluginsCount);
        Application application = ApplicationManager.getApplication();
        boolean fromSources = false;
        if (application == null || !application.isUnitTestMode()) {
            int size = result2.size();
            PluginManagerCore.loadDescriptors(PathManager.getPreInstalledPluginsPath(), result2, progress, pluginsCount);
            fromSources = size == result2.size();
        }
        PluginManagerCore.loadDescriptorsFromProperty(result2);
        PluginManagerCore.loadDescriptorsFromClassPath(result2, fromSources ? progress : null);
        IdeaPluginDescriptorImpl[] pluginDescriptors = result2.toArray(new IdeaPluginDescriptorImpl[result2.size()]);
        THashMap<PluginId, IdeaPluginDescriptorImpl> idToDescriptorMap = new THashMap<PluginId, IdeaPluginDescriptorImpl>();
        for (IdeaPluginDescriptorImpl descriptor2 : pluginDescriptors) {
            idToDescriptorMap.put(descriptor2.getPluginId(), descriptor2);
        }
        Arrays.sort(pluginDescriptors, PluginManagerCore.getPluginDescriptorComparator(idToDescriptorMap));
        if (pluginDescriptors == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/PluginManagerCore", "loadDescriptors"));
        }
        return pluginDescriptors;
    }

    private static void mergeOptionalConfigs(@NotNull Map<PluginId, IdeaPluginDescriptorImpl> descriptors) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/ide/plugins/PluginManagerCore", "mergeOptionalConfigs"));
        }
        THashMap<PluginId, IdeaPluginDescriptorImpl> descriptorsWithModules = new THashMap<PluginId, IdeaPluginDescriptorImpl>(descriptors);
        PluginManagerCore.addModulesAsDependents(descriptorsWithModules);
        for (IdeaPluginDescriptorImpl descriptor2 : descriptors.values()) {
            Map<PluginId, IdeaPluginDescriptorImpl> optionalDescriptors = descriptor2.getOptionalDescriptors();
            if (optionalDescriptors == null || optionalDescriptors.isEmpty()) continue;
            for (Map.Entry<PluginId, IdeaPluginDescriptorImpl> entry : optionalDescriptors.entrySet()) {
                if (!descriptorsWithModules.containsKey(entry.getKey())) continue;
                descriptor2.mergeOptionalConfig(entry.getValue());
            }
        }
    }

    public static void initClassLoader(@NotNull ClassLoader parentLoader, @NotNull IdeaPluginDescriptorImpl descriptor2) {
        if (parentLoader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentLoader", "com/intellij/ide/plugins/PluginManagerCore", "initClassLoader"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/plugins/PluginManagerCore", "initClassLoader"));
        }
        List<File> classPath = descriptor2.getClassPath();
        ClassLoader loader = PluginManagerCore.createPluginClassLoader(classPath.toArray(new File[classPath.size()]), new ClassLoader[]{parentLoader}, descriptor2);
        descriptor2.setLoader(loader);
    }

    static BuildNumber getBuildNumber() {
        if (ourBuildNumber == null && (ourBuildNumber = BuildNumber.fromString(System.getProperty("idea.plugins.compatible.build"))) == null) {
            BuildNumber buildNumber = ourBuildNumber = BUILD_NUMBER == null ? null : BuildNumber.fromString(BUILD_NUMBER);
            if (ourBuildNumber == null) {
                ourBuildNumber = BuildNumber.fallback();
            }
        }
        return ourBuildNumber;
    }

    private static boolean shouldLoadPlugin(@NotNull IdeaPluginDescriptor descriptor2, @NotNull IdeaPluginDescriptor[] loaded) {
        boolean shouldLoad;
        boolean checkModuleDependencies;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/plugins/PluginManagerCore", "shouldLoadPlugin"));
        }
        if (loaded == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loaded", "com/intellij/ide/plugins/PluginManagerCore", "shouldLoadPlugin"));
        }
        String idString = descriptor2.getPluginId().getIdString();
        if ("com.intellij".equals(idString)) {
            return true;
        }
        String pluginId = System.getProperty("idea.load.plugins.id");
        if (pluginId == null) {
            if (descriptor2 instanceof IdeaPluginDescriptorImpl && !descriptor2.isEnabled()) {
                return false;
            }
            if (!PluginManagerCore.shouldLoadPlugins()) {
                return false;
            }
        }
        List<String> pluginIds = pluginId == null ? null : StringUtil.split(pluginId, ",");
        boolean bl = checkModuleDependencies = !ourModulesToContainingPlugins.isEmpty() && !ourModulesToContainingPlugins.containsKey("com.intellij.modules.all");
        if (checkModuleDependencies && !PluginManagerCore.hasModuleDependencies(descriptor2)) {
            return false;
        }
        String loadPluginCategory = System.getProperty("idea.load.plugins.category");
        if (loadPluginCategory != null) {
            shouldLoad = loadPluginCategory.equals(descriptor2.getCategory());
        } else {
            if (pluginIds != null) {
                shouldLoad = pluginIds.contains(idString);
                if (!shouldLoad) {
                    THashMap<PluginId, IdeaPluginDescriptor> map = new THashMap<PluginId, IdeaPluginDescriptor>();
                    for (IdeaPluginDescriptor pluginDescriptor : loaded) {
                        map.put(pluginDescriptor.getPluginId(), pluginDescriptor);
                    }
                    PluginManagerCore.addModulesAsDependents(map);
                    for (String id : pluginIds) {
                        IdeaPluginDescriptor descriptorFromProperty = (IdeaPluginDescriptor)map.get(PluginId.getId(id));
                        if (descriptorFromProperty == null || !PluginManagerCore.isDependent(descriptorFromProperty, descriptor2.getPluginId(), map, checkModuleDependencies)) continue;
                        shouldLoad = true;
                        break;
                    }
                }
            } else {
                boolean bl2 = shouldLoad = !PluginManagerCore.getDisabledPlugins().contains(idString);
            }
            if (shouldLoad && descriptor2 instanceof IdeaPluginDescriptorImpl && PluginManagerCore.isIncompatible(descriptor2)) {
                return false;
            }
        }
        return shouldLoad;
    }

    public static boolean isIncompatible(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/plugins/PluginManagerCore", "isIncompatible"));
        }
        return PluginManagerCore.isIncompatible(descriptor2, PluginManagerCore.getBuildNumber());
    }

    public static boolean isIncompatible(@NotNull IdeaPluginDescriptor descriptor2, @Nullable BuildNumber buildNumber) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/plugins/PluginManagerCore", "isIncompatible"));
        }
        if (buildNumber == null) {
            buildNumber = PluginManagerCore.getBuildNumber();
        }
        try {
            BuildNumber untilBuild;
            BuildNumber sinceBuild;
            if (!StringUtil.isEmpty(descriptor2.getSinceBuild()) && (sinceBuild = BuildNumber.fromString(descriptor2.getSinceBuild(), descriptor2.getName())).compareTo(buildNumber) > 0) {
                return true;
            }
            if (!StringUtil.isEmpty(descriptor2.getUntilBuild()) && !buildNumber.isSnapshot() && (untilBuild = BuildNumber.fromString(descriptor2.getUntilBuild(), descriptor2.getName())).compareTo(buildNumber) < 0) {
                return true;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return false;
    }

    private static void initializePlugins(@Nullable StartupProgress progress) {
        int i;
        PluginManagerCore.configureExtensions();
        IdeaPluginDescriptor[] pluginDescriptors = PluginManagerCore.loadDescriptors(progress);
        Class callerClass = ReflectionUtil.findCallerClass(1);
        assert (callerClass != null);
        ClassLoader parentLoader = callerClass.getClassLoader();
        final ArrayList<IdeaPluginDescriptorImpl> result2 = new ArrayList<IdeaPluginDescriptorImpl>();
        THashMap<String, String> disabledPluginNames = new THashMap<String, String>();
        SmartList<String> brokenPluginsList = new SmartList<String>();
        for (IdeaPluginDescriptorImpl ideaPluginDescriptorImpl : pluginDescriptors) {
            boolean shouldLoad = PluginManagerCore.shouldLoadPlugin(ideaPluginDescriptorImpl, pluginDescriptors);
            if (shouldLoad && PluginManagerCore.isBrokenPlugin(ideaPluginDescriptorImpl)) {
                brokenPluginsList.add(ideaPluginDescriptorImpl.getName());
                shouldLoad = false;
            }
            if (shouldLoad) {
                List<String> modules = ideaPluginDescriptorImpl.getModules();
                if (modules != null) {
                    for (String module : modules) {
                        if (ourModulesToContainingPlugins.containsKey(module)) continue;
                        ourModulesToContainingPlugins.put(module, ideaPluginDescriptorImpl);
                    }
                }
                result2.add(ideaPluginDescriptorImpl);
                continue;
            }
            ideaPluginDescriptorImpl.setEnabled(false);
            disabledPluginNames.put(ideaPluginDescriptorImpl.getPluginId().getIdString(), ideaPluginDescriptorImpl.getName());
            PluginManagerCore.initClassLoader(parentLoader, ideaPluginDescriptorImpl);
        }
        String errorMessage = PluginManagerCore.filterBadPlugins(result2, disabledPluginNames);
        if (!brokenPluginsList.isEmpty()) {
            if (!StringUtil.isEmptyOrSpaces(errorMessage)) {
                errorMessage = errorMessage + "<br>";
            }
            errorMessage = errorMessage + "Following plugins are incompatible with current IDE build: " + StringUtil.join(brokenPluginsList, ", ") + "<br>\n" + StringUtil.notNullize(errorMessage);
        }
        THashMap<PluginId, IdeaPluginDescriptorImpl> idToDescriptorMap = new THashMap<PluginId, IdeaPluginDescriptorImpl>();
        for (IdeaPluginDescriptorImpl ideaPluginDescriptorImpl : result2) {
            idToDescriptorMap.put(ideaPluginDescriptorImpl.getPluginId(), ideaPluginDescriptorImpl);
        }
        IdeaPluginDescriptor corePluginDescriptor = (IdeaPluginDescriptor)idToDescriptorMap.get(PluginId.getId("com.intellij"));
        assert (corePluginDescriptor != null) : "com.intellij not found; platform prefix is " + System.getProperty("idea.platform.prefix");
        for (IdeaPluginDescriptorImpl descriptor3 : result2) {
            if (descriptor3 == corePluginDescriptor) continue;
            descriptor3.insertDependency(corePluginDescriptor);
        }
        PluginManagerCore.mergeOptionalConfigs(idToDescriptorMap);
        PluginManagerCore.addModulesAsDependents(idToDescriptorMap);
        Graph<PluginId> graph = PluginManagerCore.createPluginIdGraph(idToDescriptorMap);
        final DFSTBuilder<PluginId> builder = new DFSTBuilder<PluginId>(graph);
        if (!builder.isAcyclic()) {
            String cyclePresentation;
            if (!StringUtil.isEmptyOrSpaces(errorMessage)) {
                errorMessage = errorMessage + "<br>";
            }
            if (ApplicationManager.getApplication().isInternal()) {
                final ArrayList<String> cycles = new ArrayList<String>();
                builder.getSCCs().forEach(new TIntProcedure(){
                    private int myTNumber = 0;

                    @Override
                    public boolean execute(int size) {
                        if (size > 1) {
                            String cycle2 = "";
                            for (int j = 0; j < size; ++j) {
                                cycle2 = cycle2 + ((PluginId)builder.getNodeByTNumber(this.myTNumber + j)).getIdString() + " ";
                            }
                            cycles.add(cycle2);
                        }
                        this.myTNumber += size;
                        return true;
                    }
                });
                cyclePresentation = ": " + StringUtil.join(cycles, ";");
            } else {
                Couple<PluginId> circularDependency = builder.getCircularDependency();
                PluginId id = (PluginId)circularDependency.getFirst();
                PluginId parentId = (PluginId)circularDependency.getSecond();
                cyclePresentation = id + "->" + parentId + "->...->" + id;
            }
            errorMessage = errorMessage + IdeBundle.message("error.plugins.should.not.have.cyclic.dependencies", new Object[0]) + cyclePresentation;
        }
        PluginManagerCore.prepareLoadingPluginsErrorMessage(errorMessage);
        final Comparator<PluginId> idComparator = builder.comparator();
        Collections.sort(result2, new Comparator<IdeaPluginDescriptor>(){

            @Override
            public int compare(@NotNull IdeaPluginDescriptor o1, @NotNull IdeaPluginDescriptor o2) {
                if (o1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/ide/plugins/PluginManagerCore$9", "compare"));
                }
                if (o2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/ide/plugins/PluginManagerCore$9", "compare"));
                }
                return idComparator.compare(o1.getPluginId(), o2.getPluginId());
            }
        });
        for (i = 0; i < result2.size(); ++i) {
            ourId2Index.put(((IdeaPluginDescriptorImpl)result2.get(i)).getPluginId(), i);
        }
        i = 0;
        for (IdeaPluginDescriptorImpl pluginDescriptor : result2) {
            if (pluginDescriptor.getPluginId().getIdString().equals("com.intellij") || pluginDescriptor.isUseCoreClassLoader()) {
                pluginDescriptor.setLoader(parentLoader);
            } else {
                ClassLoader[] classLoaderArray;
                List<File> classPath = pluginDescriptor.getClassPath();
                PluginId[] dependentPluginIds = pluginDescriptor.getDependentPluginIds();
                ClassLoader[] parentLoaders = PluginManagerCore.getParentLoaders(idToDescriptorMap, dependentPluginIds);
                if (parentLoaders.length > 0) {
                    classLoaderArray = parentLoaders;
                } else {
                    ClassLoader[] classLoaderArray2 = new ClassLoader[1];
                    classLoaderArray = classLoaderArray2;
                    classLoaderArray2[0] = parentLoader;
                }
                ClassLoader pluginClassLoader = PluginManagerCore.createPluginClassLoader(classPath.toArray(new File[classPath.size()]), classLoaderArray, pluginDescriptor);
                pluginDescriptor.setLoader(pluginClassLoader);
            }
            if (progress == null) continue;
            progress.showProgress("", 0.3f + (float)i++ / (float)result2.size() * 0.35f);
        }
        PluginManagerCore.registerExtensionPointsAndExtensions(Extensions.getRootArea(), result2);
        Extensions.getRootArea().getExtensionPoint(Extensions.AREA_LISTENER_EXTENSION_POINT).registerExtension(new AreaListener(){

            @Override
            public void areaCreated(@NotNull String areaClass, @NotNull AreaInstance areaInstance) {
                if (areaClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "areaClass", "com/intellij/ide/plugins/PluginManagerCore$10", "areaCreated"));
                }
                if (areaInstance == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "areaInstance", "com/intellij/ide/plugins/PluginManagerCore$10", "areaCreated"));
                }
                PluginManagerCore.registerExtensionPointsAndExtensions(Extensions.getArea(areaInstance), result2);
            }

            @Override
            public void areaDisposing(@NotNull String areaClass, @NotNull AreaInstance areaInstance) {
                if (areaClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "areaClass", "com/intellij/ide/plugins/PluginManagerCore$10", "areaDisposing"));
                }
                if (areaInstance == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "areaInstance", "com/intellij/ide/plugins/PluginManagerCore$10", "areaDisposing"));
                }
            }
        });
        ourPlugins = pluginDescriptors;
    }

    private static void registerExtensionPointsAndExtensions(@NotNull ExtensionsArea area, @NotNull List<IdeaPluginDescriptorImpl> loadedPlugins) {
        if (area == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "area", "com/intellij/ide/plugins/PluginManagerCore", "registerExtensionPointsAndExtensions"));
        }
        if (loadedPlugins == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loadedPlugins", "com/intellij/ide/plugins/PluginManagerCore", "registerExtensionPointsAndExtensions"));
        }
        for (IdeaPluginDescriptorImpl descriptor2 : loadedPlugins) {
            descriptor2.registerExtensionPoints(area);
        }
        ExtensionPoint[] extensionPoints = area.getExtensionPoints();
        THashSet<String> epNames = new THashSet<String>(extensionPoints.length);
        for (ExtensionPoint point : extensionPoints) {
            epNames.add(point.getName());
        }
        for (IdeaPluginDescriptorImpl descriptor3 : loadedPlugins) {
            for (String epName : epNames) {
                descriptor3.registerExtensions(area, epName);
            }
        }
    }

    public static void registerExtensionPointAndExtensions(@NotNull File pluginRoot, @NotNull String fileName, @NotNull ExtensionsArea area) {
        if (pluginRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginRoot", "com/intellij/ide/plugins/PluginManagerCore", "registerExtensionPointAndExtensions"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/ide/plugins/PluginManagerCore", "registerExtensionPointAndExtensions"));
        }
        if (area == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "area", "com/intellij/ide/plugins/PluginManagerCore", "registerExtensionPointAndExtensions"));
        }
        IdeaPluginDescriptorImpl descriptor2 = pluginRoot.isDirectory() ? PluginManagerCore.loadDescriptorFromDir(pluginRoot, fileName) : PluginManagerCore.loadDescriptorFromJar(pluginRoot, fileName);
        if (descriptor2 != null) {
            PluginManagerCore.registerExtensionPointsAndExtensions(area, Collections.singletonList(descriptor2));
        } else {
            PluginManagerCore.getLogger().error("Cannot load " + fileName + " from " + pluginRoot);
        }
    }

    public static void initPlugins(@Nullable StartupProgress progress) {
        long start = System.currentTimeMillis();
        try {
            PluginManagerCore.initializePlugins(progress);
        }
        catch (RuntimeException e) {
            PluginManagerCore.getLogger().error(e);
            throw e;
        }
        PluginManagerCore.getLogger().info(ourPlugins.length + " plugins initialized in " + (System.currentTimeMillis() - start) + " ms");
        PluginManagerCore.logPlugins();
        ClassUtilCore.clearJarURLCache();
    }

    static {
        myPlugins2Disable = null;
        myPlugins2Enable = null;
    }

    private static class IdeaLogProvider
    implements LogProvider {
        private IdeaLogProvider() {
        }

        @Override
        public void error(String message) {
            PluginManagerCore.getLogger().error(message);
        }

        @Override
        public void error(Throwable t) {
            PluginManagerCore.getLogger().error(t);
        }

        @Override
        public void warn(String message) {
            PluginManagerCore.getLogger().info(message);
        }
    }

    private static class LoggerHolder {
        private static final Logger ourLogger = Logger.getInstance("#com.intellij.ide.plugins.PluginManager");
    }
}

