/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.core.CoreApplicationEnvironment;
import com.intellij.core.CoreEncodingProjectManager;
import com.intellij.core.CoreProjectScopeBuilder;
import com.intellij.core.CorePsiDocumentManager;
import com.intellij.core.MockDocumentCommitProcessor;
import com.intellij.mock.MockDumbService;
import com.intellij.mock.MockFileIndexFacade;
import com.intellij.mock.MockProject;
import com.intellij.mock.MockResolveScopeManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.impl.PsiCachedValuesFactory;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.impl.file.PsiDirectoryFactoryImpl;
import com.intellij.psi.impl.file.impl.FileManagerImpl;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.ProjectScopeBuilder;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.CachedValuesManagerImpl;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.relocated.org.picocontainer.PicoContainer;

public class CoreProjectEnvironment {
    private final Disposable myParentDisposable;
    private final CoreApplicationEnvironment myEnvironment;
    protected final FileIndexFacade myFileIndexFacade;
    protected final PsiManagerImpl myPsiManager;
    protected final MockProject myProject;
    protected final MessageBus myMessageBus;

    public CoreProjectEnvironment(@NotNull Disposable parentDisposable, @NotNull CoreApplicationEnvironment applicationEnvironment) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/core/CoreProjectEnvironment", "<init>"));
        }
        if (applicationEnvironment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationEnvironment", "com/intellij/core/CoreProjectEnvironment", "<init>"));
        }
        this.myParentDisposable = parentDisposable;
        this.myEnvironment = applicationEnvironment;
        this.myProject = this.createProject(this.myEnvironment.getApplication().getPicoContainer(), this.myParentDisposable);
        this.preregisterServices();
        this.myFileIndexFacade = this.createFileIndexFacade();
        this.myMessageBus = MessageBusFactory.newMessageBus("CoreProjectEnvironment");
        PsiModificationTrackerImpl modificationTracker2 = new PsiModificationTrackerImpl(this.myProject);
        this.myProject.registerService(PsiModificationTracker.class, modificationTracker2);
        this.myProject.registerService(FileIndexFacade.class, this.myFileIndexFacade);
        this.myProject.registerService(ResolveCache.class, new ResolveCache(this.myMessageBus));
        this.myPsiManager = new PsiManagerImpl(this.myProject, null, null, this.myFileIndexFacade, this.myMessageBus, modificationTracker2);
        ((FileManagerImpl)this.myPsiManager.getFileManager()).markInitialized();
        this.registerProjectComponent(PsiManager.class, this.myPsiManager);
        this.myProject.registerService(SmartPointerManager.class, SmartPointerManagerImpl.class);
        this.registerProjectComponent(PsiDocumentManager.class, new CorePsiDocumentManager(this.myProject, this.myPsiManager, SmartPointerManager.getInstance(this.myProject), this.myMessageBus, new MockDocumentCommitProcessor()));
        this.myProject.registerService(ResolveScopeManager.class, this.createResolveScopeManager(this.myPsiManager));
        this.myProject.registerService(PsiFileFactory.class, new PsiFileFactoryImpl(this.myPsiManager));
        this.myProject.registerService(CachedValuesManager.class, new CachedValuesManagerImpl(this.myProject, new PsiCachedValuesFactory(this.myPsiManager)));
        this.myProject.registerService(PsiDirectoryFactory.class, new PsiDirectoryFactoryImpl(this.myPsiManager));
        this.myProject.registerService(ProjectScopeBuilder.class, this.createProjectScopeBuilder());
        this.myProject.registerService(DumbService.class, new MockDumbService(this.myProject));
        this.myProject.registerService(CoreEncodingProjectManager.class, CoreEncodingProjectManager.class);
    }

    @NotNull
    protected MockProject createProject(@NotNull PicoContainer parent, @NotNull Disposable parentDisposable) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/core/CoreProjectEnvironment", "createProject"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/core/CoreProjectEnvironment", "createProject"));
        }
        MockProject mockProject = new MockProject(parent, parentDisposable);
        if (mockProject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreProjectEnvironment", "createProject"));
        }
        return mockProject;
    }

    @NotNull
    protected ProjectScopeBuilder createProjectScopeBuilder() {
        CoreProjectScopeBuilder coreProjectScopeBuilder = new CoreProjectScopeBuilder(this.myProject, this.myFileIndexFacade);
        if (coreProjectScopeBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreProjectEnvironment", "createProjectScopeBuilder"));
        }
        return coreProjectScopeBuilder;
    }

    protected void preregisterServices() {
    }

    @NotNull
    protected FileIndexFacade createFileIndexFacade() {
        MockFileIndexFacade mockFileIndexFacade = new MockFileIndexFacade(this.myProject);
        if (mockFileIndexFacade == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreProjectEnvironment", "createFileIndexFacade"));
        }
        return mockFileIndexFacade;
    }

    @NotNull
    protected ResolveScopeManager createResolveScopeManager(@NotNull PsiManager psiManager) {
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "com/intellij/core/CoreProjectEnvironment", "createResolveScopeManager"));
        }
        MockResolveScopeManager mockResolveScopeManager = new MockResolveScopeManager(psiManager.getProject());
        if (mockResolveScopeManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreProjectEnvironment", "createResolveScopeManager"));
        }
        return mockResolveScopeManager;
    }

    public <T> void registerProjectExtensionPoint(@NotNull ExtensionPointName<T> extensionPointName, @NotNull Class<? extends T> aClass) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPointName", "com/intellij/core/CoreProjectEnvironment", "registerProjectExtensionPoint"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/core/CoreProjectEnvironment", "registerProjectExtensionPoint"));
        }
        CoreApplicationEnvironment.registerExtensionPoint(Extensions.getArea(this.myProject), extensionPointName, aClass);
    }

    public <T> void addProjectExtension(@NotNull ExtensionPointName<T> name, final @NotNull T extension2) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/core/CoreProjectEnvironment", "addProjectExtension"));
        }
        if (extension2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/core/CoreProjectEnvironment", "addProjectExtension"));
        }
        final ExtensionPoint<T> extensionPoint = Extensions.getArea(this.myProject).getExtensionPoint(name);
        extensionPoint.registerExtension(extension2);
        Disposer.register(this.myParentDisposable, new Disposable(){

            @Override
            public void dispose() {
                extensionPoint.unregisterExtension(extension2);
            }
        });
    }

    public <T> void registerProjectComponent(@NotNull Class<T> interfaceClass, @NotNull T implementation) {
        if (interfaceClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interfaceClass", "com/intellij/core/CoreProjectEnvironment", "registerProjectComponent"));
        }
        if (implementation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "implementation", "com/intellij/core/CoreProjectEnvironment", "registerProjectComponent"));
        }
        CoreApplicationEnvironment.registerComponentInstance(this.myProject.getPicoContainer(), interfaceClass, implementation);
    }

    @NotNull
    public Disposable getParentDisposable() {
        Disposable disposable = this.myParentDisposable;
        if (disposable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreProjectEnvironment", "getParentDisposable"));
        }
        return disposable;
    }

    @NotNull
    public CoreApplicationEnvironment getEnvironment() {
        CoreApplicationEnvironment coreApplicationEnvironment = this.myEnvironment;
        if (coreApplicationEnvironment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreProjectEnvironment", "getEnvironment"));
        }
        return coreApplicationEnvironment;
    }

    @NotNull
    public MockProject getProject() {
        MockProject mockProject = this.myProject;
        if (mockProject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreProjectEnvironment", "getProject"));
        }
        return mockProject;
    }
}

