/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.client;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.UnmarshalException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.FileTreeWalk;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KMutableProperty1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CompilerSystemProperties;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.daemon.client.BasicCompilerServicesWithResultsFacadeServer;
import org.jetbrains.kotlin.daemon.client.CompileServiceSession;
import org.jetbrains.kotlin.daemon.client.CompositeErrorReportingOutputListener;
import org.jetbrains.kotlin.daemon.client.DaemonGcAutoConfigurationProblemsListener;
import org.jetbrains.kotlin.daemon.client.DaemonLastOutputLinesListener;
import org.jetbrains.kotlin.daemon.client.DaemonProblemReportingOutputListener;
import org.jetbrains.kotlin.daemon.client.DaemonProblemReportingOutputListenerKt;
import org.jetbrains.kotlin.daemon.client.DaemonReportingTargets;
import org.jetbrains.kotlin.daemon.client.KotlinCompilerClient;
import org.jetbrains.kotlin.daemon.client.KotlinCompilerClientKt;
import org.jetbrains.kotlin.daemon.client.NativePlatformUtilKt;
import org.jetbrains.kotlin.daemon.common.BoolPropMapper;
import org.jetbrains.kotlin.daemon.common.ClientUtilsKt;
import org.jetbrains.kotlin.daemon.common.CompilationOptions;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.CompilerMode;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptions;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptionsMemoryComparator;
import org.jetbrains.kotlin.daemon.common.DaemonOptions;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.DaemonReportCategory;
import org.jetbrains.kotlin.daemon.common.DaemonWithMetadata;
import org.jetbrains.kotlin.daemon.common.DummyProfiler;
import org.jetbrains.kotlin.daemon.common.FileAgeComparator;
import org.jetbrains.kotlin.daemon.common.NetworkUtilsKt;
import org.jetbrains.kotlin.daemon.common.OptionsGroup;
import org.jetbrains.kotlin.daemon.common.Profiler;
import org.jetbrains.kotlin.daemon.common.PropMapper;
import org.jetbrains.kotlin.daemon.common.ReportCategory;
import org.jetbrains.kotlin.daemon.common.ReportSeverity;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003VWXB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0087\u0001\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\u000e\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u001e2\u0006\u0010\u001f\u001a\u00020 2\"\b\u0002\u0010!\u001a\u001c\u0012\u0004\u0012\u00020#\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0$\u0012\u0004\u0012\u00020%\u0018\u00010\"2\b\b\u0002\u0010&\u001a\u00020'2\b\b\u0002\u0010(\u001a\u00020)2\b\b\u0002\u0010*\u001a\u00020\u00042\b\b\u0002\u0010+\u001a\u00020,\u00a2\u0006\u0002\u0010-J\b\u0010.\u001a\u00020/H\u0002J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/H\u0002JL\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020#2\u0006\u00106\u001a\u0002072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u00108\u001a\u00020\n2\u0006\u00109\u001a\u00020\n2\n\b\u0002\u0010:\u001a\u0004\u0018\u00010#J<\u0010;\u001a\u0004\u0018\u0001H<\"\u0004\b\u0000\u0010<2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u00108\u001a\u00020\n2\u0014\u0010=\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u0001H<0>H\u0082\b\u00a2\u0006\u0002\u0010?J:\u0010@\u001a\u0004\u0018\u00010\u00192\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020#2\u0006\u00106\u001a\u0002072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u00108\u001a\u00020\nJ<\u0010@\u001a\u0004\u0018\u00010\u00192\u0006\u00103\u001a\u0002042\u0006\u00106\u001a\u0002072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u00108\u001a\u00020\n2\b\b\u0002\u0010A\u001a\u00020\nJ\u000e\u0010B\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010$J\u001c\u0010C\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0D2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\"\u0010E\u001a\b\u0012\u0004\u0012\u00020\b0$2\u0012\u0010F\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0DH\u0002J\u000e\u0010G\u001a\u00020#2\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010H\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010I\u001a\u0004\u0018\u00010\bJ!\u0010J\u001a\u00020%2\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u001e\"\u00020\bH\u0007\u00a2\u0006\u0002\u0010KJ\u0016\u0010L\u001a\u00020%2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0004J\u000e\u0010M\u001a\u00020%2\u0006\u00103\u001a\u000204J\u0016\u0010M\u001a\u00020%2\u0006\u00103\u001a\u0002042\u0006\u0010\u0012\u001a\u00020\u0013J8\u0010N\u001a\u00020\n2\u0006\u00103\u001a\u0002042\u0006\u00106\u001a\u0002072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0002JH\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020#2\u0006\u00103\u001a\u0002042\u0006\u00106\u001a\u0002072\f\u0010R\u001a\b\u0012\u0004\u0012\u00020#0S2\u0018\u0010T\u001a\u0014\u0012\u0004\u0012\u00020U\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020%0\"H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006Y"}, d2={"Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient;", "", "()V", "DAEMON_CONNECT_CYCLE_ATTEMPTS", "", "DAEMON_DEFAULT_STARTUP_TIMEOUT_MS", "", "JAVA_TOOL_OPTIONS_ENV_VARIABLE", "", "verboseReporting", "", "getVerboseReporting", "()Z", "checkDaemonStartedProperly", "daemon", "Ljava/lang/Process;", "reportingTargets", "Lorg/jetbrains/kotlin/daemon/client/DaemonReportingTargets;", "daemonOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonOptions;", "startupAttempt", "gcAutoConfiguration", "Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient$GcAutoConfiguration;", "compile", "compilerService", "Lorg/jetbrains/kotlin/daemon/common/CompileService;", "sessionId", "targetPlatform", "Lorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;", "args", "", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "outputsCollector", "Lkotlin/Function2;", "Ljava/io/File;", "", "", "compilerMode", "Lorg/jetbrains/kotlin/daemon/common/CompilerMode;", "reportSeverity", "Lorg/jetbrains/kotlin/daemon/common/ReportSeverity;", "port", "profiler", "Lorg/jetbrains/kotlin/daemon/common/Profiler;", "(Lorg/jetbrains/kotlin/daemon/common/CompileService;ILorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;[Ljava/lang/String;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Lkotlin/jvm/functions/Function2;Lorg/jetbrains/kotlin/daemon/common/CompilerMode;Lorg/jetbrains/kotlin/daemon/common/ReportSeverity;ILorg/jetbrains/kotlin/daemon/common/Profiler;)I", "configureClientOptions", "Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient$ClientOptions;", "opts", "connectAndLease", "Lorg/jetbrains/kotlin/daemon/client/CompileServiceSession;", "compilerId", "Lorg/jetbrains/kotlin/daemon/common/CompilerId;", "clientAliveFlagFile", "daemonJVMOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;", "autostart", "leaseSession", "sessionAliveFlagFile", "connectLoop", "R", "body", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/daemon/client/DaemonReportingTargets;ZLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "connectToCompileService", "checkId", "detectCompilerClasspath", "getEnvironmentVariablesForTests", "", "getImplicitJvmArguments", "environmentVariablesForTests", "getOrCreateClientFlagFile", "leaseCompileSession", "aliveFlagPath", "main", "([Ljava/lang/String;)V", "releaseCompileSession", "shutdownCompileService", "startDaemon", "tryFindSuitableDaemonOrNewOpts", "Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient$DaemonSearchResult;", "registryDir", "ignoredDaemonSessionFiles", "", "report", "Lorg/jetbrains/kotlin/daemon/common/DaemonReportCategory;", "ClientOptions", "DaemonSearchResult", "GcAutoConfiguration", "kotlin-daemon-client"})
@SourceDebugExtension(value={"SMAP\nKotlinCompilerClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinCompilerClient.kt\norg/jetbrains/kotlin/daemon/client/KotlinCompilerClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 PerfUtils.kt\norg/jetbrains/kotlin/daemon/common/PerfUtilsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,696:1\n382#1,21:698\n403#1,17:720\n1#2:697\n1#2:719\n1#2:759\n44#3,4:737\n37#4,2:741\n1557#5:743\n1628#5,3:744\n1611#5,9:747\n1863#5:756\n1864#5:760\n1620#5:761\n1797#5,3:762\n1557#5:765\n1628#5,3:766\n1187#5,2:769\n1261#5,4:771\n1368#5:775\n1454#5,5:776\n1755#5,3:781\n1368#5:784\n1454#5,5:785\n1368#5:790\n1454#5,5:791\n183#6,2:757\n*S KotlinDebug\n*F\n+ 1 KotlinCompilerClient.kt\norg/jetbrains/kotlin/daemon/client/KotlinCompilerClient\n*L\n114#1:698,21\n114#1:720,17\n114#1:719\n371#1:759\n206#1:737,4\n347#1:741,2\n369#1:743\n369#1:744,3\n371#1:747,9\n371#1:756\n371#1:760\n371#1:761\n456#1:762,3\n473#1:765\n473#1:766,3\n474#1:769,2\n474#1:771,4\n518#1:775\n518#1:776,5\n521#1:781,3\n538#1:784\n538#1:785,5\n539#1:790\n539#1:791,5\n373#1:757,2\n*E\n"})
public final class KotlinCompilerClient {
    @NotNull
    public static final KotlinCompilerClient INSTANCE = new KotlinCompilerClient();
    private static final long DAEMON_DEFAULT_STARTUP_TIMEOUT_MS = 10000L;
    private static final int DAEMON_CONNECT_CYCLE_ATTEMPTS = 4;
    private static final boolean verboseReporting = CompilerSystemProperties.COMPILE_DAEMON_VERBOSE_REPORT_PROPERTY.getValue() != null;
    @NotNull
    private static final String JAVA_TOOL_OPTIONS_ENV_VARIABLE = "JAVA_TOOL_OPTIONS";

    private KotlinCompilerClient() {
    }

    public final boolean getVerboseReporting() {
        return verboseReporting;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final File getOrCreateClientFlagFile(@NotNull DaemonOptions daemonOptions) {
        File file;
        Intrinsics.checkNotNullParameter((Object)daemonOptions, (String)"daemonOptions");
        String string = CompilerSystemProperties.COMPILE_DAEMON_CLIENT_ALIVE_PATH_PROPERTY.getValue();
        if (string != null) {
            String p0 = string;
            boolean bl = false;
            String string2 = DaemonParamsKt.trimQuotes(p0);
            if (string2 != null) {
                String string3;
                String string4;
                String p02 = string4 = string2;
                boolean bl2 = false;
                String string5 = string3 = !StringsKt.isBlank((CharSequence)p02) ? string4 : null;
                if (string3 != null) {
                    File file2;
                    File file3;
                    String p03 = string3;
                    boolean bl3 = false;
                    File p04 = file3 = new File(p03);
                    boolean bl4 = false;
                    File file4 = file2 = p04.exists() ? file3 : null;
                    if (file2 != null) {
                        file = file2;
                        return file;
                    }
                }
            }
        }
        file = ClientUtilsKt.makeAutodeletingFlagFile$default(null, new File(DaemonParamsKt.getRunFilesPathOrDefault(daemonOptions)), 1, null);
        return file;
    }

    @Nullable
    public final CompileService connectToCompileService(@NotNull CompilerId compilerId, @NotNull DaemonJVMOptions daemonJVMOptions, @NotNull DaemonOptions daemonOptions, @NotNull DaemonReportingTargets reportingTargets, boolean autostart, boolean checkId) {
        Intrinsics.checkNotNullParameter((Object)compilerId, (String)"compilerId");
        Intrinsics.checkNotNullParameter((Object)daemonJVMOptions, (String)"daemonJVMOptions");
        Intrinsics.checkNotNullParameter((Object)daemonOptions, (String)"daemonOptions");
        Intrinsics.checkNotNullParameter((Object)reportingTargets, (String)"reportingTargets");
        File flagFile = this.getOrCreateClientFlagFile(daemonOptions);
        return this.connectToCompileService(compilerId, flagFile, daemonJVMOptions, daemonOptions, reportingTargets, autostart);
    }

    public static /* synthetic */ CompileService connectToCompileService$default(KotlinCompilerClient kotlinCompilerClient, CompilerId compilerId, DaemonJVMOptions daemonJVMOptions, DaemonOptions daemonOptions, DaemonReportingTargets daemonReportingTargets, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            bl2 = true;
        }
        return kotlinCompilerClient.connectToCompileService(compilerId, daemonJVMOptions, daemonOptions, daemonReportingTargets, bl, bl2);
    }

    @Nullable
    public final CompileService connectToCompileService(@NotNull CompilerId compilerId, @NotNull File clientAliveFlagFile, @NotNull DaemonJVMOptions daemonJVMOptions, @NotNull DaemonOptions daemonOptions, @NotNull DaemonReportingTargets reportingTargets, boolean autostart) {
        Intrinsics.checkNotNullParameter((Object)compilerId, (String)"compilerId");
        Intrinsics.checkNotNullParameter((Object)clientAliveFlagFile, (String)"clientAliveFlagFile");
        Intrinsics.checkNotNullParameter((Object)daemonJVMOptions, (String)"daemonJVMOptions");
        Intrinsics.checkNotNullParameter((Object)daemonOptions, (String)"daemonOptions");
        Intrinsics.checkNotNullParameter((Object)reportingTargets, (String)"reportingTargets");
        CompileServiceSession compileServiceSession = this.connectAndLease(compilerId, clientAliveFlagFile, daemonJVMOptions, daemonOptions, reportingTargets, autostart, false, null);
        return compileServiceSession != null ? compileServiceSession.getCompileService() : null;
    }

    public static /* synthetic */ CompileService connectToCompileService$default(KotlinCompilerClient kotlinCompilerClient, CompilerId compilerId, File file, DaemonJVMOptions daemonJVMOptions, DaemonOptions daemonOptions, DaemonReportingTargets daemonReportingTargets, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = true;
        }
        return kotlinCompilerClient.connectToCompileService(compilerId, file, daemonJVMOptions, daemonOptions, daemonReportingTargets, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final CompileServiceSession connectAndLease(@NotNull CompilerId compilerId, @NotNull File clientAliveFlagFile, @NotNull DaemonJVMOptions daemonJVMOptions, @NotNull DaemonOptions daemonOptions, @NotNull DaemonReportingTargets reportingTargets, boolean autostart, boolean leaseSession, @Nullable File sessionAliveFlagFile) {
        Intrinsics.checkNotNullParameter((Object)compilerId, (String)"compilerId");
        Intrinsics.checkNotNullParameter((Object)clientAliveFlagFile, (String)"clientAliveFlagFile");
        Intrinsics.checkNotNullParameter((Object)daemonJVMOptions, (String)"daemonJVMOptions");
        Intrinsics.checkNotNullParameter((Object)daemonOptions, (String)"daemonOptions");
        Intrinsics.checkNotNullParameter((Object)reportingTargets, (String)"reportingTargets");
        Set ignoredDaemonSessionFiles = new LinkedHashSet();
        int daemonStartupAttemptsCount = 0;
        GcAutoConfiguration gcAutoConfiguration = new GcAutoConfiguration(false, null, 3, null);
        KotlinCompilerClient this_$iv = this;
        boolean $i$f$connectLoop = false;
        KotlinCompilerClient kotlinCompilerClient = this_$iv;
        synchronized (kotlinCompilerClient) {
            Object object;
            boolean bl = false;
            try {
                int attempts$iv = 1;
                do {
                    Object errorDetails$iv;
                    block22: {
                        Object object2;
                        block21: {
                            Pair pair;
                            try {
                                CompileServiceSession compileServiceSession;
                                DaemonSearchResult result2;
                                boolean isLastAttempt = attempts$iv >= 4;
                                boolean bl2 = false;
                                NetworkUtilsKt.ensureServerHostnameIsSetUp();
                                DaemonSearchResult daemonSearchResult = result2 = INSTANCE.tryFindSuitableDaemonOrNewOpts(new File(daemonOptions.getRunFilesPath()), compilerId, daemonJVMOptions, ignoredDaemonSessionFiles, (Function2<? super DaemonReportCategory, ? super String, Unit>)((Function2)new Function2<DaemonReportCategory, String, Unit>(reportingTargets){
                                    final /* synthetic */ DaemonReportingTargets $reportingTargets;
                                    {
                                        this.$reportingTargets = $reportingTargets;
                                        super(2);
                                    }

                                    public final void invoke(DaemonReportCategory cat, String msg) {
                                        Intrinsics.checkNotNullParameter((Object)((Object)cat), (String)"cat");
                                        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
                                        KotlinCompilerClientKt.report$default(this.$reportingTargets, cat, msg, null, 4, null);
                                    }
                                }));
                                if (daemonSearchResult instanceof DaemonSearchResult.Found) {
                                    CompileServiceSession compileServiceSession2;
                                    CompileServiceSession it = compileServiceSession2 = KotlinCompilerClient.connectAndLease$lambda$4$tryToLeaseSession(((DaemonSearchResult.Found)result2).getCompileService(), clientAliveFlagFile, reportingTargets, leaseSession, sessionAliveFlagFile);
                                    boolean bl3 = false;
                                    if (it == null) {
                                        ignoredDaemonSessionFiles.add(((DaemonSearchResult.Found)result2).getRunFileMarker());
                                    }
                                    compileServiceSession = compileServiceSession2;
                                } else {
                                    if (!(daemonSearchResult instanceof DaemonSearchResult.NotFound)) throw new NoWhenBranchMatchedException();
                                    if (!isLastAttempt && autostart) {
                                        KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.DEBUG, "trying to start a new compiler daemon", null, 4, null);
                                        int n = daemonStartupAttemptsCount;
                                        daemonStartupAttemptsCount = n + 1;
                                        if (INSTANCE.startDaemon(compilerId, ((DaemonSearchResult.NotFound)result2).getRequiredJvmOptions(), daemonOptions, reportingTargets, n, gcAutoConfiguration)) {
                                            KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.DEBUG, "new compiler daemon started, trying to find it", null, 4, null);
                                        }
                                    }
                                    compileServiceSession = null;
                                }
                                pair = TuplesKt.to(compileServiceSession, null);
                            }
                            catch (SocketException e$iv) {
                                pair = TuplesKt.to(null, (Object)e$iv);
                            }
                            catch (ConnectException e$iv) {
                                pair = TuplesKt.to(null, (Object)e$iv);
                            }
                            catch (ConnectIOException e$iv) {
                                pair = TuplesKt.to(null, (Object)e$iv);
                            }
                            catch (UnmarshalException e$iv) {
                                pair = TuplesKt.to(null, (Object)e$iv);
                            }
                            catch (RuntimeException e$iv) {
                                pair = TuplesKt.to(null, (Object)e$iv);
                            }
                            Pair pair2 = pair;
                            Object res$iv = pair2.component1();
                            Exception err$iv = (Exception)pair2.component2();
                            Object object3 = res$iv;
                            if (object3 != null) {
                                Object object4 = object3;
                                // MONITOREXIT @DISABLED, blocks:[1, 3, 10, 13] lbl65 : MonitorExitStatement: MONITOREXIT : var14_14
                                object = object4;
                                return (CompileServiceSession)object;
                            }
                            object2 = err$iv;
                            if (object2 == null) break block21;
                            Exception it$iv = object2;
                            boolean bl4 = false;
                            String string = ", error: " + ExceptionsKt.stackTraceToString((Throwable)it$iv);
                            object2 = string;
                            if (string != null) break block22;
                        }
                        object2 = errorDetails$iv = "";
                    }
                    if (attempts$iv >= 4 || !autostart) {
                        KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.EXCEPTION, "Failed connecting to the daemon in " + attempts$iv + " retries" + (String)errorDetails$iv, null, 4, null);
                        continue;
                    }
                    KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.INFO, "" + '#' + attempts$iv + " retrying connecting to the daemon " + (String)errorDetails$iv, null, 4, null);
                } while (++attempts$iv <= 4 && autostart);
                Object var31_38 = null;
                // MONITOREXIT @DISABLED, blocks:[1, 3] lbl83 : MonitorExitStatement: MONITOREXIT : var14_14
                object = var31_38;
                return (CompileServiceSession)object;
            }
            catch (Throwable e$iv) {
                KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.EXCEPTION, e$iv.toString(), null, 4, null);
                Object object5 = null;
                // MONITOREXIT @DISABLED, blocks:[3, 9] lbl89 : MonitorExitStatement: MONITOREXIT : var14_14
                object = object5;
                return (CompileServiceSession)object;
            }
        }
    }

    public static /* synthetic */ CompileServiceSession connectAndLease$default(KotlinCompilerClient kotlinCompilerClient, CompilerId compilerId, File file, DaemonJVMOptions daemonJVMOptions, DaemonOptions daemonOptions, DaemonReportingTargets daemonReportingTargets, boolean bl, boolean bl2, File file2, int n, Object object) {
        if ((n & 0x80) != 0) {
            file2 = null;
        }
        return kotlinCompilerClient.connectAndLease(compilerId, file, daemonJVMOptions, daemonOptions, daemonReportingTargets, bl, bl2, file2);
    }

    public final void shutdownCompileService(@NotNull CompilerId compilerId, @NotNull DaemonOptions daemonOptions) {
        Intrinsics.checkNotNullParameter((Object)compilerId, (String)"compilerId");
        Intrinsics.checkNotNullParameter((Object)daemonOptions, (String)"daemonOptions");
        CompileService compileService = this.connectToCompileService(compilerId, new DaemonJVMOptions(null, null, null, null, 15, null), daemonOptions, new DaemonReportingTargets(System.out, null, null, null, 14, null), false, false);
        if (compileService != null) {
            compileService.shutdown();
        }
    }

    public final void shutdownCompileService(@NotNull CompilerId compilerId) {
        Intrinsics.checkNotNullParameter((Object)compilerId, (String)"compilerId");
        this.shutdownCompileService(compilerId, new DaemonOptions(null, 0L, 0, 0, 0L, 0L, false, false, 255, null));
    }

    public final int leaseCompileSession(@NotNull CompileService compilerService, @Nullable String aliveFlagPath) {
        Intrinsics.checkNotNullParameter((Object)compilerService, (String)"compilerService");
        return ((Number)compilerService.leaseCompileSession(aliveFlagPath).get()).intValue();
    }

    public final void releaseCompileSession(@NotNull CompileService compilerService, int sessionId) {
        Intrinsics.checkNotNullParameter((Object)compilerService, (String)"compilerService");
        compilerService.releaseCompileSession(sessionId);
    }

    public final int compile(@NotNull CompileService compilerService, int sessionId, @NotNull CompileService.TargetPlatform targetPlatform, @NotNull String[] args, @NotNull MessageCollector messageCollector2, @Nullable Function2<? super File, ? super List<? extends File>, Unit> outputsCollector2, @NotNull CompilerMode compilerMode, @NotNull ReportSeverity reportSeverity, int port, @NotNull Profiler profiler) {
        Intrinsics.checkNotNullParameter((Object)compilerService, (String)"compilerService");
        Intrinsics.checkNotNullParameter((Object)targetPlatform, (String)"targetPlatform");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)messageCollector2, (String)"messageCollector");
        Intrinsics.checkNotNullParameter((Object)compilerMode, (String)"compilerMode");
        Intrinsics.checkNotNullParameter((Object)((Object)reportSeverity), (String)"reportSeverity");
        Intrinsics.checkNotNullParameter((Object)profiler, (String)"profiler");
        Profiler $this$withMeasure$iv = profiler;
        boolean $i$f$withMeasure = false;
        List<Long> startState$iv = $this$withMeasure$iv.beginMeasure(this);
        boolean bl = false;
        BasicCompilerServicesWithResultsFacadeServer services = new BasicCompilerServicesWithResultsFacadeServer(messageCollector2, outputsCollector2, port);
        Integer[] integerArray = new Integer[]{ReportCategory.COMPILER_MESSAGE.getCode(), ReportCategory.DAEMON_MESSAGE.getCode(), ReportCategory.EXCEPTION.getCode(), ReportCategory.OUTPUT_MESSAGE.getCode()};
        int res$iv = ((Number)compilerService.compile(sessionId, args, new CompilationOptions(compilerMode, targetPlatform, integerArray, reportSeverity.getCode(), new Integer[0], null, 32, null), services, null).get()).intValue();
        $this$withMeasure$iv.endMeasure(this, startState$iv);
        return res$iv;
    }

    public static /* synthetic */ int compile$default(KotlinCompilerClient kotlinCompilerClient, CompileService compileService, int n, CompileService.TargetPlatform targetPlatform, String[] stringArray, MessageCollector messageCollector2, Function2 function2, CompilerMode compilerMode, ReportSeverity reportSeverity, int n2, Profiler profiler, int n3, Object object) {
        if ((n3 & 0x20) != 0) {
            function2 = null;
        }
        if ((n3 & 0x40) != 0) {
            compilerMode = CompilerMode.NON_INCREMENTAL_COMPILER;
        }
        if ((n3 & 0x80) != 0) {
            reportSeverity = ReportSeverity.INFO;
        }
        if ((n3 & 0x100) != 0) {
            n2 = 0;
        }
        if ((n3 & 0x200) != 0) {
            profiler = new DummyProfiler();
        }
        return kotlinCompilerClient.compile(compileService, n, targetPlatform, stringArray, messageCollector2, (Function2<? super File, ? super List<? extends File>, Unit>)function2, compilerMode, reportSeverity, n2, profiler);
    }

    private final ClientOptions configureClientOptions(ClientOptions opts) {
        String string = CompilerSystemProperties.COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY.getValue();
        if (string != null) {
            String it = string;
            boolean bl = false;
            String[] stringArray = new String[]{","};
            Iterable unrecognized = DaemonParamsKt.filterExtractProps$default(StringsKt.split$default((CharSequence)DaemonParamsKt.trimQuotes(it), (String[])stringArray, (boolean)false, (int)0, (int)6, null), opts.getMappers(), "", null, 4, null);
            if (CollectionsKt.any((Iterable)unrecognized)) {
                throw new IllegalArgumentException("Unrecognized client options passed via property " + CompilerSystemProperties.COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY.getProperty() + ": " + CollectionsKt.joinToString$default((Iterable)unrecognized, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "\nSupported options: " + CollectionsKt.joinToString$default((Iterable)opts.getMappers(), (CharSequence)", ", null, null, (int)0, null, (Function1)configureClientOptions.1.1.INSTANCE, (int)30, null));
            }
        }
        return opts;
    }

    private final ClientOptions configureClientOptions() {
        return this.configureClientOptions(new ClientOptions(false, 1, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final void main(String ... args) {
        CompileService compileService;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        CompilerId compilerId = new CompilerId(null, null, 3, null);
        DaemonOptions daemonOptions = DaemonParamsKt.configureDaemonOptions();
        DaemonJVMOptions daemonLaunchingOptions = DaemonParamsKt.configureDaemonJVMOptions(new String[0], true, false, true);
        ClientOptions clientOptions = INSTANCE.configureClientOptions();
        OptionsGroup[] optionsGroupArray = new OptionsGroup[]{compilerId, daemonOptions, daemonLaunchingOptions, clientOptions};
        Iterable<String> filteredArgs = DaemonParamsKt.filterExtractProps(ArraysKt.asIterable((Object[])args), optionsGroupArray, "--daemon-");
        if (!clientOptions.getStop()) {
            if (CollectionsKt.none((Iterable)compilerId.getCompilerClasspath())) {
                System.err.println("compiler wasn't explicitly specified, attempt to find appropriate jar");
                List<String> list = INSTANCE.detectCompilerClasspath();
                if (list != null) {
                    List<String> list2 = list;
                    boolean bl = false;
                    compilerId.setCompilerClasspath(list2);
                }
            }
            if (CollectionsKt.none((Iterable)compilerId.getCompilerClasspath())) {
                throw new IllegalArgumentException("Cannot find compiler jar");
            }
            StringBuilder stringBuilder = new StringBuilder().append("desired compiler classpath: ");
            Iterable iterable = compilerId.getCompilerClasspath();
            String string = File.pathSeparator;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathSeparator");
            System.out.println((Object)stringBuilder.append(CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null)).toString());
        }
        if ((compileService = INSTANCE.connectToCompileService(compilerId, daemonLaunchingOptions, daemonOptions, new DaemonReportingTargets(System.out, null, null, null, 14, null), !clientOptions.getStop(), !clientOptions.getStop())) == null) {
            if (!clientOptions.getStop()) throw new Exception("Unable to connect to daemon");
            System.err.println("No daemon found to shut down");
            return;
        }
        if (clientOptions.getStop()) {
            System.out.println((Object)"Shutdown the daemon");
            compileService.shutdown();
            System.out.println((Object)"Daemon shut down successfully");
            return;
        }
        if (CollectionsKt.none(filteredArgs)) {
            String string = "Warning: empty arguments list, only daemon check is performed: checkCompilerId() returns " + compileService.checkCompilerId(compilerId);
            System.out.println((Object)string);
            return;
        }
        System.out.println((Object)("Executing daemon compilation with args: " + CollectionsKt.joinToString$default(filteredArgs, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)));
        MessageCollector messageCollector2 = new MessageCollector(){
            private boolean hasErrors;

            public final boolean getHasErrors() {
                return this.hasErrors;
            }

            public final void setHasErrors(boolean bl) {
                this.hasErrors = bl;
            }

            public void clear() {
            }

            public void report(CompilerMessageSeverity severity, String message, CompilerMessageSourceLocation location) {
                Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                if (severity.isError()) {
                    this.hasErrors = true;
                }
                StringBuilder stringBuilder = new StringBuilder().append(severity.name()).append('\t');
                Object object = location;
                if (object == null || (object = object.getPath()) == null) {
                    object = "";
                }
                CompilerMessageSourceLocation compilerMessageSourceLocation = location;
                System.out.println((Object)stringBuilder.append((String)object).append(':').append(compilerMessageSourceLocation != null ? Integer.valueOf(compilerMessageSourceLocation.getLine()) : "").append(" \t").append(message).toString());
            }

            public boolean hasErrors() {
                return this.hasErrors;
            }
        };
        Function2 function2 = main.outputsCollector.1.INSTANCE;
        BasicCompilerServicesWithResultsFacadeServer servicesFacade = new BasicCompilerServicesWithResultsFacadeServer(messageCollector2, function2, 0, 4, null);
        try {
            long memBefore = ((Number)CompileService.getUsedMemory$default(compileService, false, 1, null).get()).longValue() / (long)1024;
            long startTime = System.nanoTime();
            Integer[] integerArray = new Integer[]{ReportCategory.COMPILER_MESSAGE.getCode(), ReportCategory.DAEMON_MESSAGE.getCode(), ReportCategory.EXCEPTION.getCode(), ReportCategory.OUTPUT_MESSAGE.getCode()};
            CompilationOptions compilationOptions = new CompilationOptions(CompilerMode.NON_INCREMENTAL_COMPILER, CompileService.TargetPlatform.JVM, integerArray, ReportSeverity.INFO.getCode(), new Integer[0], null, 32, null);
            Collection $this$toTypedArray$iv = CollectionsKt.toList(filteredArgs);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            CompileService.CallResult<Integer> res = compileService.compile(0, thisCollection$iv.toArray(new String[0]), compilationOptions, servicesFacade, null);
            long endTime = System.nanoTime();
            System.out.println((Object)("Compilation " + (res.isGood() ? "succeeded" : "failed") + ", result code: " + ((Number)res.get()).intValue()));
            long memAfter = ((Number)CompileService.getUsedMemory$default(compileService, false, 1, null).get()).longValue() / (long)1024;
            System.out.println((Object)("Compilation time: " + TimeUnit.NANOSECONDS.toMillis(endTime - startTime) + " ms"));
            StringBuilder stringBuilder = new StringBuilder().append("Used memory ").append(memAfter).append(" (");
            String string = "%+d";
            Object[] objectArray = new Object[]{memAfter - memBefore};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            System.out.println((Object)stringBuilder.append(string2).append(" kb)").toString());
            return;
        }
        finally {
            UnicastRemoteObject.unexportObject(servicesFacade, true);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final List<String> detectCompilerClasspath() {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Iterable $this$mapTo$iv$iv;
        void $this$map$iv;
        String string = CompilerSystemProperties.JAVA_CLASS_PATH.getValue();
        if (string == null) return null;
        CharSequence charSequence = string;
        String[] stringArray = new String[1];
        Intrinsics.checkNotNullExpressionValue((Object)File.pathSeparator, (String)"pathSeparator");
        List list = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (list == null) return null;
        Iterable iterable = list;
        boolean $i$f$map = false;
        File file = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new File((String)it).getParentFile());
        }
        iterable = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        if (iterable == null) return null;
        $this$mapTo$iv$iv = iterable;
        boolean $i$f$mapNotNull = false;
        void $i$f$mapTo22 = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            File file2;
            FileTreeWalk fileTreeWalk;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            File it = (File)element$iv$iv;
            boolean bl2 = false;
            if (it != null && (fileTreeWalk = FilesKt.walk$default((File)it, null, (int)1, null)) != null) {
                Object v1;
                block5: {
                    void $this$firstOrNull$iv;
                    Sequence sequence = (Sequence)fileTreeWalk;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        File it2 = (File)element$iv;
                        boolean bl3 = false;
                        if (!StringsKt.equals((String)it2.getName(), (String)"kotlin-compiler.jar", (boolean)true)) continue;
                        v1 = element$iv;
                        break block5;
                    }
                    v1 = null;
                }
                file2 = v1;
            } else {
                file2 = null;
            }
            if (file2 == null) continue;
            File it$iv$iv = file2;
            boolean bl4 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        file = (File)CollectionsKt.firstOrNull((List)((List)destination$iv$iv2));
        if (file == null) return null;
        File it = file;
        boolean bl = false;
        List list2 = CollectionsKt.listOf((Object)it.getAbsolutePath());
        return list2;
    }

    /*
     * Exception decompiling
     */
    private final <R> R connectLoop(DaemonReportingTargets reportingTargets, boolean autostart, Function1<? super Boolean, ? extends R> body) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 0[TRYBLOCK]], but top level block is 13[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final DaemonSearchResult tryFindSuitableDaemonOrNewOpts(File registryDir, CompilerId compilerId, DaemonJVMOptions daemonJVMOptions, Set<? extends File> ignoredDaemonSessionFiles, Function2<? super DaemonReportCategory, ? super String, Unit> report2) {
        DaemonSearchResult daemonSearchResult;
        List list;
        registryDir.mkdirs();
        File timestampMarker = Files.createTempFile(registryDir.toPath(), "kotlin-daemon-client-tsmarker", null, new FileAttribute[0]).toFile();
        try {
            Intrinsics.checkNotNullExpressionValue((Object)timestampMarker, (String)"timestampMarker");
            list = SequencesKt.toList(ClientUtilsKt.walkDaemons(registryDir, compilerId, timestampMarker, (Function2<? super File, ? super Integer, Boolean>)((Function2)new Function2<File, Integer, Boolean>(ignoredDaemonSessionFiles){
                final /* synthetic */ Set<File> $ignoredDaemonSessionFiles;
                {
                    this.$ignoredDaemonSessionFiles = $ignoredDaemonSessionFiles;
                    super(2);
                }

                public final Boolean invoke(File file, int n) {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    return !this.$ignoredDaemonSessionFiles.contains(file);
                }
            }), report2));
        }
        finally {
            timestampMarker.delete();
        }
        List aliveWithMetadata2 = list;
        Comparator comparator = new DaemonJVMOptionsMemoryComparator();
        comparator = new Comparator(comparator){
            final /* synthetic */ Comparator $comparator;
            {
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                DaemonWithMetadata daemonWithMetadata = (DaemonWithMetadata)a;
                Comparator comparator = this.$comparator;
                boolean bl = false;
                DaemonWithMetadata it = (DaemonWithMetadata)b;
                DaemonJVMOptions daemonJVMOptions = it.getJvmOptions();
                bl = false;
                DaemonJVMOptions daemonJVMOptions2 = it.getJvmOptions();
                return comparator.compare(daemonJVMOptions, daemonJVMOptions2);
            }
        };
        Comparator comparator2 = new FileAgeComparator();
        Comparator comparator3 = new Comparator(comparator, comparator2){
            final /* synthetic */ Comparator $this_thenBy;
            final /* synthetic */ Comparator $comparator;
            {
                this.$this_thenBy = $receiver;
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    DaemonWithMetadata daemonWithMetadata = (DaemonWithMetadata)a;
                    Comparator comparator = this.$comparator;
                    boolean bl = false;
                    DaemonWithMetadata it = (DaemonWithMetadata)b;
                    File file = it.getRunFile();
                    bl = false;
                    File file2 = it.getRunFile();
                    n = comparator.compare(file, file2);
                }
                return n;
            }
        };
        DaemonJVMOptions optsCopy = DaemonJVMOptions.copy$default(daemonJVMOptions, null, null, null, null, 15, null);
        DaemonWithMetadata daemonWithMetadata = (DaemonWithMetadata)CollectionsKt.maxWithOrNull((Iterable)aliveWithMetadata2, (Comparator)comparator3);
        if (daemonWithMetadata != null) {
            DaemonWithMetadata daemonWithMetadata2;
            DaemonWithMetadata it = daemonWithMetadata2 = daemonWithMetadata;
            boolean bl = false;
            daemonWithMetadata = DaemonParamsKt.memorywiseFitsInto(daemonJVMOptions, it.getJvmOptions()) ? daemonWithMetadata2 : null;
            if (daemonWithMetadata != null) {
                DaemonWithMetadata it2 = daemonWithMetadata;
                boolean bl2 = false;
                daemonSearchResult = new DaemonSearchResult.Found(it2.getDaemon(), it2.getRunFile());
                return daemonSearchResult;
            }
        }
        Iterable $this$fold$iv = aliveWithMetadata2;
        boolean $i$f$fold = false;
        DaemonJVMOptions accumulator$iv = optsCopy;
        Iterator iterator = $this$fold$iv.iterator();
        while (true) {
            void d;
            if (!iterator.hasNext()) {
                DaemonJVMOptions daemonJVMOptions2 = accumulator$iv;
                daemonSearchResult = new DaemonSearchResult.NotFound(daemonJVMOptions2);
                return daemonSearchResult;
            }
            Object element$iv = iterator.next();
            DaemonWithMetadata daemonWithMetadata3 = (DaemonWithMetadata)element$iv;
            DaemonJVMOptions opts = accumulator$iv;
            boolean bl = false;
            accumulator$iv = DaemonParamsKt.updateMemoryUpperBounds(opts, d.getJvmOptions());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> getEnvironmentVariablesForTests(DaemonReportingTargets reportingTargets) {
        Object object;
        String string = CompilerSystemProperties.COMPILE_DAEMON_ENVIRONMENT_VARIABLES_FOR_TESTS.getValue();
        if (string == null) {
            return MapsKt.emptyMap();
        }
        String systemPropertyValue = string;
        Object object2 = this;
        try {
            void $this$associateTo$iv$iv;
            void $this$associate$iv;
            String[] stringArray;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            KotlinCompilerClient $this$getEnvironmentVariablesForTests_u24lambda_u2421 = object2;
            boolean bl = false;
            KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.EXCEPTION, CompilerSystemProperties.COMPILE_DAEMON_ENVIRONMENT_VARIABLES_FOR_TESTS.getProperty() + " should be used only for testing!", null, 4, null);
            Object object3 = new String[]{";"};
            object3 = StringsKt.split$default((CharSequence)systemPropertyValue, (String[])object3, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            void var8_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                stringArray = new String[]{"="};
                collection.add(StringsKt.split$default((CharSequence)((CharSequence)it), (String[])stringArray, (boolean)false, (int)0, (int)6, null));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv2;
                List it = (List)element$iv$iv;
                boolean bl3 = false;
                stringArray = TuplesKt.to(it.get(0), it.get(1));
                map.put(stringArray.getFirst(), stringArray.getSecond());
            }
            object = Result.constructor-impl((Object)destination$iv$iv2);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        Map map = (Map)(Result.isFailure-impl((Object)object2) ? null : object2);
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    private final List<String> getImplicitJvmArguments(Map<String, String> environmentVariablesForTests) {
        String[] stringArray;
        String[] stringArray2 = environmentVariablesForTests.get(JAVA_TOOL_OPTIONS_ENV_VARIABLE);
        if (stringArray2 == null) {
            stringArray2 = System.getenv(JAVA_TOOL_OPTIONS_ENV_VARIABLE);
        }
        if ((stringArray = stringArray2) == null) {
            return CollectionsKt.emptyList();
        }
        String[] javaToolOptions = stringArray;
        stringArray = new String[]{" "};
        return StringsKt.split$default((CharSequence)((CharSequence)javaToolOptions), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean startDaemon(CompilerId compilerId, DaemonJVMOptions daemonJVMOptions, DaemonOptions daemonOptions, DaemonReportingTargets reportingTargets, int startupAttempt, GcAutoConfiguration gcAutoConfiguration) {
        Iterable list$iv$iv;
        PropMapper it;
        Object $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        boolean bl;
        List jvmArguments;
        Object $this$flatMapTo$iv$iv2;
        Map<String, String> environmentVariablesForTests;
        List javaIllegalAccessWorkaround;
        List platformSpecificOptions;
        File javaExecutable;
        block10: {
            void $this$any$iv;
            List list;
            Integer javaVersion;
            javaExecutable = new File(new File(CompilerSystemProperties.JAVA_HOME.getSafeValue(), "bin"), "java");
            String string = CompilerSystemProperties.JAVA_RMI_SERVER_HOSTNAME.getValue();
            if (string == null) {
                throw new IllegalStateException((CompilerSystemProperties.JAVA_RMI_SERVER_HOSTNAME.getProperty() + " is not set!").toString());
            }
            String serverHostname = string;
            Object[] objectArray = new String[]{"-Djava.awt.headless=true", "-D" + CompilerSystemProperties.JAVA_RMI_SERVER_HOSTNAME.getProperty() + '=' + serverHostname};
            platformSpecificOptions = CollectionsKt.listOf((Object[])objectArray);
            String string2 = CompilerSystemProperties.JAVA_VERSION.getValue();
            Integer n = javaVersion = string2 != null ? StringsKt.toIntOrNull((String)string2) : null;
            if (javaVersion != null && javaVersion >= 16) {
                Object[] objectArray2 = new String[]{"--add-exports", "java.base/sun.nio.ch=ALL-UNNAMED"};
                list = CollectionsKt.listOf((Object[])objectArray2);
            } else {
                list = CollectionsKt.emptyList();
            }
            javaIllegalAccessWorkaround = list;
            environmentVariablesForTests = this.getEnvironmentVariablesForTests(reportingTargets);
            Iterable $this$flatMap$iv2 = daemonJVMOptions.getMappers();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object t : $this$flatMapTo$iv$iv2) {
                PropMapper it2 = (PropMapper)t;
                boolean bl2 = false;
                Iterable list$iv$iv2 = it2.toArgs("-");
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv2);
            }
            jvmArguments = (List)destination$iv$iv;
            $this$flatMap$iv2 = CollectionsKt.plus((Collection)jvmArguments, (Iterable)this.getImplicitJvmArguments(environmentVariablesForTests));
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it3 = (String)element$iv;
                    boolean bl3 = false;
                    if (!(Intrinsics.areEqual((Object)it3, (Object)("-XX:-Use" + gcAutoConfiguration.getPreferredGc() + "GC")) || StringsKt.startsWith$default((String)it3, (String)"-XX:+Use", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)it3, (String)"GC", (boolean)false, (int)2, null))) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        if (bl) {
            gcAutoConfiguration.setShouldAutoConfigureGc(false);
        }
        Object[] $i$f$any = new String[]{"-XX:+UseCodeCacheFlushing", gcAutoConfiguration.getShouldAutoConfigureGc() ? "-XX:+Use" + gcAutoConfiguration.getPreferredGc() + "GC" : null};
        List additionalOptimizationOptions = CollectionsKt.listOfNotNull((Object[])$i$f$any);
        $this$flatMapTo$iv$iv2 = new String[3];
        $this$flatMapTo$iv$iv2[0] = javaExecutable.getAbsolutePath();
        $this$flatMapTo$iv$iv2[1] = "-cp";
        Iterable iterable = compilerId.getCompilerClasspath();
        String string = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathSeparator");
        $this$flatMapTo$iv$iv2[2] = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null);
        Collection collection = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])$this$flatMapTo$iv$iv2), (Iterable)platformSpecificOptions), (Iterable)jvmArguments), (Iterable)additionalOptimizationOptions), (Iterable)javaIllegalAccessWorkaround), (Object)"org.jetbrains.kotlin.daemon.KotlinCompileDaemon");
        $this$flatMapTo$iv$iv2 = daemonOptions.getMappers();
        Collection collection2 = collection;
        boolean $i$f$flatMap = false;
        void it3 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean bl2 = false;
        Iterator iterator = $this$flatMapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            it = (PropMapper)element$iv$iv;
            boolean bl4 = false;
            list$iv$iv = it.toArgs("--daemon-");
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = compilerId.getMappers();
        collection2 = CollectionsKt.plus((Collection)collection2, (Iterable)((List)destination$iv$iv));
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean bl3 = false;
        iterator = $this$flatMapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            it = (PropMapper)element$iv$iv;
            boolean bl5 = false;
            list$iv$iv = it.toArgs("--daemon-");
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List args = CollectionsKt.plus((Collection)collection2, (Iterable)((List)destination$iv$iv));
        KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.INFO, "starting the daemon as: " + CollectionsKt.joinToString$default((Iterable)args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null), null, 4, null);
        ProcessBuilder processBuilder = new ProcessBuilder(args);
        processBuilder.redirectErrorStream(true);
        processBuilder.environment().putAll(environmentVariablesForTests);
        Object $this$startDaemon_u24lambda_u2426 = $this$flatMapTo$iv$iv = new File(daemonOptions.getRunFilesPath());
        boolean bl4 = false;
        ((File)$this$startDaemon_u24lambda_u2426).mkdirs();
        Object workingDir = $this$flatMapTo$iv$iv;
        processBuilder.directory((File)workingDir);
        Process daemon = NativePlatformUtilKt.launchProcessWithFallback(processBuilder, reportingTargets, "daemon client");
        return this.checkDaemonStartedProperly(daemon, reportingTargets, daemonOptions, startupAttempt, gcAutoConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final boolean checkDaemonStartedProperly(Process daemon, DaemonReportingTargets reportingTargets, DaemonOptions daemonOptions, int startupAttempt, GcAutoConfiguration gcAutoConfiguration) {
        isEchoRead = new Semaphore(1);
        isEchoRead.acquire();
        var8_7 = new DaemonProblemReportingOutputListener[]{new DaemonLastOutputLinesListener(), new DaemonGcAutoConfigurationProblemsListener(gcAutoConfiguration, startupAttempt)};
        outputListener = DaemonProblemReportingOutputListenerKt.CompositeDaemonErrorReportingOutputListener(var8_7);
        daemonIsAlmostDead = new Ref.ObjectRef();
        daemonIsAlmostDead.element = new AtomicBoolean(false);
        stdoutThread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(daemon, isEchoRead, (Ref.ObjectRef<AtomicBoolean>)daemonIsAlmostDead, outputListener, reportingTargets){
            final /* synthetic */ Process $daemon;
            final /* synthetic */ Semaphore $isEchoRead;
            final /* synthetic */ Ref.ObjectRef<AtomicBoolean> $daemonIsAlmostDead;
            final /* synthetic */ CompositeErrorReportingOutputListener $outputListener;
            final /* synthetic */ DaemonReportingTargets $reportingTargets;
            {
                this.$daemon = $daemon;
                this.$isEchoRead = $isEchoRead;
                this.$daemonIsAlmostDead = $daemonIsAlmostDead;
                this.$outputListener = $outputListener;
                this.$reportingTargets = $reportingTargets;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                try {
                    InputStream inputStream = this.$daemon.getInputStream();
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"daemon.inputStream");
                    InputStream inputStream2 = inputStream;
                    Charset charset = Charsets.UTF_8;
                    TextStreamsKt.forEachLine((Reader)new InputStreamReader(inputStream2, charset), (Function1)((Function1)new Function1<String, Unit>(this.$outputListener, this.$reportingTargets, this.$isEchoRead){
                        final /* synthetic */ CompositeErrorReportingOutputListener $outputListener;
                        final /* synthetic */ DaemonReportingTargets $reportingTargets;
                        final /* synthetic */ Semaphore $isEchoRead;
                        {
                            this.$outputListener = $outputListener;
                            this.$reportingTargets = $reportingTargets;
                            this.$isEchoRead = $isEchoRead;
                            super(1);
                        }

                        public final void invoke(String it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            if (Thread.currentThread().isInterrupted()) {
                                return;
                            }
                            this.$outputListener.onOutputLine(it);
                            if (Intrinsics.areEqual((Object)it, (Object)"Kotlin compile daemon is ready")) {
                                KotlinCompilerClientKt.report$default(this.$reportingTargets, DaemonReportCategory.DEBUG, "Received the message signalling that the daemon is ready", null, 4, null);
                                this.$isEchoRead.release();
                                return;
                            }
                            KotlinCompilerClientKt.report(this.$reportingTargets, DaemonReportCategory.INFO, it, "daemon");
                        }
                    }));
                    if (this.$isEchoRead.availablePermits() == 0) {
                        ((AtomicBoolean)this.$daemonIsAlmostDead.element).set(true);
                    }
                }
                catch (Throwable throwable) {
                }
                finally {
                    this.$daemon.getInputStream().close();
                    this.$daemon.getOutputStream().close();
                    this.$daemon.getErrorStream().close();
                    this.$isEchoRead.release();
                }
            }
        }), (int)31, null);
        try {
            v0 = CompilerSystemProperties.COMPILE_DAEMON_STARTUP_TIMEOUT_PROPERTY.getValue();
            if (v0 == null) ** GOTO lbl-1000
            it = v0;
            $i$a$-let-KotlinCompilerClient$checkDaemonStartedProperly$daemonStartupTimeout$1 = false;
            try {
                var16_12 = Long.parseLong(it);
            }
            catch (Exception e) {
                KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.INFO, "unable to interpret " + CompilerSystemProperties.COMPILE_DAEMON_STARTUP_TIMEOUT_PROPERTY.getProperty() + " property ('" + it + "'); using default timeout 10000 ms", null, 4, null);
                var16_12 = null;
            }
            v1 = var16_12;
            v0 = v1;
            if (v1 != null) {
                v2 = v0.longValue();
            } else lbl-1000:
            // 2 sources

            {
                v2 = daemonStartupTimeout = 10000L;
            }
            if (((CharSequence)daemonOptions.getRunFilesPath()).length() > 0) {
                succeeded = isEchoRead.tryAcquire(daemonStartupTimeout, TimeUnit.MILLISECONDS);
                if (!KotlinCompilerClientKt.isProcessAlive(daemon) || ((AtomicBoolean)daemonIsAlmostDead.element).get()) {
                    exitCode = daemon.waitFor(daemonStartupTimeout, TimeUnit.MILLISECONDS) != false ? String.valueOf(daemon.exitValue()) : "Unknown";
                    KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.EXCEPTION, "The daemon has terminated unexpectedly on startup attempt #" + (startupAttempt + 1) + " with error code: " + exitCode + ". " + CollectionsKt.joinToString$default((Iterable)outputListener.retrieveProblems(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), null, 4, null);
                    v3 = false;
                } else if (!succeeded) {
                    KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.INFO, "Unable to get response from daemon in " + daemonStartupTimeout + " ms", null, 4, null);
                    v3 = false;
                } else {
                    v3 = true;
                }
                var13_19 = v3;
                return var13_19;
            }
            Thread.sleep(daemonStartupTimeout);
            var12_17 = true;
            return var12_17;
        }
        finally {
            block14: {
                if (stdoutThread.isAlive()) {
                    stdoutThread.interrupt();
                }
                v4 = reportingTargets.getOut();
                if (v4 == null) break block14;
                v4.flush();
            }
        }
    }

    private static final CompileServiceSession connectAndLease$lambda$4$tryToLeaseSession(CompileService $this$connectAndLease_u24lambda_u244_u24tryToLeaseSession, File $clientAliveFlagFile, DaemonReportingTargets $reportingTargets, boolean $leaseSession, File $sessionAliveFlagFile) {
        CompileServiceSession compileServiceSession;
        $this$connectAndLease_u24lambda_u244_u24tryToLeaseSession.registerClient($clientAliveFlagFile.getAbsolutePath());
        KotlinCompilerClientKt.report$default($reportingTargets, DaemonReportCategory.DEBUG, "connected to the daemon", null, 4, null);
        if (!$leaseSession) {
            return new CompileServiceSession($this$connectAndLease_u24lambda_u244_u24tryToLeaseSession, 0);
        }
        File file = $sessionAliveFlagFile;
        CompileService.CallResult<Integer> leaseSessionResult = $this$connectAndLease_u24lambda_u244_u24tryToLeaseSession.leaseCompileSession(file != null ? file.getAbsolutePath() : null);
        if (leaseSessionResult instanceof CompileService.CallResult.Dying) {
            KotlinCompilerClientKt.report$default($reportingTargets, DaemonReportCategory.DEBUG, "the daemon is already dying, skipping it", null, 4, null);
            compileServiceSession = null;
        } else if (leaseSessionResult instanceof CompileService.CallResult.Good) {
            int sessionId = ((Number)leaseSessionResult.get()).intValue();
            KotlinCompilerClientKt.report$default($reportingTargets, DaemonReportCategory.DEBUG, "successfully leased a compile session (id = " + sessionId + ')', null, 4, null);
            compileServiceSession = new CompileServiceSession($this$connectAndLease_u24lambda_u244_u24tryToLeaseSession, sessionId);
        } else {
            KotlinCompilerClientKt.report$default($reportingTargets, DaemonReportCategory.DEBUG, "got an expected result on attempt to lease a compile session", null, 4, null);
            compileServiceSession = new CompileServiceSession($this$connectAndLease_u24lambda_u244_u24tryToLeaseSession, ((Number)leaseSessionResult.get()).intValue());
        }
        return compileServiceSession;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R&\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\u0004\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient$ClientOptions;", "Lorg/jetbrains/kotlin/daemon/common/OptionsGroup;", "stop", "", "(Z)V", "mappers", "", "Lorg/jetbrains/kotlin/daemon/common/PropMapper;", "getMappers", "()Ljava/util/List;", "getStop", "()Z", "setStop", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "", "kotlin-daemon-client"})
    public static final class ClientOptions
    implements OptionsGroup {
        private boolean stop;

        public ClientOptions(boolean stop) {
            this.stop = stop;
        }

        public /* synthetic */ ClientOptions(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            this(bl);
        }

        public final boolean getStop() {
            return this.stop;
        }

        public final void setStop(boolean bl) {
            this.stop = bl;
        }

        @Override
        @NotNull
        public List<PropMapper<?, ?, ?>> getMappers() {
            return CollectionsKt.listOf(new BoolPropMapper(this, (KMutableProperty1)mappers.1.INSTANCE, null, 4, null));
        }

        public final boolean component1() {
            return this.stop;
        }

        @NotNull
        public final ClientOptions copy(boolean stop) {
            return new ClientOptions(stop);
        }

        public static /* synthetic */ ClientOptions copy$default(ClientOptions clientOptions, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = clientOptions.stop;
            }
            return clientOptions.copy(bl);
        }

        @NotNull
        public String toString() {
            return "ClientOptions(stop=" + this.stop + ')';
        }

        public int hashCode() {
            return Boolean.hashCode(this.stop);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ClientOptions)) {
                return false;
            }
            ClientOptions clientOptions = (ClientOptions)other;
            return this.stop == clientOptions.stop;
        }

        public ClientOptions() {
            this(false, 1, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001:\u0002\u0002\u0003\u0082\u0001\u0002\u0004\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient$DaemonSearchResult;", "", "Found", "NotFound", "Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient$DaemonSearchResult$Found;", "Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient$DaemonSearchResult$NotFound;", "kotlin-daemon-client"})
    private static interface DaemonSearchResult {

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient$DaemonSearchResult$Found;", "Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient$DaemonSearchResult;", "compileService", "Lorg/jetbrains/kotlin/daemon/common/CompileService;", "runFileMarker", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/daemon/common/CompileService;Ljava/io/File;)V", "getCompileService", "()Lorg/jetbrains/kotlin/daemon/common/CompileService;", "getRunFileMarker", "()Ljava/io/File;", "kotlin-daemon-client"})
        public static final class Found
        implements DaemonSearchResult {
            @NotNull
            private final CompileService compileService;
            @NotNull
            private final File runFileMarker;

            public Found(@NotNull CompileService compileService, @NotNull File runFileMarker) {
                Intrinsics.checkNotNullParameter((Object)compileService, (String)"compileService");
                Intrinsics.checkNotNullParameter((Object)runFileMarker, (String)"runFileMarker");
                this.compileService = compileService;
                this.runFileMarker = runFileMarker;
            }

            @NotNull
            public final CompileService getCompileService() {
                return this.compileService;
            }

            @NotNull
            public final File getRunFileMarker() {
                return this.runFileMarker;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient$DaemonSearchResult$NotFound;", "Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient$DaemonSearchResult;", "requiredJvmOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;", "(Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;)V", "getRequiredJvmOptions", "()Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;", "kotlin-daemon-client"})
        public static final class NotFound
        implements DaemonSearchResult {
            @NotNull
            private final DaemonJVMOptions requiredJvmOptions;

            public NotFound(@NotNull DaemonJVMOptions requiredJvmOptions) {
                Intrinsics.checkNotNullParameter((Object)requiredJvmOptions, (String)"requiredJvmOptions");
                this.requiredJvmOptions = requiredJvmOptions;
            }

            @NotNull
            public final DaemonJVMOptions getRequiredJvmOptions() {
                return this.requiredJvmOptions;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient$GcAutoConfiguration;", "", "shouldAutoConfigureGc", "", "preferredGc", "", "(ZLjava/lang/String;)V", "getPreferredGc", "()Ljava/lang/String;", "getShouldAutoConfigureGc", "()Z", "setShouldAutoConfigureGc", "(Z)V", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "kotlin-daemon-client"})
    public static final class GcAutoConfiguration {
        private boolean shouldAutoConfigureGc;
        @NotNull
        private final String preferredGc;

        public GcAutoConfiguration(boolean shouldAutoConfigureGc, @NotNull String preferredGc) {
            Intrinsics.checkNotNullParameter((Object)preferredGc, (String)"preferredGc");
            this.shouldAutoConfigureGc = shouldAutoConfigureGc;
            this.preferredGc = preferredGc;
        }

        public /* synthetic */ GcAutoConfiguration(boolean bl, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = true;
            }
            if ((n & 2) != 0) {
                string = "Parallel";
            }
            this(bl, string);
        }

        public final boolean getShouldAutoConfigureGc() {
            return this.shouldAutoConfigureGc;
        }

        public final void setShouldAutoConfigureGc(boolean bl) {
            this.shouldAutoConfigureGc = bl;
        }

        @NotNull
        public final String getPreferredGc() {
            return this.preferredGc;
        }

        public final boolean component1() {
            return this.shouldAutoConfigureGc;
        }

        @NotNull
        public final String component2() {
            return this.preferredGc;
        }

        @NotNull
        public final GcAutoConfiguration copy(boolean shouldAutoConfigureGc, @NotNull String preferredGc) {
            Intrinsics.checkNotNullParameter((Object)preferredGc, (String)"preferredGc");
            return new GcAutoConfiguration(shouldAutoConfigureGc, preferredGc);
        }

        public static /* synthetic */ GcAutoConfiguration copy$default(GcAutoConfiguration gcAutoConfiguration, boolean bl, String string, int n, Object object) {
            if ((n & 1) != 0) {
                bl = gcAutoConfiguration.shouldAutoConfigureGc;
            }
            if ((n & 2) != 0) {
                string = gcAutoConfiguration.preferredGc;
            }
            return gcAutoConfiguration.copy(bl, string);
        }

        @NotNull
        public String toString() {
            return "GcAutoConfiguration(shouldAutoConfigureGc=" + this.shouldAutoConfigureGc + ", preferredGc=" + this.preferredGc + ')';
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.shouldAutoConfigureGc);
            result2 = result2 * 31 + this.preferredGc.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GcAutoConfiguration)) {
                return false;
            }
            GcAutoConfiguration gcAutoConfiguration = (GcAutoConfiguration)other;
            if (this.shouldAutoConfigureGc != gcAutoConfiguration.shouldAutoConfigureGc) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.preferredGc, (Object)gcAutoConfiguration.preferredGc);
        }

        public GcAutoConfiguration() {
            this(false, null, 3, null);
        }
    }
}

