/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import java.io.File;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.Process;
import net.rubygrapefruit.platform.internal.FunctionResult;
import net.rubygrapefruit.platform.internal.jni.PosixProcessFunctions;

public class DefaultProcess
implements Process {
    public int getProcessId() throws NativeException {
        return PosixProcessFunctions.getPid();
    }

    public void detach() throws NativeException {
        FunctionResult result = new FunctionResult();
        PosixProcessFunctions.detach(result);
        if (result.isFailed()) {
            throw new NativeException(String.format("Could not detach process: %s", result.getMessage()));
        }
    }

    public File getWorkingDirectory() throws NativeException {
        FunctionResult result = new FunctionResult();
        String dir = PosixProcessFunctions.getWorkingDirectory(result);
        if (result.isFailed()) {
            throw new NativeException(String.format("Could not get process working directory: %s", result.getMessage()));
        }
        return new File(dir);
    }

    public void setWorkingDirectory(File directory) throws NativeException {
        FunctionResult result = new FunctionResult();
        PosixProcessFunctions.setWorkingDirectory(directory.getAbsolutePath(), result);
        if (result.isFailed()) {
            throw new NativeException(String.format("Could not set process working directory to '%s': %s", directory.getAbsoluteFile(), result.getMessage()));
        }
    }

    public String getEnvironmentVariable(String name) throws NativeException {
        FunctionResult result = new FunctionResult();
        String value2 = PosixProcessFunctions.getEnvironmentVariable(name, result);
        if (result.isFailed()) {
            throw new NativeException(String.format("Could not get the value of environment variable '%s': %s", name, result.getMessage()));
        }
        return value2;
    }

    public void setEnvironmentVariable(String name, String value2) throws NativeException {
        FunctionResult result = new FunctionResult();
        PosixProcessFunctions.setEnvironmentVariable(name, value2, result);
        if (result.isFailed()) {
            throw new NativeException(String.format("Could not set the value of environment variable '%s': %s", name, result.getMessage()));
        }
    }
}

