/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.common;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.daemon.common.ClientUtilsKt;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.DaemonReportCategory;
import org.jetbrains.kotlin.daemon.common.DaemonWithMetadata;
import org.jetbrains.kotlin.daemon.common.LoopbackNetworkInterface;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u001c\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u00012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\n\u001a\u001c\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0001\u001a(\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00012\b\b\u0002\u0010\u0013\u001a\u00020\u0001\u001a-\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u00032\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00190\u0017H\u0082\b\u001a\\\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\n2\u001a\b\u0002\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\"0\u00172\u001a\b\u0002\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00190\u0017\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u0003X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"LOG_PREFIX_ASSUMING_OTHER_DAEMONS_HAVE", "", "MAX_PORT_NUMBER", "", "getMAX_PORT_NUMBER", "()I", "ORPHANED_RUN_FILE_AGE_THRESHOLD_MS", "", "validFlagFileKeywordChars", "makeAutodeletingFlagFile", "Ljava/io/File;", "keyword", "baseDir", "makePortFromRunFilenameExtractor", "Lkotlin/Function1;", "digest", "makeRunFilenameString", "timestamp", "port", "escapeSequence", "tryConnectToDaemon", "Lorg/jetbrains/kotlin/daemon/common/CompileService;", "report", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/daemon/common/DaemonReportCategory;", "", "walkDaemons", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/daemon/common/DaemonWithMetadata;", "registryDir", "compilerId", "Lorg/jetbrains/kotlin/daemon/common/CompilerId;", "fileToCompareTimestamp", "filter", "", "daemon-common"})
public final class ClientUtilsKt {
    private static final int MAX_PORT_NUMBER = 65535;
    private static final long ORPHANED_RUN_FILE_AGE_THRESHOLD_MS = 1000000L;
    @NotNull
    private static final String validFlagFileKeywordChars = "abcdefghijklmnopqrstuvwxyz0123456789-_";
    @NotNull
    public static final String LOG_PREFIX_ASSUMING_OTHER_DAEMONS_HAVE = "Assuming other daemons have";

    public static final int getMAX_PORT_NUMBER() {
        return MAX_PORT_NUMBER;
    }

    @NotNull
    public static final String makeRunFilenameString(@NotNull String timestamp, @NotNull String digest, @NotNull String port, @NotNull String escapeSequence) {
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        Intrinsics.checkNotNullParameter((Object)escapeSequence, (String)"escapeSequence");
        return "kotlin-daemon" + escapeSequence + '.' + timestamp + escapeSequence + '.' + digest + escapeSequence + '.' + port + escapeSequence + ".run";
    }

    public static /* synthetic */ String makeRunFilenameString$default(String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 8) != 0) {
            string4 = "";
        }
        return ClientUtilsKt.makeRunFilenameString(string, string2, string3, string4);
    }

    @NotNull
    public static final Function1<String, Integer> makePortFromRunFilenameExtractor(@NotNull String digest) {
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        String string = ClientUtilsKt.makeRunFilenameString("[0-9TZ:\\.\\+-]+", digest, "(\\d+)", "\\");
        boolean bl = false;
        Regex regex = new Regex(string);
        return (Function1)new Function1<String, Integer>(regex){
            final /* synthetic */ Regex $regex;
            {
                this.$regex = $regex;
                super(1);
            }

            @Nullable
            public final Integer invoke(@NotNull String it) {
                Integer n;
                MatchGroupCollection matchGroupCollection;
                MatchGroup matchGroup;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Object object = Regex.find$default((Regex)this.$regex, (CharSequence)it, (int)0, (int)2, null);
                MatchGroup matchGroup2 = object == null ? null : (matchGroup = (matchGroupCollection = object.getGroups()) == null ? null : matchGroupCollection.get(1));
                if (matchGroup == null) {
                    n = null;
                } else {
                    object = matchGroup.getValue();
                    if (object == null) {
                        n = null;
                    } else {
                        matchGroupCollection = object;
                        boolean bl = false;
                        n = Integer.parseInt((String)matchGroupCollection);
                    }
                }
                return n;
            }
        };
    }

    @NotNull
    public static final Sequence<DaemonWithMetadata> walkDaemons(@NotNull File registryDir, @NotNull CompilerId compilerId, @NotNull File fileToCompareTimestamp, @NotNull Function2<? super File, ? super Integer, Boolean> filter, @NotNull Function2<? super DaemonReportCategory, ? super String, Unit> report2) {
        Intrinsics.checkNotNullParameter((Object)registryDir, (String)"registryDir");
        Intrinsics.checkNotNullParameter((Object)compilerId, (String)"compilerId");
        Intrinsics.checkNotNullParameter((Object)fileToCompareTimestamp, (String)"fileToCompareTimestamp");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        Intrinsics.checkNotNullParameter(report2, (String)"report");
        String classPathDigest = compilerId.digest();
        Function1<String, Integer> portExtractor = ClientUtilsKt.makePortFromRunFilenameExtractor(classPathDigest);
        return SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)((Sequence)FilesKt.walk$default((File)registryDir, null, (int)1, null)), (Function1)((Function1)new Function1<File, Pair<? extends File, ? extends Integer>>(portExtractor){
            final /* synthetic */ Function1<String, Integer> $portExtractor;
            {
                this.$portExtractor = $portExtractor;
                super(1);
            }

            @NotNull
            public final Pair<File, Integer> invoke(@NotNull File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                return new Pair((Object)it, this.$portExtractor.invoke((Object)string));
            }
        })), (Function1)((Function1)new Function1<Pair<? extends File, ? extends Integer>, Boolean>(filter){
            final /* synthetic */ Function2<File, Integer, Boolean> $filter;
            {
                this.$filter = $filter;
                super(1);
            }

            public final boolean invoke(@NotNull Pair<? extends File, Integer> $dstr$file$port) {
                Intrinsics.checkNotNullParameter($dstr$file$port, (String)"$dstr$file$port");
                File file = (File)$dstr$file$port.component1();
                Integer port = (Integer)$dstr$file$port.component2();
                return port != null && (Boolean)this.$filter.invoke((Object)file, (Object)port) != false;
            }
        })), (Function1)((Function1)new Function1<Pair<? extends File, ? extends Integer>, DaemonWithMetadata>(fileToCompareTimestamp, report2){
            final /* synthetic */ File $fileToCompareTimestamp;
            final /* synthetic */ Function2<DaemonReportCategory, String, Unit> $report;
            {
                this.$fileToCompareTimestamp = $fileToCompareTimestamp;
                this.$report = $report;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final DaemonWithMetadata invoke(@NotNull Pair<? extends File, Integer> $dstr$file$port) {
                Object object;
                CompileService daemon2;
                Object report$iv;
                long relativeAge;
                File file;
                block14: {
                    CompileService compileService;
                    block13: {
                        Object object2;
                        Intrinsics.checkNotNullParameter($dstr$file$port, (String)"$dstr$file$port");
                        file = (File)$dstr$file$port.component1();
                        Integer port = (Integer)$dstr$file$port.component2();
                        int n = ClientUtilsKt.getMAX_PORT_NUMBER() - 1;
                        Intrinsics.checkNotNull((Object)port);
                        int n2 = port;
                        n = 1 <= n2 ? (n2 <= n ? 1 : 0) : 0;
                        n2 = 0;
                        boolean bl = false;
                        if (_Assertions.ENABLED && n == 0) {
                            boolean bl2 = false;
                            String string = "Assertion failed";
                            throw (Throwable)((Object)new AssertionError((Object)string));
                        }
                        relativeAge = this.$fileToCompareTimestamp.lastModified() - file.lastModified();
                        this.$report.invoke((Object)((Object)DaemonReportCategory.DEBUG), (Object)("found daemon on port " + port + " (" + relativeAge + " ms old), trying to connect"));
                        int n3 = port;
                        report$iv = this.$report;
                        boolean $i$f$tryConnectToDaemon = false;
                        try {
                            void port$iv;
                            object2 = LocateRegistry.getRegistry(LoopbackNetworkInterface.INSTANCE.getLoopbackInetAddressName(), (int)port$iv, LoopbackNetworkInterface.INSTANCE.getClientLoopbackSocketFactory());
                            Remote daemon$iv = object2 == null ? null : object2.lookup("KotlinJvmCompilerService");
                            object2 = daemon$iv;
                            if (object2 == null) {
                                report$iv.invoke((Object)((Object)DaemonReportCategory.INFO), (Object)"daemon not found");
                                break block13;
                            }
                            if (object2 instanceof CompileService) {
                                compileService = (CompileService)daemon$iv;
                                break block14;
                            }
                            report$iv.invoke((Object)((Object)DaemonReportCategory.INFO), (Object)Intrinsics.stringPlus((String)"Unable to cast compiler service, actual class received: ", (Object)daemon$iv.getClass().getName()));
                        }
                        catch (Throwable e$iv) {
                            Object object3 = e$iv.getCause();
                            Object object4 = object2 = object3 == null ? null : ((Throwable)object3).getMessage();
                            report$iv.invoke((Object)((Object)DaemonReportCategory.INFO), (Object)Intrinsics.stringPlus((String)"cannot connect to registry: ", (Object)(object2 == null ? ((object3 = e$iv.getMessage()) == null ? "unknown error" : object3) : object2)));
                        }
                    }
                    compileService = daemon2 = null;
                }
                if (daemon2 == null) {
                    if (relativeAge - 1000000L <= 0L) {
                        this.$report.invoke((Object)((Object)DaemonReportCategory.DEBUG), (Object)("found fresh run file '" + file.getAbsolutePath() + "' (" + relativeAge + " ms old), but no daemon, ignoring it"));
                    } else {
                        this.$report.invoke((Object)((Object)DaemonReportCategory.DEBUG), (Object)("found seemingly orphaned run file '" + file.getAbsolutePath() + "' (" + relativeAge + " ms old), deleting it"));
                        if (!file.delete()) {
                            this.$report.invoke((Object)((Object)DaemonReportCategory.INFO), (Object)("WARNING: unable to delete seemingly orphaned file '" + file.getAbsolutePath() + "', cleanup recommended"));
                        }
                    }
                }
                try {
                    DaemonWithMetadata daemonWithMetadata;
                    object = daemon2;
                    if (object == null) {
                        daemonWithMetadata = null;
                    } else {
                        report$iv = object;
                        boolean bl = false;
                        boolean bl3 = false;
                        Object it = report$iv;
                        boolean bl4 = false;
                        daemonWithMetadata = new DaemonWithMetadata((CompileService)it, file, it.getDaemonJVMOptions().get());
                    }
                    object = daemonWithMetadata;
                }
                catch (Exception e) {
                    this.$report.invoke((Object)((Object)DaemonReportCategory.INFO), (Object)Intrinsics.stringPlus((String)"ERROR: unable to retrieve daemon JVM options, assuming daemon is dead: ", (Object)e.getMessage()));
                    object = null;
                }
                return object;
            }
        }));
    }

    public static /* synthetic */ Sequence walkDaemons$default(File file, CompilerId compilerId, File file2, Function2 function2, Function2 function22, int n, Object object) {
        if ((n & 8) != 0) {
            function2 = walkDaemons.1.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            function22 = walkDaemons.2.INSTANCE;
        }
        return ClientUtilsKt.walkDaemons(file, compilerId, file2, (Function2<? super File, ? super Integer, Boolean>)function2, (Function2<? super DaemonReportCategory, ? super String, Unit>)function22);
    }

    private static final CompileService tryConnectToDaemon(int port, Function2<? super DaemonReportCategory, ? super String, Unit> report2) {
        boolean $i$f$tryConnectToDaemon = false;
        try {
            Remote remote = LocateRegistry.getRegistry(LoopbackNetworkInterface.INSTANCE.getLoopbackInetAddressName(), port, LoopbackNetworkInterface.INSTANCE.getClientLoopbackSocketFactory());
            Remote daemon2 = remote == null ? null : remote.lookup("KotlinJvmCompilerService");
            remote = daemon2;
            if (remote == null) {
                report2.invoke((Object)DaemonReportCategory.INFO, (Object)"daemon not found");
            } else {
                if (remote instanceof CompileService) {
                    return (CompileService)daemon2;
                }
                report2.invoke((Object)DaemonReportCategory.INFO, (Object)Intrinsics.stringPlus((String)"Unable to cast compiler service, actual class received: ", (Object)daemon2.getClass().getName()));
            }
        }
        catch (Throwable e) {
            String string;
            Object object = e.getCause();
            String string2 = string = object == null ? null : ((Throwable)object).getMessage();
            report2.invoke((Object)DaemonReportCategory.INFO, (Object)Intrinsics.stringPlus((String)"cannot connect to registry: ", (Object)(string == null ? ((object = e.getMessage()) == null ? "unknown error" : object) : string)));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final File makeAutodeletingFlagFile(@NotNull String keyword, @Nullable File baseDir) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        String string = keyword;
        StringBuilder stringBuilder = new StringBuilder().append("kotlin-");
        boolean $i$f$filter = false;
        CharSequence charSequence = (CharSequence)$this$filter$iv;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo = false;
        int n = 0;
        int n2 = $this$filterTo$iv$iv.length();
        while (n < n2) {
            void index$iv$iv;
            char element$iv$iv;
            char it = element$iv$iv = $this$filterTo$iv$iv.charAt((int)index$iv$iv);
            boolean bl = false;
            char c = it;
            boolean bl2 = false;
            if (StringsKt.contains$default((CharSequence)validFlagFileKeywordChars, (char)Character.toLowerCase(c), (boolean)false, (int)2, null)) {
                destination$iv$iv.append(element$iv$iv);
            }
            ++index$iv$iv;
        }
        String string2 = ((StringBuilder)destination$iv$iv).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"filterTo(StringBuilder(), predicate).toString()");
        String string3 = string2;
        String prefix = stringBuilder.append(string3).append('-').toString();
        File file = baseDir;
        File flagFile = Intrinsics.areEqual((Object)(file == null ? null : Boolean.valueOf(file.isDirectory())), (Object)true) ? Files.createTempFile(baseDir.toPath(), prefix, "-is-running", new FileAttribute[0]).toFile() : Files.createTempFile(prefix, "-is-running", new FileAttribute[0]).toFile();
        flagFile.deleteOnExit();
        Intrinsics.checkNotNullExpressionValue((Object)flagFile, (String)"flagFile");
        return flagFile;
    }

    public static /* synthetic */ File makeAutodeletingFlagFile$default(String string, File file, int n, Object object) {
        if ((n & 1) != 0) {
            string = "compiler-client";
        }
        if ((n & 2) != 0) {
            file = null;
        }
        return ClientUtilsKt.makeAutodeletingFlagFile(string, file);
    }
}

