/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.common;

import java.io.File;
import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.daemon.common.ClientUtilsKt;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.DaemonReportCategory;
import org.jetbrains.kotlin.daemon.common.DaemonWithMetadata;
import org.jetbrains.kotlin.daemon.common.LoopbackNetworkInterface;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000V\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u001c\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u00012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\n\u001a\u001c\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0001\u001a(\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00012\b\b\u0002\u0010\u0013\u001a\u00020\u0001\u001a-\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u00032\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00190\u0017H\u0082\b\u001a\\\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\n2\u001a\b\u0002\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\"0\u00172\u001a\b\u0002\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00190\u0017\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u0003X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"LOG_PREFIX_ASSUMING_OTHER_DAEMONS_HAVE", "", "MAX_PORT_NUMBER", "", "getMAX_PORT_NUMBER", "()I", "ORPHANED_RUN_FILE_AGE_THRESHOLD_MS", "", "validFlagFileKeywordChars", "makeAutodeletingFlagFile", "Ljava/io/File;", "keyword", "baseDir", "makePortFromRunFilenameExtractor", "Lkotlin/Function1;", "digest", "makeRunFilenameString", "timestamp", "port", "escapeSequence", "tryConnectToDaemon", "Lorg/jetbrains/kotlin/daemon/common/CompileService;", "report", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/daemon/common/DaemonReportCategory;", "", "walkDaemons", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/daemon/common/DaemonWithMetadata;", "registryDir", "compilerId", "Lorg/jetbrains/kotlin/daemon/common/CompilerId;", "fileToCompareTimestamp", "filter", "", "daemon-common"})
public final class ClientUtilsKt {
    private static final int MAX_PORT_NUMBER = 65535;
    private static final long ORPHANED_RUN_FILE_AGE_THRESHOLD_MS = 1000000L;
    private static final String validFlagFileKeywordChars = "abcdefghijklmnopqrstuvwxyz0123456789-_";
    @NotNull
    public static final String LOG_PREFIX_ASSUMING_OTHER_DAEMONS_HAVE = "Assuming other daemons have";

    public static final int getMAX_PORT_NUMBER() {
        return MAX_PORT_NUMBER;
    }

    @NotNull
    public static final String makeRunFilenameString(@NotNull String timestamp, @NotNull String digest, @NotNull String port, @NotNull String escapeSequence) {
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        Intrinsics.checkNotNullParameter((Object)escapeSequence, (String)"escapeSequence");
        return DaemonParamsKt.getCOMPILE_DAEMON_DEFAULT_FILES_PREFIX() + escapeSequence + '.' + timestamp + escapeSequence + '.' + digest + escapeSequence + '.' + port + escapeSequence + ".run";
    }

    public static /* synthetic */ String makeRunFilenameString$default(String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 8) != 0) {
            string4 = "";
        }
        return ClientUtilsKt.makeRunFilenameString(string, string2, string3, string4);
    }

    @NotNull
    public static final Function1<String, Integer> makePortFromRunFilenameExtractor(@NotNull String digest) {
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        String string = ClientUtilsKt.makeRunFilenameString("[0-9TZ:\\.\\+-]+", digest, "(\\d+)", "\\");
        boolean bl = false;
        Regex regex = new Regex(string);
        return (Function1)new Function1<String, Integer>(regex){
            final /* synthetic */ Regex $regex;

            @Nullable
            public final Integer invoke(@NotNull String it) {
                Integer n;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Object object = Regex.find$default((Regex)this.$regex, (CharSequence)it, (int)0, (int)2, null);
                if (object != null && (object = object.getGroups()) != null && (object = object.get(1)) != null && (object = object.getValue()) != null) {
                    Object object2 = object;
                    boolean bl = false;
                    n = Integer.parseInt((String)object2);
                } else {
                    n = null;
                }
                return n;
            }
            {
                this.$regex = regex;
                super(1);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Sequence<DaemonWithMetadata> walkDaemons(@NotNull File registryDir, @NotNull CompilerId compilerId, @NotNull File fileToCompareTimestamp, @NotNull Function2<? super File, ? super Integer, Boolean> filter, @NotNull Function2<? super DaemonReportCategory, ? super String, Unit> report2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)registryDir, (String)"registryDir");
        Intrinsics.checkNotNullParameter((Object)compilerId, (String)"compilerId");
        Intrinsics.checkNotNullParameter((Object)fileToCompareTimestamp, (String)"fileToCompareTimestamp");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        Intrinsics.checkNotNullParameter(report2, (String)"report");
        Iterable $this$map$iv = compilerId.getCompilerClasspath();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = new File((String)it).getAbsolutePath();
            collection.add(string2);
        }
        String classPathDigest = DaemonParamsKt.toHexString(DaemonParamsKt.distinctStringsDigest((List)destination$iv$iv));
        Function1<String, Integer> portExtractor = ClientUtilsKt.makePortFromRunFilenameExtractor(classPathDigest);
        return SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)((Sequence)FilesKt.walk$default((File)registryDir, null, (int)1, null)), (Function1)((Function1)new Function1<File, Pair<? extends File, ? extends Integer>>(portExtractor){
            final /* synthetic */ Function1 $portExtractor;

            @NotNull
            public final Pair<File, Integer> invoke(@NotNull File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                return new Pair((Object)it, this.$portExtractor.invoke((Object)string));
            }
            {
                this.$portExtractor = function1;
                super(1);
            }
        })), (Function1)((Function1)new Function1<Pair<? extends File, ? extends Integer>, Boolean>(filter){
            final /* synthetic */ Function2 $filter;

            /*
             * WARNING - void declaration
             */
            public final boolean invoke(@NotNull Pair<? extends File, Integer> $dstr$file$port) {
                void file;
                Intrinsics.checkNotNullParameter($dstr$file$port, (String)"<name for destructuring parameter 0>");
                File file2 = (File)$dstr$file$port.component1();
                Integer port = (Integer)$dstr$file$port.component2();
                return port != null && (Boolean)this.$filter.invoke((Object)file, (Object)port) != false;
            }
            {
                this.$filter = function2;
                super(1);
            }
        })), (Function1)((Function1)new Function1<Pair<? extends File, ? extends Integer>, DaemonWithMetadata>(fileToCompareTimestamp, report2){
            final /* synthetic */ File $fileToCompareTimestamp;
            final /* synthetic */ Function2 $report;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final DaemonWithMetadata invoke(@NotNull Pair<? extends File, Integer> $dstr$file$port) {
                CompileService compileService;
                CompileService daemon2;
                long relativeAge;
                void file;
                block16: {
                    CompileService compileService2;
                    block15: {
                        Intrinsics.checkNotNullParameter($dstr$file$port, (String)"<name for destructuring parameter 0>");
                        File file2 = (File)$dstr$file$port.component1();
                        Integer port = (Integer)$dstr$file$port.component2();
                        int n = ClientUtilsKt.getMAX_PORT_NUMBER() - 1;
                        Integer n2 = port;
                        Intrinsics.checkNotNull((Object)n2);
                        int n3 = n2;
                        n3 = 1 <= n3 && n >= n3 ? 1 : 0;
                        boolean bl = false;
                        boolean bl2 = false;
                        if (_Assertions.ENABLED && n3 == 0) {
                            boolean bl3 = false;
                            String string = "Assertion failed";
                            throw (Throwable)((Object)new AssertionError((Object)string));
                        }
                        relativeAge = this.$fileToCompareTimestamp.lastModified() - file.lastModified();
                        this.$report.invoke((Object)((Object)DaemonReportCategory.DEBUG), (Object)("found daemon on port " + port + " (" + relativeAge + " ms old), trying to connect"));
                        int n4 = port;
                        Function2 report$iv = this.$report;
                        boolean $i$f$tryConnectToDaemon = false;
                        try {
                            Remote daemon$iv;
                            void port$iv;
                            Registry registry = LocateRegistry.getRegistry(LoopbackNetworkInterface.INSTANCE.getLoopbackInetAddressName(), (int)port$iv, LoopbackNetworkInterface.INSTANCE.getClientLoopbackSocketFactory());
                            Remote remote = daemon$iv = registry != null ? registry.lookup(DaemonParamsKt.getCOMPILER_SERVICE_RMI_NAME()) : null;
                            if (remote == null) {
                                report$iv.invoke((Object)((Object)DaemonReportCategory.INFO), (Object)"daemon not found");
                                break block15;
                            }
                            if (remote instanceof CompileService) {
                                compileService2 = (CompileService)daemon$iv;
                                break block16;
                            }
                            report$iv.invoke((Object)((Object)DaemonReportCategory.INFO), (Object)("Unable to cast compiler service, actual class received: " + daemon$iv.getClass().getName()));
                        }
                        catch (Throwable e$iv) {
                            Object object;
                            StringBuilder stringBuilder = new StringBuilder().append("cannot connect to registry: ");
                            Object object2 = e$iv.getCause();
                            if (object2 == null || (object2 = ((Throwable)object2).getMessage()) == null) {
                                object2 = object = e$iv.getMessage();
                            }
                            if (object2 == null) {
                                object = "unknown error";
                            }
                            report$iv.invoke((Object)((Object)DaemonReportCategory.INFO), (Object)stringBuilder.append((String)object).toString());
                        }
                    }
                    compileService2 = daemon2 = null;
                }
                if (daemon2 == null) {
                    if (relativeAge - 1000000L <= 0L) {
                        this.$report.invoke((Object)((Object)DaemonReportCategory.DEBUG), (Object)("found fresh run file '" + file.getAbsolutePath() + "' (" + relativeAge + " ms old), but no daemon, ignoring it"));
                    } else {
                        this.$report.invoke((Object)((Object)DaemonReportCategory.DEBUG), (Object)("found seemingly orphaned run file '" + file.getAbsolutePath() + "' (" + relativeAge + " ms old), deleting it"));
                        if (!file.delete()) {
                            this.$report.invoke((Object)((Object)DaemonReportCategory.INFO), (Object)("WARNING: unable to delete seemingly orphaned file '" + file.getAbsolutePath() + "', cleanup recommended"));
                        }
                    }
                }
                try {
                    DaemonWithMetadata daemonWithMetadata;
                    CompileService compileService3 = daemon2;
                    if (compileService3 != null) {
                        compileService = compileService3;
                        boolean report$iv = false;
                        boolean bl = false;
                        CompileService it = compileService;
                        boolean bl4 = false;
                        daemonWithMetadata = new DaemonWithMetadata(it, (File)file, it.getDaemonJVMOptions().get());
                    } else {
                        daemonWithMetadata = null;
                    }
                    compileService = daemonWithMetadata;
                }
                catch (Exception e) {
                    this.$report.invoke((Object)((Object)DaemonReportCategory.INFO), (Object)("ERROR: unable to retrieve daemon JVM options, assuming daemon is dead: " + e.getMessage()));
                    compileService = null;
                }
                return compileService;
            }
            {
                this.$fileToCompareTimestamp = file;
                this.$report = function2;
                super(1);
            }
        }));
    }

    public static /* synthetic */ Sequence walkDaemons$default(File file, CompilerId compilerId, File file2, Function2 function2, Function2 function22, int n, Object object) {
        if ((n & 8) != 0) {
            function2 = walkDaemons.1.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            function22 = walkDaemons.2.INSTANCE;
        }
        return ClientUtilsKt.walkDaemons(file, compilerId, file2, (Function2<? super File, ? super Integer, Boolean>)function2, (Function2<? super DaemonReportCategory, ? super String, Unit>)function22);
    }

    private static final CompileService tryConnectToDaemon(int port, Function2<? super DaemonReportCategory, ? super String, Unit> report2) {
        int $i$f$tryConnectToDaemon = 0;
        try {
            Remote daemon2;
            Registry registry = LocateRegistry.getRegistry(LoopbackNetworkInterface.INSTANCE.getLoopbackInetAddressName(), port, LoopbackNetworkInterface.INSTANCE.getClientLoopbackSocketFactory());
            Remote remote = daemon2 = registry != null ? registry.lookup(DaemonParamsKt.getCOMPILER_SERVICE_RMI_NAME()) : null;
            if (remote == null) {
                report2.invoke((Object)DaemonReportCategory.INFO, (Object)"daemon not found");
            } else {
                if (remote instanceof CompileService) {
                    return (CompileService)daemon2;
                }
                report2.invoke((Object)DaemonReportCategory.INFO, (Object)("Unable to cast compiler service, actual class received: " + daemon2.getClass().getName()));
            }
        }
        catch (Throwable e) {
            Object object;
            StringBuilder stringBuilder = new StringBuilder().append("cannot connect to registry: ");
            Object object2 = e.getCause();
            if (object2 == null || (object2 = ((Throwable)object2).getMessage()) == null) {
                object2 = object = e.getMessage();
            }
            if (object2 == null) {
                object = "unknown error";
            }
            report2.invoke((Object)DaemonReportCategory.INFO, (Object)stringBuilder.append((String)object).toString());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final File makeAutodeletingFlagFile(@NotNull String keyword, @Nullable File baseDir) {
        Object object;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        Object object2 = keyword;
        CharSequence charSequence = new StringBuilder().append("kotlin-");
        boolean $i$f$filter = false;
        CharSequence charSequence2 = (CharSequence)$this$filter$iv;
        Object destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo = false;
        int n = 0;
        int n2 = $this$filterTo$iv$iv.length();
        while (n < n2) {
            void index$iv$iv;
            char element$iv$iv;
            char it = element$iv$iv = $this$filterTo$iv$iv.charAt((int)index$iv$iv);
            boolean bl = false;
            char c = it;
            boolean bl2 = false;
            if (StringsKt.contains$default((CharSequence)validFlagFileKeywordChars, (char)Character.toLowerCase(c), (boolean)false, (int)2, null)) {
                destination$iv$iv.append(element$iv$iv);
            }
            ++index$iv$iv;
        }
        String string = ((StringBuilder)destination$iv$iv).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"filterTo(StringBuilder(), predicate).toString()");
        String string2 = string;
        CharSequence charSequence3 = charSequence.append(string2).append('-').toString();
        String string3 = "-is-running";
        File file = baseDir;
        if (file != null) {
            void it;
            object2 = file;
            boolean bl = false;
            boolean bl3 = false;
            destination$iv$iv = object2;
            string2 = string3;
            charSequence = charSequence3;
            boolean bl4 = false;
            boolean bl5 = it.isDirectory() && it.exists();
            charSequence3 = charSequence;
            string3 = string2;
            object = bl5 ? object2 : null;
        } else {
            object = null;
        }
        File flagFile = File.createTempFile(charSequence3, string3, object);
        flagFile.deleteOnExit();
        File file2 = flagFile;
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"flagFile");
        return file2;
    }

    public static /* synthetic */ File makeAutodeletingFlagFile$default(String string, File file, int n, Object object) {
        if ((n & 1) != 0) {
            string = "compiler-client";
        }
        if ((n & 2) != 0) {
            file = null;
        }
        return ClientUtilsKt.makeAutodeletingFlagFile(string, file);
    }

    public static final /* synthetic */ CompileService access$tryConnectToDaemon(int port, Function2 report2) {
        return ClientUtilsKt.tryConnectToDaemon(port, (Function2<? super DaemonReportCategory, ? super String, Unit>)report2);
    }
}

