/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.common;

import java.io.File;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.daemon.common.FileSystem$WhenMappings;
import org.jetbrains.kotlin.daemon.common.FileSystemUtilsKt;
import org.jetbrains.kotlin.daemon.common.OSKind;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\r\u001a\u00020\u00042\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u000f\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0010R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/daemon/common/FileSystem;", "", "()V", "logFilesPath", "", "getLogFilesPath", "()Ljava/lang/String;", "runtimeStateFilesBasePath", "getRuntimeStateFilesBasePath", "tempPath", "getTempPath", "userHomePath", "getUserHomePath", "getRuntimeStateFilesPath", "names", "", "([Ljava/lang/String;)Ljava/lang/String;", "compiler-deps"})
public final class FileSystem {
    public static final FileSystem INSTANCE;

    @NotNull
    public final String getUserHomePath() {
        String string = System.getProperty("user.home");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"System.getProperty(\"user.home\")");
        if (string == null) {
            FileSystem.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public final String getTempPath() {
        String string = System.getProperty("java.io.tmpdir");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"System.getProperty(\"java.io.tmpdir\")");
        if (string == null) {
            FileSystem.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public final String getLogFilesPath() {
        String string = this.getTempPath();
        if (string == null) {
            FileSystem.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public final String getRuntimeStateFilesBasePath() {
        String string;
        switch (FileSystem$WhenMappings.$EnumSwitchMapping$0[OSKind.Companion.getCurrent().ordinal()]) {
            case 1: {
                string = FileSystemUtilsKt.access$orDefault(System.getenv("LOCALAPPDATA"), this.getTempPath());
                break;
            }
            case 2: {
                string = this.getUserHomePath() + "/Library/Application Support";
                break;
            }
            case 3: {
                string = FileSystemUtilsKt.access$orDefault(System.getenv("XDG_DATA_HOME"), this.getUserHomePath() + "/.local/share");
                break;
            }
            case 4: {
                string = this.getTempPath();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (string == null) {
            FileSystem.$$$reportNull$$$0(3);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getRuntimeStateFilesPath(String ... names) {
        String string;
        Object dir;
        Object object;
        Object p1;
        Object accumulator$iv;
        Object $receiver$iv;
        if (names == null) {
            FileSystem.$$$reportNull$$$0(4);
        }
        Intrinsics.checkParameterIsNotNull((Object)names, (String)"names");
        boolean bl = ArraysKt.any((Object[])names);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        File base = new File(this.getRuntimeStateFilesBasePath());
        if (base.exists() && base.isDirectory()) {
            $receiver$iv = names;
            accumulator$iv = base;
            for (int i = 0; i < ((Object[])$receiver$iv).length; ++i) {
                void p2;
                Object element$iv = $receiver$iv[i];
                String string3 = (String)element$iv;
                p1 = accumulator$iv;
                accumulator$iv = new File((File)p1, (String)p2);
            }
            object = accumulator$iv;
        } else {
            File initial$iv;
            File file;
            $receiver$iv = ArraysKt.drop((Object[])names, (int)1);
            accumulator$iv = ArraysKt.first((Object[])names);
            String string4 = this.getUserHomePath();
            File file2 = file;
            File file3 = file;
            String it = (String)accumulator$iv;
            String string5 = StringsKt.startsWith$default((String)it, (String)".", (boolean)false, (int)2, null) ? it : '.' + it;
            file2(string4, string5);
            File accumulator$iv2 = initial$iv = file3;
            Iterator iterator = $receiver$iv.iterator();
            while (iterator.hasNext()) {
                void p2;
                Object element$iv = iterator.next();
                p1 = (String)element$iv;
                File p12 = accumulator$iv2;
                accumulator$iv2 = new File(p12, (String)p2);
            }
            object = dir = accumulator$iv2;
        }
        if (((File)dir).exists() && ((File)dir).isDirectory() || ((File)dir).mkdirs()) {
            String string6 = ((File)dir).getAbsolutePath();
            string = string6;
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"dir.absolutePath");
        } else {
            string = this.getTempPath();
        }
        if (string == null) {
            FileSystem.$$$reportNull$$$0(5);
        }
        return string;
    }

    private FileSystem() {
        INSTANCE = this;
    }

    static {
        new FileSystem();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/daemon/common/FileSystem";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserHomePath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogFilesPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRuntimeStateFilesBasePath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/daemon/common/FileSystem";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRuntimeStateFilesPath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRuntimeStateFilesPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

