/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.buildtools.internal;

import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.script.experimental.jvm.JvmScriptingHostConfigurationKt;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.SourcesUtilsKt;
import org.jetbrains.kotlin.build.report.BuildReporter;
import org.jetbrains.kotlin.build.report.ICReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.DoNothingBuildMetricsReporter;
import org.jetbrains.kotlin.buildtools.api.CompilationResult;
import org.jetbrains.kotlin.buildtools.api.CompilationService;
import org.jetbrains.kotlin.buildtools.api.CompilerArgumentsParseException;
import org.jetbrains.kotlin.buildtools.api.CompilerExecutionStrategyConfiguration;
import org.jetbrains.kotlin.buildtools.api.ProjectId;
import org.jetbrains.kotlin.buildtools.api.jvm.ClassSnapshotGranularity;
import org.jetbrains.kotlin.buildtools.api.jvm.ClasspathSnapshotBasedIncrementalCompilationApproachParameters;
import org.jetbrains.kotlin.buildtools.api.jvm.IncrementalJvmCompilationConfiguration;
import org.jetbrains.kotlin.buildtools.api.jvm.JvmCompilationConfiguration;
import org.jetbrains.kotlin.buildtools.internal.AggregatedIcConfiguration;
import org.jetbrains.kotlin.buildtools.internal.BuildToolsApiBuildICReporter;
import org.jetbrains.kotlin.buildtools.internal.ClasspathEntrySnapshotImpl;
import org.jetbrains.kotlin.buildtools.internal.ClasspathSnapshotBasedIncrementalJvmCompilationConfigurationImpl;
import org.jetbrains.kotlin.buildtools.internal.CompilationServiceImplKt;
import org.jetbrains.kotlin.buildtools.internal.CompilerExecutionStrategy;
import org.jetbrains.kotlin.buildtools.internal.CompilerExecutionStrategyConfigurationImpl;
import org.jetbrains.kotlin.buildtools.internal.ConfigurationAdaptersKt;
import org.jetbrains.kotlin.buildtools.internal.DaemonAdaptersKt;
import org.jetbrains.kotlin.buildtools.internal.DaemonCompilationResults;
import org.jetbrains.kotlin.buildtools.internal.IcAdaptersKt;
import org.jetbrains.kotlin.buildtools.internal.JvmCompilationConfigurationImpl;
import org.jetbrains.kotlin.buildtools.internal.KotlinLoggerMessageCollectorAdapter;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.ArgumentParseErrors;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.ParseCommandLineArgumentsKt;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.PrintingMessageCollector;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreApplicationEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.modules.CoreJrtFileSystem;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileSystem;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.ZipHandler;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import org.jetbrains.kotlin.compilerRunner.KotlinCompilerRunnerUtils;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.daemon.client.BasicCompilerServicesWithResultsFacadeServer;
import org.jetbrains.kotlin.daemon.client.CompileServiceSession;
import org.jetbrains.kotlin.daemon.common.CompilationOptions;
import org.jetbrains.kotlin.daemon.common.CompilationResults;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.CompilerServicesFacadeBase;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptions;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.RestPropMapper;
import org.jetbrains.kotlin.incremental.ClasspathChanges;
import org.jetbrains.kotlin.incremental.IncrementalCompilationFeatures;
import org.jetbrains.kotlin.incremental.IncrementalCompilerRunnerKt;
import org.jetbrains.kotlin.incremental.IncrementalJvmCompilerRunner;
import org.jetbrains.kotlin.incremental.classpathDiff.ClasspathEntrySnapshotter;
import org.jetbrains.kotlin.incremental.multiproject.EmptyModulesApiHistory;
import org.jetbrains.kotlin.incremental.multiproject.ModulesApiHistory;
import org.jetbrains.kotlin.incremental.storage.FileLocations;
import org.jetbrains.kotlin.scripting.compiler.plugin.impl.ErrorReportingKt;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionsFromClasspathDiscoverySource;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J<\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0019H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u0006H\u0016J\b\u0010\u001e\u001a\u00020\u001dH\u0002J\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001b0 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00070\u0019H\u0016J4\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0019H\u0002JD\u0010&\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010#\u001a\u00020$2\u0006\u0010'\u001a\u00020(2\u0006\u0010%\u001a\u00020\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0019H\u0002J\b\u0010)\u001a\u00020\u001bH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/CompilationServiceImpl;", "Lorg/jetbrains/kotlin/buildtools/api/CompilationService;", "<init>", "()V", "buildIdToSessionFlagFile", "", "Lorg/jetbrains/kotlin/buildtools/api/ProjectId;", "Ljava/io/File;", "calculateClasspathSnapshot", "Lorg/jetbrains/kotlin/buildtools/internal/ClasspathEntrySnapshotImpl;", "classpathEntry", "granularity", "Lorg/jetbrains/kotlin/buildtools/api/jvm/ClassSnapshotGranularity;", "makeCompilerExecutionStrategyConfiguration", "Lorg/jetbrains/kotlin/buildtools/internal/CompilerExecutionStrategyConfigurationImpl;", "makeJvmCompilationConfiguration", "Lorg/jetbrains/kotlin/buildtools/internal/JvmCompilationConfigurationImpl;", "compileJvm", "Lorg/jetbrains/kotlin/buildtools/api/CompilationResult;", "projectId", "strategyConfig", "Lorg/jetbrains/kotlin/buildtools/api/CompilerExecutionStrategyConfiguration;", "compilationConfig", "Lorg/jetbrains/kotlin/buildtools/api/jvm/JvmCompilationConfiguration;", "sources", "", "arguments", "", "finishProjectCompilation", "", "clearJarCaches", "getCustomKotlinScriptFilenameExtensions", "", "classpath", "compileInProcess", "loggerAdapter", "Lorg/jetbrains/kotlin/buildtools/internal/KotlinLoggerMessageCollectorAdapter;", "compilationConfiguration", "compileWithinDaemon", "daemonConfiguration", "Lorg/jetbrains/kotlin/buildtools/internal/CompilerExecutionStrategy$Daemon;", "getCompilerVersion", "kotlin-build-tools-impl"})
@SourceDebugExtension(value={"SMAP\nCompilationServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompilationServiceImpl.kt\norg/jetbrains/kotlin/buildtools/internal/CompilationServiceImpl\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,248:1\n1159#2,3:249\n1557#3:252\n1628#3,3:253\n1557#3:258\n1628#3,3:259\n37#4,2:256\n1#5:262\n*S KotlinDebug\n*F\n+ 1 CompilationServiceImpl.kt\norg/jetbrains/kotlin/buildtools/internal/CompilationServiceImpl\n*L\n125#1:249,3\n180#1:252\n180#1:253,3\n223#1:258\n223#1:259,3\n223#1:256,2\n*E\n"})
public final class CompilationServiceImpl
implements CompilationService {
    @NotNull
    public static final CompilationServiceImpl INSTANCE = new CompilationServiceImpl();
    @NotNull
    private static final Map<ProjectId, File> buildIdToSessionFlagFile = new ConcurrentHashMap();

    private CompilationServiceImpl() {
    }

    @NotNull
    public ClasspathEntrySnapshotImpl calculateClasspathSnapshot(@NotNull File classpathEntry, @NotNull ClassSnapshotGranularity granularity) {
        Intrinsics.checkNotNullParameter((Object)classpathEntry, (String)"classpathEntry");
        Intrinsics.checkNotNullParameter((Object)granularity, (String)"granularity");
        return new ClasspathEntrySnapshotImpl(ClasspathEntrySnapshotter.INSTANCE.snapshot(classpathEntry, granularity, (BuildMetricsReporter)DoNothingBuildMetricsReporter.INSTANCE));
    }

    @NotNull
    public CompilerExecutionStrategyConfigurationImpl makeCompilerExecutionStrategyConfiguration() {
        return new CompilerExecutionStrategyConfigurationImpl();
    }

    @NotNull
    public JvmCompilationConfigurationImpl makeJvmCompilationConfiguration() {
        return new JvmCompilationConfigurationImpl(null, null, 3, null);
    }

    @NotNull
    public CompilationResult compileJvm(@NotNull ProjectId projectId, @NotNull CompilerExecutionStrategyConfiguration strategyConfig, @NotNull JvmCompilationConfiguration compilationConfig, @NotNull List<? extends File> sources, @NotNull List<String> arguments) {
        CompilationResult compilationResult;
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)strategyConfig, (String)"strategyConfig");
        Intrinsics.checkNotNullParameter((Object)compilationConfig, (String)"compilationConfig");
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        if (!(strategyConfig instanceof CompilerExecutionStrategyConfigurationImpl)) {
            boolean $i$a$-check-CompilationServiceImpl$compileJvm$32 = false;
            String $i$a$-check-CompilationServiceImpl$compileJvm$32 = "Initial strategy configuration object must be acquired from the `makeCompilerExecutionStrategyConfiguration` method.";
            throw new IllegalStateException($i$a$-check-CompilationServiceImpl$compileJvm$32.toString());
        }
        if (!(compilationConfig instanceof JvmCompilationConfigurationImpl)) {
            boolean $i$a$-check-CompilationServiceImpl$compileJvm$42 = false;
            String $i$a$-check-CompilationServiceImpl$compileJvm$42 = "Initial JVM compilation configuration object must be acquired from the `makeJvmCompilationConfiguration` method.";
            throw new IllegalStateException($i$a$-check-CompilationServiceImpl$compileJvm$42.toString());
        }
        KotlinLoggerMessageCollectorAdapter loggerAdapter = new KotlinLoggerMessageCollectorAdapter(((JvmCompilationConfigurationImpl)compilationConfig).getLogger());
        CompilerExecutionStrategy selectedStrategy = ((CompilerExecutionStrategyConfigurationImpl)strategyConfig).getSelectedStrategy$kotlin_build_tools_impl();
        if (selectedStrategy instanceof CompilerExecutionStrategy.InProcess) {
            compilationResult = this.compileInProcess(loggerAdapter, (JvmCompilationConfigurationImpl)compilationConfig, sources, arguments);
        } else if (selectedStrategy instanceof CompilerExecutionStrategy.Daemon) {
            compilationResult = this.compileWithinDaemon(projectId, loggerAdapter, (CompilerExecutionStrategy.Daemon)selectedStrategy, (JvmCompilationConfigurationImpl)compilationConfig, sources, arguments);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return compilationResult;
    }

    public void finishProjectCompilation(@NotNull ProjectId projectId) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        this.clearJarCaches();
        File file = buildIdToSessionFlagFile.remove(projectId);
        if (file == null) {
            return;
        }
        File file2 = file;
        file2.delete();
    }

    private final void clearJarCaches() {
        block2: {
            KotlinCoreApplicationEnvironment kotlinCoreApplicationEnvironment;
            ZipHandler.clearFileAccessorCache();
            KotlinCoreApplicationEnvironment kotlinCoreApplicationEnvironment2 = KotlinCoreEnvironment.Companion.getApplicationEnvironment();
            if (kotlinCoreApplicationEnvironment2 == null) break block2;
            KotlinCoreApplicationEnvironment $this$clearJarCaches_u24lambda_u242 = kotlinCoreApplicationEnvironment = kotlinCoreApplicationEnvironment2;
            boolean bl = false;
            VirtualFileSystem virtualFileSystem = $this$clearJarCaches_u24lambda_u242.getJarFileSystem();
            CoreJarFileSystem coreJarFileSystem = virtualFileSystem instanceof CoreJarFileSystem ? (CoreJarFileSystem)virtualFileSystem : null;
            if (coreJarFileSystem != null) {
                coreJarFileSystem.clearHandlersCache();
            }
            virtualFileSystem = $this$clearJarCaches_u24lambda_u242.getJrtFileSystem();
            CoreJrtFileSystem coreJrtFileSystem = virtualFileSystem instanceof CoreJrtFileSystem ? (CoreJrtFileSystem)virtualFileSystem : null;
            if (coreJrtFileSystem != null) {
                coreJrtFileSystem.clearRoots();
            }
            $this$clearJarCaches_u24lambda_u242.idleCleanup();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<String> getCustomKotlinScriptFilenameExtensions(@NotNull List<? extends File> classpath) {
        void destination$iv;
        void $this$mapTo$iv;
        Sequence definitions;
        Intrinsics.checkNotNullParameter(classpath, (String)"classpath");
        Sequence sequence = definitions = new ScriptDefinitionsFromClasspathDiscoverySource(classpath, JvmScriptingHostConfigurationKt.getDefaultJvmScriptingHostConfiguration(), ErrorReportingKt.getReporter((MessageCollector)((MessageCollector)new PrintingMessageCollector(System.out, MessageRenderer.WITHOUT_PATHS, false)))).getDefinitions();
        Collection collection = new ArrayList();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            ScriptDefinition scriptDefinition = (ScriptDefinition)item$iv;
            void var10_10 = destination$iv;
            boolean bl = false;
            var10_10.add(it.getFileExtension());
        }
        return destination$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final CompilationResult compileInProcess(KotlinLoggerMessageCollectorAdapter loggerAdapter, JvmCompilationConfigurationImpl compilationConfiguration, List<? extends File> sources, List<String> arguments) {
        CompilationResult compilationResult;
        IncrementalJvmCompilationConfiguration<?> options;
        AggregatedIcConfiguration<ClasspathSnapshotBasedIncrementalCompilationApproachParameters> aggregatedIcConfiguration;
        loggerAdapter.getKotlinLogger$kotlin_build_tools_impl().debug("Compiling using the in-process strategy");
        K2JVMCompiler compiler = new K2JVMCompiler();
        K2JVMCompilerArguments parsedArguments = compiler.createArguments();
        ParseCommandLineArgumentsKt.parseCommandLineArguments$default(arguments, (CommonToolArguments)((CommonToolArguments)parsedArguments), (boolean)false, (int)4, null);
        String string = ParseCommandLineArgumentsKt.validateArguments((ArgumentParseErrors)parsedArguments.getErrors());
        if (string != null) {
            String it = string;
            boolean bl = false;
            throw new CompilerArgumentsParseException(it);
        }
        MessageCollector.report$default((MessageCollector)loggerAdapter, (CompilerMessageSeverity)CompilerMessageSeverity.INFO, (String)arguments.toString(), null, (int)4, null);
        AggregatedIcConfiguration<ClasspathSnapshotBasedIncrementalCompilationApproachParameters> aggregatedIcConfiguration2 = aggregatedIcConfiguration = compilationConfiguration.getAggregatedIcConfiguration$kotlin_build_tools_impl();
        Object object = options = aggregatedIcConfiguration2 != null ? aggregatedIcConfiguration2.getOptions() : null;
        if (options instanceof ClasspathSnapshotBasedIncrementalJvmCompilationConfigurationImpl) {
            Set kotlinFilenameExtensions = SetsKt.plus((Set)SourcesUtilsKt.getDEFAULT_KOTLIN_SOURCE_FILES_EXTENSIONS(), (Iterable)compilationConfiguration.getKotlinScriptFilenameExtensions());
            List kotlinSources = CollectionsKt.plus((Collection)IncrementalCompilerRunnerKt.extractKotlinSourcesFromFreeCompilerArguments((CommonCompilerArguments)((CommonCompilerArguments)parsedArguments), (Set)kotlinFilenameExtensions), (Iterable)sources);
            Intrinsics.checkNotNull(aggregatedIcConfiguration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.buildtools.internal.AggregatedIcConfiguration<org.jetbrains.kotlin.buildtools.api.jvm.ClasspathSnapshotBasedIncrementalCompilationApproachParameters>");
            ClasspathChanges.ClasspathSnapshotEnabled classpathChanges = IcAdaptersKt.getClasspathChanges(aggregatedIcConfiguration);
            BuildReporter buildReporter = new BuildReporter((ICReporter)new BuildToolsApiBuildICReporter(loggerAdapter.getKotlinLogger$kotlin_build_tools_impl(), ((ClasspathSnapshotBasedIncrementalJvmCompilationConfigurationImpl)options).getRootProjectDir()), (BuildMetricsReporter)DoNothingBuildMetricsReporter.INSTANCE);
            File file = aggregatedIcConfiguration.getWorkingDir();
            EmptyModulesApiHistory emptyModulesApiHistory = EmptyModulesApiHistory.INSTANCE;
            boolean bl = ((ClasspathSnapshotBasedIncrementalJvmCompilationConfigurationImpl)options).getPreciseJavaTrackingEnabled();
            Set<File> set = ((ClasspathSnapshotBasedIncrementalJvmCompilationConfigurationImpl)options).getOutputDirs();
            IncrementalCompilationFeatures incrementalCompilationFeatures = ConfigurationAdaptersKt.extractIncrementalCompilationFeatures(options);
            IncrementalJvmCompilerRunner incrementalCompiler = new IncrementalJvmCompilerRunner(file, buildReporter, bl, null, (Collection)set, (ModulesApiHistory)emptyModulesApiHistory, kotlinFilenameExtensions, (ClasspathChanges)classpathChanges, incrementalCompilationFeatures);
            File rootProjectDir = ((ClasspathSnapshotBasedIncrementalJvmCompilationConfigurationImpl)options).getRootProjectDir();
            File buildDir = ((ClasspathSnapshotBasedIncrementalJvmCompilationConfigurationImpl)options).getBuildDir();
            parsedArguments.setIncrementalCompilation(Boolean.valueOf(true));
            compilationResult = CompilationServiceImplKt.access$getAsCompilationResult(incrementalCompiler.compile(kotlinSources, (CommonCompilerArguments)parsedArguments, (MessageCollector)loggerAdapter, IcAdaptersKt.getAsChangedFiles(aggregatedIcConfiguration.getSourcesChanges()), rootProjectDir != null && buildDir != null ? new FileLocations(rootProjectDir, buildDir) : null));
        } else {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable kotlinFilenameExtensions = sources;
            Collection collection2 = parsedArguments.getFreeArgs();
            K2JVMCompilerArguments k2JVMCompilerArguments = parsedArguments;
            boolean $i$f$map = false;
            void classpathChanges = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file = (File)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getAbsolutePath());
            }
            collection = (List)destination$iv$iv;
            k2JVMCompilerArguments.setFreeArgs(CollectionsKt.plus((Collection)collection2, (Iterable)collection));
            compilationResult = CompilationServiceImplKt.access$getAsCompilationResult(compiler.exec((MessageCollector)loggerAdapter, Services.EMPTY, (CommonToolArguments)parsedArguments));
        }
        return compilationResult;
    }

    /*
     * WARNING - void declaration
     */
    private final CompilationResult compileWithinDaemon(ProjectId projectId, KotlinLoggerMessageCollectorAdapter loggerAdapter, CompilerExecutionStrategy.Daemon daemonConfiguration, JvmCompilationConfigurationImpl compilationConfiguration, List<? extends File> sources, List<String> arguments) {
        ExitCode exitCode;
        Object v3;
        int exitCode2;
        block7: {
            AggregatedIcConfiguration<?> aggregatedIcConfiguration;
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            DaemonJVMOptions daemonJVMOptions;
            loggerAdapter.getKotlinLogger$kotlin_build_tools_impl().debug("Compiling using the daemon strategy");
            CompilerId compilerId = CompilerId.Companion.makeCompilerId((Iterable)CompilationServiceImplKt.access$getCurrentClasspath());
            File file = buildIdToSessionFlagFile.computeIfAbsent(projectId, arg_0 -> CompilationServiceImpl.compileWithinDaemon$lambda$7(CompilationServiceImpl::compileWithinDaemon$lambda$6, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"computeIfAbsent(...)");
            File sessionIsAliveFlagFile = file;
            DaemonJVMOptions opts = daemonJVMOptions = DaemonParamsKt.configureDaemonJVMOptions((String[])new String[0], (boolean)true, (boolean)false, (boolean)true);
            boolean bl = false;
            if (!((Collection)daemonConfiguration.getJvmArguments()).isEmpty()) {
                CollectionsKt.addAll((Collection)opts.getJvmParams(), (Iterable)DaemonParamsKt.filterExtractProps((Iterable)daemonConfiguration.getJvmArguments(), (List)opts.getMappers(), (String)"", (RestPropMapper)opts.getRestMapper()));
            }
            DaemonJVMOptions jvmOptions = daemonJVMOptions;
            CompileServiceSession compileServiceSession = KotlinCompilerRunnerUtils.newDaemonConnection$default((CompilerId)compilerId, (File)DaemonAdaptersKt.getClientIsAliveFile(), (File)sessionIsAliveFlagFile, (MessageCollector)loggerAdapter, (boolean)false, null, (DaemonJVMOptions)jvmOptions, (int)32, null);
            if (compileServiceSession == null) {
                return CompilationServiceImplKt.access$getAsCompilationResult(ExitCode.INTERNAL_ERROR);
            }
            daemonJVMOptions = compileServiceSession;
            CompileService daemon = daemonJVMOptions.component1();
            int sessionId = daemonJVMOptions.component2();
            CompilationOptions daemonCompileOptions = DaemonAdaptersKt.getAsDaemonCompilationOptions(compilationConfiguration);
            Iterable $this$toTypedArray$iv = arguments;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            $this$toTypedArray$iv = sources;
            Object[] objectArray = thisCollection$iv.toArray(new String[0]);
            int n = sessionId;
            CompileService compileService = daemon;
            boolean $i$f$map = false;
            thisCollection$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file2 = (File)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getAbsolutePath());
            }
            collection = (List)destination$iv$iv;
            exitCode2 = ((Number)compileService.compile(n, (String[])ArraysKt.plus((Object[])objectArray, (Collection)collection), daemonCompileOptions, (CompilerServicesFacadeBase)new BasicCompilerServicesWithResultsFacadeServer((MessageCollector)loggerAdapter, null, 0, 6, null), (CompilationResults)new DaemonCompilationResults(loggerAdapter.getKotlinLogger$kotlin_build_tools_impl(), (aggregatedIcConfiguration = compilationConfiguration.getAggregatedIcConfiguration$kotlin_build_tools_impl()) != null && (aggregatedIcConfiguration = aggregatedIcConfiguration.getOptions()) != null ? aggregatedIcConfiguration.getRootProjectDir() : null)).get()).intValue();
            try {
                daemon.releaseCompileSession(sessionId);
            }
            catch (RemoteException e) {
                loggerAdapter.getKotlinLogger$kotlin_build_tools_impl().warn("Unable to release compile session, maybe daemon is already down: " + e);
            }
            Iterable iterable = (Iterable)EntriesMappings.entries$0;
            for (Object t : iterable) {
                ExitCode it = (ExitCode)t;
                boolean bl3 = false;
                if (!(it.getCode() == exitCode2)) continue;
                v3 = t;
                break block7;
            }
            v3 = null;
        }
        if ((exitCode = (ExitCode)v3) == null) {
            exitCode = exitCode2 == 0 ? ExitCode.OK : ExitCode.COMPILATION_ERROR;
        }
        return CompilationServiceImplKt.access$getAsCompilationResult(exitCode);
    }

    @NotNull
    public String getCompilerVersion() {
        String string = KotlinCompilerVersion.VERSION;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VERSION");
        return string;
    }

    private static final File compileWithinDaemon$lambda$6(ProjectId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return DaemonAdaptersKt.createSessionIsAliveFlagFile();
    }

    private static final File compileWithinDaemon$lambda$7(Function1 $tmp0, Object p0) {
        return (File)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<ExitCode> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])ExitCode.values()));
        }
    }
}

