/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.ClassProtoData;
import org.jetbrains.kotlin.incremental.KotlinClassInfoKt;
import org.jetbrains.kotlin.incremental.LocalFileKotlinClass;
import org.jetbrains.kotlin.incremental.ProtoData;
import org.jetbrains.kotlin.incremental.ProtoDifferenceUtilsKt;
import org.jetbrains.kotlin.incremental.storage.ProtoMapValue;
import org.jetbrains.kotlin.inline.InlineFunctionOrAccessor;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.metadata.jvm.deserialization.BitEncoding;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0006\u0018\u0000 42\u00020\u0001:\u000234BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\n\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0019\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0016\u0010\u0014R\u0013\u0010\n\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001b\u001a\u00020\u001c8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b\u001d\u0010\u001eR\u001b\u0010!\u001a\u00020\"8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010 \u001a\u0004\b#\u0010$R\u001b\u0010&\u001a\u00020'8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010 \u001a\u0004\b(\u0010)R\u001d\u0010+\u001a\u0004\u0018\u00010\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010 \u001a\u0004\b,\u0010\u0010R#\u0010.\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010/8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u0010 \u001a\u0004\b0\u00101\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/incremental/KotlinClassInfo;", "", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "classKind", "Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader$Kind;", "classHeaderData", "", "", "classHeaderStrings", "multifileClassName", "extraInfo", "Lorg/jetbrains/kotlin/incremental/KotlinClassInfo$ExtraInfo;", "<init>", "(Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader$Kind;[Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/kotlin/incremental/KotlinClassInfo$ExtraInfo;)V", "getClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "getClassKind", "()Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader$Kind;", "getClassHeaderData", "()[Ljava/lang/String;", "[Ljava/lang/String;", "getClassHeaderStrings", "getMultifileClassName", "()Ljava/lang/String;", "getExtraInfo", "()Lorg/jetbrains/kotlin/incremental/KotlinClassInfo$ExtraInfo;", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "getClassName", "()Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "className$delegate", "Lkotlin/Lazy;", "protoMapValue", "Lorg/jetbrains/kotlin/incremental/storage/ProtoMapValue;", "getProtoMapValue", "()Lorg/jetbrains/kotlin/incremental/storage/ProtoMapValue;", "protoMapValue$delegate", "protoData", "Lorg/jetbrains/kotlin/incremental/ProtoData;", "getProtoData", "()Lorg/jetbrains/kotlin/incremental/ProtoData;", "protoData$delegate", "companionObject", "getCompanionObject", "companionObject$delegate", "constantsInCompanionObject", "", "getConstantsInCompanionObject", "()Ljava/util/List;", "constantsInCompanionObject$delegate", "ExtraInfo", "Companion", "kotlin-build-common"})
public final class KotlinClassInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClassId classId;
    @NotNull
    private final KotlinClassHeader.Kind classKind;
    @NotNull
    private final String[] classHeaderData;
    @NotNull
    private final String[] classHeaderStrings;
    @Nullable
    private final String multifileClassName;
    @NotNull
    private final ExtraInfo extraInfo;
    @NotNull
    private final Lazy className$delegate;
    @NotNull
    private final Lazy protoMapValue$delegate;
    @NotNull
    private final Lazy protoData$delegate;
    @NotNull
    private final Lazy companionObject$delegate;
    @NotNull
    private final Lazy constantsInCompanionObject$delegate;

    public KotlinClassInfo(@NotNull ClassId classId, @NotNull KotlinClassHeader.Kind classKind, @NotNull String[] classHeaderData, @NotNull String[] classHeaderStrings, @Nullable String multifileClassName, @NotNull ExtraInfo extraInfo) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        Intrinsics.checkNotNullParameter((Object)classKind, (String)"classKind");
        Intrinsics.checkNotNullParameter((Object)classHeaderData, (String)"classHeaderData");
        Intrinsics.checkNotNullParameter((Object)classHeaderStrings, (String)"classHeaderStrings");
        Intrinsics.checkNotNullParameter((Object)extraInfo, (String)"extraInfo");
        this.classId = classId;
        this.classKind = classKind;
        this.classHeaderData = classHeaderData;
        this.classHeaderStrings = classHeaderStrings;
        this.multifileClassName = multifileClassName;
        this.extraInfo = extraInfo;
        this.className$delegate = LazyKt.lazy((Function0)((Function0)new Function0<JvmClassName>(this){
            final /* synthetic */ KotlinClassInfo this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final JvmClassName invoke() {
                return JvmClassName.byClassId((ClassId)this.this$0.getClassId());
            }
        }));
        this.protoMapValue$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ProtoMapValue>(this){
            final /* synthetic */ KotlinClassInfo this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final ProtoMapValue invoke() {
                boolean bl = this.this$0.getClassKind() != KotlinClassHeader.Kind.CLASS;
                byte[] byArray = BitEncoding.decodeBytes((String[])this.this$0.getClassHeaderData());
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decodeBytes(...)");
                return new ProtoMapValue(bl, byArray, this.this$0.getClassHeaderStrings());
            }
        }));
        this.protoData$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ProtoData>(this){
            final /* synthetic */ KotlinClassInfo this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final ProtoData invoke() {
                boolean bl = this.this$0.getClassKind() != KotlinClassHeader.Kind.MULTIFILE_CLASS;
                KotlinClassInfo kotlinClassInfo = this.this$0;
                if (!bl) {
                    boolean bl2 = false;
                    String string = "Proto data is not available for KotlinClassHeader.Kind.MULTIFILE_CLASS: " + kotlinClassInfo.getClassId();
                    throw new IllegalStateException(string.toString());
                }
                return ProtoDifferenceUtilsKt.toProtoData(this.this$0.getProtoMapValue(), this.this$0.getClassId().getPackageFqName());
            }
        }));
        this.companionObject$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ClassId>(this){
            final /* synthetic */ KotlinClassInfo this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final ClassId invoke() {
                ClassId classId;
                if (this.this$0.getClassKind() == KotlinClassHeader.Kind.CLASS) {
                    ProtoData protoData2 = this.this$0.getProtoData();
                    Intrinsics.checkNotNull((Object)protoData2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.incremental.ClassProtoData");
                    String string = ProtoDifferenceUtilsKt.getCompanionObjectName((ClassProtoData)protoData2);
                    if (string != null) {
                        String string2 = string;
                        KotlinClassInfo kotlinClassInfo = this.this$0;
                        String it = string2;
                        boolean bl = false;
                        ClassId classId2 = kotlinClassInfo.getClassId();
                        Name name = Name.identifier((String)it);
                        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
                        classId = classId2.createNestedClassId(name);
                    } else {
                        classId = null;
                    }
                } else {
                    classId = null;
                }
                return classId;
            }
        }));
        this.constantsInCompanionObject$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends String>>(this){
            final /* synthetic */ KotlinClassInfo this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final List<String> invoke() {
                List<String> list;
                if (this.this$0.getClassKind() == KotlinClassHeader.Kind.CLASS) {
                    ProtoData protoData2 = this.this$0.getProtoData();
                    Intrinsics.checkNotNull((Object)protoData2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.incremental.ClassProtoData");
                    ClassProtoData classProtoData = (ClassProtoData)protoData2;
                    list = ProtoDifferenceUtilsKt.isCompanionObject(classProtoData.getProto()) ? ProtoDifferenceUtilsKt.getConstants(classProtoData) : null;
                } else {
                    list = null;
                }
                return list;
            }
        }));
    }

    @NotNull
    public final ClassId getClassId() {
        return this.classId;
    }

    @NotNull
    public final KotlinClassHeader.Kind getClassKind() {
        return this.classKind;
    }

    @NotNull
    public final String[] getClassHeaderData() {
        return this.classHeaderData;
    }

    @NotNull
    public final String[] getClassHeaderStrings() {
        return this.classHeaderStrings;
    }

    @Nullable
    public final String getMultifileClassName() {
        return this.multifileClassName;
    }

    @NotNull
    public final ExtraInfo getExtraInfo() {
        return this.extraInfo;
    }

    @NotNull
    public final JvmClassName getClassName() {
        Lazy lazy = this.className$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (JvmClassName)object;
    }

    @NotNull
    public final ProtoMapValue getProtoMapValue() {
        Lazy lazy = this.protoMapValue$delegate;
        return (ProtoMapValue)lazy.getValue();
    }

    @NotNull
    public final ProtoData getProtoData() {
        Lazy lazy = this.protoData$delegate;
        return (ProtoData)lazy.getValue();
    }

    @Nullable
    public final ClassId getCompanionObject() {
        Lazy lazy = this.companionObject$delegate;
        return (ClassId)lazy.getValue();
    }

    @Nullable
    public final List<String> getConstantsInCompanionObject() {
        Lazy lazy = this.constantsInCompanionObject$delegate;
        return (List)lazy.getValue();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/incremental/KotlinClassInfo$Companion;", "", "<init>", "()V", "createFrom", "Lorg/jetbrains/kotlin/incremental/KotlinClassInfo;", "kotlinClass", "Lorg/jetbrains/kotlin/incremental/LocalFileKotlinClass;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "classHeader", "Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader;", "classContents", "", "kotlin-build-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinClassInfo createFrom(@NotNull LocalFileKotlinClass kotlinClass) {
            Intrinsics.checkNotNullParameter((Object)((Object)kotlinClass), (String)"kotlinClass");
            ClassId classId = kotlinClass.getClassId();
            Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"<get-classId>(...)");
            KotlinClassHeader kotlinClassHeader = kotlinClass.getClassHeader();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinClassHeader, (String)"<get-classHeader>(...)");
            return this.createFrom(classId, kotlinClassHeader, kotlinClass.getFileContents());
        }

        @NotNull
        public final KotlinClassInfo createFrom(@NotNull ClassId classId, @NotNull KotlinClassHeader classHeader, @NotNull byte[] classContents) {
            String[] stringArray;
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            Intrinsics.checkNotNullParameter((Object)classHeader, (String)"classHeader");
            Intrinsics.checkNotNullParameter((Object)classContents, (String)"classContents");
            KotlinClassHeader.Kind kind = classHeader.getKind();
            String[] stringArray2 = classHeader.getData();
            if (stringArray2 == null && (stringArray2 = classHeader.getIncompatibleData()) == null) {
                stringArray2 = new String[]{};
            }
            if ((stringArray = classHeader.getStrings()) == null) {
                stringArray = new String[]{};
            }
            return new KotlinClassInfo(classId, kind, stringArray2, stringArray, classHeader.getMultifileClassName(), KotlinClassInfoKt.access$getExtraInfo(classHeader, classContents));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B9\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\t\u0010\nR\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/incremental/KotlinClassInfo$ExtraInfo;", "", "classSnapshotExcludingMembers", "", "constantSnapshots", "", "", "inlineFunctionOrAccessorSnapshots", "Lorg/jetbrains/kotlin/inline/InlineFunctionOrAccessor;", "<init>", "(Ljava/lang/Long;Ljava/util/Map;Ljava/util/Map;)V", "getClassSnapshotExcludingMembers", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getConstantSnapshots", "()Ljava/util/Map;", "getInlineFunctionOrAccessorSnapshots", "kotlin-build-common"})
    public static final class ExtraInfo {
        @Nullable
        private final Long classSnapshotExcludingMembers;
        @NotNull
        private final Map<String, Long> constantSnapshots;
        @NotNull
        private final Map<InlineFunctionOrAccessor, Long> inlineFunctionOrAccessorSnapshots;

        public ExtraInfo(@Nullable Long classSnapshotExcludingMembers, @NotNull Map<String, Long> constantSnapshots, @NotNull Map<InlineFunctionOrAccessor, Long> inlineFunctionOrAccessorSnapshots) {
            Intrinsics.checkNotNullParameter(constantSnapshots, (String)"constantSnapshots");
            Intrinsics.checkNotNullParameter(inlineFunctionOrAccessorSnapshots, (String)"inlineFunctionOrAccessorSnapshots");
            this.classSnapshotExcludingMembers = classSnapshotExcludingMembers;
            this.constantSnapshots = constantSnapshots;
            this.inlineFunctionOrAccessorSnapshots = inlineFunctionOrAccessorSnapshots;
        }

        @Nullable
        public final Long getClassSnapshotExcludingMembers() {
            return this.classSnapshotExcludingMembers;
        }

        @NotNull
        public final Map<String, Long> getConstantSnapshots() {
            return this.constantSnapshots;
        }

        @NotNull
        public final Map<InlineFunctionOrAccessor, Long> getInlineFunctionOrAccessorSnapshots() {
            return this.inlineFunctionOrAccessorSnapshots;
        }
    }
}

