/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverter;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/LegacyFileExternalizer;", "Lcom/intellij/util/io/DataExternalizer;", "Ljava/io/File;", "pathConverter", "Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "<init>", "(Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;)V", "save", "", "output", "Ljava/io/DataOutput;", "file", "read", "input", "Ljava/io/DataInput;", "kotlin-build-common"})
final class LegacyFileExternalizer
implements DataExternalizer<File> {
    @NotNull
    private final FileToPathConverter pathConverter;

    public LegacyFileExternalizer(@NotNull FileToPathConverter pathConverter) {
        Intrinsics.checkNotNullParameter((Object)pathConverter, (String)"pathConverter");
        this.pathConverter = pathConverter;
    }

    public void save(@NotNull DataOutput output, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        EnumeratorStringDescriptor.INSTANCE.save(output, this.pathConverter.toPath(file));
    }

    @NotNull
    public File read(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String string = EnumeratorStringDescriptor.INSTANCE.read(input);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"read(...)");
        return this.pathConverter.toFile(string);
    }
}

