/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.IncrementalCompilationContext;
import org.jetbrains.kotlin.incremental.storage.AppendableInMemoryStorage;
import org.jetbrains.kotlin.incremental.storage.AppendableLazyStorage;
import org.jetbrains.kotlin.incremental.storage.AppendablePersistentStorage;
import org.jetbrains.kotlin.incremental.storage.InMemoryStorage;
import org.jetbrains.kotlin.incremental.storage.LazyStorage;
import org.jetbrains.kotlin.incremental.storage.PersistentStorage;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001aJ\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00030\t2\u0006\u0010\n\u001a\u00020\u000b\u001aJ\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u000e0\r\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u0010"}, d2={"createPersistentStorage", "Lorg/jetbrains/kotlin/incremental/storage/PersistentStorage;", "KEY", "VALUE", "storageFile", "Ljava/io/File;", "keyDescriptor", "Lcom/intellij/util/io/KeyDescriptor;", "valueExternalizer", "Lcom/intellij/util/io/DataExternalizer;", "icContext", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;", "createAppendablePersistentStorage", "Lorg/jetbrains/kotlin/incremental/storage/AppendablePersistentStorage;", "E", "elementExternalizer", "kotlin-build-common"})
public final class LazyStorageKt {
    @NotNull
    public static final <KEY, VALUE> PersistentStorage<KEY, VALUE> createPersistentStorage(@NotNull File storageFile, @NotNull KeyDescriptor<KEY> keyDescriptor, @NotNull DataExternalizer<VALUE> valueExternalizer, @NotNull IncrementalCompilationContext icContext) {
        PersistentStorage persistentStorage;
        Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
        Intrinsics.checkNotNullParameter(keyDescriptor, (String)"keyDescriptor");
        Intrinsics.checkNotNullParameter(valueExternalizer, (String)"valueExternalizer");
        Intrinsics.checkNotNullParameter((Object)icContext, (String)"icContext");
        LazyStorage<KEY, VALUE> storage = new LazyStorage<KEY, VALUE>(storageFile, keyDescriptor, valueExternalizer);
        boolean bl = false;
        if (icContext.getKeepIncrementalCompilationCachesInMemory()) {
            InMemoryStorage inMemoryStorage;
            InMemoryStorage it = inMemoryStorage = new InMemoryStorage(storage);
            boolean bl2 = false;
            icContext.getTransaction().registerInMemoryStorageWrapper(it);
            persistentStorage = inMemoryStorage;
        } else {
            persistentStorage = storage;
        }
        return persistentStorage;
    }

    @NotNull
    public static final <KEY, E> AppendablePersistentStorage<KEY, E> createAppendablePersistentStorage(@NotNull File storageFile, @NotNull KeyDescriptor<KEY> keyDescriptor, @NotNull DataExternalizer<E> elementExternalizer, @NotNull IncrementalCompilationContext icContext) {
        AppendablePersistentStorage appendablePersistentStorage;
        Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
        Intrinsics.checkNotNullParameter(keyDescriptor, (String)"keyDescriptor");
        Intrinsics.checkNotNullParameter(elementExternalizer, (String)"elementExternalizer");
        Intrinsics.checkNotNullParameter((Object)icContext, (String)"icContext");
        AppendableLazyStorage<KEY, E> storage = new AppendableLazyStorage<KEY, E>(storageFile, keyDescriptor, elementExternalizer);
        boolean bl = false;
        if (icContext.getKeepIncrementalCompilationCachesInMemory()) {
            AppendableInMemoryStorage appendableInMemoryStorage;
            AppendableInMemoryStorage it = appendableInMemoryStorage = new AppendableInMemoryStorage(storage);
            boolean bl2 = false;
            icContext.getTransaction().registerInMemoryStorageWrapper(it);
            appendablePersistentStorage = appendableInMemoryStorage;
        } else {
            appendablePersistentStorage = storage;
        }
        return appendablePersistentStorage;
    }
}

