/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/RelocatableFileToPathConverter;", "Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "baseDir", "Ljava/io/File;", "(Ljava/io/File;)V", "unixStyleBaseDirPathPrefix", "", "toFile", "path", "toPath", "file", "kotlin-build-common"})
public final class RelocatableFileToPathConverter
implements FileToPathConverter {
    @NotNull
    private final File baseDir;
    @NotNull
    private final String unixStyleBaseDirPathPrefix;

    public RelocatableFileToPathConverter(@NotNull File baseDir) {
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        this.baseDir = baseDir;
        this.unixStyleBaseDirPathPrefix = FilesKt.getInvariantSeparatorsPath((File)this.baseDir) + '/';
    }

    @Override
    @NotNull
    public String toPath(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!StringsKt.startsWith$default((String)FilesKt.getInvariantSeparatorsPath((File)file), (String)this.unixStyleBaseDirPathPrefix, (boolean)false, (int)2, null)) {
            boolean bl = false;
            String string = "The given file '" + file.getPath() + "' is located outside the base directory '" + this.baseDir.getPath() + '\'';
            throw new IllegalStateException(string.toString());
        }
        return FilesKt.getInvariantSeparatorsPath((File)FilesKt.relativeTo((File)file, (File)this.baseDir));
    }

    @Override
    @NotNull
    public File toFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return FilesKt.normalize((File)FilesKt.resolve((File)this.baseDir, (String)path));
    }
}

