/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0004\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0002\u001a\n\u0010\u0007\u001a\u00020\u0006*\u00020\u0002\u001a\u0018\u0010\b\u001a\u00020\u0006*\u00020\u00022\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a8\u0006\f"}, d2={"createDirectory", "", "Ljava/io/File;", "deleteDirectoryContents", "deleteRecursivelyOrThrow", "isClassFile", "", "isJavaFile", "isKotlinFile", "sourceFilesExtensions", "", "", "kotlin-build-common"})
public final class FileUtilsKt {
    public static final boolean isJavaFile(@NotNull File $this$isJavaFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isJavaFile, (String)"<this>");
        return StringsKt.equals((String)FilesKt.getExtension((File)$this$isJavaFile), (String)"java", (boolean)true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isKotlinFile(@NotNull File $this$isKotlinFile, @NotNull List<String> sourceFilesExtensions) {
        String it;
        Intrinsics.checkNotNullParameter((Object)$this$isKotlinFile, (String)"<this>");
        Intrinsics.checkNotNullParameter(sourceFilesExtensions, (String)"sourceFilesExtensions");
        if (FileUtilsKt.isJavaFile($this$isKotlinFile)) return false;
        Iterable $this$any$iv = sourceFilesExtensions;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl = false;
        } while (!StringsKt.equals((String)it, (String)FilesKt.getExtension((File)$this$isKotlinFile), (boolean)true));
        return true;
    }

    public static final boolean isClassFile(@NotNull File $this$isClassFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isClassFile, (String)"<this>");
        return StringsKt.equals((String)FilesKt.getExtension((File)$this$isClassFile), (String)"class", (boolean)true);
    }

    public static final void deleteDirectoryContents(@NotNull File $this$deleteDirectoryContents) {
        Intrinsics.checkNotNullParameter((Object)$this$deleteDirectoryContents, (String)"<this>");
        if ($this$deleteDirectoryContents.isDirectory()) {
            File[] fileArray = $this$deleteDirectoryContents.listFiles();
            Intrinsics.checkNotNull((Object)fileArray);
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                FileUtilsKt.deleteRecursivelyOrThrow(it);
            }
        } else {
            if ($this$deleteDirectoryContents.isFile()) {
                throw new IllegalStateException(("Expected a directory but found a regular file: " + $this$deleteDirectoryContents.getPath()).toString());
            }
            throw new IllegalStateException(("Directory does not exist: " + $this$deleteDirectoryContents.getPath()).toString());
        }
    }

    public static final void deleteRecursivelyOrThrow(@NotNull File $this$deleteRecursivelyOrThrow) {
        Intrinsics.checkNotNullParameter((Object)$this$deleteRecursivelyOrThrow, (String)"<this>");
        if (!FilesKt.deleteRecursively((File)$this$deleteRecursivelyOrThrow)) {
            throw new IOException("Could not delete '" + $this$deleteRecursivelyOrThrow.getPath() + '\'');
        }
    }

    public static final void createDirectory(@NotNull File $this$createDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$createDirectory, (String)"<this>");
        if (!$this$createDirectory.isDirectory()) {
            if ($this$createDirectory.isFile()) {
                throw new IllegalStateException(("A regular file already exists at this path: " + $this$createDirectory.getPath()).toString());
            }
            if (!$this$createDirectory.mkdirs() && !$this$createDirectory.isDirectory()) {
                throw new IOException("Could not create directory '" + $this$createDirectory.getPath() + '\'');
            }
        }
    }
}

