/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.AbstractIncrementalCache;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.ClassProtoData;
import org.jetbrains.kotlin.incremental.InlineFunctionsMap;
import org.jetbrains.kotlin.incremental.IrTranslationResultMap;
import org.jetbrains.kotlin.incremental.PackageMetadataMap;
import org.jetbrains.kotlin.incremental.ProtoData;
import org.jetbrains.kotlin.incremental.ProtoDataProvider;
import org.jetbrains.kotlin.incremental.TranslationResultMap;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumerImpl;
import org.jetbrains.kotlin.incremental.js.IrTranslationResultValue;
import org.jetbrains.kotlin.incremental.js.TranslationResultValue;
import org.jetbrains.kotlin.incremental.storage.BasicMap;
import org.jetbrains.kotlin.incremental.storage.DirtyClassesFqNameMap;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverter;
import org.jetbrains.kotlin.incremental.storage.SourceToFqNameMap;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.serialization.SerializerExtensionProtocol;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0016\u0018\u0000 >2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001>B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\"\u0010-\u001a\u00020*2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002000/2\u0006\u0010+\u001a\u00020,J\u0016\u00101\u001a\u00020*2\u0006\u00102\u001a\u0002032\u0006\u0010+\u001a\u00020,J\u0016\u00104\u001a\u00020*2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u000406H\u0016J\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002080/J\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002000/J\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020\u00120/J\u0018\u0010;\u001a\u00020*2\u0006\u0010<\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u0002H\u0002R\u0014\u0010\n\u001a\u00020\u000bX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u000fj\b\u0012\u0004\u0012\u00020\u0004`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00128F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\u00020$X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJsCache;", "Lorg/jetbrains/kotlin/incremental/AbstractIncrementalCache;", "Lorg/jetbrains/kotlin/name/FqName;", "cachesDir", "Ljava/io/File;", "pathConverter", "Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "serializerProtocol", "Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;)V", "dirtyOutputClassesMap", "Lorg/jetbrains/kotlin/incremental/storage/DirtyClassesFqNameMap;", "getDirtyOutputClassesMap$kotlin_build_common", "()Lorg/jetbrains/kotlin/incremental/storage/DirtyClassesFqNameMap;", "dirtySources", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "value", "", "header", "getHeader", "()[B", "setHeader", "([B)V", "headerFile", "getHeaderFile", "()Ljava/io/File;", "inlineFunctions", "Lorg/jetbrains/kotlin/incremental/InlineFunctionsMap;", "irTranslationResults", "Lorg/jetbrains/kotlin/incremental/IrTranslationResultMap;", "packageMetadata", "Lorg/jetbrains/kotlin/incremental/PackageMetadataMap;", "protoData", "Lorg/jetbrains/kotlin/incremental/ProtoDataProvider;", "sourceToClassesMap", "Lorg/jetbrains/kotlin/incremental/storage/SourceToFqNameMap;", "getSourceToClassesMap$kotlin_build_common", "()Lorg/jetbrains/kotlin/incremental/storage/SourceToFqNameMap;", "translationResults", "Lorg/jetbrains/kotlin/incremental/TranslationResultMap;", "clearCacheForRemovedClasses", "", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "compare", "translatedFiles", "", "Lorg/jetbrains/kotlin/incremental/js/TranslationResultValue;", "compareAndUpdate", "incrementalResults", "Lorg/jetbrains/kotlin/incremental/js/IncrementalResultsConsumerImpl;", "markDirty", "removedAndCompiledSources", "", "nonDirtyIrParts", "Lorg/jetbrains/kotlin/incremental/js/IrTranslationResultValue;", "nonDirtyPackageParts", "", "registerOutputForFile", "srcFile", "name", "Companion", "kotlin-build-common"})
public class IncrementalJsCache
extends AbstractIncrementalCache<FqName> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProtoDataProvider protoData;
    @NotNull
    private final SourceToFqNameMap sourceToClassesMap;
    @NotNull
    private final DirtyClassesFqNameMap dirtyOutputClassesMap;
    @NotNull
    private final TranslationResultMap translationResults;
    @NotNull
    private final IrTranslationResultMap irTranslationResults;
    @NotNull
    private final InlineFunctionsMap inlineFunctions;
    @NotNull
    private final PackageMetadataMap packageMetadata;
    @NotNull
    private final HashSet<File> dirtySources;
    @NotNull
    private static final String TRANSLATION_RESULT_MAP = "translation-result";
    @NotNull
    private static final String IR_TRANSLATION_RESULT_MAP = "ir-translation-result";
    @NotNull
    private static final String INLINE_FUNCTIONS = "inline-functions";
    @NotNull
    private static final String HEADER_FILE_NAME = "header.meta";
    @NotNull
    private static final String PACKAGE_META_FILE = "packages-meta";

    public IncrementalJsCache(@NotNull File cachesDir, @NotNull FileToPathConverter pathConverter, @NotNull SerializerExtensionProtocol serializerProtocol) {
        Intrinsics.checkNotNullParameter((Object)cachesDir, (String)"cachesDir");
        Intrinsics.checkNotNullParameter((Object)pathConverter, (String)"pathConverter");
        Intrinsics.checkNotNullParameter((Object)serializerProtocol, (String)"serializerProtocol");
        super(cachesDir, pathConverter);
        this.protoData = new ProtoDataProvider(serializerProtocol);
        this.sourceToClassesMap = (SourceToFqNameMap)this.registerMap((BasicMap)new SourceToFqNameMap(this.getStorageFile(AbstractIncrementalCache.Companion.getSOURCE_TO_CLASSES()), pathConverter));
        this.dirtyOutputClassesMap = (DirtyClassesFqNameMap)this.registerMap((BasicMap)new DirtyClassesFqNameMap(this.getStorageFile(AbstractIncrementalCache.Companion.getDIRTY_OUTPUT_CLASSES())));
        this.translationResults = (TranslationResultMap)this.registerMap((BasicMap)new TranslationResultMap(this.getStorageFile(TRANSLATION_RESULT_MAP), pathConverter, this.protoData));
        this.irTranslationResults = (IrTranslationResultMap)this.registerMap((BasicMap)new IrTranslationResultMap(this.getStorageFile(IR_TRANSLATION_RESULT_MAP), pathConverter));
        this.inlineFunctions = (InlineFunctionsMap)this.registerMap((BasicMap)new InlineFunctionsMap(this.getStorageFile(INLINE_FUNCTIONS), pathConverter));
        this.packageMetadata = (PackageMetadataMap)this.registerMap((BasicMap)new PackageMetadataMap(this.getStorageFile(PACKAGE_META_FILE)));
        boolean bl = false;
        this.dirtySources = new HashSet();
    }

    @NotNull
    public SourceToFqNameMap getSourceToClassesMap$kotlin_build_common() {
        return this.sourceToClassesMap;
    }

    @NotNull
    public DirtyClassesFqNameMap getDirtyOutputClassesMap$kotlin_build_common() {
        return this.dirtyOutputClassesMap;
    }

    private final File getHeaderFile() {
        return new File(this.getCachesDir(), HEADER_FILE_NAME);
    }

    @NotNull
    public final byte[] getHeader() {
        return FilesKt.readBytes((File)this.getHeaderFile());
    }

    public final void setHeader(@NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.getCachesDir().mkdirs();
        FilesKt.writeBytes((File)this.getHeaderFile(), (byte[])value);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void markDirty(@NotNull Collection<? extends File> removedAndCompiledSources) {
        Intrinsics.checkNotNullParameter(removedAndCompiledSources, (String)"removedAndCompiledSources");
        Iterable $this$forEach$iv = removedAndCompiledSources;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object v0;
            void $this$minByOrNull$iv;
            void $this$mapTo$iv$iv;
            File sourceFile = (File)element$iv;
            boolean bl = false;
            Iterable $this$map$iv = this.getSourceToClassesMap$kotlin_build_common().get(sourceFile);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string;
                void it;
                FqName fqName = (FqName)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                FqName fqName2 = FqNamesUtilKt.parentOrNull((FqName)it);
                String string2 = fqName2 == null ? "" : ((string = fqName2.asString()) == null ? "" : string);
                collection.add(string2);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = minElem$iv;
                } else {
                    String it = (String)minElem$iv;
                    boolean bl3 = false;
                    int minValue$iv = it.length();
                    do {
                        Object e$iv = iterator$iv.next();
                        String it2 = (String)e$iv;
                        $i$a$-minByOrNull-IncrementalJsCache$markDirty$1$2 = false;
                        int v$iv = it2.length();
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = minElem$iv;
                }
            }
            String string = v0;
            if (string == null) continue;
            String string3 = string;
            boolean bl4 = false;
            boolean bl5 = false;
            String it = string3;
            boolean bl6 = false;
            this.packageMetadata.remove(it);
        }
        super.markDirty(removedAndCompiledSources);
        this.dirtySources.addAll(removedAndCompiledSources);
    }

    public final void compare(@NotNull Map<File, TranslationResultValue> translatedFiles, @NotNull ChangesCollector changesCollector) {
        Intrinsics.checkNotNullParameter(translatedFiles, (String)"translatedFiles");
        Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
        Object object = translatedFiles;
        boolean bl = false;
        Iterator<Map.Entry<File, TranslationResultValue>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Map<ClassId, ProtoData> map;
            Object object2 = object = iterator.next();
            boolean bl2 = false;
            File srcFile = (File)object2.getKey();
            Object object3 = object;
            boolean bl3 = false;
            TranslationResultValue data = (TranslationResultValue)object3.getValue();
            TranslationResultValue translationResultValue = this.translationResults.get(srcFile);
            if (translationResultValue == null) {
                map = null;
            } else {
                byte[] byArray = translationResultValue.getMetadata();
                if (byArray == null) {
                    map = null;
                } else {
                    byte[] byArray2 = byArray;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    byte[] it = byArray2;
                    boolean bl6 = false;
                    map = this.protoData.invoke(srcFile, it);
                }
            }
            Map<ClassId, ProtoData> map2 = map;
            Map<Object, Object> oldProtoMap = map2 == null ? MapsKt.emptyMap() : map2;
            Map<ClassId, ProtoData> newProtoMap = this.protoData.invoke(srcFile, data.getMetadata());
            for (ClassId classId : SetsKt.plus(oldProtoMap.keySet(), (Iterable)newProtoMap.keySet())) {
                ChangesCollector.collectProtoChanges$default(changesCollector, (ProtoData)oldProtoMap.get(classId), newProtoMap.get(classId), false, 4, null);
            }
        }
    }

    public final void compareAndUpdate(@NotNull IncrementalResultsConsumerImpl incrementalResults, @NotNull ChangesCollector changesCollector) {
        Object metadata;
        Object inlineDeclarations;
        TranslationResultValue data;
        Object object;
        Map translatedFiles;
        Intrinsics.checkNotNullParameter((Object)incrementalResults, (String)"incrementalResults");
        Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
        Map object22 = translatedFiles = incrementalResults.getPackageParts();
        boolean bl = false;
        Iterator iterator = object22.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean bl2;
            Object object2;
            Map<ClassId, ProtoData> map;
            TranslationResultValue translationResultValue;
            TranslationResultValue translationResultValue2 = translationResultValue = iterator.next();
            boolean bl3 = false;
            File srcFile = (File)translationResultValue2.getKey();
            object = translationResultValue;
            boolean bl4 = false;
            data = (TranslationResultValue)object.getValue();
            this.dirtySources.remove(srcFile);
            object = data;
            byte[] binaryMetadata = object.component1();
            byte[] binaryAst = object.component2();
            byte[] inlineData = object.component3();
            Object object3 = this.translationResults.get(srcFile);
            if (object3 == null) {
                map = null;
            } else {
                object2 = object3.getMetadata();
                if (object2 == null) {
                    map = null;
                } else {
                    byte[] byArray = object2;
                    boolean bl5 = false;
                    bl2 = false;
                    byte[] it = byArray;
                    boolean bl6 = false;
                    map = this.protoData.invoke(srcFile, it);
                }
            }
            Map<ClassId, ProtoData> map2 = map;
            Map<Object, Object> oldProtoMap = map2 == null ? MapsKt.emptyMap() : map2;
            Map<ClassId, ProtoData> newProtoMap = this.protoData.invoke(srcFile, binaryMetadata);
            object2 = newProtoMap;
            boolean bl6 = false;
            object3 = object2.entrySet().iterator();
            while (object3.hasNext()) {
                byte[] byArray = object2 = (Map.Entry)object3.next();
                bl2 = false;
                ClassId classId = (ClassId)byArray.getKey();
                Object object4 = object2;
                boolean bl7 = false;
                ProtoData protoData = (ProtoData)object4.getValue();
                object4 = classId.asSingleFqName();
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"classId.asSingleFqName()");
                this.registerOutputForFile(srcFile, (FqName)object4);
                if (!(protoData instanceof ClassProtoData)) continue;
                this.addToClassStorage(((ClassProtoData)protoData).getProto(), ((ClassProtoData)protoData).getNameResolver(), srcFile);
            }
            for (ClassId classId : SetsKt.plus(oldProtoMap.keySet(), (Iterable)newProtoMap.keySet())) {
                ChangesCollector.collectProtoChanges$default(changesCollector, (ProtoData)oldProtoMap.get(classId), newProtoMap.get(classId), false, 4, null);
            }
            this.translationResults.put(srcFile, binaryMetadata, binaryAst, inlineData);
        }
        Map map = incrementalResults.getInlineFunctions();
        boolean srcFile = false;
        iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            TranslationResultValue translationResultValue;
            data = translationResultValue = iterator.next();
            boolean bl8 = false;
            File srcFile2 = (File)data.getKey();
            object = translationResultValue;
            boolean binaryMetadata = false;
            inlineDeclarations = (Map)object.getValue();
            this.inlineFunctions.process(srcFile2, (Map<String, Long>)inlineDeclarations, changesCollector);
        }
        Map map3 = incrementalResults.getPackageMetadata();
        boolean srcFile2 = false;
        for (Map.Entry entry : map3.entrySet()) {
            inlineDeclarations = entry;
            boolean bl9 = false;
            String packageName = (String)inlineDeclarations.getKey();
            object = entry;
            boolean binaryMetadata = false;
            metadata = (byte[])object.getValue();
            this.packageMetadata.put(packageName, (byte[])metadata);
        }
        Map map4 = incrementalResults.getIrFileData();
        boolean packageName = false;
        for (Map.Entry entry : map4.entrySet()) {
            metadata = entry;
            boolean bl10 = false;
            File srcFile3 = (File)metadata.getKey();
            object = entry;
            boolean binaryMetadata = false;
            IrTranslationResultValue irData = (IrTranslationResultValue)object.getValue();
            object = irData;
            byte[] fileData = object.component1();
            byte[] types = object.component2();
            byte[] signatures = object.component3();
            byte[] strings = object.component4();
            byte[] declarations = object.component5();
            byte[] bodies = object.component6();
            byte[] fqn = object.component7();
            this.irTranslationResults.put(srcFile3, fileData, types, signatures, strings, declarations, bodies, fqn);
        }
    }

    private final void registerOutputForFile(File srcFile, FqName name) {
        this.getSourceToClassesMap$kotlin_build_common().add(srcFile, name);
        this.getDirtyOutputClassesMap$kotlin_build_common().notDirty(name);
    }

    @Override
    public void clearCacheForRemovedClasses(@NotNull ChangesCollector changesCollector) {
        Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
        Iterable $this$forEach$iv = this.dirtySources;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            this.translationResults.remove(it, changesCollector);
            this.irTranslationResults.remove(it);
            this.inlineFunctions.remove(it);
        }
        this.removeAllFromClassStorage(this.getDirtyOutputClassesMap$kotlin_build_common().getDirtyOutputClasses(), changesCollector);
        this.dirtySources.clear();
        this.getDirtyOutputClassesMap$kotlin_build_common().clean();
    }

    @NotNull
    public final Map<File, TranslationResultValue> nonDirtyPackageParts() {
        boolean bl = false;
        HashMap<File, TranslationResultValue> hashMap = new HashMap<File, TranslationResultValue>();
        boolean bl2 = false;
        boolean bl3 = false;
        HashMap<File, TranslationResultValue> $this$nonDirtyPackageParts_u24lambda_u2d7 = hashMap;
        boolean bl4 = false;
        for (File file : this.translationResults.keys()) {
            if (this.dirtySources.contains(file)) continue;
            TranslationResultValue translationResultValue = this.translationResults.get(file);
            Intrinsics.checkNotNull((Object)translationResultValue);
            $this$nonDirtyPackageParts_u24lambda_u2d7.put(file, translationResultValue);
        }
        return hashMap;
    }

    @NotNull
    public final Map<String, byte[]> packageMetadata() {
        boolean bl = false;
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        boolean bl2 = false;
        boolean bl3 = false;
        HashMap<String, byte[]> $this$packageMetadata_u24lambda_u2d8 = hashMap;
        boolean bl4 = false;
        for (String fqNameString : this.packageMetadata.keys()) {
            byte[] byArray = this.packageMetadata.get(fqNameString);
            Intrinsics.checkNotNull((Object)byArray);
            $this$packageMetadata_u24lambda_u2d8.put(fqNameString, byArray);
        }
        return hashMap;
    }

    @NotNull
    public final Map<File, IrTranslationResultValue> nonDirtyIrParts() {
        boolean bl = false;
        HashMap<File, IrTranslationResultValue> hashMap = new HashMap<File, IrTranslationResultValue>();
        boolean bl2 = false;
        boolean bl3 = false;
        HashMap<File, IrTranslationResultValue> $this$nonDirtyIrParts_u24lambda_u2d9 = hashMap;
        boolean bl4 = false;
        for (File file : this.irTranslationResults.keys()) {
            if (this.dirtySources.contains(file)) continue;
            IrTranslationResultValue irTranslationResultValue = this.irTranslationResults.get(file);
            Intrinsics.checkNotNull((Object)irTranslationResultValue);
            $this$nonDirtyIrParts_u24lambda_u2d9.put(file, irTranslationResultValue);
        }
        return hashMap;
    }

    @Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJsCache$Companion;", "", "()V", "HEADER_FILE_NAME", "", "INLINE_FUNCTIONS", "IR_TRANSLATION_RESULT_MAP", "PACKAGE_META_FILE", "TRANSLATION_RESULT_MAP", "hasHeaderFile", "", "cachesDir", "Ljava/io/File;", "kotlin-build-common"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean hasHeaderFile(@NotNull File cachesDir) {
            Intrinsics.checkNotNullParameter((Object)cachesDir, (String)"cachesDir");
            return new File(cachesDir, IncrementalJsCache.HEADER_FILE_NAME).exists();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

