/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.IncrementalJvmCacheKt;
import org.jetbrains.kotlin.incremental.IrTranslationResultValueExternalizer;
import org.jetbrains.kotlin.incremental.js.IrTranslationResultValue;
import org.jetbrains.kotlin.incremental.storage.BasicStringMap;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverter;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\b\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0014J\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\u0004H\u0086\u0002J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eJF\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0012J\u000e\u0010\u0019\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0004R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/incremental/IrTranslationResultMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "Lorg/jetbrains/kotlin/incremental/js/IrTranslationResultValue;", "storageFile", "Ljava/io/File;", "pathConverter", "Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;)V", "dumpValue", "", "value", "get", "sourceFile", "keys", "", "put", "", "newFiledata", "", "newTypes", "newSignatures", "newStrings", "newDeclarations", "newBodies", "fqn", "remove", "kotlin-build-common"})
final class IrTranslationResultMap
extends BasicStringMap<IrTranslationResultValue> {
    private final FileToPathConverter pathConverter;

    @Override
    @NotNull
    protected String dumpValue(@NotNull IrTranslationResultValue value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return "Filedata: " + IncrementalJvmCacheKt.md5(value.getFileData()) + ", " + "Types: " + IncrementalJvmCacheKt.md5(value.getTypes()) + ", " + "Signatures: " + IncrementalJvmCacheKt.md5(value.getSignatures()) + ", " + "Strings: " + IncrementalJvmCacheKt.md5(value.getStrings()) + ", " + "Declarations: " + IncrementalJvmCacheKt.md5(value.getDeclarations()) + ", " + "Bodies: " + IncrementalJvmCacheKt.md5(value.getBodies());
    }

    public final void put(@NotNull File sourceFile, @NotNull byte[] newFiledata, @NotNull byte[] newTypes, @NotNull byte[] newSignatures, @NotNull byte[] newStrings, @NotNull byte[] newDeclarations, @NotNull byte[] newBodies, @NotNull byte[] fqn) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkNotNullParameter((Object)newFiledata, (String)"newFiledata");
        Intrinsics.checkNotNullParameter((Object)newTypes, (String)"newTypes");
        Intrinsics.checkNotNullParameter((Object)newSignatures, (String)"newSignatures");
        Intrinsics.checkNotNullParameter((Object)newStrings, (String)"newStrings");
        Intrinsics.checkNotNullParameter((Object)newDeclarations, (String)"newDeclarations");
        Intrinsics.checkNotNullParameter((Object)newBodies, (String)"newBodies");
        Intrinsics.checkNotNullParameter((Object)fqn, (String)"fqn");
        this.getStorage().set(this.pathConverter.toPath(sourceFile), new IrTranslationResultValue(newFiledata, newTypes, newSignatures, newStrings, newDeclarations, newBodies, fqn));
    }

    @Nullable
    public final IrTranslationResultValue get(@NotNull File sourceFile) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        return (IrTranslationResultValue)this.getStorage().get(this.pathConverter.toPath(sourceFile));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<File> keys() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getStorage().getKeys();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File file = this.pathConverter.toFile((String)it);
            collection.add(file);
        }
        return (List)destination$iv$iv;
    }

    public final void remove(@NotNull File sourceFile) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        String path = this.pathConverter.toPath(sourceFile);
        this.getStorage().remove(path);
    }

    public IrTranslationResultMap(@NotNull File storageFile, @NotNull FileToPathConverter pathConverter) {
        Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
        Intrinsics.checkNotNullParameter((Object)pathConverter, (String)"pathConverter");
        super(storageFile, IrTranslationResultValueExternalizer.INSTANCE);
        this.pathConverter = pathConverter;
    }
}

