/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.GeneratedFile;
import org.jetbrains.kotlin.build.GeneratedFilesKt;
import org.jetbrains.kotlin.build.GeneratedJvmClass;
import org.jetbrains.kotlin.build.JvmSourceRoot;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.incremental.ChangeInfo;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.DirtyData;
import org.jetbrains.kotlin.incremental.ICReporter;
import org.jetbrains.kotlin.incremental.IncrementalCacheCommon;
import org.jetbrains.kotlin.incremental.IncrementalCompilationComponentsImpl;
import org.jetbrains.kotlin.incremental.IncrementalJvmCache;
import org.jetbrains.kotlin.incremental.LookupStorage;
import org.jetbrains.kotlin.incremental.LookupSymbol;
import org.jetbrains.kotlin.incremental.LookupTrackerImpl;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCache;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.modules.KotlinModuleXmlBuilder;
import org.jetbrains.kotlin.modules.TargetId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.progress.CompilationCanceledStatus;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\u008c\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a,\u0010\u0000\u001a\u00020\u00012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t\u001aV\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012\u001a@\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00122\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00122\u0006\u0010\u001d\u001a\u00020\u001e2\u000e\b\u0002\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0018\u001a:\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0\u00182\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00122\u0006\u0010\u001d\u001a\u00020\u001e2\u000e\b\u0002\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0018\u001a$\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u00122\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,\u001a\"\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00182\u0006\u0010.\u001a\u00020\u001c2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0012\u001a \u0010/\u001a\u000200*\u00020,2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00122\u0006\u0010\u001d\u001a\u00020\u001e\u001a.\u00101\u001a\u00020&*\u00020\"2\u0006\u0010\u0006\u001a\u00020\u00072\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00122\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012\u00a8\u00064"}, d2={"makeCompileServices", "Lorg/jetbrains/kotlin/config/Services;", "incrementalCaches", "", "Lorg/jetbrains/kotlin/modules/TargetId;", "Lorg/jetbrains/kotlin/load/kotlin/incremental/components/IncrementalCache;", "lookupTracker", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "compilationCanceledStatus", "Lorg/jetbrains/kotlin/progress/CompilationCanceledStatus;", "makeModuleFile", "Ljava/io/File;", "name", "", "isTest", "", "outputDir", "sourcesToCompile", "", "javaSourceRoots", "Lorg/jetbrains/kotlin/build/JvmSourceRoot;", "classpath", "friendDirs", "mapClassesFqNamesToFiles", "", "caches", "Lorg/jetbrains/kotlin/incremental/IncrementalCacheCommon;", "classesFqNames", "Lorg/jetbrains/kotlin/name/FqName;", "reporter", "Lorg/jetbrains/kotlin/incremental/ICReporter;", "excludes", "mapLookupSymbolsToFiles", "lookupStorage", "Lorg/jetbrains/kotlin/incremental/LookupStorage;", "lookupSymbols", "Lorg/jetbrains/kotlin/incremental/LookupSymbol;", "updateIncrementalCache", "", "generatedFiles", "Lorg/jetbrains/kotlin/build/GeneratedFile;", "cache", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "withSubtypes", "typeFqName", "getDirtyData", "Lorg/jetbrains/kotlin/incremental/DirtyData;", "update", "filesToCompile", "removedFiles", "kotlin-build-common"})
public final class BuildUtilKt {
    @NotNull
    public static final File makeModuleFile(@NotNull String name, boolean isTest, @NotNull File outputDir2, @NotNull Iterable<? extends File> sourcesToCompile, @NotNull Iterable<JvmSourceRoot> javaSourceRoots, @NotNull Iterable<? extends File> classpath, @NotNull Iterable<? extends File> friendDirs) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)outputDir2, (String)"outputDir");
        Intrinsics.checkParameterIsNotNull(sourcesToCompile, (String)"sourcesToCompile");
        Intrinsics.checkParameterIsNotNull(javaSourceRoots, (String)"javaSourceRoots");
        Intrinsics.checkParameterIsNotNull(classpath, (String)"classpath");
        Intrinsics.checkParameterIsNotNull(friendDirs, (String)"friendDirs");
        KotlinModuleXmlBuilder builder = new KotlinModuleXmlBuilder();
        String string = outputDir2.getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"outputDir.absolutePath");
        builder.addModule(name, string, sourcesToCompile, javaSourceRoots, classpath, null, "java-production", isTest, SetsKt.setOf((Object)outputDir2), friendDirs);
        File scriptFile = File.createTempFile("kjps", StringUtil.sanitizeJavaIdentifier((String)name) + ".script.xml");
        FileUtil.writeToFile((File)scriptFile, (String)((Object)builder.asText()).toString());
        File file = scriptFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"scriptFile");
        return file;
    }

    @NotNull
    public static final Services makeCompileServices(@NotNull Map<TargetId, ? extends IncrementalCache> incrementalCaches, @NotNull LookupTracker lookupTracker, @Nullable CompilationCanceledStatus compilationCanceledStatus) {
        Services.Builder $receiver;
        block0: {
            CompilationCanceledStatus compilationCanceledStatus2;
            Services.Builder builder;
            Intrinsics.checkParameterIsNotNull(incrementalCaches, (String)"incrementalCaches");
            Intrinsics.checkParameterIsNotNull((Object)lookupTracker, (String)"lookupTracker");
            $receiver = builder = new Services.Builder();
            $receiver.register(LookupTracker.class, (Object)lookupTracker);
            $receiver.register(IncrementalCompilationComponents.class, (Object)new IncrementalCompilationComponentsImpl(incrementalCaches));
            CompilationCanceledStatus compilationCanceledStatus3 = compilationCanceledStatus;
            if (compilationCanceledStatus3 == null) break block0;
            CompilationCanceledStatus it = compilationCanceledStatus2 = compilationCanceledStatus3;
            $receiver.register(CompilationCanceledStatus.class, (Object)it);
        }
        return $receiver.build();
    }

    public static final void updateIncrementalCache(@NotNull Iterable<? extends GeneratedFile> generatedFiles, @NotNull IncrementalJvmCache cache, @NotNull ChangesCollector changesCollector) {
        Intrinsics.checkParameterIsNotNull(generatedFiles, (String)"generatedFiles");
        Intrinsics.checkParameterIsNotNull((Object)cache, (String)"cache");
        Intrinsics.checkParameterIsNotNull((Object)changesCollector, (String)"changesCollector");
        for (GeneratedFile generatedFile : generatedFiles) {
            if (generatedFile instanceof GeneratedJvmClass) {
                cache.saveFileToCache((GeneratedJvmClass)generatedFile, changesCollector);
                continue;
            }
            if (!GeneratedFilesKt.isModuleMappingFile(generatedFile.getOutputFile())) continue;
            cache.saveModuleMappingToCache(generatedFile.getSourceFiles(), generatedFile.getOutputFile());
        }
        cache.clearCacheForRemovedClasses(changesCollector);
    }

    public static final void update(@NotNull LookupStorage $receiver, @NotNull LookupTracker lookupTracker, @NotNull Iterable<? extends File> filesToCompile, @NotNull Iterable<? extends File> removedFiles) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)lookupTracker, (String)"lookupTracker");
        Intrinsics.checkParameterIsNotNull(filesToCompile, (String)"filesToCompile");
        Intrinsics.checkParameterIsNotNull(removedFiles, (String)"removedFiles");
        if (!(lookupTracker instanceof LookupTrackerImpl)) {
            throw (Throwable)((Object)new AssertionError((Object)("Lookup tracker is expected to be LookupTrackerImpl, got " + lookupTracker.getClass())));
        }
        $receiver.removeLookupsFrom((Sequence<? extends File>)SequencesKt.plus((Sequence)CollectionsKt.asSequence(filesToCompile), (Sequence)CollectionsKt.asSequence(removedFiles)));
        Set set = ((LookupTrackerImpl)lookupTracker).getLookups().entrySet();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"lookupTracker.lookups.entrySet()");
        Set set2 = ((LookupTrackerImpl)lookupTracker).getPathInterner().getValues();
        Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"lookupTracker.pathInterner.values");
        $receiver.addAll(set, set2);
    }

    @NotNull
    public static final DirtyData getDirtyData(@NotNull ChangesCollector $receiver, @NotNull Iterable<? extends IncrementalCacheCommon> caches, @NotNull ICReporter reporter) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(caches, (String)"caches");
        Intrinsics.checkParameterIsNotNull((Object)reporter, (String)"reporter");
        HashSet<LookupSymbol> dirtyLookupSymbols = new HashSet<LookupSymbol>();
        HashSet dirtyClassesFqNames = new HashSet();
        for (ChangeInfo change : $receiver.changes()) {
            Collection<Object> fqNames;
            reporter.report((Function0<String>)((Function0)new Function0<String>(change){
                final /* synthetic */ ChangeInfo $change;

                @NotNull
                public final String invoke() {
                    return "Process " + this.$change;
                }
                {
                    this.$change = changeInfo;
                    super(0);
                }
            }));
            if (change instanceof ChangeInfo.SignatureChanged) {
                fqNames = !((ChangeInfo.SignatureChanged)change).getAreSubclassesAffected() ? (Collection)CollectionsKt.listOf((Object)change.getFqName()) : (Collection)BuildUtilKt.withSubtypes(change.getFqName(), caches);
                for (FqName fqName : fqNames) {
                    String name;
                    boolean bl;
                    boolean bl2 = bl = !fqName.isRoot();
                    if (_Assertions.ENABLED && !bl) {
                        String string = "" + fqName + " is root when processing " + change;
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    String string = fqName.parent().asString();
                    Name name2 = fqName.shortName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"classFqName.shortName()");
                    String string2 = name = name2.getIdentifier();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
                    String string3 = string;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"scope");
                    dirtyLookupSymbols.add(new LookupSymbol(string2, string3));
                }
                continue;
            }
            if (!(change instanceof ChangeInfo.MembersChanged)) continue;
            fqNames = BuildUtilKt.withSubtypes(change.getFqName(), caches);
            dirtyClassesFqNames.addAll(fqNames);
            for (String string : ((ChangeInfo.MembersChanged)change).getNames()) {
                for (FqName fqName : fqNames) {
                    String string4 = fqName.asString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"fqName.asString()");
                    dirtyLookupSymbols.add(new LookupSymbol(string, string4));
                }
            }
        }
        return new DirtyData((Collection<LookupSymbol>)dirtyLookupSymbols, dirtyClassesFqNames);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<File> mapLookupSymbolsToFiles(@NotNull LookupStorage lookupStorage, @NotNull Iterable<LookupSymbol> lookupSymbols, @NotNull ICReporter reporter, @NotNull Set<? extends File> excludes) {
        Intrinsics.checkParameterIsNotNull((Object)lookupStorage, (String)"lookupStorage");
        Intrinsics.checkParameterIsNotNull(lookupSymbols, (String)"lookupSymbols");
        Intrinsics.checkParameterIsNotNull((Object)reporter, (String)"reporter");
        Intrinsics.checkParameterIsNotNull(excludes, (String)"excludes");
        HashSet dirtyFiles = new HashSet();
        for (LookupSymbol lookup : lookupSymbols) {
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)lookupStorage.get(lookup);
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void p1;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                File file = new File((String)p1);
                collection.add(file);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                File it = (File)element$iv$iv;
                if (!(!excludes.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List affectedFiles = (List)destination$iv$iv;
            reporter.report((Function0<String>)((Function0)new Function0<String>(lookup, reporter, affectedFiles){
                final /* synthetic */ LookupSymbol $lookup;
                final /* synthetic */ ICReporter $reporter;
                final /* synthetic */ List $affectedFiles;

                @NotNull
                public final String invoke() {
                    return "" + this.$lookup.getScope() + '#' + this.$lookup.getName() + " caused recompilation of: " + this.$reporter.pathsAsString(this.$affectedFiles);
                }
                {
                    this.$lookup = lookupSymbol;
                    this.$reporter = iCReporter;
                    this.$affectedFiles = list;
                    super(0);
                }
            }));
            dirtyFiles.addAll(affectedFiles);
        }
        return dirtyFiles;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Set mapLookupSymbolsToFiles$default(LookupStorage lookupStorage, Iterable iterable, ICReporter iCReporter, Set set, int n, Object object) {
        if ((n & 8) != 0) {
            set = SetsKt.emptySet();
        }
        return BuildUtilKt.mapLookupSymbolsToFiles(lookupStorage, iterable, iCReporter, set);
    }

    @NotNull
    public static final Set<File> mapClassesFqNamesToFiles(@NotNull Iterable<? extends IncrementalCacheCommon> caches, @NotNull Iterable<FqName> classesFqNames, @NotNull ICReporter reporter, @NotNull Set<? extends File> excludes) {
        Intrinsics.checkParameterIsNotNull(caches, (String)"caches");
        Intrinsics.checkParameterIsNotNull(classesFqNames, (String)"classesFqNames");
        Intrinsics.checkParameterIsNotNull((Object)reporter, (String)"reporter");
        Intrinsics.checkParameterIsNotNull(excludes, (String)"excludes");
        HashSet<File> dirtyFiles = new HashSet<File>();
        for (IncrementalCacheCommon incrementalCacheCommon : caches) {
            for (FqName dirtyClassFqName : classesFqNames) {
                File srcFile = incrementalCacheCommon.getSourceFileIfClass(dirtyClassFqName);
                if (srcFile == null || excludes.contains(srcFile)) continue;
                reporter.report((Function0<String>)((Function0)new Function0<String>(dirtyClassFqName, reporter, srcFile){
                    final /* synthetic */ FqName $dirtyClassFqName;
                    final /* synthetic */ ICReporter $reporter;
                    final /* synthetic */ File $srcFile;

                    @NotNull
                    public final String invoke() {
                        return "Class " + this.$dirtyClassFqName + " caused recompilation of: " + this.$reporter.pathsAsString(this.$srcFile);
                    }
                    {
                        this.$dirtyClassFqName = fqName;
                        this.$reporter = iCReporter;
                        this.$srcFile = file;
                        super(0);
                    }
                }));
                dirtyFiles.add(srcFile);
            }
        }
        return dirtyFiles;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Set mapClassesFqNamesToFiles$default(Iterable iterable, Iterable iterable2, ICReporter iCReporter, Set set, int n, Object object) {
        if ((n & 8) != 0) {
            set = SetsKt.emptySet();
        }
        return BuildUtilKt.mapClassesFqNamesToFiles(iterable, iterable2, iCReporter, set);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<FqName> withSubtypes(@NotNull FqName typeFqName, @NotNull Iterable<? extends IncrementalCacheCommon> caches) {
        Collection collection;
        Intrinsics.checkParameterIsNotNull((Object)typeFqName, (String)"typeFqName");
        Intrinsics.checkParameterIsNotNull(caches, (String)"caches");
        LinkedList<FqName> types = new LinkedList<FqName>(CollectionsKt.listOf((Object)typeFqName));
        HashSet<FqName> subtypes = new HashSet<FqName>();
        while (!(collection = (Collection)types).isEmpty()) {
            void $receiver$iv;
            FqName unprocessedType = (FqName)types.pollFirst();
            Sequence sequence = SequencesKt.filter((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence(caches), (Function1)((Function1)new Function1<IncrementalCacheCommon, Sequence<? extends FqName>>(unprocessedType){
                final /* synthetic */ FqName $unprocessedType;

                @NotNull
                public final Sequence<FqName> invoke(@NotNull IncrementalCacheCommon it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    FqName fqName = this.$unprocessedType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)fqName, (String)"unprocessedType");
                    return it.getSubtypesOf(fqName);
                }
                {
                    this.$unprocessedType = fqName;
                    super(1);
                }
            })), (Function1)((Function1)new Function1<FqName, Boolean>(subtypes){
                final /* synthetic */ HashSet $subtypes;

                public final boolean invoke(@NotNull FqName it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return !this.$subtypes.contains(it);
                }
                {
                    this.$subtypes = hashSet;
                    super(1);
                }
            }));
            for (Object element$iv : $receiver$iv) {
                FqName it = (FqName)element$iv;
                types.addLast(it);
            }
            subtypes.add(unprocessedType);
        }
        return subtypes;
    }
}

