/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.build;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=2, xi=2, d1={"\u0000\u001a\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a$\u0010\u0000\u001a\u0004\u0018\u0001H\u0001\"\n\b\u0000\u0010\u0001\u0018\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0086\b\u00a2\u0006\u0002\u0010\u0005\u001a-\u0010\u0000\u001a\u0004\u0018\u0001H\u0001\"\b\b\u0000\u0010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0007\u00a2\u0006\u0002\u0010\b\u001a\"\u0010\t\u001a\u00020\u0004\"\n\b\u0000\u0010\u0001\u0018\u0001*\u00020\u00022\u0006\u0010\n\u001a\u0002H\u0001H\u0086\b\u00a2\u0006\u0002\u0010\u000b\u001a+\u0010\t\u001a\u00020\u0004\"\b\b\u0000\u0010\u0001*\u00020\u00022\u0006\u0010\n\u001a\u0002H\u00012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0007\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"deserializeFromPlainText", "T", "", "str", "", "(Ljava/lang/String;)Ljava/lang/Object;", "klass", "Lkotlin/reflect/KClass;", "(Ljava/lang/String;Lkotlin/reflect/KClass;)Ljava/lang/Object;", "serializeToPlainText", "instance", "(Ljava/lang/Object;)Ljava/lang/String;", "(Ljava/lang/Object;Lkotlin/reflect/KClass;)Ljava/lang/String;", "kotlin-build-common"})
public final class SerializationUtilsKt {
    private static final <T> String serializeToPlainText(T instance) {
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return SerializationUtilsKt.serializeToPlainText(instance, Reflection.getOrCreateKotlinClass(Object.class));
    }

    @NotNull
    public static final <T> String serializeToPlainText(@NotNull T instance, @NotNull KClass<T> klass) {
        Intrinsics.checkParameterIsNotNull(instance, (String)"instance");
        Intrinsics.checkParameterIsNotNull(klass, (String)"klass");
        ArrayList<String> lines = new ArrayList<String>();
        for (KProperty1 property : KClasses.getMemberProperties(klass)) {
            Object value = property.get(instance);
            if (value == null) continue;
            lines.add(property.getName() + '=' + value);
        }
        return CollectionsKt.joinToString$default((Iterable)lines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    private static final <T> T deserializeFromPlainText(String str) {
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return SerializationUtilsKt.deserializeFromPlainText(str, Reflection.getOrCreateKotlinClass(Object.class));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final <T> T deserializeFromPlainText(@NotNull String str, @NotNull KClass<T> klass) {
        void $receiver$iv;
        Iterator $receiver$iv$iv;
        Object object;
        Object element$iv$iv2;
        void $receiver$iv$iv2;
        Iterable $receiver$iv2;
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        Intrinsics.checkParameterIsNotNull(klass, (String)"klass");
        ArrayList<Integer> args = new ArrayList<Integer>();
        Iterable iterable = StringsKt.split$default((CharSequence)str, (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null);
        void var5_4 = $receiver$iv2;
        Iterable destination$iv$iv = new ArrayList();
        for (Object element$iv$iv2 : $receiver$iv$iv2) {
            String p1 = (String)element$iv$iv2;
            object = p1;
            if (!(!StringsKt.isBlank((CharSequence)object))) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        $receiver$iv2 = (List)destination$iv$iv;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10)), (int)16);
        destination$iv$iv = $receiver$iv2;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        element$iv$iv2 = $receiver$iv$iv.iterator();
        while (element$iv$iv2.hasNext()) {
            Object element$iv$iv3 = element$iv$iv2.next();
            object = destination$iv$iv2;
            String it = (String)element$iv$iv3;
            Pair pair = TuplesKt.to((Object)StringsKt.substringBefore$default((String)it, (String)"=", null, (int)2, null), (Object)StringsKt.substringAfter$default((String)it, (String)"=", null, (int)2, null));
            object.put(pair.getFirst(), pair.getSecond());
        }
        Map properties = destination$iv$iv2;
        KFunction kFunction = KClasses.getPrimaryConstructor(klass);
        if (kFunction == null) {
            throw (Throwable)new IllegalStateException(JvmClassMappingKt.getJavaClass(klass) + " does not have primary constructor");
        }
        KFunction primaryConstructor = kFunction;
        Iterable $receiver$iv3 = primaryConstructor.getParameters();
        element$iv$iv2 = $receiver$iv3;
        Object object2 = new Comparator<T>(){

            public final int compare(T a, T b) {
                KParameter it = (KParameter)a;
                Comparable comparable = Integer.valueOf(it.getIndex());
                it = (KParameter)b;
                Comparable comparable2 = comparable;
                Integer n = it.getIndex();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        };
        $receiver$iv$iv = CollectionsKt.sortedWith((Iterable)element$iv$iv2, (Comparator)object2).iterator();
        while ($receiver$iv$iv.hasNext()) {
            Object object3;
            element$iv$iv2 = properties;
            KParameter param = (KParameter)$receiver$iv$iv.next();
            object2 = param.getName();
            String argumentString = (String)element$iv$iv2.get(object2);
            if (argumentString == null) {
                if (param.getType().isMarkedNullable()) {
                    args.add(null);
                    continue;
                }
                return null;
            }
            object2 = param.getType().getClassifier();
            if (Intrinsics.areEqual((Object)object2, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                object = argumentString;
                object3 = Integer.parseInt((String)object);
            } else if (Intrinsics.areEqual((Object)object2, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                object = argumentString;
                object3 = Boolean.parseBoolean((String)object);
            } else if (Intrinsics.areEqual((Object)object2, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                object3 = argumentString;
            } else {
                throw (Throwable)new IllegalStateException("Unexpected property type: " + param.getType());
            }
            Integer argument = object3;
            args.add(argument);
        }
        Collection param = args;
        KFunction kFunction2 = primaryConstructor;
        void thisCollection$iv = $receiver$iv;
        Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
        if (objectArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] objectArray2 = objectArray;
        return (T)kFunction2.call(Arrays.copyOf(objectArray2, objectArray2.length));
    }
}

