/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.assignment.plugin.k2.diagnostics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.assignment.plugin.AssignmentPluginNames;
import org.jetbrains.kotlin.assignment.plugin.k2.FirAssignAnnotationMatchingServiceKt;
import org.jetbrains.kotlin.assignment.plugin.k2.diagnostics.FirErrorsAssignmentPlugin;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeAmbiguityError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeDiagnosticWithSingleCandidate;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\f\u001a\u00020\r*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\f\u0010\u0010\u001a\u00020\r*\u00020\u0002H\u0002J\f\u0010\u0011\u001a\u00020\r*\u00020\u0002H\u0002J\u0014\u0010\u0012\u001a\u00020\r*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u0010\u0013\u001a\u00020\r*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\f\u0010\u0014\u001a\u00020\r*\u00020\u0002H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/assignment/plugin/k2/diagnostics/FirAssignmentPluginFunctionCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isAnnotated", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isFunctionResolveError", "isOverloadAssignCallCandidate", "isOverloadedAssignCall", "isOverloadedAssignCallError", "isReturnTypeUnit", "kotlin-assignment-compiler-plugin.k2"})
public final class FirAssignmentPluginFunctionCallChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirAssignmentPluginFunctionCallChecker INSTANCE = new FirAssignmentPluginFunctionCallChecker();

    private FirAssignmentPluginFunctionCallChecker() {
    }

    public void check(@NotNull FirFunctionCall expression, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!this.isOverloadAssignCallCandidate(expression)) {
            return;
        }
        if (this.isFunctionResolveError(expression)) {
            if (this.isOverloadedAssignCallError(expression, context.getSession())) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)expression.getSource()), (KtDiagnosticFactory0)FirErrorsAssignmentPlugin.INSTANCE.getNO_APPLICABLE_ASSIGN_METHOD(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
            }
        } else if (this.isOverloadedAssignCall(expression, context.getSession()) && !this.isReturnTypeUnit(expression)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)expression.getSource()), (KtDiagnosticFactory0)FirErrorsAssignmentPlugin.INSTANCE.getCALL_ERROR_ASSIGN_METHOD_SHOULD_RETURN_UNIT(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isOverloadAssignCallCandidate(FirFunctionCall $this$isOverloadAssignCallCandidate) {
        FirCall $this$arguments$iv = (FirCall)$this$isOverloadAssignCallCandidate;
        boolean $i$f$getArguments = false;
        if ($this$arguments$iv.getArgumentList().getArguments().size() != 1) return false;
        KtSourceElement ktSourceElement = $this$isOverloadAssignCallCandidate.getSource();
        if (!Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.DesugaredCompoundAssignment.INSTANCE)) return false;
        return true;
    }

    private final boolean isFunctionResolveError(FirFunctionCall $this$isFunctionResolveError) {
        return $this$isFunctionResolveError.getCalleeReference() instanceof FirErrorNamedReference;
    }

    private final boolean isOverloadedAssignCallError(FirFunctionCall $this$isOverloadedAssignCallError, FirSession session) {
        ConeDiagnostic diagnostic;
        FirNamedReference firNamedReference = $this$isOverloadedAssignCallError.getCalleeReference();
        FirErrorNamedReference firErrorNamedReference = firNamedReference instanceof FirErrorNamedReference ? (FirErrorNamedReference)firNamedReference : null;
        Object object = diagnostic = firErrorNamedReference != null ? firErrorNamedReference.getDiagnostic() : null;
        Name functionName = diagnostic instanceof ConeAmbiguityError ? ((ConeAmbiguityError)diagnostic).getName() : (diagnostic instanceof ConeDiagnosticWithSingleCandidate ? ((ConeDiagnosticWithSingleCandidate)diagnostic).getCandidate().getCallInfo().getName() : (diagnostic instanceof ConeUnresolvedNameError ? ((ConeUnresolvedNameError)diagnostic).getName() : $this$isOverloadedAssignCallError.getCalleeReference().getName()));
        return Intrinsics.areEqual((Object)functionName, (Object)AssignmentPluginNames.INSTANCE.getASSIGN_METHOD()) && this.isAnnotated($this$isOverloadedAssignCallError, session);
    }

    private final boolean isOverloadedAssignCall(FirFunctionCall $this$isOverloadedAssignCall, FirSession session) {
        return Intrinsics.areEqual((Object)$this$isOverloadedAssignCall.getCalleeReference().getName(), (Object)AssignmentPluginNames.INSTANCE.getASSIGN_METHOD()) && this.isAnnotated($this$isOverloadedAssignCall, session);
    }

    private final boolean isAnnotated(FirFunctionCall $this$isAnnotated, FirSession session) {
        FirExpression firExpression;
        return FirAssignAnnotationMatchingServiceKt.getAnnotationMatchingService(session).isAnnotated((firExpression = $this$isAnnotated.getExplicitReceiver()) != null && (firExpression = firExpression.getTypeRef()) != null ? FirHelpersKt.toRegularClassSymbol((FirTypeRef)firExpression, (FirSession)session) : null);
    }

    private final boolean isReturnTypeUnit(FirFunctionCall $this$isReturnTypeUnit) {
        FirCallableSymbol firCallableSymbol = FirExpressionUtilKt.toResolvedCallableSymbol((FirExpression)((FirExpression)$this$isReturnTypeUnit));
        return firCallableSymbol != null && (firCallableSymbol = firCallableSymbol.getResolvedReturnType()) != null ? ConeBuiltinTypeUtilsKt.isUnit((ConeKotlinType)firCallableSymbol) : false;
    }
}

