/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.providers;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.components.KaPsiTypeProviderMixIn;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaTypeParameterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtCallableSymbolKt;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.analysis.api.types.KaTypeMappingMode;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\u000b\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\r\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000eH\u0002JB\u0010\u000f\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00052\b\b\u0002\u0010\u0017\u001a\u00020\u0005H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/analysis/providers/PsiDeclarationAndKtSymbolEqualityChecker;", "", "<init>", "()V", "representsTheSameDeclaration", "", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "psi", "Lcom/intellij/psi/PsiMethod;", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol;", "returnTypesMatch", "typeParametersMatch", "valueParametersMatch", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaFunctionLikeSymbol;", "isTheSameTypes", "context", "Lcom/intellij/psi/PsiType;", "ktType", "Lorg/jetbrains/kotlin/analysis/api/types/KaType;", "mode", "Lorg/jetbrains/kotlin/analysis/api/types/KaTypeMappingMode;", "isVararg", "isVarargs", "symbol-light-classes"})
@SourceDebugExtension(value={"SMAP\nPsiDeclarationAndKtSymbolEqualityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PsiDeclarationAndKtSymbolEqualityChecker.kt\norg/jetbrains/kotlin/analysis/providers/PsiDeclarationAndKtSymbolEqualityChecker\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n23332#2,8:109\n1#3:117\n1872#4,3:118\n*S KotlinDebug\n*F\n+ 1 PsiDeclarationAndKtSymbolEqualityChecker.kt\norg/jetbrains/kotlin/analysis/providers/PsiDeclarationAndKtSymbolEqualityChecker\n*L\n44#1:109,8\n59#1:118,3\n*E\n"})
public final class PsiDeclarationAndKtSymbolEqualityChecker {
    @NotNull
    public static final PsiDeclarationAndKtSymbolEqualityChecker INSTANCE = new PsiDeclarationAndKtSymbolEqualityChecker();

    private PsiDeclarationAndKtSymbolEqualityChecker() {
    }

    public final boolean representsTheSameDeclaration(@NotNull KaSession $this$representsTheSameDeclaration, @NotNull PsiMethod psi, @NotNull KaCallableSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)$this$representsTheSameDeclaration, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        if (!this.returnTypesMatch($this$representsTheSameDeclaration, psi, symbol)) {
            return false;
        }
        if (!this.typeParametersMatch(psi, symbol)) {
            return false;
        }
        return !(symbol instanceof KaFunctionLikeSymbol) || this.valueParametersMatch($this$representsTheSameDeclaration, psi, (KaFunctionLikeSymbol)symbol);
    }

    private final boolean returnTypesMatch(KaSession $this$returnTypesMatch, PsiMethod psi, KaCallableSymbol symbol) {
        boolean bl;
        if (symbol instanceof KaConstructorSymbol) {
            return true;
        }
        PsiType psiType = psi.getReturnType();
        if (psiType != null) {
            PsiType it = psiType;
            boolean bl2 = false;
            bl = PsiDeclarationAndKtSymbolEqualityChecker.isTheSameTypes$default(INSTANCE, $this$returnTypesMatch, psi, it, symbol.getReturnType(), KaTypeMappingMode.RETURN_TYPE, false, false, 48, null);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean typeParametersMatch(PsiMethod psi, KaCallableSymbol symbol) {
        void $this$zip$iv;
        if (psi.getTypeParameters().length != symbol.getTypeParameters().size()) {
            return false;
        }
        PsiTypeParameter[] psiTypeParameterArray = psi.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiTypeParameterArray, (String)"getTypeParameters(...)");
        Object[] objectArray = psiTypeParameterArray;
        Iterable other$iv = symbol.getTypeParameters();
        boolean $i$f$zip = false;
        int arraySize$iv = ((void)$this$zip$iv).length;
        ArrayList<Unit> list$iv = new ArrayList<Unit>(Math.min(CollectionsKt.collectionSizeOrDefault((Iterable)other$iv, (int)10), arraySize$iv));
        int i$iv = 0;
        for (Object element$iv : other$iv) {
            void typeParameterSymbol;
            void psiTypeParameter;
            if (i$iv >= arraySize$iv) break;
            int n = i$iv++;
            KaTypeParameterSymbol kaTypeParameterSymbol = (KaTypeParameterSymbol)element$iv;
            PsiTypeParameter psiTypeParameter2 = (PsiTypeParameter)$this$zip$iv[n];
            ArrayList<Unit> arrayList = list$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)psiTypeParameter.getName(), (Object)typeParameterSymbol.getName().asString())) {
                return false;
            }
            arrayList.add(Unit.INSTANCE);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean valueParametersMatch(KaSession $this$valueParametersMatch, PsiMethod psi, KaFunctionLikeSymbol symbol) {
        int valueParameterCount;
        int n = valueParameterCount = symbol.isExtension() ? symbol.getValueParameters().size() + 1 : symbol.getValueParameters().size();
        if (psi.getParameterList().getParametersCount() != valueParameterCount) {
            return false;
        }
        if (symbol.isExtension()) {
            boolean bl;
            PsiParameter psiParameter = psi.getParameterList().getParameters()[0];
            KaType kaType = KtCallableSymbolKt.getReceiverType(symbol);
            if (kaType != null) {
                KaType it = kaType;
                boolean bl2 = false;
                PsiType psiType = psiParameter.getType();
                Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getType(...)");
                bl = PsiDeclarationAndKtSymbolEqualityChecker.isTheSameTypes$default(INSTANCE, $this$valueParametersMatch, psi, psiType, it, null, false, false, 56, null);
            } else {
                bl = false;
            }
            if (!bl) {
                return false;
            }
        }
        int offset = symbol.isExtension() ? 1 : 0;
        Iterable $this$forEachIndexed$iv = symbol.getValueParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void valueParameterSymbol;
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            KaValueParameterSymbol kaValueParameterSymbol = (KaValueParameterSymbol)item$iv;
            int index = n2;
            boolean bl = false;
            PsiParameter psiParameter = psi.getParameterList().getParameters()[index + offset];
            if (psiParameter.isVarArgs() && !valueParameterSymbol.isVararg()) {
                return false;
            }
            PsiType psiType = psiParameter.getType();
            Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getType(...)");
            if (INSTANCE.isTheSameTypes($this$valueParametersMatch, psi, psiType, valueParameterSymbol.getReturnType(), KaTypeMappingMode.VALUE_PARAMETER, valueParameterSymbol.isVararg(), psiParameter.isVarArgs())) continue;
            return false;
        }
        return true;
    }

    private final boolean isTheSameTypes(KaSession $this$isTheSameTypes, PsiMethod context, PsiType psi, KaType ktType, KaTypeMappingMode mode, boolean isVararg, boolean isVarargs) {
        if (Intrinsics.areEqual((Object)psi, (Object)PsiType.VOID) && $this$isTheSameTypes.isUnit(ktType)) {
            return true;
        }
        PsiType psiType = KaPsiTypeProviderMixIn.asPsiType$default($this$isTheSameTypes, ktType, (PsiElement)context, true, mode, false, null, false, 56, null);
        if (psiType == null) {
            return false;
        }
        PsiType ktTypeRendered = psiType;
        return isVararg ? (isVarargs ? Intrinsics.areEqual((Object)new PsiEllipsisType(ktTypeRendered), (Object)psi) : Intrinsics.areEqual((Object)new PsiArrayType(ktTypeRendered), (Object)psi)) : Intrinsics.areEqual((Object)ktTypeRendered, (Object)psi);
    }

    static /* synthetic */ boolean isTheSameTypes$default(PsiDeclarationAndKtSymbolEqualityChecker psiDeclarationAndKtSymbolEqualityChecker, KaSession kaSession, PsiMethod psiMethod, PsiType psiType, KaType kaType, KaTypeMappingMode kaTypeMappingMode, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            kaTypeMappingMode = KaTypeMappingMode.DEFAULT;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        return psiDeclarationAndKtSymbolEqualityChecker.isTheSameTypes(kaSession, psiMethod, psiType, kaType, kaTypeMappingMode, bl, bl2);
    }
}

