/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.evaluate;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.annotations.KaAnnotationApplicationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KaAnnotationApplicationWithArgumentsInfo;
import org.jetbrains.kotlin.analysis.api.annotations.KaAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KaArrayAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KaConstantAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KaEnumEntryAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KaKClassAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KaNamedAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KaUnsupportedAnnotationValue;
import org.jetbrains.kotlin.analysis.api.base.KaConstantValue;
import org.jetbrains.kotlin.analysis.api.base.KaConstantValueFactory;
import org.jetbrains.kotlin.analysis.api.components.KaConstantEvaluationMode;
import org.jetbrains.kotlin.analysis.api.fir.KaFirSession;
import org.jetbrains.kotlin.analysis.api.fir.KaSymbolByFirBuilder;
import org.jetbrains.kotlin.analysis.api.fir.evaluate.FirCompileTimeConstantEvaluator;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeToken;
import org.jetbrains.kotlin.analysis.api.symbols.KaConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.pointers.KaSymbolPointer;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirArrayLiteral;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirEnumEntryDeserializedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirSpreadArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedSymbolError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedTypeQualifierError;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.ArrayFqNames;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002J.\u0010\u0012\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0013*\b\u0012\u0004\u0012\u00020\f0\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0015*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/evaluate/FirAnnotationValueConverter;", "", "<init>", "()V", "toNamedConstantValue", "", "Lorg/jetbrains/kotlin/analysis/api/annotations/KaNamedAnnotationValue;", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "argumentMapping", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "builder", "Lorg/jetbrains/kotlin/analysis/api/fir/KaSymbolByFirBuilder;", "convertConstantExpression", "Lorg/jetbrains/kotlin/analysis/api/annotations/KaConstantAnnotationValue;", "Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;", "convertVarargsExpression", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotationValue;", "Lorg/jetbrains/kotlin/psi/KtElement;", "toConstantValue", "firExpression", "computeErrorCallClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "call", "Lorg/jetbrains/kotlin/fir/expressions/FirGetClassCall;", "analysis-api-fir"})
@SourceDebugExtension(value={"SMAP\nFirAnnotationValueConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirAnnotationValueConverter.kt\norg/jetbrains/kotlin/analysis/api/fir/evaluate/FirAnnotationValueConverter\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,240:1\n126#2:241\n153#2,3:242\n1#3:245\n57#4,4:246\n1863#5,2:250\n*S KotlinDebug\n*F\n+ 1 FirAnnotationValueConverter.kt\norg/jetbrains/kotlin/analysis/api/fir/evaluate/FirAnnotationValueConverter\n*L\n43#1:241\n43#1:242,3\n139#1:246,4\n139#1:250,2\n*E\n"})
public final class FirAnnotationValueConverter {
    @NotNull
    public static final FirAnnotationValueConverter INSTANCE = new FirAnnotationValueConverter();

    private FirAnnotationValueConverter() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<KaNamedAnnotationValue> toNamedConstantValue(@NotNull KaSession analysisSession, @NotNull Map<Name, ? extends FirExpression> argumentMapping, @NotNull KaSymbolByFirBuilder builder2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        Intrinsics.checkNotNullParameter(argumentMapping, (String)"argumentMapping");
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Map<Name, ? extends FirExpression> $this$map$iv = argumentMapping;
        boolean $i$f$map = false;
        Map<Name, ? extends FirExpression> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Name name = (Name)entry.getKey();
            FirExpression expression = (FirExpression)entry.getValue();
            KaAnnotationValue kaAnnotationValue = INSTANCE.convertConstantExpression(expression, builder2);
            if (kaAnnotationValue == null) {
                kaAnnotationValue = new KaUnsupportedAnnotationValue(analysisSession.getToken());
            }
            collection.add(new KaNamedAnnotationValue(name, kaAnnotationValue, analysisSession.getToken()));
        }
        return (List)destination$iv$iv;
    }

    private final KaConstantAnnotationValue convertConstantExpression(FirLiteralExpression $this$convertConstantExpression, KaSession analysisSession) {
        KaConstantAnnotationValue kaConstantAnnotationValue;
        KaConstantValue constantValue;
        KaConstantValue kaConstantValue;
        PsiElement psiElement = UtilsKt.getPsi((FirElement)((FirElement)$this$convertConstantExpression));
        KtElement expression = psiElement instanceof KtElement ? (KtElement)psiElement : null;
        ConeKotlinType type = $this$convertConstantExpression.getConeTypeOrNull();
        if ($this$convertConstantExpression.getValue() == null) {
            kaConstantValue = new KaConstantValue.KaNullConstantValue(expression);
        } else if (type == null) {
            PsiElement psiElement2;
            kaConstantValue = KaConstantValueFactory.INSTANCE.createConstantValue($this$convertConstantExpression.getValue(), (psiElement2 = UtilsKt.getPsi((FirElement)((FirElement)$this$convertConstantExpression))) instanceof KtElement ? (KtElement)psiElement2 : null);
        } else if (ConeBuiltinTypeUtilsKt.isBoolean((ConeKotlinType)type)) {
            Object object = $this$convertConstantExpression.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
            kaConstantValue = new KaConstantValue.KaBooleanConstantValue((Boolean)object, expression);
        } else if (ConeBuiltinTypeUtilsKt.isChar((ConeKotlinType)type)) {
            char c;
            Object object = $this$convertConstantExpression.getValue();
            Character c2 = object instanceof Character ? (Character)object : null;
            if (c2 != null) {
                c = c2.charValue();
            } else {
                Object object2 = $this$convertConstantExpression.getValue();
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Number");
                c = (char)((Number)object2).intValue();
            }
            kaConstantValue = new KaConstantValue.KaCharConstantValue(c, expression);
        } else if (ConeBuiltinTypeUtilsKt.isByte((ConeKotlinType)type)) {
            Object object = $this$convertConstantExpression.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
            kaConstantValue = new KaConstantValue.KaByteConstantValue(((Number)object).byteValue(), expression);
        } else if (ConeBuiltinTypeUtilsKt.isUByte((ConeKotlinType)type)) {
            Object object = $this$convertConstantExpression.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
            kaConstantValue = new KaConstantValue.KaUnsignedByteConstantValue(UByte.constructor-impl((byte)((Number)object).byteValue()), expression, null);
        } else if (ConeBuiltinTypeUtilsKt.isShort((ConeKotlinType)type)) {
            Object object = $this$convertConstantExpression.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
            kaConstantValue = new KaConstantValue.KaShortConstantValue(((Number)object).shortValue(), expression);
        } else if (ConeBuiltinTypeUtilsKt.isUShort((ConeKotlinType)type)) {
            Object object = $this$convertConstantExpression.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
            kaConstantValue = new KaConstantValue.KaUnsignedShortConstantValue(UShort.constructor-impl((short)((Number)object).shortValue()), expression, null);
        } else if (ConeBuiltinTypeUtilsKt.isInt((ConeKotlinType)type)) {
            Object object = $this$convertConstantExpression.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
            kaConstantValue = new KaConstantValue.KaIntConstantValue(((Number)object).intValue(), expression);
        } else if (ConeBuiltinTypeUtilsKt.isUInt((ConeKotlinType)type)) {
            Object object = $this$convertConstantExpression.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
            kaConstantValue = new KaConstantValue.KaUnsignedIntConstantValue(UInt.constructor-impl((int)((Number)object).intValue()), expression, null);
        } else if (ConeBuiltinTypeUtilsKt.isLong((ConeKotlinType)type)) {
            Object object = $this$convertConstantExpression.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
            kaConstantValue = new KaConstantValue.KaLongConstantValue(((Number)object).longValue(), expression);
        } else if (ConeBuiltinTypeUtilsKt.isULong((ConeKotlinType)type)) {
            Object object = $this$convertConstantExpression.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
            kaConstantValue = new KaConstantValue.KaUnsignedLongConstantValue(ULong.constructor-impl((long)((Number)object).longValue()), expression, null);
        } else if (ConeBuiltinTypeUtilsKt.isString((ConeKotlinType)type)) {
            kaConstantValue = new KaConstantValue.KaStringConstantValue(String.valueOf($this$convertConstantExpression.getValue()), expression);
        } else if (ConeBuiltinTypeUtilsKt.isFloat((ConeKotlinType)type)) {
            Object object = $this$convertConstantExpression.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
            kaConstantValue = new KaConstantValue.KaFloatConstantValue(((Number)object).floatValue(), expression);
        } else if (ConeBuiltinTypeUtilsKt.isDouble((ConeKotlinType)type)) {
            Object object = $this$convertConstantExpression.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
            kaConstantValue = new KaConstantValue.KaDoubleConstantValue(((Number)object).doubleValue(), expression);
        } else {
            kaConstantValue = null;
        }
        KaConstantValue kaConstantValue2 = constantValue = kaConstantValue;
        if (kaConstantValue2 != null) {
            KaConstantValue it = kaConstantValue2;
            boolean bl = false;
            kaConstantAnnotationValue = new KaConstantAnnotationValue(it, analysisSession.getToken());
        } else {
            kaConstantAnnotationValue = null;
        }
        return kaConstantAnnotationValue;
    }

    private final Pair<Collection<KaAnnotationValue>, KtElement> convertVarargsExpression(Collection<? extends FirExpression> $this$convertVarargsExpression, KaSymbolByFirBuilder builder2) {
        List list;
        KtElement representativePsi = null;
        List $this$convertVarargsExpression_u24lambda_u242 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (FirExpression firExpression : $this$convertVarargsExpression) {
            KaAnnotationValue converted;
            if (INSTANCE.convertConstantExpression(firExpression, builder2) == null) continue;
            boolean bl2 = (firExpression instanceof FirSpreadArgumentExpression || firExpression instanceof FirNamedArgumentExpression) && converted instanceof KaArrayAnnotationValue ? $this$convertVarargsExpression_u24lambda_u242.addAll(((KaArrayAnnotationValue)converted).getValues()) : $this$convertVarargsExpression_u24lambda_u242.add(converted);
            KtElement ktElement = representativePsi;
            if (ktElement == null) {
                ktElement = converted.getSourcePsi();
            }
            representativePsi = ktElement;
        }
        List flattenedVarargs = CollectionsKt.build((List)list);
        return TuplesKt.to((Object)flattenedVarargs, representativePsi);
    }

    @Nullable
    public final KaAnnotationValue toConstantValue(@NotNull FirExpression firExpression, @NotNull KaSymbolByFirBuilder builder2) {
        Intrinsics.checkNotNullParameter((Object)firExpression, (String)"firExpression");
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        return this.convertConstantExpression(firExpression, builder2);
    }

    private final KaAnnotationValue convertConstantExpression(FirExpression $this$convertConstantExpression, KaSymbolByFirBuilder builder2) {
        KaAnnotationValue kaAnnotationValue;
        KaAnnotationValue kaAnnotationValue2;
        KaLifetimeToken token = builder2.getAnalysisSession().getToken();
        PsiElement psiElement = UtilsKt.getPsi((FirElement)((FirElement)$this$convertConstantExpression));
        KtElement sourcePsi = psiElement instanceof KtElement ? (KtElement)psiElement : null;
        FirExpression firExpression = $this$convertConstantExpression;
        if (firExpression instanceof FirLiteralExpression) {
            kaAnnotationValue2 = this.convertConstantExpression((FirLiteralExpression)$this$convertConstantExpression, builder2.getAnalysisSession());
        } else if (firExpression instanceof FirNamedArgumentExpression) {
            kaAnnotationValue2 = this.convertConstantExpression(((FirNamedArgumentExpression)$this$convertConstantExpression).getExpression(), builder2);
        } else if (firExpression instanceof FirSpreadArgumentExpression) {
            kaAnnotationValue2 = this.convertConstantExpression(((FirSpreadArgumentExpression)$this$convertConstantExpression).getExpression(), builder2);
        } else if (firExpression instanceof FirVarargArgumentsExpression) {
            Pair<Collection<KaAnnotationValue>, KtElement> pair = this.convertVarargsExpression(((FirVarargArgumentsExpression)$this$convertConstantExpression).getArguments(), builder2);
            Collection annotationValues = (Collection)pair.component1();
            KtElement representativePsi = (KtElement)pair.component2();
            KtElement ktElement = representativePsi;
            if (ktElement == null) {
                ktElement = sourcePsi;
            }
            kaAnnotationValue2 = new KaArrayAnnotationValue(annotationValues, ktElement, token);
        } else if (firExpression instanceof FirArrayLiteral) {
            kaAnnotationValue2 = new KaArrayAnnotationValue((Collection)this.convertVarargsExpression(((FirArrayLiteral)$this$convertConstantExpression).getArgumentList().getArguments(), builder2).getFirst(), sourcePsi, token);
        } else if (firExpression instanceof FirFunctionCall) {
            FirNamedReference representativePsi = ((FirFunctionCall)$this$convertConstantExpression).getCalleeReference();
            FirResolvedNamedReference firResolvedNamedReference = representativePsi instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)representativePsi : null;
            if (firResolvedNamedReference == null) {
                return null;
            }
            FirResolvedNamedReference reference = firResolvedNamedReference;
            FirBasedSymbol resolvedSymbol = reference.getResolvedSymbol();
            if (resolvedSymbol instanceof FirConstructorSymbol) {
                KaAnnotationApplicationValue kaAnnotationApplicationValue;
                FirClassLikeSymbol firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol((FirBasedSymbol)resolvedSymbol, (FirSession)builder2.getRootSession());
                if (firClassLikeSymbol == null) {
                    return null;
                }
                FirClassLikeSymbol classSymbol = firClassLikeSymbol;
                FirDeclaration firDeclaration = classSymbol.getFir();
                FirClass firClass = firDeclaration instanceof FirClass ? (FirClass)firDeclaration : null;
                if ((firClass != null ? firClass.getClassKind() : null) == ClassKind.ANNOTATION_CLASS) {
                    KaFirSession $this$resolvedArgumentMapping$iv;
                    Map resultMap = new LinkedHashMap();
                    FirCall firCall = (FirCall)$this$convertConstantExpression;
                    boolean $i$f$getResolvedArgumentMapping = false;
                    FirArgumentList argumentList$iv = $this$resolvedArgumentMapping$iv.getArgumentList();
                    LinkedHashMap linkedHashMap = argumentList$iv instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList$iv).getMapping() : null;
                    Object object = linkedHashMap;
                    if (linkedHashMap != null && (object = ((LinkedHashMap)object).entrySet()) != null) {
                        Iterable $this$forEach$iv = (Iterable)object;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            Map.Entry entry = (Map.Entry)element$iv;
                            boolean bl = false;
                            Intrinsics.checkNotNull((Object)entry);
                            Object k = entry.getKey();
                            Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
                            FirExpression arg = (FirExpression)k;
                            Object v = entry.getValue();
                            Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
                            FirValueParameter param = (FirValueParameter)v;
                            resultMap.put(param.getName(), arg);
                        }
                    }
                    KtCallElement ktCallElement = (firDeclaration = UtilsKt.getPsi((FirElement)((FirElement)$this$convertConstantExpression))) instanceof KtCallElement ? (KtCallElement)firDeclaration : null;
                    $this$resolvedArgumentMapping$iv = builder2.getAnalysisSession();
                    Integer n = null;
                    List<KaNamedAnnotationValue> list = this.toNamedConstantValue(builder2.getAnalysisSession(), resultMap, builder2);
                    AnnotationUseSiteTarget annotationUseSiteTarget = null;
                    KtCallElement ktCallElement2 = ktCallElement;
                    ClassId classId = ((FirConstructorSymbol)resolvedSymbol).getCallableId().getClassId();
                    boolean bl = false;
                    KaSymbolPointer<KaConstructorSymbol> kaSymbolPointer = builder2.getFunctionLikeBuilder().buildConstructorSymbol((FirConstructorSymbol)resolvedSymbol).createPointer();
                    KaLifetimeToken kaLifetimeToken = token;
                    KaSymbolPointer<KaConstructorSymbol> kaSymbolPointer2 = kaSymbolPointer;
                    Integer n2 = n;
                    List<KaNamedAnnotationValue> list2 = list;
                    AnnotationUseSiteTarget annotationUseSiteTarget2 = annotationUseSiteTarget;
                    KtCallElement ktCallElement3 = ktCallElement2;
                    ClassId classId2 = classId;
                    KaLifetimeToken kaLifetimeToken2 = token;
                    KaAnnotationApplicationWithArgumentsInfo kaAnnotationApplicationWithArgumentsInfo = new KaAnnotationApplicationWithArgumentsInfo(classId2, ktCallElement3, annotationUseSiteTarget2, list2, n2, kaSymbolPointer2, kaLifetimeToken);
                    kaAnnotationApplicationValue = new KaAnnotationApplicationValue(kaAnnotationApplicationWithArgumentsInfo, kaLifetimeToken2);
                } else {
                    kaAnnotationApplicationValue = null;
                }
                kaAnnotationValue2 = kaAnnotationApplicationValue;
            } else if (resolvedSymbol instanceof FirNamedFunctionSymbol) {
                if (ArrayFqNames.ARRAY_CALL_FQ_NAMES.contains(((FirNamedFunctionSymbol)resolvedSymbol).getCallableId().asSingleFqName())) {
                    kaAnnotationValue2 = (FirExpression)CollectionsKt.singleOrNull((List)((FirFunctionCall)$this$convertConstantExpression).getArgumentList().getArguments());
                    if (kaAnnotationValue2 == null || (kaAnnotationValue2 = this.convertConstantExpression((FirExpression)kaAnnotationValue2, builder2)) == null) {
                        kaAnnotationValue2 = new KaArrayAnnotationValue(CollectionsKt.emptyList(), sourcePsi, token);
                    }
                } else {
                    kaAnnotationValue2 = null;
                }
            } else {
                kaAnnotationValue2 = resolvedSymbol instanceof FirEnumEntrySymbol ? (KaAnnotationValue)new KaEnumEntryAnnotationValue(((FirEnumEntrySymbol)resolvedSymbol).getCallableId(), sourcePsi, token) : null;
            }
        } else if (firExpression instanceof FirPropertyAccessExpression) {
            FirReference classSymbol = ((FirPropertyAccessExpression)$this$convertConstantExpression).getCalleeReference();
            FirResolvedNamedReference firResolvedNamedReference = classSymbol instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)classSymbol : null;
            if (firResolvedNamedReference == null) {
                return null;
            }
            FirResolvedNamedReference reference = firResolvedNamedReference;
            FirBasedSymbol resolvedSymbol = reference.getResolvedSymbol();
            kaAnnotationValue2 = resolvedSymbol instanceof FirEnumEntrySymbol ? new KaEnumEntryAnnotationValue(((FirEnumEntrySymbol)resolvedSymbol).getCallableId(), sourcePsi, token) : null;
        } else if (firExpression instanceof FirEnumEntryDeserializedAccessExpression) {
            kaAnnotationValue2 = new KaEnumEntryAnnotationValue(new CallableId(((FirEnumEntryDeserializedAccessExpression)$this$convertConstantExpression).getEnumClassId(), ((FirEnumEntryDeserializedAccessExpression)$this$convertConstantExpression).getEnumEntryName()), sourcePsi, token);
        } else if (firExpression instanceof FirGetClassCall) {
            KaKClassAnnotationValue kaKClassAnnotationValue;
            ConeKotlinType coneType;
            ConeKotlinType coneKotlinType = FirAnnotationUtilsKt.getTargetType((FirGetClassCall)((FirGetClassCall)$this$convertConstantExpression));
            ConeKotlinType coneKotlinType2 = coneType = coneKotlinType != null ? TypeExpansionUtilsKt.fullyExpandedType((ConeKotlinType)coneKotlinType, (FirSession)builder2.getRootSession()) : null;
            if (coneType instanceof ConeClassLikeType && !(coneType instanceof ConeErrorType)) {
                ClassId classId = ((ConeClassLikeType)coneType).getLookupTag().getClassId();
                KaType type = builder2.getTypeBuilder().buildKtType(coneType);
                kaKClassAnnotationValue = new KaKClassAnnotationValue(type, classId, sourcePsi, token);
            } else {
                ConeDiagnostic coneDiagnostic;
                ClassId classId;
                ClassId classId3 = classId = this.computeErrorCallClassId((FirGetClassCall)$this$convertConstantExpression);
                if (classId3 != null) {
                    ClassId p0 = classId3;
                    boolean bl = false;
                    coneDiagnostic = (ConeDiagnostic)new ConeUnresolvedSymbolError(p0);
                } else {
                    coneDiagnostic = (ConeDiagnostic)new ConeSimpleDiagnostic("Unresolved class reference", null, 2, null);
                }
                ConeDiagnostic diagnostic = coneDiagnostic;
                KaType errorType = builder2.getTypeBuilder().buildKtType((ConeKotlinType)new ConeErrorType(diagnostic, false, null, null, null, 30, null));
                kaKClassAnnotationValue = new KaKClassAnnotationValue(errorType, classId, sourcePsi, token);
            }
            kaAnnotationValue2 = kaKClassAnnotationValue;
        } else {
            kaAnnotationValue2 = kaAnnotationValue = null;
        }
        if (kaAnnotationValue2 == null) {
            firExpression = FirCompileTimeConstantEvaluator.INSTANCE.evaluate((FirElement)$this$convertConstantExpression, KaConstantEvaluationMode.CONSTANT_EXPRESSION_EVALUATION);
            kaAnnotationValue = firExpression != null ? this.convertConstantExpression((FirLiteralExpression)firExpression, builder2.getAnalysisSession()) : null;
        }
        return kaAnnotationValue;
    }

    private final ClassId computeErrorCallClassId(FirGetClassCall call) {
        FqNameUnsafe fqNameUnsafe;
        String fqNameString;
        List list;
        List qualifierParts = new ArrayList();
        FirAnnotationValueConverter.computeErrorCallClassId$process(qualifierParts, call.getArgument());
        List it = list = CollectionsKt.filterNotNull((Iterable)CollectionsKt.asReversedMutable((List)qualifierParts));
        boolean bl = false;
        List list2 = !((Collection)it).isEmpty() ? list : null;
        String string = fqNameString = list2 != null ? CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)".", null, null, (int)0, null, null, (int)62, null) : null;
        if (fqNameString != null && (fqNameUnsafe = new FqNameUnsafe(fqNameString)).isSafe()) {
            FqName fqName = fqNameUnsafe.toSafe();
            Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"toSafe(...)");
            return ClassId.Companion.topLevel(fqName);
        }
        return null;
    }

    private static final void computeErrorCallClassId$process(List<String> qualifierParts, FirExpression expression) {
        block1: {
            ConeDiagnostic diagnostic;
            ConeErrorType errorType;
            ConeKotlinType coneKotlinType = FirTypeUtilsKt.getResolvedType((FirExpression)expression);
            ConeErrorType coneErrorType = errorType = coneKotlinType instanceof ConeErrorType ? (ConeErrorType)coneKotlinType : null;
            Object object = diagnostic = coneErrorType != null ? coneErrorType.getDiagnostic() : null;
            String unresolvedName = diagnostic instanceof ConeUnresolvedTypeQualifierError ? ((ConeUnresolvedTypeQualifierError)diagnostic).getQualifier() : (diagnostic instanceof ConeUnresolvedNameError ? ((ConeUnresolvedNameError)diagnostic).getQualifier() : null);
            ((Collection)qualifierParts).add(unresolvedName);
            if (errorType == null || !(expression instanceof FirPropertyAccessExpression)) break block1;
            FirExpression firExpression = ((FirPropertyAccessExpression)expression).getExplicitReceiver();
            if (firExpression != null) {
                FirExpression it = firExpression;
                boolean bl = false;
                FirAnnotationValueConverter.computeErrorCallClassId$process(qualifierParts, it);
            }
        }
    }
}

