/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.annotations;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaStarTypeProjection;
import org.jetbrains.kotlin.analysis.api.KaTypeArgumentWithVariance;
import org.jetbrains.kotlin.analysis.api.KaTypeProjection;
import org.jetbrains.kotlin.analysis.api.annotations.KaAnnotationApplicationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KaAnnotationApplicationWithArgumentsInfo;
import org.jetbrains.kotlin.analysis.api.annotations.KaAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KaArrayAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KaConstantAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KaEnumEntryAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KaKClassAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KaNamedAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KaUnsupportedAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KtAnnotatedKt;
import org.jetbrains.kotlin.analysis.api.types.KaClassErrorType;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.analysis.api.types.KaUsualClassType;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001d\u0010\b\u001a\u00020\t*\u00060\u000bj\u0002`\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\fJ\u001d\u0010\r\u001a\u00020\t*\u00060\u000bj\u0002`\n2\u0006\u0010\u0006\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u001d\u0010\u0010\u001a\u00020\t*\u00060\u000bj\u0002`\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013J\u001d\u0010\u0014\u001a\u00020\t*\u00060\u000bj\u0002`\n2\u0006\u0010\u0006\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016J\u001d\u0010\u0017\u001a\u00020\t*\u00060\u000bj\u0002`\n2\u0006\u0010\u0006\u001a\u00020\u0018H\u0002\u00a2\u0006\u0002\u0010\u0019J\u001d\u0010\u001a\u001a\u00020\t*\u00060\u000bj\u0002`\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00a2\u0006\u0002\u0010\u001dJ\u001d\u0010\u001e\u001a\u00020\t*\u00060\u000bj\u0002`\n2\u0006\u0010\u0006\u001a\u00020\u001fH\u0002\u00a2\u0006\u0002\u0010 J\u001d\u0010!\u001a\u00020\t*\u00060\u000bj\u0002`\n2\u0006\u0010\u0006\u001a\u00020\"H\u0002\u00a2\u0006\u0002\u0010#J#\u0010$\u001a\u00020\t*\u00060\u000bj\u0002`\n2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00070&H\u0002\u00a2\u0006\u0002\u0010'J#\u0010(\u001a\u00020\t*\u00060\u000bj\u0002`\n2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020)0&H\u0002\u00a2\u0006\u0002\u0010'JU\u0010*\u001a\u00020\t\"\u0004\b\u0000\u0010+*\u00060\u000bj\u0002`\n2\f\u0010,\u001a\b\u0012\u0004\u0012\u0002H+0&2\u0006\u0010-\u001a\u00020\u00052!\u0010\u0004\u001a\u001d\u0012\b\u0012\u00060\u000bj\u0002`\n\u0012\u0004\u0012\u0002H+\u0012\u0004\u0012\u00020\t0.\u00a2\u0006\u0002\b/H\u0082\b\u00a2\u0006\u0002\u00100\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotationValueRenderer;", "", "<init>", "()V", "render", "", "value", "Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotationValue;", "renderConstantValue", "", "Lkotlin/text/StringBuilder;", "Ljava/lang/StringBuilder;", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotationValue;)V", "renderKClassAnnotationValue", "Lorg/jetbrains/kotlin/analysis/api/annotations/KaKClassAnnotationValue;", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/analysis/api/annotations/KaKClassAnnotationValue;)V", "renderType", "type", "Lorg/jetbrains/kotlin/analysis/api/types/KaType;", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/analysis/api/types/KaType;)V", "renderConstantAnnotationValue", "Lorg/jetbrains/kotlin/analysis/api/annotations/KaConstantAnnotationValue;", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/analysis/api/annotations/KaConstantAnnotationValue;)V", "renderEnumEntryConstantValue", "Lorg/jetbrains/kotlin/analysis/api/annotations/KaEnumEntryAnnotationValue;", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/analysis/api/annotations/KaEnumEntryAnnotationValue;)V", "renderAnnotationConstantValue", "application", "Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotationApplicationValue;", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotationApplicationValue;)V", "renderAnnotationApplication", "Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotationApplicationWithArgumentsInfo;", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotationApplicationWithArgumentsInfo;)V", "renderArrayConstantValue", "Lorg/jetbrains/kotlin/analysis/api/annotations/KaArrayAnnotationValue;", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/analysis/api/annotations/KaArrayAnnotationValue;)V", "renderConstantValueList", "list", "", "(Ljava/lang/StringBuilder;Ljava/util/Collection;)V", "renderNamedConstantValueList", "Lorg/jetbrains/kotlin/analysis/api/annotations/KaNamedAnnotationValue;", "renderWithSeparator", "E", "collection", "separator", "Lkotlin/Function2;", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/StringBuilder;Ljava/util/Collection;Ljava/lang/String;Lkotlin/jvm/functions/Function2;)V", "analysis-api"})
@SourceDebugExtension(value={"SMAP\nKtAnnotationValueRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtAnnotationValueRenderer.kt\norg/jetbrains/kotlin/analysis/api/annotations/KaAnnotationValueRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n131#1:139\n132#1,5:142\n137#1:148\n131#1:149\n132#1,5:152\n137#1:158\n131#1:159\n132#1,5:162\n137#1:168\n1872#2,2:140\n1874#2:147\n1872#2,2:150\n1874#2:157\n1872#2,2:160\n1874#2:167\n1872#2,3:169\n*S KotlinDebug\n*F\n+ 1 KtAnnotationValueRenderer.kt\norg/jetbrains/kotlin/analysis/api/annotations/KaAnnotationValueRenderer\n*L\n66#1:139\n66#1:142,5\n66#1:148\n112#1:149\n112#1:152,5\n112#1:158\n118#1:159\n118#1:162,5\n118#1:168\n66#1:140,2\n66#1:147\n112#1:150,2\n112#1:157\n118#1:160,2\n118#1:167\n131#1:169,3\n*E\n"})
public final class KaAnnotationValueRenderer {
    @NotNull
    public static final KaAnnotationValueRenderer INSTANCE = new KaAnnotationValueRenderer();

    private KaAnnotationValueRenderer() {
    }

    @NotNull
    public final String render(@NotNull KaAnnotationValue value) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        StringBuilder $this$render_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        INSTANCE.renderConstantValue($this$render_u24lambda_u240, value);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void renderConstantValue(StringBuilder $this$renderConstantValue, KaAnnotationValue value) {
        KaAnnotationValue kaAnnotationValue = value;
        if (kaAnnotationValue instanceof KaAnnotationApplicationValue) {
            this.renderAnnotationConstantValue($this$renderConstantValue, (KaAnnotationApplicationValue)value);
        } else if (kaAnnotationValue instanceof KaArrayAnnotationValue) {
            this.renderArrayConstantValue($this$renderConstantValue, (KaArrayAnnotationValue)value);
        } else if (kaAnnotationValue instanceof KaEnumEntryAnnotationValue) {
            this.renderEnumEntryConstantValue($this$renderConstantValue, (KaEnumEntryAnnotationValue)value);
        } else if (kaAnnotationValue instanceof KaConstantAnnotationValue) {
            this.renderConstantAnnotationValue($this$renderConstantValue, (KaConstantAnnotationValue)value);
        } else if (kaAnnotationValue instanceof KaUnsupportedAnnotationValue) {
            $this$renderConstantValue.append("error(\"non-annotation value\")");
        } else if (kaAnnotationValue instanceof KaKClassAnnotationValue) {
            this.renderKClassAnnotationValue($this$renderConstantValue, (KaKClassAnnotationValue)value);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void renderKClassAnnotationValue(StringBuilder $this$renderKClassAnnotationValue, KaKClassAnnotationValue value) {
        this.renderType($this$renderKClassAnnotationValue, value.getType());
        $this$renderKClassAnnotationValue.append("::class");
    }

    /*
     * WARNING - void declaration
     */
    private final void renderType(StringBuilder $this$renderType, KaType type) {
        StringBuilder stringBuilder;
        Object object;
        if (!((Collection)KtAnnotatedKt.getAnnotations(type)).isEmpty()) {
            object = KtAnnotatedKt.getAnnotations(type).iterator();
            while (object.hasNext()) {
                KaAnnotationApplicationWithArgumentsInfo annotation = (KaAnnotationApplicationWithArgumentsInfo)object.next();
                $this$renderType.append('@');
                this.renderAnnotationApplication($this$renderType, annotation);
                $this$renderType.append(' ');
            }
        }
        if ((object = type) instanceof KaUsualClassType) {
            ClassId classId = ((KaUsualClassType)type).getClassId();
            StringBuilder stringBuilder2 = classId.isLocal() ? $this$renderType.append(RenderingUtilsKt.render((Name)classId.getShortClassName())) : $this$renderType.append(RenderingUtilsKt.render((FqName)classId.asSingleFqName()));
            if (!((Collection)((KaUsualClassType)type).getOwnTypeArguments()).isEmpty()) {
                void collection$iv;
                $this$renderType.append('<');
                KaAnnotationValueRenderer kaAnnotationValueRenderer = this;
                StringBuilder stringBuilder3 = $this$renderType;
                Collection collection = ((KaUsualClassType)type).getOwnTypeArguments();
                String separator$iv = ", ";
                boolean $i$f$renderWithSeparator = false;
                Iterable $this$forEachIndexed$iv$iv = (Iterable)collection$iv;
                boolean $i$f$forEachIndexed = false;
                int index$iv$iv = 0;
                for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
                    void typeProjection;
                    void $this$renderWithSeparator$iv;
                    void element$iv;
                    int n;
                    if ((n = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Object t = item$iv$iv;
                    int index$iv = n;
                    boolean bl = false;
                    KaTypeProjection kaTypeProjection = (KaTypeProjection)element$iv;
                    void $this$renderType_u24lambda_u241 = $this$renderWithSeparator$iv;
                    boolean bl2 = false;
                    void var22_22 = typeProjection;
                    if (var22_22 instanceof KaStarTypeProjection) {
                        $this$renderType_u24lambda_u241.append('*');
                    } else if (var22_22 instanceof KaTypeArgumentWithVariance) {
                        INSTANCE.renderType((StringBuilder)$this$renderType_u24lambda_u241, ((KaTypeArgumentWithVariance)typeProjection).getType());
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    if (index$iv == collection$iv.size() - 1) continue;
                    $this$renderWithSeparator$iv.append(separator$iv);
                }
                $this$renderType.append('>');
            }
            stringBuilder = Unit.INSTANCE;
        } else {
            stringBuilder = object instanceof KaClassErrorType ? $this$renderType.append("UNRESOLVED_CLASS") : $this$renderType.append(type.asStringForDebugging());
        }
    }

    private final void renderConstantAnnotationValue(StringBuilder $this$renderConstantAnnotationValue, KaConstantAnnotationValue value) {
        $this$renderConstantAnnotationValue.append(value.getConstantValue().renderAsKotlinConstant());
    }

    private final void renderEnumEntryConstantValue(StringBuilder $this$renderEnumEntryConstantValue, KaEnumEntryAnnotationValue value) {
        CallableId callableId = value.getCallableId();
        $this$renderEnumEntryConstantValue.append(callableId != null && (callableId = callableId.asSingleFqName()) != null ? callableId.asString() : null);
    }

    private final void renderAnnotationConstantValue(StringBuilder $this$renderAnnotationConstantValue, KaAnnotationApplicationValue application) {
        this.renderAnnotationApplication($this$renderAnnotationConstantValue, application.getAnnotationValue());
    }

    private final void renderAnnotationApplication(StringBuilder $this$renderAnnotationApplication, KaAnnotationApplicationWithArgumentsInfo value) {
        $this$renderAnnotationApplication.append(value.getClassId());
        if (!((Collection)value.getArguments()).isEmpty()) {
            $this$renderAnnotationApplication.append("(");
            this.renderNamedConstantValueList($this$renderAnnotationApplication, (Collection<KaNamedAnnotationValue>)value.getArguments());
            $this$renderAnnotationApplication.append(")");
        }
    }

    private final void renderArrayConstantValue(StringBuilder $this$renderArrayConstantValue, KaArrayAnnotationValue value) {
        $this$renderArrayConstantValue.append("[");
        this.renderConstantValueList($this$renderArrayConstantValue, value.getValues());
        $this$renderArrayConstantValue.append("]");
    }

    /*
     * WARNING - void declaration
     */
    private final void renderConstantValueList(StringBuilder $this$renderConstantValueList, Collection<? extends KaAnnotationValue> list) {
        KaAnnotationValueRenderer kaAnnotationValueRenderer = this;
        StringBuilder stringBuilder = $this$renderConstantValueList;
        String separator$iv = ", ";
        boolean $i$f$renderWithSeparator = false;
        Iterable $this$forEachIndexed$iv$iv = list;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
            void constantValue;
            void $this$renderWithSeparator$iv;
            void element$iv;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv;
            int index$iv = n;
            boolean bl = false;
            KaAnnotationValue kaAnnotationValue = (KaAnnotationValue)element$iv;
            void $this$renderConstantValueList_u24lambda_u242 = $this$renderWithSeparator$iv;
            boolean bl2 = false;
            INSTANCE.renderConstantValue((StringBuilder)$this$renderConstantValueList_u24lambda_u242, (KaAnnotationValue)constantValue);
            if (index$iv == list.size() - 1) continue;
            $this$renderWithSeparator$iv.append(separator$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderNamedConstantValueList(StringBuilder $this$renderNamedConstantValueList, Collection<KaNamedAnnotationValue> list) {
        KaAnnotationValueRenderer kaAnnotationValueRenderer = this;
        StringBuilder stringBuilder = $this$renderNamedConstantValueList;
        String separator$iv = ", ";
        boolean $i$f$renderWithSeparator = false;
        Iterable $this$forEachIndexed$iv$iv = list;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
            void namedValue;
            void $this$renderWithSeparator$iv;
            void element$iv;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv;
            int index$iv = n;
            boolean bl = false;
            KaNamedAnnotationValue kaNamedAnnotationValue = (KaNamedAnnotationValue)element$iv;
            void $this$renderNamedConstantValueList_u24lambda_u243 = $this$renderWithSeparator$iv;
            boolean bl2 = false;
            $this$renderNamedConstantValueList_u24lambda_u243.append(namedValue.getName());
            $this$renderNamedConstantValueList_u24lambda_u243.append(" = ");
            INSTANCE.renderConstantValue((StringBuilder)$this$renderNamedConstantValueList_u24lambda_u243, namedValue.getExpression());
            $this$renderNamedConstantValueList_u24lambda_u243.append(", ");
            if (index$iv == list.size() - 1) continue;
            $this$renderWithSeparator$iv.append(separator$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final <E> void renderWithSeparator(StringBuilder $this$renderWithSeparator, Collection<? extends E> collection, String separator, Function2<? super StringBuilder, ? super E, Unit> render) {
        boolean $i$f$renderWithSeparator = false;
        Iterable $this$forEachIndexed$iv = collection;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void element;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv;
            int index = n;
            boolean bl = false;
            render.invoke((Object)$this$renderWithSeparator, (Object)element);
            if (index == collection.size() - 1) continue;
            $this$renderWithSeparator.append(separator);
        }
    }
}

