/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt3.base.incremental;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kapt3.base.incremental.CacheKt;
import org.jetbrains.kotlin.kapt3.base.incremental.Changes;
import org.jetbrains.kotlin.kapt3.base.incremental.ClassFileStructure;
import org.jetbrains.kotlin.kapt3.base.incremental.IncrementalAptCache;
import org.jetbrains.kotlin.kapt3.base.incremental.IncrementalProcessor;
import org.jetbrains.kotlin.kapt3.base.incremental.JavaClassCache;
import org.jetbrains.kotlin.kapt3.base.incremental.SourcesToReprocess;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0011J0\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u0015J$\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d0 2\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001d0$H\u0002J\b\u0010%\u001a\u00020\u000fH\u0002J\b\u0010&\u001a\u00020\nH\u0002J\b\u0010'\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/kapt3/base/incremental/JavaClassCacheManager;", "Ljava/io/Closeable;", "file", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "getFile", "()Ljava/io/File;", "javaCacheFile", "javaCache", "Lorg/jetbrains/kotlin/kapt3/base/incremental/JavaClassCache;", "getJavaCache$kotlin_annotation_processing_base", "()Lorg/jetbrains/kotlin/kapt3/base/incremental/JavaClassCache;", "aptCacheFile", "aptCache", "Lorg/jetbrains/kotlin/kapt3/base/incremental/IncrementalAptCache;", "closed", "", "updateCache", "", "processors", "", "Lorg/jetbrains/kotlin/kapt3/base/incremental/IncrementalProcessor;", "failedToAnalyzeSources", "invalidateAndGetDirtyFiles", "Lorg/jetbrains/kotlin/kapt3/base/incremental/SourcesToReprocess;", "changedSources", "", "dirtyClasspathJvmNames", "", "compiledSources", "getAllImpactedTypes", "", "changes", "Lorg/jetbrains/kotlin/kapt3/base/incremental/Changes;", "aggregatingGeneratedTypes", "", "maybeGetAptCacheFromFile", "maybeGetJavaCacheFromFile", "close", "kotlin-annotation-processing-base"})
@SourceDebugExtension(value={"SMAP\ncache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 cache.kt\norg/jetbrains/kotlin/kapt3/base/incremental/JavaClassCacheManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,229:1\n1863#2:230\n1864#2:233\n1863#2,2:234\n216#3,2:231\n*S KotlinDebug\n*F\n+ 1 cache.kt\norg/jetbrains/kotlin/kapt3/base/incremental/JavaClassCacheManager\n*L\n28#1:230\n28#1:233\n70#1:234,2\n29#1:231,2\n*E\n"})
public final class JavaClassCacheManager
implements Closeable {
    @NotNull
    private final File file;
    @NotNull
    private final File javaCacheFile;
    @NotNull
    private final JavaClassCache javaCache;
    @NotNull
    private final File aptCacheFile;
    @NotNull
    private final IncrementalAptCache aptCache;
    private boolean closed;

    public JavaClassCacheManager(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        this.javaCacheFile = FilesKt.resolve((File)this.file, (String)"java-cache.bin");
        this.javaCache = this.maybeGetJavaCacheFromFile();
        this.aptCacheFile = FilesKt.resolve((File)this.file, (String)"apt-cache.bin");
        this.aptCache = this.maybeGetAptCacheFromFile();
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public final JavaClassCache getJavaCache$kotlin_annotation_processing_base() {
        return this.javaCache;
    }

    public final void updateCache(@NotNull List<IncrementalProcessor> processors, boolean failedToAnalyzeSources) {
        Intrinsics.checkNotNullParameter(processors, (String)"processors");
        if (!this.aptCache.updateCache(processors, failedToAnalyzeSources)) {
            this.javaCache.invalidateAll$kotlin_annotation_processing_base();
            return;
        }
        Iterable $this$forEach$iv = processors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IncrementalProcessor processor = (IncrementalProcessor)element$iv;
            boolean bl = false;
            Map<File, String> $this$forEach$iv2 = processor.getGeneratedClassFilesToTypes();
            boolean $i$f$forEach2 = false;
            Iterator<Map.Entry<File, String>> iterator = $this$forEach$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<File, String> element$iv2;
                Map.Entry<File, String> entry = element$iv2 = iterator.next();
                boolean bl2 = false;
                File classFile = entry.getKey();
                String type = entry.getValue();
                URI uRI = classFile.toURI();
                Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toURI(...)");
                ClassFileStructure classFileStructure = new ClassFileStructure(uRI, type);
                this.javaCache.addSourceStructure(classFileStructure);
            }
        }
    }

    @NotNull
    public final SourcesToReprocess invalidateAndGetDirtyFiles(@NotNull Collection<? extends File> changedSources, @NotNull Collection<String> dirtyClasspathJvmNames, @NotNull List<? extends File> compiledSources) {
        Intrinsics.checkNotNullParameter(changedSources, (String)"changedSources");
        Intrinsics.checkNotNullParameter(dirtyClasspathJvmNames, (String)"dirtyClasspathJvmNames");
        Intrinsics.checkNotNullParameter(compiledSources, (String)"compiledSources");
        if (!this.aptCache.isIncremental()) {
            return SourcesToReprocess.FullRebuild.INSTANCE;
        }
        int totalDeclaredTypes = this.javaCache.getSourceFileDefinedTypesCount();
        boolean compileOutputHasEnoughClassFiles = CacheKt.access$checkMinNumberOfClassFiles(compiledSources, totalDeclaredTypes);
        if (!compileOutputHasEnoughClassFiles) {
            return SourcesToReprocess.FullRebuild.INSTANCE;
        }
        HashSet<String> dirtyClasspathFqNames = new HashSet<String>(dirtyClasspathJvmNames.size());
        Iterable $this$forEach$iv = dirtyClasspathJvmNames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            dirtyClasspathFqNames.add(StringsKt.replace$default((String)StringsKt.replace$default((String)it, (String)"$", (String)".", (boolean)false, (int)4, null), (String)"/", (String)".", (boolean)false, (int)4, null));
        }
        Changes changes = new Changes(changedSources, CollectionsKt.toSet((Iterable)dirtyClasspathFqNames));
        Set<String> aggregatingGeneratedTypes2 = this.aptCache.getAggregatingGeneratedTypes((Function1<? super Collection<? extends File>, ? extends Set<String>>)((Function1)new Function1<Collection<? extends File>, Set<? extends String>>((Object)this.javaCache){

            public final Set<String> invoke(Collection<? extends File> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return ((JavaClassCache)this.receiver).getTypesForFiles(p0);
            }

            public final String getSignature() {
                return "getTypesForFiles(Ljava/util/Collection;)Ljava/util/Set;";
            }

            public final String getName() {
                return "getTypesForFiles";
            }

            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(JavaClassCache.class);
            }
        }));
        Set<String> impactedTypes = this.getAllImpactedTypes(changes, aggregatingGeneratedTypes2);
        Set<String> isolatingGeneratedTypes2 = this.aptCache.getIsolatingGeneratedTypes((Function1<? super Collection<? extends File>, ? extends Set<String>>)((Function1)new Function1<Collection<? extends File>, Set<? extends String>>((Object)this.javaCache){

            public final Set<String> invoke(Collection<? extends File> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return ((JavaClassCache)this.receiver).getTypesForFiles(p0);
            }

            public final String getSignature() {
                return "getTypesForFiles(Ljava/util/Collection;)Ljava/util/Set;";
            }

            public final String getName() {
                return "getTypesForFiles";
            }

            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(JavaClassCache.class);
            }
        }));
        Set sourcesToReprocess = CollectionsKt.toMutableSet((Iterable)changedSources);
        List classNamesToReprocess = new ArrayList();
        if (!changedSources.isEmpty() || !((Collection)impactedTypes).isEmpty()) {
            for (String aggregatingOrigin : this.aptCache.getAggregatingOrigins()) {
                if (impactedTypes.contains(aggregatingOrigin)) continue;
                File originSource = this.javaCache.getSourceForType(aggregatingOrigin);
                if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)originSource), (Object)"java")) {
                    sourcesToReprocess.add(originSource);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)originSource), (Object)"class")) continue;
                classNamesToReprocess.add(aggregatingOrigin);
            }
        }
        for (String impactedType : impactedTypes) {
            String isolatingOrigin2;
            if (!isolatingGeneratedTypes2.contains(impactedType) && !aggregatingGeneratedTypes2.contains(impactedType)) {
                sourcesToReprocess.add(this.javaCache.getSourceForType(impactedType));
                continue;
            }
            if (!isolatingGeneratedTypes2.contains(impactedType) || impactedTypes.contains(isolatingOrigin2 = this.aptCache.getOriginForGeneratedIsolatingType(impactedType, (Function1<? super String, ? extends File>)((Function1)new Function1<String, File>((Object)this.javaCache){

                public final File invoke(String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((JavaClassCache)this.receiver).getSourceForType(p0);
                }

                public final String getSignature() {
                    return "getSourceForType(Ljava/lang/String;)Ljava/io/File;";
                }

                public final String getName() {
                    return "getSourceForType";
                }

                public final KDeclarationContainer getOwner() {
                    return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(JavaClassCache.class);
                }
            }))) || dirtyClasspathFqNames.contains(isolatingOrigin2)) continue;
            File originSource = this.javaCache.getSourceForType(isolatingOrigin2);
            if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)originSource), (Object)"java")) {
                sourcesToReprocess.add(originSource);
                continue;
            }
            if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)originSource), (Object)"class")) continue;
            classNamesToReprocess.add(isolatingOrigin2);
        }
        if (!((Collection)sourcesToReprocess).isEmpty() || !((Collection)classNamesToReprocess).isEmpty()) {
            this.javaCache.invalidateDataForTypes(impactedTypes);
            this.aptCache.invalidateAggregating();
            this.aptCache.invalidateIsolatingForOriginTypes(SetsKt.plus(impactedTypes, (Iterable)dirtyClasspathFqNames));
        }
        return new SourcesToReprocess.Incremental(CollectionsKt.toList((Iterable)sourcesToReprocess), impactedTypes, classNamesToReprocess);
    }

    private final Set<String> getAllImpactedTypes(Changes changes, Set<String> aggregatingGeneratedTypes2) {
        Set<String> impactedTypes = this.javaCache.getAllImpactedTypes(changes);
        impactedTypes.addAll((Collection<String>)this.aptCache.getIsolatingGeneratedTypesForOrigins(changes.getDirtyFqNamesFromClasspath(), (Function1<? super Collection<? extends File>, ? extends Set<String>>)((Function1)new Function1<Collection<? extends File>, Set<? extends String>>((Object)this.javaCache){

            public final Set<String> invoke(Collection<? extends File> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return ((JavaClassCache)this.receiver).getTypesForFiles(p0);
            }

            public final String getSignature() {
                return "getTypesForFiles(Ljava/util/Collection;)Ljava/util/Set;";
            }

            public final String getName() {
                return "getTypesForFiles";
            }

            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(JavaClassCache.class);
            }
        })));
        if (!changes.getSourceChanges().isEmpty() || !((Collection)impactedTypes).isEmpty()) {
            impactedTypes.addAll((Collection<String>)aggregatingGeneratedTypes2);
        }
        List<String> it = this.aptCache.getIsolatingGeneratedTypesForOrigins(impactedTypes, (Function1<? super Collection<? extends File>, ? extends Set<String>>)((Function1)new Function1<Collection<? extends File>, Set<? extends String>>((Object)this.javaCache){

            public final Set<String> invoke(Collection<? extends File> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return ((JavaClassCache)this.receiver).getTypesForFiles(p0);
            }

            public final String getSignature() {
                return "getTypesForFiles(Ljava/util/Collection;)Ljava/util/Set;";
            }

            public final String getName() {
                return "getTypesForFiles";
            }

            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(JavaClassCache.class);
            }
        }));
        boolean bl = false;
        impactedTypes.addAll((Collection<String>)it);
        return impactedTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IncrementalAptCache maybeGetAptCacheFromFile() {
        IncrementalAptCache incrementalAptCache;
        if (this.aptCacheFile.exists()) {
            Object object;
            try {
                IncrementalAptCache incrementalAptCache2;
                object = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.aptCacheFile)));
                Throwable throwable = null;
                try {
                    ObjectInputStream it = (ObjectInputStream)object;
                    boolean bl = false;
                    Object object2 = it.readObject();
                    Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.kapt3.base.incremental.IncrementalAptCache");
                    incrementalAptCache2 = (IncrementalAptCache)object2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                object = incrementalAptCache2;
            }
            catch (Throwable e) {
                object = new IncrementalAptCache();
            }
            incrementalAptCache = object;
        } else {
            incrementalAptCache = new IncrementalAptCache();
        }
        return incrementalAptCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final JavaClassCache maybeGetJavaCacheFromFile() {
        JavaClassCache javaClassCache;
        if (this.javaCacheFile.exists()) {
            Object object;
            try {
                JavaClassCache javaClassCache2;
                object = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.javaCacheFile)));
                Throwable throwable = null;
                try {
                    ObjectInputStream it = (ObjectInputStream)object;
                    boolean bl = false;
                    Object object2 = it.readObject();
                    Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.kapt3.base.incremental.JavaClassCache");
                    javaClassCache2 = (JavaClassCache)object2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                object = javaClassCache2;
            }
            catch (Throwable e) {
                object = new JavaClassCache();
            }
            javaClassCache = object;
        } else {
            javaClassCache = new JavaClassCache();
        }
        return javaClassCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ObjectOutputStream it2;
        if (this.closed) {
            return;
        }
        File $this$close_u24lambda_u247 = this.javaCacheFile;
        boolean bl = false;
        $this$close_u24lambda_u247.delete();
        $this$close_u24lambda_u247.getParentFile().mkdirs();
        Closeable closeable = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream($this$close_u24lambda_u247)));
        Throwable throwable = null;
        try {
            it2 = (ObjectOutputStream)closeable;
            boolean bl2 = false;
            it2.writeObject(this.javaCache);
            it2 = Unit.INSTANCE;
        }
        catch (Throwable it2) {
            throwable = it2;
            throw it2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        File $this$close_u24lambda_u249 = this.aptCacheFile;
        boolean bl3 = false;
        $this$close_u24lambda_u249.delete();
        $this$close_u24lambda_u249.getParentFile().mkdirs();
        closeable = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream($this$close_u24lambda_u249)));
        throwable = null;
        try {
            it2 = (ObjectOutputStream)closeable;
            boolean bl4 = false;
            it2.writeObject(this.aptCache);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        this.closed = true;
    }
}

