/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.sessions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.low.level.api.fir.caches.SoftValueCleaner;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSessionCache;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.fir.BuiltinTypes;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0002#$B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH&J\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001d\u001a\u00020\u001cJ\u0013\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00000\u001fH\u0000\u00a2\u0006\u0002\b J\b\u0010!\u001a\u00020\"H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;", "Lorg/jetbrains/kotlin/fir/FirSession;", "ktModule", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "builtinTypes", "Lorg/jetbrains/kotlin/fir/BuiltinTypes;", "kind", "Lorg/jetbrains/kotlin/fir/FirSession$Kind;", "<init>", "(Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;Lorg/jetbrains/kotlin/fir/BuiltinTypes;Lorg/jetbrains/kotlin/fir/FirSession$Kind;)V", "getKtModule", "()Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "getBuiltinTypes", "()Lorg/jetbrains/kotlin/fir/BuiltinTypes;", "getScopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "value", "", "isValid", "()Z", "createValidityTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "lazyDisposable", "Lkotlin/Lazy;", "Lcom/intellij/openapi/Disposable;", "requestDisposable", "createCleaner", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/SoftValueCleaner;", "createCleaner$low_level_api_fir", "toString", "", "ValidityModificationTracker", "LLFirSessionCleaner", "low-level-api-fir"})
public abstract class LLFirSession
extends FirSession {
    @NotNull
    private final KtModule ktModule;
    @NotNull
    private final BuiltinTypes builtinTypes;
    private volatile boolean isValid;
    @NotNull
    private final Lazy<Disposable> lazyDisposable;

    public LLFirSession(@NotNull KtModule ktModule, @NotNull BuiltinTypes builtinTypes, @NotNull FirSession.Kind kind) {
        Intrinsics.checkNotNullParameter((Object)ktModule, (String)"ktModule");
        Intrinsics.checkNotNullParameter((Object)builtinTypes, (String)"builtinTypes");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        super(null, kind);
        this.ktModule = ktModule;
        this.builtinTypes = builtinTypes;
        this.isValid = true;
        this.lazyDisposable = LazyKt.lazy(() -> LLFirSession.lazyDisposable$lambda$0(this));
    }

    @NotNull
    public final KtModule getKtModule() {
        return this.ktModule;
    }

    @NotNull
    public BuiltinTypes getBuiltinTypes() {
        return this.builtinTypes;
    }

    @NotNull
    public abstract ScopeSession getScopeSession();

    @NotNull
    public final Project getProject() {
        return this.ktModule.getProject();
    }

    public final boolean isValid() {
        return this.isValid;
    }

    @NotNull
    public final ModificationTracker createValidityTracker() {
        return new ValidityModificationTracker();
    }

    @NotNull
    public final Disposable requestDisposable() {
        return (Disposable)this.lazyDisposable.getValue();
    }

    @NotNull
    public final SoftValueCleaner<LLFirSession> createCleaner$low_level_api_fir() {
        Disposable disposable = this.lazyDisposable.isInitialized() ? (Disposable)this.lazyDisposable.getValue() : null;
        return new LLFirSessionCleaner(disposable);
    }

    @NotNull
    public String toString() {
        return Reflection.getOrCreateKotlinClass(((Object)((Object)this)).getClass()).getSimpleName() + " for " + this.ktModule.getModuleDescription();
    }

    private static final Disposable lazyDisposable$lambda$0(LLFirSession this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposable2 = disposable;
        Disposer.register((Disposable)LLFirSessionCache.Companion.getInstance(this$0.getProject()), (Disposable)disposable2);
        return disposable2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession$LLFirSessionCleaner;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/SoftValueCleaner;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;", "disposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/Disposable;)V", "cleanUp", "", "value", "low-level-api-fir"})
    @SourceDebugExtension(value={"SMAP\nLLFirSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLFirSession.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession$LLFirSessionCleaner\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,135:1\n1#2:136\n*E\n"})
    private static final class LLFirSessionCleaner
    implements SoftValueCleaner<LLFirSession> {
        @Nullable
        private final Disposable disposable;

        public LLFirSessionCleaner(@Nullable Disposable disposable) {
            this.disposable = disposable;
        }

        @Override
        public void cleanUp(@Nullable LLFirSession value) {
            block4: {
                if (value != null && this.disposable != null) {
                    if (!value.lazyDisposable.isInitialized()) {
                        boolean $i$a$-require-LLFirSession$LLFirSessionCleaner$cleanUp$32 = false;
                        String $i$a$-require-LLFirSession$LLFirSessionCleaner$cleanUp$32 = "The session to clean up should have an initialized disposable when a disposable is also registered with this cleaner. The session to clean up might not be consistent with the session from which this cleaner was created.";
                        throw new IllegalArgumentException($i$a$-require-LLFirSession$LLFirSessionCleaner$cleanUp$32.toString());
                    }
                    if (!Intrinsics.areEqual((Object)value.lazyDisposable.getValue(), (Object)this.disposable)) {
                        boolean bl = false;
                        String string = "The session to clean up should have a disposable that is equal to the disposable registered with this cleaner. The session to clean up might not be consistent with the session from which this cleaner was created.";
                        throw new IllegalArgumentException(string.toString());
                    }
                }
                LLFirSession lLFirSession = value;
                if (lLFirSession != null) {
                    lLFirSession.isValid = false;
                }
                Disposable disposable = this.disposable;
                if (disposable == null) break block4;
                Disposable it = disposable;
                boolean bl = false;
                Disposer.dispose((Disposable)it);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession$ValidityModificationTracker;", "Lcom/intellij/openapi/util/ModificationTracker;", "<init>", "(Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;)V", "count", "Ljava/util/concurrent/atomic/AtomicLong;", "getModificationCount", "", "low-level-api-fir"})
    private final class ValidityModificationTracker
    implements ModificationTracker {
        @NotNull
        private AtomicLong count = new AtomicLong();

        public long getModificationCount() {
            if (LLFirSession.this.isValid()) {
                return 0L;
            }
            return this.count.incrementAndGet();
        }
    }
}

