/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.components.KtSubstitutorProvider;
import org.jetbrains.kotlin.analysis.api.fir.KtFirAnalysisSession;
import org.jetbrains.kotlin.analysis.api.fir.components.KtFirAnalysisSessionComponent;
import org.jetbrains.kotlin.analysis.api.fir.utils.KtSymbolUtilsKt;
import org.jetbrains.kotlin.analysis.api.symbols.KtClassOrObjectSymbol;
import org.jetbrains.kotlin.analysis.api.types.KtSubstitutor;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.substitution.SubstitutorsKt;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J4\u0010\u000e\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010\u0018\u00010\u000f2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/KtFirSubstitutorProvider;", "Lorg/jetbrains/kotlin/analysis/api/components/KtSubstitutorProvider;", "Lorg/jetbrains/kotlin/analysis/api/fir/components/KtFirAnalysisSessionComponent;", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;", "<init>", "(Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;)V", "getAnalysisSession", "()Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;", "createSubstitutor", "Lorg/jetbrains/kotlin/analysis/api/types/KtSubstitutor;", "subClass", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtClassOrObjectSymbol;", "superClass", "collectInheritancePath", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "baseSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "superSymbol", "analysis-api-fir"})
@SourceDebugExtension(value={"SMAP\nKtFirSubstitutorProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtFirSubstitutorProvider.kt\norg/jetbrains/kotlin/analysis/api/fir/components/KtFirSubstitutorProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n1557#2:75\n1628#2,3:76\n2669#2,7:79\n*S KotlinDebug\n*F\n+ 1 KtFirSubstitutorProvider.kt\norg/jetbrains/kotlin/analysis/api/fir/components/KtFirSubstitutorProvider\n*L\n32#1:75\n32#1:76,3\n38#1:79,7\n*E\n"})
public final class KtFirSubstitutorProvider
extends KtSubstitutorProvider
implements KtFirAnalysisSessionComponent {
    @NotNull
    private final KtFirAnalysisSession analysisSession;

    public KtFirSubstitutorProvider(@NotNull KtFirAnalysisSession analysisSession) {
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        this.analysisSession = analysisSession;
    }

    @Override
    @NotNull
    public KtFirAnalysisSession getAnalysisSession() {
        return this.analysisSession;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public KtSubstitutor createSubstitutor(@NotNull KtClassOrObjectSymbol subClass, @NotNull KtClassOrObjectSymbol superClass) {
        KtSubstitutor ktSubstitutor;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)subClass, (String)"subClass");
        Intrinsics.checkNotNullParameter((Object)superClass, (String)"superClass");
        if (Intrinsics.areEqual((Object)subClass, (Object)superClass)) {
            return new KtSubstitutor.Empty(this.getToken());
        }
        FirClassSymbol<?> baseFirSymbol = KtSymbolUtilsKt.getFirSymbol(subClass);
        FirClassSymbol<?> superFirSymbol = KtSymbolUtilsKt.getFirSymbol(superClass);
        List<Pair<ConeClassLikeType, FirRegularClassSymbol>> list = this.collectInheritancePath(baseFirSymbol, superFirSymbol);
        if (list == null) {
            return null;
        }
        List<Pair<ConeClassLikeType, FirRegularClassSymbol>> inheritancePath = list;
        Iterable $this$map$iv = inheritancePath;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ConeClassLikeType type = (ConeClassLikeType)pair.component1();
            FirRegularClassSymbol symbol = (FirRegularClassSymbol)pair.component2();
            collection.add(FirKotlinScopeProviderKt.substitutorForSuperType((ConeClassLikeType)type, (FirSession)this.getRootModuleSession(), (FirRegularClassSymbol)symbol));
        }
        List substitutors = (List)destination$iv$iv;
        if (substitutors.size() == 0) {
            ktSubstitutor = new KtSubstitutor.Empty(this.getToken());
        } else {
            Iterable $this$reduce$iv = substitutors;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void right;
                Object item$iv$iv;
                item$iv$iv = (ConeSubstitutor)iterator$iv.next();
                ConeSubstitutor left = (ConeSubstitutor)accumulator$iv;
                boolean bl = false;
                accumulator$iv = SubstitutorsKt.chain((ConeSubstitutor)left, (ConeSubstitutor)right);
            }
            ConeSubstitutor chained = (ConeSubstitutor)accumulator$iv;
            ktSubstitutor = this.getFirSymbolBuilder().getTypeBuilder().buildSubstitutor(chained);
        }
        return ktSubstitutor;
    }

    private final List<Pair<ConeClassLikeType, FirRegularClassSymbol>> collectInheritancePath(FirClassSymbol<?> baseSymbol, FirClassSymbol<?> superSymbol) {
        List stack = new ArrayList();
        Ref.ObjectRef result = new Ref.ObjectRef();
        KtFirSubstitutorProvider.collectInheritancePath$dfs((Ref.ObjectRef<List<Pair<ConeClassLikeType, FirRegularClassSymbol>>>)result, this, stack, superSymbol, baseSymbol);
        List list = (List)result.element;
        return list != null ? CollectionsKt.reversed((Iterable)list) : null;
    }

    private static final void collectInheritancePath$dfs(Ref.ObjectRef<List<Pair<ConeClassLikeType, FirRegularClassSymbol>>> result, KtFirSubstitutorProvider this$0, List<Pair<ConeClassLikeType, FirRegularClassSymbol>> stack, FirClassSymbol<?> $superSymbol, FirClassSymbol<?> symbol) {
        for (ConeKotlinType superType : symbol.getResolvedSuperTypes()) {
            FirRegularClassSymbol superClassSymbol;
            if (result.element != null) {
                return;
            }
            if (!(superType instanceof ConeClassLikeType) || TypeUtilsKt.toRegularClassSymbol((ConeClassLikeType)((ConeClassLikeType)superType), (FirSession)this$0.getRootModuleSession()) == null) continue;
            ((Collection)stack).add(TuplesKt.to((Object)superType, (Object)superClassSymbol));
            if (Intrinsics.areEqual((Object)superClassSymbol, $superSymbol)) {
                result.element = CollectionsKt.toList((Iterable)stack);
                if (Intrinsics.areEqual((Object)((Pair)CollectionsKt.removeLast(stack)).getSecond(), (Object)superClassSymbol)) break;
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            KtFirSubstitutorProvider.collectInheritancePath$dfs(result, this$0, stack, $superSymbol, (FirClassSymbol)superClassSymbol);
            if (Intrinsics.areEqual((Object)((Pair)CollectionsKt.removeLast(stack)).getSecond(), (Object)superClassSymbol)) continue;
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
    }
}

