/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.CachedValueBase;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.fir.KtFirAnalysisSession;
import org.jetbrains.kotlin.analysis.api.fir.KtFirAnalysisSessionProvider;
import org.jetbrains.kotlin.analysis.api.fir.KtFirAnalysisSessionProviderKt;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeToken;
import org.jetbrains.kotlin.analysis.api.session.KtAnalysisSessionProvider;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LLFirResolveSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LowLevelFirApiFacadeKt;
import org.jetbrains.kotlin.analysis.project.structure.KtDanglingFileModule;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.project.structure.KtModuleKt;
import org.jetbrains.kotlin.analysis.project.structure.ProjectStructureProvider;
import org.jetbrains.kotlin.analysis.providers.KotlinModificationTrackerFactoryKt;
import org.jetbrains.kotlin.psi.KtElement;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\tH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R4\u0010\u0006\u001a(\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\t\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSessionProvider;", "Lorg/jetbrains/kotlin/analysis/api/session/KtAnalysisSessionProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Ljava/util/concurrent/ConcurrentMap;", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "Lkotlin/reflect/KClass;", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "Lcom/intellij/psi/util/CachedValue;", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "getAnalysisSession", "useSiteKtElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "getAnalysisSessionByUseSiteKtModule", "useSiteKtModule", "clearCaches", "", "analysis-api-fir"})
public final class KtFirAnalysisSessionProvider
extends KtAnalysisSessionProvider {
    @NotNull
    private final ConcurrentMap<Pair<KtModule, KClass<? extends KtLifetimeToken>>, CachedValue<KtAnalysisSession>> cache;

    public KtFirAnalysisSessionProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.cache = new ConcurrentHashMap();
        LowMemoryWatcher.register(this::clearCaches, (Disposable)((Disposable)project));
    }

    @Override
    @NotNull
    public KtAnalysisSession getAnalysisSession(@NotNull KtElement useSiteKtElement) {
        Intrinsics.checkNotNullParameter((Object)useSiteKtElement, (String)"useSiteKtElement");
        KtModule module = ProjectStructureProvider.Companion.getModule(this.getProject(), (PsiElement)useSiteKtElement, null);
        return this.getAnalysisSessionByUseSiteKtModule(module);
    }

    @Override
    @NotNull
    public KtAnalysisSession getAnalysisSessionByUseSiteKtModule(@NotNull KtModule useSiteKtModule) {
        Intrinsics.checkNotNullParameter((Object)useSiteKtModule, (String)"useSiteKtModule");
        if (useSiteKtModule instanceof KtDanglingFileModule && !KtModuleKt.isStable((KtDanglingFileModule)((KtDanglingFileModule)useSiteKtModule))) {
            LLFirResolveSession firResolveSession = LowLevelFirApiFacadeKt.getFirResolveSession(useSiteKtModule, this.getProject());
            KtLifetimeToken validityToken = this.getTokenFactory().create(this.getProject());
            return KtFirAnalysisSession.Companion.createAnalysisSessionByFirResolveSession$analysis_api_fir(firResolveSession, validityToken);
        }
        KClass<? extends KtLifetimeToken> identifier = this.getTokenFactory().getIdentifier();
        KtFirAnalysisSessionProviderKt.access$flushPendingChanges(identifier, this.getProject());
        Pair key = new Pair((Object)useSiteKtModule, identifier);
        Object object = this.cache.computeIfAbsent((Pair<KtModule, KClass<? extends KtLifetimeToken>>)key, arg_0 -> KtFirAnalysisSessionProvider.getAnalysisSessionByUseSiteKtModule$lambda$0((Function1)new Function1<Pair<? extends KtModule, ? extends KClass<? extends KtLifetimeToken>>, CachedValue<KtAnalysisSession>>(this, useSiteKtModule){
            final /* synthetic */ KtFirAnalysisSessionProvider this$0;
            final /* synthetic */ KtModule $useSiteKtModule;
            {
                this.this$0 = $receiver;
                this.$useSiteKtModule = $useSiteKtModule;
                super(1);
            }

            public final CachedValue<KtAnalysisSession> invoke(Pair<? extends KtModule, ? extends KClass<? extends KtLifetimeToken>> it) {
                return CachedValuesManager.getManager((Project)this.this$0.getProject()).createCachedValue(() -> getAnalysisSessionByUseSiteKtModule.1.invoke$lambda$0(this.$useSiteKtModule, this.this$0));
            }

            private static final CachedValueProvider.Result invoke$lambda$0(KtModule $useSiteKtModule, KtFirAnalysisSessionProvider this$0) {
                Intrinsics.checkNotNullParameter((Object)$useSiteKtModule, (String)"$useSiteKtModule");
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                LLFirResolveSession firResolveSession = LowLevelFirApiFacadeKt.getFirResolveSession($useSiteKtModule, this$0.getProject());
                KtLifetimeToken validityToken = this$0.getTokenFactory().create(this$0.getProject());
                Object[] objectArray = new Object[]{firResolveSession.getUseSiteFirSession().createValidityTracker(), KotlinModificationTrackerFactoryKt.createProjectWideOutOfBlockModificationTracker((Project)this$0.getProject())};
                return new CachedValueProvider.Result((Object)KtFirAnalysisSession.Companion.createAnalysisSessionByFirResolveSession$analysis_api_fir(firResolveSession, validityToken), objectArray);
            }
        }, arg_0)).getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (KtAnalysisSession)object;
    }

    @Override
    public void clearCaches() {
        for (CachedValue cachedValue2 : this.cache.values()) {
            if (!(cachedValue2 instanceof CachedValueBase)) {
                boolean bl = false;
                String string = "Unsupported 'CachedValue' of type " + cachedValue2.getClass() + '\'';
                throw new IllegalStateException(string.toString());
            }
            ((CachedValueBase)cachedValue2).clear();
        }
    }

    private static final CachedValue getAnalysisSessionByUseSiteKtModule$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CachedValue)$tmp0.invoke(p0);
    }
}

