/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.annotations;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.annotations.KtAnnotationApplicationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KtAnnotationApplicationWithArgumentsInfo;
import org.jetbrains.kotlin.analysis.api.annotations.KtAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KtArrayAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KtConstantAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KtEnumEntryAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KtKClassAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KtNamedAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KtUnsupportedAnnotationValue;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001d\u0010\b\u001a\u00020\t*\u00060\u000bj\u0002`\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\fJ\u001d\u0010\r\u001a\u00020\t*\u00060\u000bj\u0002`\n2\u0006\u0010\u0006\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u001d\u0010\u0010\u001a\u00020\t*\u00060\u000bj\u0002`\n2\u0006\u0010\u0006\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012J\u001d\u0010\u0013\u001a\u00020\t*\u00060\u000bj\u0002`\n2\u0006\u0010\u0006\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015J\u001d\u0010\u0016\u001a\u00020\t*\u00060\u000bj\u0002`\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a2\u0006\u0002\u0010\u0019J\u001d\u0010\u001a\u001a\u00020\t*\u00060\u000bj\u0002`\n2\u0006\u0010\u0006\u001a\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010\u001cJ\u001d\u0010\u001d\u001a\u00020\t*\u00060\u000bj\u0002`\n2\u0006\u0010\u0006\u001a\u00020\u001eH\u0002\u00a2\u0006\u0002\u0010\u001fJ#\u0010 \u001a\u00020\t*\u00060\u000bj\u0002`\n2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00070\"H\u0002\u00a2\u0006\u0002\u0010#J#\u0010$\u001a\u00020\t*\u00060\u000bj\u0002`\n2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020%0\"H\u0002\u00a2\u0006\u0002\u0010#JU\u0010&\u001a\u00020\t\"\u0004\b\u0000\u0010'*\u00060\u000bj\u0002`\n2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H'0\"2\u0006\u0010)\u001a\u00020\u00052!\u0010\u0004\u001a\u001d\u0012\b\u0012\u00060\u000bj\u0002`\n\u0012\u0004\u0012\u0002H'\u0012\u0004\u0012\u00020\t0*\u00a2\u0006\u0002\b+H\u0082\b\u00a2\u0006\u0002\u0010,\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/analysis/api/annotations/KtAnnotationValueRenderer;", "", "<init>", "()V", "render", "", "value", "Lorg/jetbrains/kotlin/analysis/api/annotations/KtAnnotationValue;", "renderConstantValue", "", "Lkotlin/text/StringBuilder;", "Ljava/lang/StringBuilder;", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/analysis/api/annotations/KtAnnotationValue;)V", "renderKClassAnnotationValue", "Lorg/jetbrains/kotlin/analysis/api/annotations/KtKClassAnnotationValue;", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/analysis/api/annotations/KtKClassAnnotationValue;)V", "renderConstantAnnotationValue", "Lorg/jetbrains/kotlin/analysis/api/annotations/KtConstantAnnotationValue;", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/analysis/api/annotations/KtConstantAnnotationValue;)V", "renderEnumEntryConstantValue", "Lorg/jetbrains/kotlin/analysis/api/annotations/KtEnumEntryAnnotationValue;", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/analysis/api/annotations/KtEnumEntryAnnotationValue;)V", "renderAnnotationConstantValue", "application", "Lorg/jetbrains/kotlin/analysis/api/annotations/KtAnnotationApplicationValue;", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/analysis/api/annotations/KtAnnotationApplicationValue;)V", "renderAnnotationApplication", "Lorg/jetbrains/kotlin/analysis/api/annotations/KtAnnotationApplicationWithArgumentsInfo;", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/analysis/api/annotations/KtAnnotationApplicationWithArgumentsInfo;)V", "renderArrayConstantValue", "Lorg/jetbrains/kotlin/analysis/api/annotations/KtArrayAnnotationValue;", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/analysis/api/annotations/KtArrayAnnotationValue;)V", "renderConstantValueList", "list", "", "(Ljava/lang/StringBuilder;Ljava/util/Collection;)V", "renderNamedConstantValueList", "Lorg/jetbrains/kotlin/analysis/api/annotations/KtNamedAnnotationValue;", "renderWithSeparator", "E", "collection", "separator", "Lkotlin/Function2;", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/StringBuilder;Ljava/util/Collection;Ljava/lang/String;Lkotlin/jvm/functions/Function2;)V", "analysis-api"})
@SourceDebugExtension(value={"SMAP\nKtAnnotationValueRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtAnnotationValueRenderer.kt\norg/jetbrains/kotlin/analysis/api/annotations/KtAnnotationValueRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n94#1:102\n95#1,5:105\n100#1:111\n94#1:112\n95#1,5:115\n100#1:121\n1862#2,2:103\n1864#2:110\n1862#2,2:113\n1864#2:120\n1862#2,3:122\n*S KotlinDebug\n*F\n+ 1 KtAnnotationValueRenderer.kt\norg/jetbrains/kotlin/analysis/api/annotations/KtAnnotationValueRenderer\n*L\n75#1:102\n75#1:105,5\n75#1:111\n81#1:112\n81#1:115,5\n81#1:121\n75#1:103,2\n75#1:110\n81#1:113,2\n81#1:120\n94#1:122,3\n*E\n"})
public final class KtAnnotationValueRenderer {
    @NotNull
    public static final KtAnnotationValueRenderer INSTANCE = new KtAnnotationValueRenderer();

    private KtAnnotationValueRenderer() {
    }

    @NotNull
    public final String render(@NotNull KtAnnotationValue value) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        StringBuilder $this$render_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        INSTANCE.renderConstantValue($this$render_u24lambda_u240, value);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void renderConstantValue(StringBuilder $this$renderConstantValue, KtAnnotationValue value) {
        KtAnnotationValue ktAnnotationValue = value;
        if (ktAnnotationValue instanceof KtAnnotationApplicationValue) {
            this.renderAnnotationConstantValue($this$renderConstantValue, (KtAnnotationApplicationValue)value);
        } else if (ktAnnotationValue instanceof KtArrayAnnotationValue) {
            this.renderArrayConstantValue($this$renderConstantValue, (KtArrayAnnotationValue)value);
        } else if (ktAnnotationValue instanceof KtEnumEntryAnnotationValue) {
            this.renderEnumEntryConstantValue($this$renderConstantValue, (KtEnumEntryAnnotationValue)value);
        } else if (ktAnnotationValue instanceof KtConstantAnnotationValue) {
            this.renderConstantAnnotationValue($this$renderConstantValue, (KtConstantAnnotationValue)value);
        } else if (Intrinsics.areEqual((Object)ktAnnotationValue, (Object)KtUnsupportedAnnotationValue.INSTANCE)) {
            $this$renderConstantValue.append("error(\"non-annotation value\")");
        } else if (ktAnnotationValue instanceof KtKClassAnnotationValue) {
            this.renderKClassAnnotationValue($this$renderConstantValue, (KtKClassAnnotationValue)value);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void renderKClassAnnotationValue(StringBuilder $this$renderKClassAnnotationValue, KtKClassAnnotationValue value) {
        StringBuilder stringBuilder;
        KtKClassAnnotationValue ktKClassAnnotationValue = value;
        if (ktKClassAnnotationValue instanceof KtKClassAnnotationValue.KtErrorClassAnnotationValue) {
            stringBuilder = $this$renderKClassAnnotationValue.append("UNRESOLVED_CLASS");
        } else if (ktKClassAnnotationValue instanceof KtKClassAnnotationValue.KtLocalKClassAnnotationValue) {
            Name name = ((KtKClassAnnotationValue.KtLocalKClassAnnotationValue)value).getKtClass().getNameAsName();
            stringBuilder = $this$renderKClassAnnotationValue.append(name != null ? RenderingUtilsKt.render((Name)name) : null);
        } else if (ktKClassAnnotationValue instanceof KtKClassAnnotationValue.KtNonLocalKClassAnnotationValue) {
            stringBuilder = $this$renderKClassAnnotationValue.append(RenderingUtilsKt.render((FqName)((KtKClassAnnotationValue.KtNonLocalKClassAnnotationValue)value).getClassId().asSingleFqName()));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        $this$renderKClassAnnotationValue.append("::class");
    }

    private final void renderConstantAnnotationValue(StringBuilder $this$renderConstantAnnotationValue, KtConstantAnnotationValue value) {
        $this$renderConstantAnnotationValue.append(value.getConstantValue().renderAsKotlinConstant());
    }

    private final void renderEnumEntryConstantValue(StringBuilder $this$renderEnumEntryConstantValue, KtEnumEntryAnnotationValue value) {
        CallableId callableId = value.getCallableId();
        $this$renderEnumEntryConstantValue.append(callableId != null && (callableId = callableId.asSingleFqName()) != null ? callableId.asString() : null);
    }

    private final void renderAnnotationConstantValue(StringBuilder $this$renderAnnotationConstantValue, KtAnnotationApplicationValue application) {
        this.renderAnnotationApplication($this$renderAnnotationConstantValue, application.getAnnotationValue());
    }

    private final void renderAnnotationApplication(StringBuilder $this$renderAnnotationApplication, KtAnnotationApplicationWithArgumentsInfo value) {
        $this$renderAnnotationApplication.append(value.getClassId());
        if (!((Collection)value.getArguments()).isEmpty()) {
            $this$renderAnnotationApplication.append("(");
            this.renderNamedConstantValueList($this$renderAnnotationApplication, (Collection<KtNamedAnnotationValue>)value.getArguments());
            $this$renderAnnotationApplication.append(")");
        }
    }

    private final void renderArrayConstantValue(StringBuilder $this$renderArrayConstantValue, KtArrayAnnotationValue value) {
        $this$renderArrayConstantValue.append("[");
        this.renderConstantValueList($this$renderArrayConstantValue, value.getValues());
        $this$renderArrayConstantValue.append("]");
    }

    /*
     * WARNING - void declaration
     */
    private final void renderConstantValueList(StringBuilder $this$renderConstantValueList, Collection<? extends KtAnnotationValue> list) {
        KtAnnotationValueRenderer ktAnnotationValueRenderer = this;
        StringBuilder stringBuilder = $this$renderConstantValueList;
        String separator$iv = ", ";
        boolean $i$f$renderWithSeparator = false;
        Iterable $this$forEachIndexed$iv$iv = list;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
            void constantValue;
            void $this$renderWithSeparator$iv;
            void element$iv;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv;
            int index$iv = n;
            boolean bl = false;
            KtAnnotationValue ktAnnotationValue = (KtAnnotationValue)element$iv;
            void $this$renderConstantValueList_u24lambda_u241 = $this$renderWithSeparator$iv;
            boolean bl2 = false;
            INSTANCE.renderConstantValue((StringBuilder)$this$renderConstantValueList_u24lambda_u241, (KtAnnotationValue)constantValue);
            if (index$iv == list.size() - 1) continue;
            $this$renderWithSeparator$iv.append(separator$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderNamedConstantValueList(StringBuilder $this$renderNamedConstantValueList, Collection<KtNamedAnnotationValue> list) {
        KtAnnotationValueRenderer ktAnnotationValueRenderer = this;
        StringBuilder stringBuilder = $this$renderNamedConstantValueList;
        String separator$iv = ", ";
        boolean $i$f$renderWithSeparator = false;
        Iterable $this$forEachIndexed$iv$iv = list;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
            void namedValue;
            void $this$renderWithSeparator$iv;
            void element$iv;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv;
            int index$iv = n;
            boolean bl = false;
            KtNamedAnnotationValue ktNamedAnnotationValue = (KtNamedAnnotationValue)element$iv;
            void $this$renderNamedConstantValueList_u24lambda_u242 = $this$renderWithSeparator$iv;
            boolean bl2 = false;
            $this$renderNamedConstantValueList_u24lambda_u242.append(namedValue.getName());
            $this$renderNamedConstantValueList_u24lambda_u242.append(" = ");
            INSTANCE.renderConstantValue((StringBuilder)$this$renderNamedConstantValueList_u24lambda_u242, namedValue.getExpression());
            $this$renderNamedConstantValueList_u24lambda_u242.append(", ");
            if (index$iv == list.size() - 1) continue;
            $this$renderWithSeparator$iv.append(separator$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final <E> void renderWithSeparator(StringBuilder $this$renderWithSeparator, Collection<? extends E> collection, String separator, Function2<? super StringBuilder, ? super E, Unit> render) {
        boolean $i$f$renderWithSeparator = false;
        Iterable $this$forEachIndexed$iv = collection;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void element;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv;
            int index = n;
            boolean bl = false;
            render.invoke((Object)$this$renderWithSeparator, (Object)element);
            if (index == collection.size() - 1) continue;
            $this$renderWithSeparator.append(separator);
        }
    }
}

