/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.LLFirModuleResolveComponents;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.DiagnosticCheckerFilter;
import org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics.FileStructureElementDiagnosticList;
import org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics.FileStructureElementDiagnostics;
import org.jetbrains.kotlin.analysis.low.level.api.fir.element.builder.FirElementBuilderKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.DeclarationStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileElementFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileStructure;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.RootStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.DeclarationUtilsKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.ExceptionUtilsKt;
import org.jetbrains.kotlin.diagnostics.KtPsiDiagnostic;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElementWithResolveState;
import org.jetbrains.kotlin.fir.FirFileAnnotationsContainer;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirCodeFragment;
import org.jetbrains.kotlin.fir.declarations.FirDanglingModifierList;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.impl.FirPrimaryConstructor;
import org.jetbrains.kotlin.fir.resolve.providers.FirProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachementBuilderUtilsKt;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;
import org.jetbrains.kotlin.utils.exceptions.KotlinExceptionWithAttachments;
import org.jetbrains.kotlin.utils.exceptions.KotlinIllegalArgumentExceptionWithAttachments;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 )2\u00020\u0001:\u0001)B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000eJ\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000eJ\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0014\u0010\u0017\u001a\u00020\u0018*\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001eJ(\u0010\u001f\u001a\u00020\u0011*\b\u0012\u0004\u0012\u00020\u001c0 2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000f0!2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000f0!J\u0010\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u0016H\u0002J\u0010\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructure;", "", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "firFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "moduleComponents", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/fir/declarations/FirFile;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;)V", "firProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirProvider;", "structureElements", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructureElement;", "invalidateElement", "", "element", "getStructureElementFor", "getContainerKtElement", "getStructureKtElement", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "isPartOfSuperClassCall", "", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "getAllDiagnosticsForFile", "", "Lorg/jetbrains/kotlin/diagnostics/KtPsiDiagnostic;", "diagnosticCheckerFilter", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/DiagnosticCheckerFilter;", "collectDiagnosticsFromStructureElements", "", "", "getAllStructureElements", "createDeclarationStructure", "declaration", "createDanglingModifierListStructure", "container", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "createStructureElement", "Companion", "low-level-api-fir"})
@SourceDebugExtension(value={"SMAP\nFileStructure.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileStructure.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructure\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 FileStructureElementDiagnostics.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/diagnostics/FileStructureElementDiagnostics\n+ 6 FileStructureElementDiagnosticList.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/diagnostics/FileStructureElementDiagnosticList\n+ 7 ExceptionAttachmentBuilder.kt\norg/jetbrains/kotlin/utils/exceptions/ExceptionAttachmentBuilderKt\n*L\n1#1,223:1\n72#2,2:224\n1#3:226\n1855#4:227\n1855#4,2:231\n1856#4:237\n1855#4,2:238\n40#5,2:228\n43#5,4:233\n16#6:230\n81#7,7:240\n76#7,2:247\n57#7:249\n78#7:250\n*S KotlinDebug\n*F\n+ 1 FileStructure.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructure\n*L\n66#1:224,2\n66#1:226\n129#1:227\n130#1:231,2\n129#1:237\n173#1:238,2\n130#1:228,2\n130#1:233,4\n130#1:230\n218#1:240,7\n218#1:247,2\n218#1:249\n218#1:250\n*E\n"})
public final class FileStructure {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KtFile ktFile;
    @NotNull
    private final FirFile firFile;
    @NotNull
    private final LLFirModuleResolveComponents moduleComponents;
    @NotNull
    private final FirProvider firProvider;
    @NotNull
    private final ConcurrentHashMap<KtElement, FileStructureElement> structureElements;

    private FileStructure(KtFile ktFile, FirFile firFile, LLFirModuleResolveComponents moduleComponents) {
        this.ktFile = ktFile;
        this.firFile = firFile;
        this.moduleComponents = moduleComponents;
        this.firProvider = FirProviderKt.getFirProvider((FirSession)this.firFile.getModuleData().getSession());
        this.structureElements = new ConcurrentHashMap();
    }

    public final void invalidateElement(@NotNull KtElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtElement container2 = this.getContainerKtElement(element);
        this.structureElements.remove(container2);
    }

    @NotNull
    public final FileStructureElement getStructureElementFor(@NotNull KtElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtElement container2 = this.getContainerKtElement(element);
        ConcurrentMap $this$getOrPut$iv = this.structureElements;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(container2);
        if (object == null) {
            boolean bl = false;
            FileStructureElement default$iv = this.createStructureElement(container2);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(container2, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
        return (FileStructureElement)object;
    }

    private final KtElement getContainerKtElement(KtElement element) {
        KtDeclaration declaration = this.getStructureKtElement(element);
        KtElement container2 = null;
        if (declaration != null) {
            container2 = (KtElement)declaration;
        } else {
            KtModifierList ktModifierList;
            KtModifierList modifierList = (KtModifierList)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)element), KtModifierList.class, (boolean)false);
            if (modifierList != null && modifierList.getNextSibling() instanceof PsiErrorElement) {
                ktModifierList = modifierList;
            } else {
                KtFile ktFile = element.getContainingKtFile();
                Intrinsics.checkNotNull((Object)ktFile);
                ktModifierList = ktFile;
            }
            container2 = (KtElement)ktModifierList;
        }
        return container2;
    }

    private final KtDeclaration getStructureKtElement(KtElement element) {
        KtPrimaryConstructor resultedContainer;
        KtDeclaration container2 = FirElementBuilderKt.getNonLocalContainingOrThisDeclaration((PsiElement)element, (Function1<? super KtDeclaration, Boolean>)((Function1)getStructureKtElement.container.1.INSTANCE));
        KtPrimaryConstructor ktPrimaryConstructor = resultedContainer = container2 instanceof KtClassOrObject && this.isPartOfSuperClassCall((KtClassOrObject)container2, element) ? ((KtClassOrObject)container2).getPrimaryConstructor() : null;
        return ktPrimaryConstructor != null ? (KtDeclaration)ktPrimaryConstructor : container2;
    }

    private final boolean isPartOfSuperClassCall(KtClassOrObject $this$isPartOfSuperClassCall, KtElement element) {
        for (KtSuperTypeListEntry entry : $this$isPartOfSuperClassCall.getSuperTypeListEntries()) {
            boolean typeReferenceIsAncestor;
            if (!(entry instanceof KtSuperTypeCallEntry)) continue;
            KtTypeReference ktTypeReference = ((KtSuperTypeCallEntry)entry).getCalleeExpression().getTypeReference();
            boolean bl = ktTypeReference != null ? PsiUtilsKt.isAncestor((PsiElement)((PsiElement)ktTypeReference), (PsiElement)((PsiElement)element), (boolean)false) : (typeReferenceIsAncestor = false);
            if (typeReferenceIsAncestor) {
                return false;
            }
            if (!PsiUtilsKt.isAncestor((PsiElement)((PsiElement)entry), (PsiElement)((PsiElement)element), (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final List<KtPsiDiagnostic> getAllDiagnosticsForFile(@NotNull DiagnosticCheckerFilter diagnosticCheckerFilter) {
        List list;
        Intrinsics.checkNotNullParameter((Object)((Object)diagnosticCheckerFilter), (String)"diagnosticCheckerFilter");
        FirLazyDeclarationResolverKt.lazyResolveToPhase((FirDeclaration)((FirDeclaration)this.firFile), (FirResolvePhase)FirResolvePhase.BODY_RESOLVE);
        Collection<FileStructureElement> structureElements = this.getAllStructureElements();
        List $this$getAllDiagnosticsForFile_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        this.collectDiagnosticsFromStructureElements($this$getAllDiagnosticsForFile_u24lambda_u241, structureElements, diagnosticCheckerFilter);
        return CollectionsKt.build((List)list);
    }

    private final void collectDiagnosticsFromStructureElements(Collection<KtPsiDiagnostic> $this$collectDiagnosticsFromStructureElements, Collection<? extends FileStructureElement> structureElements, DiagnosticCheckerFilter diagnosticCheckerFilter) {
        Iterable $this$forEach$iv = structureElements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            List diagnostics;
            boolean $i$f$forEach2;
            Iterable $this$forEach$iv$iv$iv;
            boolean $i$f$forEach3;
            FileStructureElementDiagnosticList this_$iv$iv;
            FileStructureElement structureElement = (FileStructureElement)element$iv;
            boolean bl2 = false;
            FileStructureElementDiagnostics this_$iv = structureElement.getDiagnostics();
            boolean $i$f$forEach4 = false;
            if (diagnosticCheckerFilter.getRunCommonCheckers()) {
                this_$iv$iv = FileStructureElementDiagnostics.access$getDiagnosticByCommonCheckers(this_$iv);
                $i$f$forEach3 = false;
                $this$forEach$iv$iv$iv = FileStructureElementDiagnosticList.access$getMap$p(this_$iv$iv).values();
                $i$f$forEach2 = false;
                for (Object element$iv$iv$iv : $this$forEach$iv$iv$iv) {
                    diagnostics = (List)element$iv$iv$iv;
                    bl = false;
                    $this$collectDiagnosticsFromStructureElements.addAll(diagnostics);
                }
            }
            if (!diagnosticCheckerFilter.getRunExtendedCheckers()) continue;
            this_$iv$iv = FileStructureElementDiagnostics.access$getDiagnosticByExtendedCheckers(this_$iv);
            $i$f$forEach3 = false;
            $this$forEach$iv$iv$iv = FileStructureElementDiagnosticList.access$getMap$p(this_$iv$iv).values();
            $i$f$forEach2 = false;
            for (Object element$iv$iv$iv : $this$forEach$iv$iv$iv) {
                diagnostics = (List)element$iv$iv$iv;
                bl = false;
                $this$collectDiagnosticsFromStructureElements.addAll(diagnostics);
            }
        }
    }

    @NotNull
    public final Collection<FileStructureElement> getAllStructureElements() {
        Object[] objectArray = new FileStructureElement[]{this.getStructureElementFor((KtElement)this.ktFile)};
        Set structureElements = SetsKt.mutableSetOf((Object[])objectArray);
        this.ktFile.accept((PsiElementVisitor)new KtVisitorVoid(this, structureElements){
            final /* synthetic */ FileStructure this$0;
            final /* synthetic */ Set<FileStructureElement> $structureElements;
            {
                this.this$0 = $receiver;
                this.$structureElements = $structureElements;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                element.acceptChildren((PsiElementVisitor)this);
            }

            public void visitDeclaration(KtDeclaration dcl) {
                boolean canHaveInnerStructure;
                Intrinsics.checkNotNullParameter((Object)dcl, (String)"dcl");
                FileStructureElement structureElement = this.this$0.getStructureElementFor((KtElement)dcl);
                ((Collection)this.$structureElements).add(structureElement);
                boolean bl = canHaveInnerStructure = dcl instanceof KtClassOrObject || dcl instanceof KtScript;
                if (canHaveInnerStructure) {
                    dcl.acceptChildren((PsiElementVisitor)this);
                }
            }

            public void visitModifierList(KtModifierList list) {
                Intrinsics.checkNotNullParameter((Object)list, (String)"list");
                if (Intrinsics.areEqual((Object)list.getParent(), (Object)FileStructure.access$getKtFile$p(this.this$0))) {
                    ((Collection)this.$structureElements).add(this.this$0.getStructureElementFor((KtElement)list));
                }
            }
        });
        return structureElements;
    }

    private final FileStructureElement createDeclarationStructure(KtDeclaration declaration) {
        FirDeclaration firDeclaration = DeclarationUtilsKt.findSourceNonLocalFirDeclaration(declaration, this.firFile, this.firProvider);
        FirLazyDeclarationResolverKt.lazyResolveToPhase((FirDeclaration)firDeclaration, (FirResolvePhase)FirResolvePhase.BODY_RESOLVE);
        if (firDeclaration instanceof FirPrimaryConstructor) {
            Iterable $this$forEach$iv = ((FirPrimaryConstructor)firDeclaration).getValueParameters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirValueParameter parameter2 = (FirValueParameter)element$iv;
                boolean bl = false;
                FirProperty firProperty = ClassMembersKt.getCorrespondingProperty((FirValueParameter)parameter2);
                if (firProperty != null) {
                    FirLazyDeclarationResolverKt.lazyResolveToPhase((FirDeclaration)((FirDeclaration)firProperty), (FirResolvePhase)FirResolvePhase.BODY_RESOLVE);
                }
            }
        }
        return FileElementFactory.INSTANCE.createFileStructureElement(firDeclaration, this.firFile, this.moduleComponents);
    }

    private final FileStructureElement createDanglingModifierListStructure(KtModifierList container2) {
        FirDeclaration firDeclaration = DeclarationUtilsKt.findSourceByTraversingWholeTree((KtElement)container2, this.moduleComponents.getFirFileBuilder(), this.firFile);
        FirDanglingModifierList firDanglingModifierList = firDeclaration instanceof FirDanglingModifierList ? (FirDanglingModifierList)firDeclaration : null;
        if (firDanglingModifierList == null) {
            ExceptionUtilsKt.errorWithFirSpecificEntries$default("No dangling modifier found", null, null, null, (PsiElement)container2, null, 46, null);
            throw null;
        }
        FirDanglingModifierList firDanglingModifierList2 = firDanglingModifierList;
        FirLazyDeclarationResolverKt.lazyResolveToPhase((FirDeclaration)((FirDeclaration)firDanglingModifierList2), (FirResolvePhase)FirResolvePhase.BODY_RESOLVE);
        return new DeclarationStructureElement(this.firFile, (FirDeclaration)firDanglingModifierList2, this.moduleComponents);
    }

    /*
     * WARNING - void declaration
     */
    private final FileStructureElement createStructureElement(KtElement container2) {
        FileStructureElement fileStructureElement;
        if (container2 instanceof KtCodeFragment) {
            FirCodeFragment firCodeFragment = DeclarationUtilsKt.getCodeFragment(this.firFile);
            FirLazyDeclarationResolverKt.lazyResolveToPhase((FirDeclaration)((FirDeclaration)firCodeFragment), (FirResolvePhase)FirResolvePhase.BODY_RESOLVE);
            fileStructureElement = new DeclarationStructureElement(this.firFile, (FirDeclaration)firCodeFragment, this.moduleComponents);
        } else if (container2 instanceof KtFile) {
            FirFile firFile = this.moduleComponents.getFirFileBuilder().buildRawFirFileWithCaching(this.ktFile);
            FirLazyDeclarationResolverKt.lazyResolveToPhase((FirDeclaration)((FirDeclaration)firFile), (FirResolvePhase)FirResolvePhase.IMPORTS);
            FirFileAnnotationsContainer firFileAnnotationsContainer = firFile.getAnnotationsContainer();
            if (firFileAnnotationsContainer != null) {
                FirFileAnnotationsContainer it = firFileAnnotationsContainer;
                boolean bl = false;
                this.moduleComponents.getFirModuleLazyDeclarationResolver().lazyResolve((FirElementWithResolveState)it, this.moduleComponents.getScopeSessionProvider().getScopeSession(), FirResolvePhase.BODY_RESOLVE);
            }
            fileStructureElement = new RootStructureElement(firFile, this.moduleComponents);
        } else if (container2 instanceof KtDeclaration) {
            fileStructureElement = this.createDeclarationStructure((KtDeclaration)container2);
        } else if (container2 instanceof KtModifierList && ((KtModifierList)container2).getNextSibling() instanceof PsiErrorElement) {
            fileStructureElement = this.createDanglingModifierListStructure((KtModifierList)container2);
        } else {
            void $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder;
            String message$iv = "Invalid container " + Reflection.getOrCreateKotlinClass(container2.getClass());
            Throwable cause$iv = null;
            String attachmentName$iv = "info.txt";
            boolean $i$f$errorWithAttachment = false;
            boolean $i$f$buildErrorWithAttachment = false;
            KotlinIllegalArgumentExceptionWithAttachments exception$iv$iv = new KotlinIllegalArgumentExceptionWithAttachments(message$iv, cause$iv);
            KotlinExceptionWithAttachments $this$buildAttachment$iv$iv$iv = (KotlinExceptionWithAttachments)exception$iv$iv;
            boolean $i$f$buildAttachment = false;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder2 = exceptionAttachmentBuilder = new ExceptionAttachmentBuilder();
            String string = attachmentName$iv;
            KotlinExceptionWithAttachments kotlinExceptionWithAttachments = $this$buildAttachment$iv$iv$iv;
            boolean bl = false;
            void $this$createStructureElement_u24lambda_u246 = $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
            boolean bl2 = false;
            ExceptionAttachementBuilderUtilsKt.withPsiEntry((ExceptionAttachmentBuilder)$this$createStructureElement_u24lambda_u246, (String)"container", (PsiElement)((PsiElement)container2));
            kotlinExceptionWithAttachments.withAttachment(string, (Object)exceptionAttachmentBuilder.buildString());
            throw (Throwable)exception$iv$iv;
        }
        return fileStructureElement;
    }

    public /* synthetic */ FileStructure(KtFile ktFile, FirFile firFile, LLFirModuleResolveComponents moduleComponents, DefaultConstructorMarker $constructor_marker) {
        this(ktFile, firFile, moduleComponents);
    }

    public static final /* synthetic */ KtFile access$getKtFile$p(FileStructure $this) {
        return $this.ktFile;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructure$Companion;", "", "<init>", "()V", "build", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructure;", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "moduleComponents", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;", "low-level-api-fir"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FileStructure build(@NotNull KtFile ktFile, @NotNull LLFirModuleResolveComponents moduleComponents) {
            Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
            Intrinsics.checkNotNullParameter((Object)moduleComponents, (String)"moduleComponents");
            FirFile firFile = moduleComponents.getFirFileBuilder().buildRawFirFileWithCaching(ktFile);
            return new FileStructure(ktFile, firFile, moduleComponents, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

