/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.annotation;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.annotation.AnnotatedElement;
import org.jetbrains.kotlin.annotation.AnnotatedElementKt;
import org.jetbrains.kotlin.annotation.AnnotationWriter;
import org.jetbrains.kotlin.annotation.KotlinAnnotationProvider;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0005B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0006\u001a\u00020\u0007H\u0004J\u000e\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020&R#\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR<\u0010\u0010\u001a*\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00120\u0011j\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u0012`\u0013X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R$\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\u001aj\b\u0012\u0004\u0012\u00020\u000b`\u001bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/annotation/KotlinAnnotationProvider;", "", "annotationsFile", "Ljava/io/File;", "(Ljava/io/File;)V", "()V", "annotationsReader", "Ljava/io/Reader;", "(Ljava/io/Reader;)V", "annotatedKotlinElements", "", "", "", "Lorg/jetbrains/kotlin/annotation/AnnotatedElement;", "getAnnotatedKotlinElements", "()Ljava/util/Map;", "annotatedKotlinElementsInternal", "Ljava/util/LinkedHashMap;", "", "Lkotlin/collections/LinkedHashMap;", "getAnnotatedKotlinElementsInternal", "()Ljava/util/LinkedHashMap;", "kotlinClasses", "getKotlinClasses", "()Ljava/util/Set;", "kotlinClassesInternal", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "getKotlinClassesInternal", "()Ljava/util/LinkedHashSet;", "supportInheritedAnnotations", "", "getSupportInheritedAnnotations", "()Z", "readAnnotations", "", "writeAnnotations", "writer", "Lorg/jetbrains/kotlin/annotation/AnnotationWriter;", "kotlin-annotation-processing"})
public class KotlinAnnotationProvider {
    @NotNull
    private final LinkedHashSet<String> kotlinClassesInternal;
    @NotNull
    private final LinkedHashMap<String, Set<AnnotatedElement>> annotatedKotlinElementsInternal;

    @NotNull
    protected final LinkedHashSet<String> getKotlinClassesInternal() {
        return this.kotlinClassesInternal;
    }

    @NotNull
    protected final LinkedHashMap<String, Set<AnnotatedElement>> getAnnotatedKotlinElementsInternal() {
        return this.annotatedKotlinElementsInternal;
    }

    @NotNull
    public final Map<String, Set<AnnotatedElement>> getAnnotatedKotlinElements() {
        return this.annotatedKotlinElementsInternal;
    }

    @NotNull
    public final Set<String> getKotlinClasses() {
        return this.kotlinClassesInternal;
    }

    public final boolean getSupportInheritedAnnotations() {
        Collection collection = this.kotlinClassesInternal;
        return !collection.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void readAnnotations(@NotNull Reader annotationsReader) {
        Intrinsics.checkParameterIsNotNull((Object)annotationsReader, (String)"annotationsReader");
        readAnnotations.1 handleShortenedName$ = readAnnotations.1.INSTANCE;
        LinkedHashMap shortenedAnnotationCache = new LinkedHashMap();
        LinkedHashMap shortenedPackageNameCache = new LinkedHashMap();
        Function1<String, String> expandAnnotation$ = new Function1<String, String>(shortenedAnnotationCache){
            final /* synthetic */ LinkedHashMap $shortenedAnnotationCache;

            @NotNull
            public final String invoke(@NotNull String s) {
                Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
                Map map = this.$shortenedAnnotationCache;
                Object object = map.get(s);
                if (object == null) {
                    object = s;
                }
                return (String)object;
            }
            {
                this.$shortenedAnnotationCache = linkedHashMap;
                super(1);
            }
        };
        Function1<String, String> expandClassName$ = new Function1<String, String>(shortenedPackageNameCache){
            final /* synthetic */ LinkedHashMap $shortenedPackageNameCache;

            @NotNull
            public final String invoke(@NotNull String s) {
                Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
                String id = StringsKt.substringBefore((String)s, (char)'/', (String)"");
                CharSequence charSequence = id;
                if (charSequence.length() == 0) {
                    return s;
                }
                String string = (String)this.$shortenedPackageNameCache.get(id);
                if (string == null) {
                    throw (Throwable)new RuntimeException("Value for " + id + " couldn't be found in shrink cache");
                }
                String shortenedValue = string;
                String string2 = s;
                int n = id.length() + 1;
                StringBuilder stringBuilder = new StringBuilder().append(shortenedValue).append('.');
                String string3 = string2.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                String string4 = string3;
                return stringBuilder.append(string4).toString();
            }
            {
                this.$shortenedPackageNameCache = linkedHashMap;
                super(1);
            }
        };
        Reader $receiver$iv = annotationsReader;
        Closeable closeable = $receiver$iv;
        int n = 8192;
        closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
        n = 0;
        try {
            BufferedReader it$iv = (BufferedReader)closeable;
            Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
            block31: for (String line : lines) {
                String type;
                CharSequence charSequence = line;
                if (charSequence.length() == 0) continue;
                List lineParts = StringsKt.split$default((CharSequence)line, (char[])new char[]{' '}, (boolean)false, (int)0, (int)6, null);
                switch (type = (String)lineParts.get(0)) {
                    case "a": {
                        readAnnotations.1.INSTANCE.invoke(shortenedAnnotationCache, lineParts);
                        continue block31;
                    }
                    case "p": {
                        readAnnotations.1.INSTANCE.invoke(shortenedPackageNameCache, lineParts);
                        continue block31;
                    }
                    case "d": {
                        String classFqName = StringsKt.replace$default((String)expandClassName$.invoke((String)lineParts.get(1)), (char)'$', (char)'.', (boolean)false, (int)4, null);
                        this.kotlinClassesInternal.add(classFqName);
                        continue block31;
                    }
                    case "c": 
                    case "f": 
                    case "m": {
                        AnnotatedElement annotatedElement;
                        Object object;
                        String annotationName = expandAnnotation$.invoke((String)lineParts.get(1));
                        String classFqName = StringsKt.replace$default((String)expandClassName$.invoke((String)lineParts.get(2)), (char)'$', (char)'.', (boolean)false, (int)4, null);
                        String elementName = lineParts.size() == 4 ? (String)lineParts.get(3) : null;
                        Map $receiver$iv2 = this.annotatedKotlinElementsInternal;
                        Object value$iv = $receiver$iv2.get(annotationName);
                        if (value$iv == null) {
                            LinkedHashSet answer$iv = new LinkedHashSet();
                            $receiver$iv2.put(annotationName, answer$iv);
                            object = answer$iv;
                        } else {
                            object = value$iv;
                        }
                        Set set = (Set)object;
                        switch (type) {
                            case "c": {
                                annotatedElement = new AnnotatedElement.Class(classFqName);
                                break;
                            }
                            case "f": {
                                String name;
                                if (elementName == null) {
                                    throw (Throwable)((Object)new AssertionError((Object)"Name for field must be provided"));
                                }
                                annotatedElement = new AnnotatedElement.Field(classFqName, name);
                                break;
                            }
                            case "m": {
                                String name;
                                if (elementName == null) {
                                    throw (Throwable)((Object)new AssertionError((Object)"Name for method must be provided"));
                                }
                                if (Intrinsics.areEqual((Object)"<init>", (Object)name)) {
                                    annotatedElement = new AnnotatedElement.Constructor(classFqName);
                                    break;
                                }
                                annotatedElement = new AnnotatedElement.Method(classFqName, name);
                                break;
                            }
                            default: {
                                throw (Throwable)((Object)new AssertionError((Object)("Unknown type: " + type)));
                            }
                        }
                        set.add(annotatedElement);
                        continue block31;
                    }
                }
                throw (Throwable)((Object)new AssertionError((Object)("Unknown type: " + type)));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception exception) {
            n = 1;
            try {
                closeable.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw (Throwable)exception;
        }
        finally {
            if (n == 0) {
                closeable.close();
            }
        }
    }

    public final void writeAnnotations(@NotNull AnnotationWriter writer) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        Map<String, Set<AnnotatedElement>> map = this.getAnnotatedKotlinElements();
        Iterator<Object> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Set<AnnotatedElement>> entry;
            Map.Entry<String, Set<AnnotatedElement>> entry2 = entry = iterator.next();
            String annotation = entry2.getKey();
            entry2 = entry;
            Set<AnnotatedElement> elements = entry2.getValue();
            for (AnnotatedElement element : elements) {
                AnnotatedElementKt.writeAnnotatedElement(writer, annotation, element);
            }
        }
        for (String className : this.getKotlinClasses()) {
            writer.writeClassDeclaration(className);
        }
    }

    public KotlinAnnotationProvider(@NotNull Reader annotationsReader) {
        Intrinsics.checkParameterIsNotNull((Object)annotationsReader, (String)"annotationsReader");
        KotlinAnnotationProvider kotlinAnnotationProvider = this;
        Cloneable cloneable = new LinkedHashSet();
        kotlinAnnotationProvider.kotlinClassesInternal = cloneable;
        kotlinAnnotationProvider = this;
        cloneable = new LinkedHashMap();
        kotlinAnnotationProvider.annotatedKotlinElementsInternal = cloneable;
        this.readAnnotations(annotationsReader);
    }

    public KotlinAnnotationProvider(@NotNull File annotationsFile) {
        Intrinsics.checkParameterIsNotNull((Object)annotationsFile, (String)"annotationsFile");
        Object object = annotationsFile;
        KotlinAnnotationProvider kotlinAnnotationProvider = this;
        Charset charset = Charsets.UTF_8;
        Object object2 = object;
        object2 = new FileInputStream((File)object2);
        Reader reader = new InputStreamReader((InputStream)object2, charset);
        object = reader;
        int n = 8192;
        reader = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
        kotlinAnnotationProvider(reader);
    }

    public KotlinAnnotationProvider() {
        this(new StringReader(""));
    }
}

