/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.java.model.elements;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiMember;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.java.model.JeAbstractElement;
import org.jetbrains.kotlin.java.model.JeAnnotationOwner;
import org.jetbrains.kotlin.java.model.JeElement;
import org.jetbrains.kotlin.java.model.JeModifierListOwner;
import org.jetbrains.kotlin.java.model.JeName;
import org.jetbrains.kotlin.java.model.JeNameKt;
import org.jetbrains.kotlin.java.model.elements.JeAnnotationMirror;
import org.jetbrains.kotlin.java.model.elements.JeMethodExecutableElement;
import org.jetbrains.kotlin.java.model.elements.JeTypeElement;
import org.jetbrains.kotlin.java.model.internal.InternalUtilKt;
import org.jetbrains.kotlin.java.model.types.JeTypeUtils;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u00042\u00020\u0005B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0007J=\u0010\b\u001a\n \n*\u0004\u0018\u0001H\tH\t\"\u0004\b\u0000\u0010\t\"\u0004\b\u0001\u0010\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\u000b0\r2\u0006\u0010\u000e\u001a\u0002H\u000bH\u0016\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096\u0002J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\r\u0010\"\u001a\u00070#\u00a2\u0006\u0002\b$H\u0016\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/java/model/elements/JeVariableElement;", "Lorg/jetbrains/kotlin/java/model/JeAbstractElement;", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiVariable;", "Ljavax/lang/model/element/VariableElement;", "Lorg/jetbrains/kotlin/java/model/JeModifierListOwner;", "Lorg/jetbrains/kotlin/java/model/JeAnnotationOwner;", "psi", "(Lorg/jetbrains/kotlin/com/intellij/psi/PsiVariable;)V", "accept", "R", "kotlin.jvm.PlatformType", "P", "v", "Ljavax/lang/model/element/ElementVisitor;", "p", "(Ljavax/lang/model/element/ElementVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "asType", "Ljavax/lang/model/type/TypeMirror;", "equals", "", "other", "", "getConstantValue", "getEnclosedElements", "", "Ljavax/lang/model/element/Element;", "getEnclosingElement", "Lorg/jetbrains/kotlin/java/model/JeElement;", "getKind", "Ljavax/lang/model/element/ElementKind;", "getSimpleName", "Lorg/jetbrains/kotlin/java/model/JeName;", "hashCode", "", "toString", "", "Lorg/jetbrains/annotations/Nullable;", "kotlin-annotation-processing"})
public final class JeVariableElement
extends JeAbstractElement<PsiVariable>
implements VariableElement,
JeModifierListOwner,
JeAnnotationOwner {
    @Override
    @NotNull
    public JeName getSimpleName() {
        return JeNameKt.JeName(((PsiVariable)this.getPsi()).getName());
    }

    @Override
    @Nullable
    public JeElement getEnclosingElement() {
        JeTypeElement jeTypeElement;
        PsiMember containingClass;
        PsiMember psiMember;
        PsiVariable psiVariable;
        PsiVariable psi = (PsiVariable)this.getPsi();
        if (psi instanceof PsiParameter) {
            PsiElement psiElement = ((PsiParameter)psi).getDeclarationScope();
            if (!(psiElement instanceof PsiMethod)) {
                psiElement = null;
            }
            PsiMethod psiMethod = (PsiMethod)psiElement;
            if (psiMethod != null) {
                PsiMethod psiMethod2 = psiMethod;
                PsiMethod it = psiMethod2;
                return new JeMethodExecutableElement(it);
            }
        }
        if (!((psiVariable = psi) instanceof PsiMember)) {
            psiVariable = null;
        }
        if ((psiMember = (PsiMember)psiVariable) == null || (psiMember = psiMember.getContainingClass()) == null) {
            psiMember = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)psi), PsiClass.class);
        }
        PsiMember psiMember2 = containingClass = psiMember;
        if (psiMember2 != null) {
            PsiMember psiMember3 = psiMember2;
            PsiClass p1 = (PsiClass)psiMember3;
            jeTypeElement = new JeTypeElement(p1);
        } else {
            jeTypeElement = null;
        }
        return jeTypeElement;
    }

    @Override
    @Nullable
    public Object getConstantValue() {
        PsiExpression psiExpression = ((PsiVariable)this.getPsi()).getInitializer();
        return psiExpression != null ? InternalUtilKt.calcConstantValue$default(psiExpression, null, 1, null) : null;
    }

    @Override
    @NotNull
    public ElementKind getKind() {
        PsiVariable psiVariable = (PsiVariable)this.getPsi();
        return psiVariable instanceof PsiField ? ElementKind.FIELD : (psiVariable instanceof PsiParameter ? ElementKind.PARAMETER : ElementKind.LOCAL_VARIABLE);
    }

    @Override
    @NotNull
    public TypeMirror asType() {
        PsiType psiType = ((PsiVariable)this.getPsi()).getType();
        PsiManager psiManager = ((PsiVariable)this.getPsi()).getManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiManager, (String)"psi.manager");
        return JeTypeUtils.toJeType$default(psiType, psiManager, false, 2, null);
    }

    @Override
    public <R, P> R accept(@NotNull ElementVisitor<R, P> v, P p) {
        Intrinsics.checkParameterIsNotNull(v, (String)"v");
        return v.visitVariable(this, p);
    }

    @NotNull
    public List<Element> getEnclosedElements() {
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(object != null ? object.getClass() : null, this.getClass()) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.java.model.elements.JeVariableElement");
        }
        return Intrinsics.areEqual((Object)((PsiVariable)this.getPsi()), (Object)((PsiVariable)((JeVariableElement)object2).getPsi()));
    }

    @Override
    public int hashCode() {
        return this.getPsi().hashCode();
    }

    @NotNull
    public String toString() {
        String string = ((PsiVariable)this.getPsi()).getName();
        if (string == null) {
            string = "<unnamed variable>";
        }
        return string;
    }

    public JeVariableElement(@NotNull PsiVariable psi) {
        Intrinsics.checkParameterIsNotNull((Object)psi, (String)"psi");
        super((PsiElement)psi);
    }

    @Override
    @NotNull
    public Set<Modifier> getModifiers() {
        return JeModifierListOwner.DefaultImpls.getModifiers(this);
    }

    @Override
    @Nullable
    public <A extends Annotation> A getAnnotation(@NotNull Class<A> annotationClass) {
        Intrinsics.checkParameterIsNotNull(annotationClass, (String)"annotationClass");
        return JeAnnotationOwner.DefaultImpls.getAnnotation(this, annotationClass);
    }

    @Override
    @NotNull
    public <A extends Annotation> A[] getAnnotationsByType(@NotNull Class<A> annotationClass) {
        Intrinsics.checkParameterIsNotNull(annotationClass, (String)"annotationClass");
        return JeAnnotationOwner.DefaultImpls.getAnnotationsByType((JeAnnotationOwner)this, annotationClass);
    }

    @Override
    @NotNull
    public List<JeAnnotationMirror> getAnnotationMirrors() {
        return JeAnnotationOwner.DefaultImpls.getAnnotationMirrors(this);
    }
}

