/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.java.model.types;

import java.util.Arrays;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiIntersectionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.java.model.JeConverterKt;
import org.jetbrains.kotlin.java.model.elements.JeTypeParameterElement;
import org.jetbrains.kotlin.java.model.types.JeNullType;
import org.jetbrains.kotlin.java.model.types.JePsiType;
import org.jetbrains.kotlin.java.model.types.JeTypeUtils;
import org.jetbrains.kotlin.java.model.types.JeTypeWithManager;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ=\u0010\u0011\u001a\n \u0013*\u0004\u0018\u0001H\u0012H\u0012\"\u0004\b\u0000\u0010\u0012\"\u0004\b\u0001\u0010\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u0002H\u00140\u00162\u0006\u0010\u0017\u001a\u0002H\u0014H\u0016\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0096\u0002J\b\u0010\u001f\u001a\u00020 H\u0016J\n\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\n\u0010#\u001a\u0004\u0018\u00010\"H\u0016J\b\u0010$\u001a\u00020%H\u0016J\r\u0010&\u001a\u00070'\u00a2\u0006\u0002\b(H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/java/model/types/JeTypeVariableType;", "Lorg/jetbrains/kotlin/java/model/types/JePsiType;", "Lorg/jetbrains/kotlin/java/model/types/JeTypeWithManager;", "Ljavax/lang/model/type/TypeVariable;", "psiType", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiClassType;", "parameter", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiTypeParameter;", "(Lorg/jetbrains/kotlin/com/intellij/psi/PsiClassType;Lorg/jetbrains/kotlin/com/intellij/psi/PsiTypeParameter;)V", "getParameter", "()Lorg/jetbrains/kotlin/com/intellij/psi/PsiTypeParameter;", "psiManager", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiManager;", "getPsiManager", "()Lorg/jetbrains/kotlin/com/intellij/psi/PsiManager;", "getPsiType", "()Lorg/jetbrains/kotlin/com/intellij/psi/PsiClassType;", "accept", "R", "kotlin.jvm.PlatformType", "P", "v", "Ljavax/lang/model/type/TypeVisitor;", "p", "(Ljavax/lang/model/type/TypeVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "asElement", "Lorg/jetbrains/kotlin/java/model/elements/JeTypeParameterElement;", "equals", "", "other", "", "getKind", "Ljavax/lang/model/type/TypeKind;", "getLowerBound", "Ljavax/lang/model/type/TypeMirror;", "getUpperBound", "hashCode", "", "toString", "", "Lorg/jetbrains/annotations/Nullable;", "kotlin-annotation-processing"})
public final class JeTypeVariableType
extends JePsiType
implements JeTypeWithManager,
TypeVariable {
    @NotNull
    private final PsiClassType psiType;
    @NotNull
    private final PsiTypeParameter parameter;

    @Override
    @NotNull
    public TypeKind getKind() {
        return TypeKind.TYPEVAR;
    }

    @Override
    public <R, P> R accept(@NotNull TypeVisitor<R, P> v, P p) {
        Intrinsics.checkParameterIsNotNull(v, (String)"v");
        return v.visitTypeVariable(this, p);
    }

    @Override
    @NotNull
    public PsiManager getPsiManager() {
        PsiManager psiManager = this.parameter.getManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiManager, (String)"parameter.manager");
        return psiManager;
    }

    @Override
    @Nullable
    public TypeMirror getLowerBound() {
        return JeNullType.INSTANCE;
    }

    @Override
    @Nullable
    public TypeMirror getUpperBound() {
        TypeMirror typeMirror;
        PsiClassType[] superTypes = this.parameter.getSuperTypes();
        if (((Object[])superTypes).length == 1) {
            typeMirror = JeTypeUtils.toJeType$default((PsiType)ArraysKt.first((Object[])superTypes), this.getPsiManager(), false, 2, null);
        } else {
            PsiType[] psiTypeArray = (PsiType[])superTypes;
            typeMirror = JeTypeUtils.toJeType$default(PsiIntersectionType.createIntersection((PsiType[])Arrays.copyOf(psiTypeArray, psiTypeArray.length)), this.getPsiManager(), false, 2, null);
        }
        return typeMirror;
    }

    @Override
    @NotNull
    public JeTypeParameterElement asElement() {
        return new JeTypeParameterElement(this.parameter, JeConverterKt.toJeElement((PsiElement)this.parameter.getOwner()));
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(object != null ? object.getClass() : null, this.getClass()) ^ true) {
            return false;
        }
        PsiClassType psiClassType = this.getPsiType();
        Object object2 = other;
        if (!(object2 instanceof JeTypeVariableType)) {
            object2 = null;
        }
        JeTypeVariableType jeTypeVariableType = (JeTypeVariableType)object2;
        return Intrinsics.areEqual((Object)psiClassType, (Object)(jeTypeVariableType != null ? jeTypeVariableType.getPsiType() : null));
    }

    @Override
    @NotNull
    public String toString() {
        String string = this.parameter.getName();
        if (string == null) {
            string = "<none>";
        }
        return string;
    }

    @Override
    public int hashCode() {
        return this.getPsiType().hashCode();
    }

    @NotNull
    public PsiClassType getPsiType() {
        return this.psiType;
    }

    @NotNull
    public final PsiTypeParameter getParameter() {
        return this.parameter;
    }

    public JeTypeVariableType(@NotNull PsiClassType psiType, @NotNull PsiTypeParameter parameter) {
        Intrinsics.checkParameterIsNotNull((Object)psiType, (String)"psiType");
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        this.psiType = psiType;
        this.parameter = parameter;
    }
}

