/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.annotation;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.ConstantsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.annotation.AnnotatedElement;
import org.jetbrains.kotlin.annotation.AnnotatedElementKt;
import org.jetbrains.kotlin.annotation.AnnotationWriter;
import org.jetbrains.kotlin.annotation.CompactNotationType;
import org.jetbrains.kotlin.annotation.KotlinAnnotationProvider;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0005B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0006\u001a\u00020\u0007H\u0004J\u000e\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020$R#\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR&\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00120\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/annotation/KotlinAnnotationProvider;", "", "annotationsFile", "Ljava/io/File;", "(Ljava/io/File;)V", "()V", "annotationsReader", "Ljava/io/Reader;", "(Ljava/io/Reader;)V", "annotatedKotlinElements", "", "", "", "Lorg/jetbrains/kotlin/annotation/AnnotatedElement;", "getAnnotatedKotlinElements", "()Ljava/util/Map;", "annotatedKotlinElementsInternal", "Ljava/util/LinkedHashMap;", "", "getAnnotatedKotlinElementsInternal", "()Ljava/util/LinkedHashMap;", "kotlinClasses", "getKotlinClasses", "()Ljava/util/Set;", "kotlinClassesInternal", "Ljava/util/LinkedHashSet;", "getKotlinClassesInternal", "()Ljava/util/LinkedHashSet;", "supportInheritedAnnotations", "", "getSupportInheritedAnnotations", "()Z", "readAnnotations", "", "writeAnnotations", "writer", "Lorg/jetbrains/kotlin/annotation/AnnotationWriter;", "kotlin-annotation-processing"})
public class KotlinAnnotationProvider {
    @NotNull
    private final LinkedHashSet<String> kotlinClassesInternal;
    @NotNull
    private final LinkedHashMap<String, Set<AnnotatedElement>> annotatedKotlinElementsInternal;

    @NotNull
    protected final LinkedHashSet<String> getKotlinClassesInternal() {
        return this.kotlinClassesInternal;
    }

    @NotNull
    protected final LinkedHashMap<String, Set<AnnotatedElement>> getAnnotatedKotlinElementsInternal() {
        return this.annotatedKotlinElementsInternal;
    }

    @NotNull
    public final Map<String, Set<AnnotatedElement>> getAnnotatedKotlinElements() {
        return this.annotatedKotlinElementsInternal;
    }

    @NotNull
    public final Set<String> getKotlinClasses() {
        return this.kotlinClassesInternal;
    }

    public final boolean getSupportInheritedAnnotations() {
        Collection collection = this.kotlinClassesInternal;
        return !collection.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected final void readAnnotations(@NotNull Reader annotationsReader) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)annotationsReader, (String)"annotationsReader");
        readAnnotations.1 handleShortenedName$ = readAnnotations.1.INSTANCE;
        LinkedHashMap shortenedAnnotationCache = MapsKt.linkedMapOf((Pair[])new Pair[0]);
        LinkedHashMap shortenedPackageNameCache = MapsKt.linkedMapOf((Pair[])new Pair[0]);
        Function1<String, String> expandAnnotation$ = new Function1<String, String>(shortenedAnnotationCache){
            final /* synthetic */ LinkedHashMap $shortenedAnnotationCache;

            @NotNull
            public final String invoke(@NotNull String s) {
                Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
                Map map = this.$shortenedAnnotationCache;
                Object object = map.get(s);
                if (object == null) {
                    object = s;
                }
                return (String)object;
            }
            {
                this.$shortenedAnnotationCache = linkedHashMap;
                super(1);
            }
        };
        Function1<String, String> expandClassName$ = new Function1<String, String>(shortenedPackageNameCache){
            final /* synthetic */ LinkedHashMap $shortenedPackageNameCache;

            @NotNull
            public final String invoke(@NotNull String s) {
                Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
                String id = StringsKt.substringBefore((String)s, (char)'/', (String)"");
                CharSequence charSequence = id;
                if (charSequence.length() == 0) {
                    return s;
                }
                String string = (String)this.$shortenedPackageNameCache.get(id);
                if (string == null) {
                    throw (Throwable)new RuntimeException("Value for " + id + " couldn't be found in shrink cache");
                }
                String shortenedValue = string;
                String string2 = s;
                int n = id.length() + 1;
                StringBuilder stringBuilder = new StringBuilder().append(shortenedValue).append('.');
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                String string5 = string4;
                return stringBuilder.append(string5).toString();
            }
            {
                this.$shortenedPackageNameCache = linkedHashMap;
                super(1);
            }
        };
        Reader reader = annotationsReader;
        Closeable closeable = $receiver$iv;
        int n = 0;
        boolean bl = true;
        Object var11_14 = null;
        if (var11_14 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buffered");
        }
        if (bl & true) {
            n = ConstantsKt.DEFAULT_BUFFER_SIZE;
        }
        closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
        n = 0;
        try {
            BufferedReader it$iv = (BufferedReader)closeable;
            Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
            for (String line : lines) {
                CharSequence charSequence = line;
                if (charSequence.length() == 0) continue;
                List lineParts = StringsKt.split$default((CharSequence)line, (char[])new char[]{' '}, (boolean)false, (int)0, (int)6, null);
                String type = (String)lineParts.get(0);
                String string = type;
                if (Intrinsics.areEqual((Object)string, (Object)CompactNotationType.SHORTENED_ANNOTATION)) {
                    readAnnotations.1.INSTANCE.invoke(shortenedAnnotationCache, lineParts);
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)CompactNotationType.SHORTENED_PACKAGE_NAME)) {
                    readAnnotations.1.INSTANCE.invoke(shortenedPackageNameCache, lineParts);
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)CompactNotationType.CLASS_DECLARATION)) {
                    String classFqName = StringsKt.replace$default((String)expandClassName$.invoke((String)lineParts.get(1)), (char)'$', (char)'.', (boolean)false, (int)4, null);
                    this.kotlinClassesInternal.add(classFqName);
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)CompactNotationType.ANNOTATED_CLASS) || Intrinsics.areEqual((Object)string, (Object)CompactNotationType.ANNOTATED_FIELD) || Intrinsics.areEqual((Object)string, (Object)CompactNotationType.ANNOTATED_METHOD)) {
                    String name;
                    AnnotatedElement annotatedElement;
                    Object object;
                    void $receiver$iv2;
                    String annotationName = expandAnnotation$.invoke((String)lineParts.get(1));
                    String classFqName = StringsKt.replace$default((String)expandClassName$.invoke((String)lineParts.get(2)), (char)'$', (char)'.', (boolean)false, (int)4, null);
                    String elementName = lineParts.size() == 4 ? (String)lineParts.get(3) : (String)null;
                    Object object2 = this.annotatedKotlinElementsInternal;
                    Object value$iv = $receiver$iv2.get(annotationName);
                    if (value$iv == null) {
                        LinkedHashSet answer$iv = SetsKt.linkedSetOf((Object[])new AnnotatedElement[0]);
                        $receiver$iv2.put(annotationName, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    Set set = (Set)object;
                    object2 = type;
                    if (Intrinsics.areEqual((Object)object2, (Object)CompactNotationType.ANNOTATED_CLASS)) {
                        annotatedElement = new AnnotatedElement.Class(classFqName);
                    } else if (Intrinsics.areEqual((Object)object2, (Object)CompactNotationType.ANNOTATED_FIELD)) {
                        if (elementName == null) {
                            throw (Throwable)((Object)new AssertionError((Object)"Name for field must be provided"));
                        }
                        annotatedElement = new AnnotatedElement.Field(classFqName, name);
                    } else if (Intrinsics.areEqual((Object)object2, (Object)CompactNotationType.ANNOTATED_METHOD)) {
                        if (elementName == null) {
                            throw (Throwable)((Object)new AssertionError((Object)"Name for method must be provided"));
                        }
                        annotatedElement = Intrinsics.areEqual((Object)AnnotatedElement.Constructor.METHOD_NAME, (Object)name) ? (AnnotatedElement)new AnnotatedElement.Constructor(classFqName) : (AnnotatedElement)new AnnotatedElement.Method(classFqName, name);
                    } else {
                        throw (Throwable)((Object)new AssertionError((Object)("Unknown type: " + type)));
                    }
                    set.add(annotatedElement);
                    continue;
                }
                throw (Throwable)((Object)new AssertionError((Object)("Unknown type: " + type)));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception exception) {
            n = 1;
            try {
                closeable.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw (Throwable)exception;
        }
        finally {
            if (n == 0) {
                closeable.close();
            }
        }
    }

    public final void writeAnnotations(@NotNull AnnotationWriter writer) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        Map<String, Set<AnnotatedElement>> map = this.getAnnotatedKotlinElements();
        Iterator<Object> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Set<AnnotatedElement>> entry;
            Map.Entry<String, Set<AnnotatedElement>> entry2 = entry = iterator.next();
            String annotation = entry2.getKey();
            Map.Entry<String, Set<AnnotatedElement>> entry3 = entry;
            Set<AnnotatedElement> elements = entry3.getValue();
            for (AnnotatedElement element : elements) {
                AnnotatedElementKt.writeAnnotatedElement(writer, annotation, element);
            }
        }
        for (String className : this.getKotlinClasses()) {
            writer.writeClassDeclaration(className);
        }
    }

    public KotlinAnnotationProvider(@NotNull Reader annotationsReader) {
        Intrinsics.checkParameterIsNotNull((Object)annotationsReader, (String)"annotationsReader");
        this.kotlinClassesInternal = SetsKt.linkedSetOf((Object[])new String[0]);
        this.annotatedKotlinElementsInternal = MapsKt.linkedMapOf((Pair[])new Pair[0]);
        this.readAnnotations(annotationsReader);
    }

    public KotlinAnnotationProvider(@NotNull File annotationsFile) {
        Intrinsics.checkParameterIsNotNull((Object)annotationsFile, (String)"annotationsFile");
        Object object = annotationsFile;
        Charset charset = null;
        boolean bl = true;
        Object object2 = null;
        KotlinAnnotationProvider kotlinAnnotationProvider = this;
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reader");
        }
        if (bl & true) {
            charset = Charsets.UTF_8;
        }
        object2 = object;
        object2 = new FileInputStream((File)object2);
        Reader reader = new InputStreamReader((InputStream)object2, charset);
        object = reader;
        int n = 0;
        bl = true;
        object2 = null;
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buffered");
        }
        if (bl & true) {
            n = ConstantsKt.DEFAULT_BUFFER_SIZE;
        }
        reader = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
        kotlinAnnotationProvider(reader);
    }

    public KotlinAnnotationProvider() {
        this(new StringReader(""));
    }
}

