/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt3.base.incremental;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kapt3.base.incremental.IncrementalProcessorsKt;
import org.jetbrains.kotlin.kapt3.base.incremental.RuntimeProcType;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ3\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0010\u0010\u0014\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00160\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u0006H\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0013\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u001bH\u0000\u00a2\u0006\u0002\b\u001cJ\u0019\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00060\u001eH\u0000\u00a2\u0006\u0002\b\u001fJ\u001b\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u001eH\u0000\u00a2\u0006\u0002\b!J\r\u0010\"\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b#J1\u0010$\u001a\u00020\u00072\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00060\u001b2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u001b2\u0006\u0010(\u001a\u00020)H\u0000\u00a2\u0006\u0002\b*R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00060\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00060\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/kapt3/base/incremental/AnnotationProcessorDependencyCollector;", "", "runtimeProcType", "Lorg/jetbrains/kotlin/kapt3/base/incremental/RuntimeProcType;", "warningCollector", "Lkotlin/Function1;", "", "", "(Lorg/jetbrains/kotlin/kapt3/base/incremental/RuntimeProcType;Lkotlin/jvm/functions/Function1;)V", "aggregatedTypes", "", "generatedClassFilesToTypes", "", "Ljava/io/File;", "generatedToSource", "isFullRebuild", "", "add", "createdFile", "Ljava/net/URI;", "originatingElements", "", "Ljavax/lang/model/element/Element;", "classId", "add$kotlin_annotation_processing_maven", "(Ljava/net/URI;[Ljavax/lang/model/element/Element;Ljava/lang/String;)V", "getAggregatedTypes", "", "getAggregatedTypes$kotlin_annotation_processing_maven", "getGeneratedClassFilesToTypes", "", "getGeneratedClassFilesToTypes$kotlin_annotation_processing_maven", "getGeneratedToSources", "getGeneratedToSources$kotlin_annotation_processing_maven", "getRuntimeType", "getRuntimeType$kotlin_annotation_processing_maven", "recordProcessingInputs", "supportedAnnotationTypes", "annotations", "Ljavax/lang/model/element/TypeElement;", "roundEnv", "Ljavax/annotation/processing/RoundEnvironment;", "recordProcessingInputs$kotlin_annotation_processing_maven", "kotlin-annotation-processing-maven"})
public final class AnnotationProcessorDependencyCollector {
    @NotNull
    private final RuntimeProcType runtimeProcType;
    @NotNull
    private final Function1<String, Unit> warningCollector;
    @NotNull
    private final Map<File, String> generatedToSource;
    @NotNull
    private final Set<String> aggregatedTypes;
    @NotNull
    private final Map<File, String> generatedClassFilesToTypes;
    private boolean isFullRebuild;

    public AnnotationProcessorDependencyCollector(@NotNull RuntimeProcType runtimeProcType, @NotNull Function1<? super String, Unit> warningCollector) {
        Intrinsics.checkNotNullParameter((Object)((Object)runtimeProcType), (String)"runtimeProcType");
        Intrinsics.checkNotNullParameter(warningCollector, (String)"warningCollector");
        this.runtimeProcType = runtimeProcType;
        this.warningCollector = warningCollector;
        boolean bl = false;
        this.generatedToSource = new LinkedHashMap();
        bl = false;
        this.aggregatedTypes = new LinkedHashSet();
        bl = false;
        this.generatedClassFilesToTypes = new LinkedHashMap();
        this.isFullRebuild = !this.runtimeProcType.isIncremental();
    }

    public final void recordProcessingInputs$kotlin_annotation_processing_maven(@NotNull Set<String> supportedAnnotationTypes, @NotNull Set<? extends TypeElement> annotations, @NotNull RoundEnvironment roundEnv) {
        Intrinsics.checkNotNullParameter(supportedAnnotationTypes, (String)"supportedAnnotationTypes");
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        Intrinsics.checkNotNullParameter((Object)roundEnv, (String)"roundEnv");
        if (this.isFullRebuild) {
            return;
        }
        if (supportedAnnotationTypes.contains("*")) {
            Set<? extends Element> set = roundEnv.getRootElements();
            List list = set == null ? null : CollectionsKt.filterNotNull((Iterable)set);
            this.aggregatedTypes.addAll(IncrementalProcessorsKt.access$getTopLevelClassNames(list == null ? (Collection)SetsKt.emptySet() : (Collection)list));
        } else {
            for (TypeElement typeElement : annotations) {
                Set<? extends Element> set = roundEnv.getElementsAnnotatedWith(typeElement);
                List list = set == null ? null : CollectionsKt.filterNotNull((Iterable)set);
                this.aggregatedTypes.addAll(IncrementalProcessorsKt.access$getTopLevelClassNames(list == null ? (Collection)CollectionsKt.emptyList() : (Collection)list));
            }
        }
    }

    public final void add$kotlin_annotation_processing_maven(@NotNull URI createdFile, @NotNull Element[] originatingElements, @Nullable String classId) {
        Map<File, String> map;
        Intrinsics.checkNotNullParameter((Object)createdFile, (String)"createdFile");
        Intrinsics.checkNotNullParameter((Object)originatingElements, (String)"originatingElements");
        if (this.isFullRebuild) {
            return;
        }
        File generatedFile = new File(createdFile);
        if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)generatedFile), (Object)"class")) {
            if (classId == null) {
                this.isFullRebuild = true;
                this.warningCollector.invoke((Object)("Unable to determine type defined in " + generatedFile + '.'));
                return;
            }
            map = this.generatedClassFilesToTypes;
            boolean bl = false;
            map.put(generatedFile, classId);
        }
        if (this.runtimeProcType == RuntimeProcType.AGGREGATING) {
            map = this.generatedToSource;
            Object v = null;
            boolean bl = false;
            map.put(generatedFile, (String)v);
        } else {
            Set srcClasses = IncrementalProcessorsKt.access$getTopLevelClassNames(ArraysKt.filterNotNull((Object[])originatingElements));
            if (srcClasses.size() != 1) {
                this.isFullRebuild = true;
                this.warningCollector.invoke((Object)("Expected 1 originating source file when generating " + generatedFile + ", but detected " + srcClasses.size() + ": [" + CollectionsKt.joinToString$default((Iterable)srcClasses, null, null, null, (int)0, null, null, (int)63, null) + "]."));
            } else {
                Map<File, String> map2 = this.generatedToSource;
                Object object = CollectionsKt.single((Iterable)srcClasses);
                boolean bl = false;
                map2.put(generatedFile, (String)object);
            }
        }
    }

    @NotNull
    public final Map<File, String> getGeneratedToSources$kotlin_annotation_processing_maven() {
        return this.isFullRebuild ? MapsKt.emptyMap() : this.generatedToSource;
    }

    @NotNull
    public final Set<String> getAggregatedTypes$kotlin_annotation_processing_maven() {
        return this.isFullRebuild ? SetsKt.emptySet() : this.aggregatedTypes;
    }

    @NotNull
    public final Map<File, String> getGeneratedClassFilesToTypes$kotlin_annotation_processing_maven() {
        return this.isFullRebuild ? MapsKt.emptyMap() : this.generatedClassFilesToTypes;
    }

    @NotNull
    public final RuntimeProcType getRuntimeType$kotlin_annotation_processing_maven() {
        return this.isFullRebuild ? RuntimeProcType.NON_INCREMENTAL : this.runtimeProcType;
    }
}

