/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt3.base.incremental;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.source.util.Trees;
import java.net.URI;
import java.util.List;
import javax.lang.model.util.Elements;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kapt3.base.incremental.JavaClassCache;
import org.jetbrains.kotlin.kapt3.base.incremental.SourceFileStructure;
import org.jetbrains.kotlin.kapt3.base.incremental.TypeTreeVisitor;
import org.jetbrains.kotlin.kapt3.base.incremental.Visibility;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/kapt3/base/incremental/MentionedTypesTaskListener;", "Lcom/sun/source/util/TaskListener;", "cache", "Lorg/jetbrains/kotlin/kapt3/base/incremental/JavaClassCache;", "elementUtils", "Ljavax/lang/model/util/Elements;", "trees", "Lcom/sun/source/util/Trees;", "(Lorg/jetbrains/kotlin/kapt3/base/incremental/JavaClassCache;Ljavax/lang/model/util/Elements;Lcom/sun/source/util/Trees;)V", "failureReason", "", "getFailureReason", "()Ljava/lang/String;", "setFailureReason", "(Ljava/lang/String;)V", "time", "", "getTime", "()J", "setTime", "(J)V", "finished", "", "e", "Lcom/sun/source/util/TaskEvent;", "started", "kotlin-annotation-processing-maven"})
public final class MentionedTypesTaskListener
implements TaskListener {
    private long time;
    @Nullable
    private String failureReason;
    private final JavaClassCache cache;
    private final Elements elementUtils;
    private final Trees trees;

    public final long getTime() {
        return this.time;
    }

    public final void setTime(long l) {
        this.time = l;
    }

    @Nullable
    public final String getFailureReason() {
        return this.failureReason;
    }

    public final void setFailureReason(@Nullable String string) {
        this.failureReason = string;
    }

    @Override
    public void started(@NotNull TaskEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    @Override
    public void finished(@NotNull TaskEvent e) {
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (this.failureReason != null) {
                    return;
                }
                if (e.getKind() != TaskEvent.Kind.ENTER) break block7;
                URI uRI = e.getSourceFile().toUri();
                Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"e.sourceFile.toUri()");
                if (!this.cache.isAlreadyProcessed(uRI)) break block8;
            }
            return;
        }
        try {
            long l = System.currentTimeMillis();
            CompilationUnitTree compilationUnit = e.getCompilationUnit();
            URI uRI = e.getSourceFile().toUri();
            Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"e.sourceFile.toUri()");
            SourceFileStructure structure = new SourceFileStructure(uRI);
            CompilationUnitTree compilationUnitTree = compilationUnit;
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnitTree, (String)"compilationUnit");
            TypeTreeVisitor treeVisitor2 = new TypeTreeVisitor(this.elementUtils, this.trees, compilationUnitTree, structure);
            List<? extends Tree> list = compilationUnit.getTypeDecls();
            Intrinsics.checkNotNullExpressionValue(list, (String)"compilationUnit.typeDecls");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Tree it = (Tree)element$iv;
                boolean bl = false;
                it.accept(treeVisitor2, Visibility.ABI);
            }
            this.cache.addSourceStructure(structure);
            this.time += System.currentTimeMillis() - l;
        }
        catch (Throwable t) {
            this.failureReason = "Running non-incrementally because analyzing " + e.getSourceFile().toUri() + " failed.";
        }
    }

    public MentionedTypesTaskListener(@NotNull JavaClassCache cache, @NotNull Elements elementUtils, @NotNull Trees trees) {
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        Intrinsics.checkNotNullParameter((Object)elementUtils, (String)"elementUtils");
        Intrinsics.checkNotNullParameter((Object)trees, (String)"trees");
        this.cache = cache;
        this.elementUtils = elementUtils;
        this.trees = trees;
    }
}

