/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt3.base;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.processing.Processor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.base.kapt3.KaptFlag;
import org.jetbrains.kotlin.base.kapt3.KaptOptions;
import org.jetbrains.kotlin.kapt3.base.LoadedProcessors;
import org.jetbrains.kotlin.kapt3.base.ProcessorLoader;
import org.jetbrains.kotlin.kapt3.base.incremental.DeclaredProcType;
import org.jetbrains.kotlin.kapt3.base.incremental.IncrementalProcessor;
import org.jetbrains.kotlin.kapt3.base.incremental.IncrementalProcessorDiscoveryKt;
import org.jetbrains.kotlin.kapt3.base.util.KaptLogger;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J.\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0016\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0016J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0016H\u0002J*\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u001dH\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/kapt3/base/ProcessorLoader;", "Ljava/io/Closeable;", "options", "Lorg/jetbrains/kotlin/base/kapt3/KaptOptions;", "logger", "Lorg/jetbrains/kotlin/kapt3/base/util/KaptLogger;", "(Lorg/jetbrains/kotlin/base/kapt3/KaptOptions;Lorg/jetbrains/kotlin/kapt3/base/util/KaptLogger;)V", "annotationProcessingClassLoader", "Ljava/net/URLClassLoader;", "close", "", "doLoadProcessors", "", "Ljavax/annotation/processing/Processor;", "classpath", "Ljava/util/LinkedHashSet;", "Ljava/io/File;", "Lkotlin/collections/LinkedHashSet;", "classLoader", "loadProcessors", "Lorg/jetbrains/kotlin/kapt3/base/LoadedProcessors;", "parentClassLoader", "Ljava/lang/ClassLoader;", "tryLoadProcessor", "fqName", "", "wrapInIncrementalProcessor", "Lorg/jetbrains/kotlin/kapt3/base/incremental/IncrementalProcessor;", "processors", "", "kotlin-annotation-processing-maven"})
public class ProcessorLoader
implements Closeable {
    private URLClassLoader annotationProcessingClassLoader;
    private final KaptOptions options;
    private final KaptLogger logger;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LoadedProcessors loadProcessors(@NotNull ClassLoader parentClassLoader) {
        List processors;
        List list;
        URLClassLoader classLoader;
        Collection<URL> collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)parentClassLoader, (String)"parentClassLoader");
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        boolean bl = false;
        boolean bl2 = false;
        Iterable<File> $this$apply = linkedHashSet;
        boolean bl3 = false;
        $this$apply.addAll(this.options.getProcessingClasspath());
        if (this.options.get(KaptFlag.INCLUDE_COMPILE_CLASSPATH)) {
            $this$apply.addAll(this.options.getCompileClasspath());
        }
        LinkedHashSet<File> classpath = linkedHashSet;
        Iterable $this$map$iv = classpath;
        boolean $i$f$map = false;
        $this$apply = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            URL uRL = it.toURI().toURL();
            collection.add(uRL);
        }
        collection = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray22 = false;
        Collection thisCollection$iv22 = $this$toTypedArray$iv;
        URL[] uRLArray = thisCollection$iv22.toArray(new URL[0]);
        if (uRLArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        ClassLoader classLoader2 = parentClassLoader;
        URL[] uRLArray2 = uRLArray;
        this.annotationProcessingClassLoader = classLoader = new URLClassLoader(uRLArray2, classLoader2);
        Collection $i$f$toTypedArray22 = this.options.getProcessors();
        boolean thisCollection$iv22 = false;
        if (!$i$f$toTypedArray22.isEmpty()) {
            void $this$mapNotNullTo$iv$iv;
            this.logger.info("Annotation processor class names are set, skip AP discovery");
            Iterable $this$mapNotNull$iv = this.options.getProcessors();
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Processor processor;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl5 = false;
                String it = (String)element$iv$iv;
                boolean bl6 = false;
                if (this.tryLoadProcessor(it, classLoader) == null) continue;
                boolean bl7 = false;
                boolean bl8 = false;
                Processor it$iv$iv = processor;
                boolean bl9 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            list = (List)destination$iv$iv2;
        } else {
            this.logger.info("Need to discovery annotation processors in the AP classpath");
            list = processors = this.doLoadProcessors(classpath, classLoader);
        }
        if (processors.isEmpty()) {
            this.logger.info("No annotation processors available, aborting");
        } else {
            KaptLogger $this$info$iv = this.logger;
            boolean $i$f$info = false;
            if ($this$info$iv.isVerbose()) {
                KaptLogger kaptLogger = $this$info$iv;
                boolean bl10 = false;
                String string = "Annotation processors: " + CollectionsKt.joinToString$default((Iterable)processors, null, null, null, (int)0, null, (Function1)loadProcessors.1.1.INSTANCE, (int)31, null);
                kaptLogger.info(string);
            }
        }
        return new LoadedProcessors(this.wrapInIncrementalProcessor(processors, (Iterable<? extends File>)classpath), classLoader);
    }

    public static /* synthetic */ LoadedProcessors loadProcessors$default(ProcessorLoader processorLoader, ClassLoader classLoader, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: loadProcessors");
        }
        if ((n & 1) != 0) {
            ClassLoader classLoader2 = ClassLoader.getSystemClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)classLoader2, (String)"ClassLoader.getSystemClassLoader()");
            classLoader = classLoader2;
        }
        return processorLoader.loadProcessors(classLoader);
    }

    /*
     * WARNING - void declaration
     */
    private final List<IncrementalProcessor> wrapInIncrementalProcessor(List<? extends Processor> processors, Iterable<? extends File> classpath) {
        void $this$mapTo$iv$iv;
        Object it;
        Iterable $this$filterTo$iv$iv;
        Object object;
        Collection collection;
        void $this$mapTo$iv$iv2;
        if (this.options.getIncrementalCache() == null) {
            void $this$mapTo$iv$iv3;
            Iterable $this$map$iv = processors;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void it2;
                Processor processor = (Processor)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                IncrementalProcessor incrementalProcessor = new IncrementalProcessor((Processor)it2, DeclaredProcType.NON_INCREMENTAL, this.logger);
                collection2.add(incrementalProcessor);
            }
            return (List)destination$iv$iv;
        }
        Iterable $this$map$iv = processors;
        boolean $i$f$map = false;
        Iterable destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it3;
            Processor bl = (Processor)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            object = it3.getClass().getName();
            collection.add(object);
        }
        Set processorNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        Map<String, DeclaredProcType> processorsInfo = IncrementalProcessorDiscoveryKt.getIncrementalProcessorsFromClasspath(processorNames, classpath);
        Iterable $this$filter$iv = processorNames;
        boolean $i$f$filter = false;
        Iterable $i$f$mapTo22 = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!processorsInfo.containsKey(it))) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List nonIncremental = (List)destination$iv$iv3;
        Iterable $this$map$iv2 = processors;
        boolean $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv2;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            DeclaredProcType declaredProcType;
            block9: {
                block8: {
                    it = (Processor)item$iv$iv;
                    collection = destination$iv$iv3;
                    boolean bl = false;
                    declaredProcType = processorsInfo.get(it.getClass().getName());
                    if (declaredProcType == null) break block8;
                    DeclaredProcType declaredProcType2 = declaredProcType;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    DeclaredProcType it4 = declaredProcType2;
                    boolean bl5 = false;
                    DeclaredProcType declaredProcType3 = nonIncremental.isEmpty() ? it4 : DeclaredProcType.INCREMENTAL_BUT_OTHER_APS_ARE_NOT;
                    declaredProcType = declaredProcType3;
                    if (declaredProcType3 != null) break block9;
                }
                declaredProcType = DeclaredProcType.NON_INCREMENTAL;
            }
            DeclaredProcType procType = declaredProcType;
            object = new IncrementalProcessor((Processor)it, procType, this.logger);
            collection.add(object);
        }
        return (List)destination$iv$iv3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public List<Processor> doLoadProcessors(@NotNull LinkedHashSet<File> classpath, @NotNull URLClassLoader classLoader) {
        void $this$mapNotNullTo$iv$iv;
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter(classpath, (String)"classpath");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        boolean bl = false;
        Set processorNames = new LinkedHashSet();
        Function1<InputStream, Unit> $fun$processSingleInput$1 = new Function1<InputStream, Unit>(processorNames){
            final /* synthetic */ Set $processorNames;

            public final void invoke(@NotNull InputStream input) {
                Sequence lines;
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                InputStream inputStream = input;
                Charset charset = Charsets.UTF_8;
                boolean bl = false;
                Closeable closeable = inputStream;
                int n = 0;
                closeable = new InputStreamReader((InputStream)closeable, charset);
                n = 8192;
                boolean bl2 = false;
                Sequence $this$forEach$iv = lines = TextStreamsKt.lineSequence((BufferedReader)(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n)));
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    String line = (String)element$iv;
                    boolean bl3 = false;
                    CharSequence charSequence = StringsKt.substringBefore$default((String)line, (String)"#", null, (int)2, null);
                    boolean bl4 = false;
                    String string = charSequence;
                    if (string == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    String processedLine = ((Object)StringsKt.trim((CharSequence)string)).toString();
                    charSequence = processedLine;
                    bl4 = false;
                    if (!(charSequence.length() > 0)) continue;
                    this.$processorNames.add(processedLine);
                }
            }
            {
                this.$processorNames = set;
                super(1);
            }
        };
        String serviceFile = "META-INF/services/javax.annotation.processing.Processor";
        for (File file : classpath) {
            boolean bl2;
            boolean bl3;
            boolean bl4;
            File file2 = file;
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
            if (file2.isDirectory()) {
                object2 = FilesKt.resolve((File)file, (String)serviceFile);
                bl4 = false;
                bl3 = false;
                Object it = object2;
                boolean bl5 = false;
                Object object3 = ((File)it).isFile() ? object2 : null;
                if (object3 != null) {
                    object2 = object3;
                    bl4 = false;
                    bl3 = false;
                    it = object2;
                    boolean bl6 = false;
                    object = it;
                    bl2 = false;
                    $fun$processSingleInput$1.invoke((InputStream)new FileInputStream((File)object));
                }
                continue;
            }
            if (file.isFile()) {
                object2 = new ZipFile(file);
                bl4 = false;
                bl3 = false;
                Throwable throwable = null;
                try {
                    Unit unit;
                    ZipFile zipFile = (ZipFile)object2;
                    boolean bl7 = false;
                    if (zipFile.getEntry(serviceFile) != null) {
                        bl2 = false;
                        boolean bl8 = false;
                        Object zipEntry = object;
                        boolean bl9 = false;
                        Closeable closeable = zipFile.getInputStream((ZipEntry)zipEntry);
                        boolean bl10 = false;
                        boolean bl11 = false;
                        Throwable throwable2 = null;
                        try {
                            InputStream it = (InputStream)closeable;
                            boolean bl12 = false;
                            InputStream inputStream = it;
                            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"it");
                            $fun$processSingleInput$1.invoke(inputStream);
                            Unit unit2 = Unit.INSTANCE;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                        }
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    zipFile = unit;
                    continue;
                }
                catch (Throwable zipFile) {
                    throwable = zipFile;
                    throw zipFile;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                    continue;
                }
            }
            this.logger.info(file + " cannot be used to locate " + serviceFile + " file.");
        }
        Iterable $this$mapNotNull$iv = processorNames;
        boolean $i$f$mapNotNull = false;
        object2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            Processor processor;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl13 = false;
            String it = (String)element$iv$iv;
            boolean bl14 = false;
            if (this.tryLoadProcessor(it, classLoader) == null) continue;
            boolean bl15 = false;
            boolean bl16 = false;
            Processor it$iv$iv = processor;
            boolean bl17 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Processor tryLoadProcessor(String fqName, ClassLoader classLoader) {
        Class<?> clazz;
        try {
            Class<?> clazz2 = Class.forName(fqName, true, classLoader);
            Intrinsics.checkNotNullExpressionValue(clazz2, (String)"Class.forName(fqName, true, classLoader)");
            clazz = clazz2;
        }
        catch (Throwable e) {
            this.logger.warn("Can't find annotation processor class " + fqName + ": " + e.getMessage());
            return null;
        }
        Class<?> annotationProcessorClass = clazz;
        try {
            Object annotationProcessorInstance = annotationProcessorClass.newInstance();
            if (!(annotationProcessorInstance instanceof Processor)) {
                this.logger.warn(fqName + " is not an instance of 'Processor'");
                return null;
            }
            return (Processor)annotationProcessorInstance;
        }
        catch (Throwable e) {
            this.logger.warn("Can't load annotation processor class " + fqName + ": " + e.getMessage());
            return null;
        }
    }

    @Override
    public void close() {
        block0: {
            URLClassLoader uRLClassLoader = this.annotationProcessingClassLoader;
            if (uRLClassLoader == null) break block0;
            uRLClassLoader.close();
        }
    }

    public ProcessorLoader(@NotNull KaptOptions options, @NotNull KaptLogger logger) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.options = options;
        this.logger = logger;
    }
}

